require 'vertx/command_line'
require 'vertx/future'
require 'vertx/util/utils.rb'
# Generated from io.vertx.core.cli.CLI
module Vertx
  #  Interface defining a command-line interface (in other words a command such as 'run', 'ls'...).
  #  This interface is polyglot to ease reuse such as in Vert.x Shell.
  #  <p/>
  #  A command line interface has a name, and defines a set of options and arguments. Options are key-value pair such
  #  as <code>-foo=bar</code> or <code>-flag</code>. The supported formats depend on the used parser. Arguments are unlike
  #  options raw values. Options are defined using
  #  {Hash{String => Object}}, while argument are defined using {Hash{String => Object}}.
  #  <p/>
  #  Command line interfaces also define a summary and a description. These attributes are used in the usage generation
  #  . To disable the help generation, set the <code>hidden</code> attribute to <code>true</code>.
  #  <p/>
  #  Command Line Interface object does not contains "value", it's a model. It must be evaluated by a
  #  parser that returns a {::Vertx::CommandLine} object containing the argument and option values.
  class CLI
    # @private
    # @param j_del [::Vertx::CLI] the java delegate
    def initialize(j_del)
      @j_del = j_del
    end
    # @private
    # @return [::Vertx::CLI] the underlying java delegate
    def j_del
      @j_del
    end
    @@j_api_type = Object.new
    def @@j_api_type.accept?(obj)
      obj.class == CLI
    end
    def @@j_api_type.wrap(obj)
      CLI.new(obj)
    end
    def @@j_api_type.unwrap(obj)
      obj.j_del
    end
    def self.j_api_type
      @@j_api_type
    end
    def self.j_class
      Java::IoVertxCoreCli::CLI.java_class
    end
    #  Sets the name of the CLI.
    # @overload setName(name)
    #   @param [String] name the name
    # @return [self]
    def set_name(*args)
      if args[0].class == String && !block_given?
        @j_del.java_method(:setName, [Java::java.lang.String.java_class]).call(args[0])
        return self
      end
      if defined?(super)
        super
      else
        raise ArgumentError, "Invalid arguments when calling set_name(#{args[0]})"
      end
    end
    #  Adds a set of arguments. Unlike {::Vertx::CLI#set_arguments}, this method does not remove the existing arguments.
    #  The given list is appended to the existing list.
    # @overload addArguments(args)
    #   @param [Array<Hash{String => Object}>] args the arguments, must not be <code>null</code>
    # @return [self]
    def add_arguments(*args)
      if args[0].class == Array && !block_given?
        @j_del.java_method(:addArguments, [Java::JavaUtil::List.java_class]).call(args[0].map { |element| Java::IoVertxCoreCli::Argument.new(::Vertx::Util::Utils.to_json_object(element)) })
        return self
      end
      if defined?(super)
        super
      else
        raise ArgumentError, "Invalid arguments when calling add_arguments(#{args[0]})"
      end
    end
    #  Sets the summary of the CLI.
    # @overload setSummary(summary)
    #   @param [String] summary the summary
    # @return [self]
    def set_summary(*args)
      if args[0].class == String && !block_given?
        @j_del.java_method(:setSummary, [Java::java.lang.String.java_class]).call(args[0])
        return self
      end
      if defined?(super)
        super
      else
        raise ArgumentError, "Invalid arguments when calling set_summary(#{args[0]})"
      end
    end
    # @overload getSummary()
    # @return [String] the CLI summary.
    def get_summary
      if !block_given?
        return @j_del.java_method(:getSummary, []).call()
      end
      if defined?(super)
        super
      else
        raise ArgumentError, "Invalid arguments when calling get_summary()"
      end
    end
    # @overload getName()
    # @return [String] the CLI name.
    def get_name
      if !block_given?
        return @j_del.java_method(:getName, []).call()
      end
      if defined?(super)
        super
      else
        raise ArgumentError, "Invalid arguments when calling get_name()"
      end
    end
    #  Gets an {Hash{String => Object}} based on its index.
    # @overload getArgument(name)
    #   @param [String] name the name of the argument, must not be <code>null</code>
    # @overload getArgument(index)
    #   @param [Fixnum] index the index, must be positive or zero.
    # @return [Hash{String => Object}] the {Hash{String => Object}}, <code>null</code> if not found.
    def get_argument(*args)
      if args[0].class == String && !block_given?
        return @j_del.java_method(:getArgument, [Java::java.lang.String.java_class]).call(args[0]) != nil ? JSON.parse(@j_del.java_method(:getArgument, [Java::java.lang.String.java_class]).call(args[0]).toJson.encode) : nil
      elsif args[0].class == Fixnum && !block_given?
        return @j_del.java_method(:getArgument, [Java::int.java_class]).call(args[0]) != nil ? JSON.parse(@j_del.java_method(:getArgument, [Java::int.java_class]).call(args[0]).toJson.encode) : nil
      end
      if defined?(super)
        super
      else
        raise ArgumentError, "Invalid arguments when calling get_argument(#{args[0]})"
      end
    end
    #  Gets an {Hash{String => Object}} based on its name (short name, long name or argument name).
    # @overload getOption(name)
    #   @param [String] name the name, must not be <code>null</code>
    # @return [Hash{String => Object}] the {Hash{String => Object}}, <code>null</code> if not found
    def get_option(*args)
      if args[0].class == String && !block_given?
        return @j_del.java_method(:getOption, [Java::java.lang.String.java_class]).call(args[0]) != nil ? JSON.parse(@j_del.java_method(:getOption, [Java::java.lang.String.java_class]).call(args[0]).toJson.encode) : nil
      end
      if defined?(super)
        super
      else
        raise ArgumentError, "Invalid arguments when calling get_option(#{args[0]})"
      end
    end
    # @overload setDescription(desc)
    #   @param [String] desc 
    # @return [self]
    def set_description(*args)
      if args[0].class == String && !block_given?
        @j_del.java_method(:setDescription, [Java::java.lang.String.java_class]).call(args[0])
        return self
      end
      if defined?(super)
        super
      else
        raise ArgumentError, "Invalid arguments when calling set_description(#{args[0]})"
      end
    end
    #  Parses the user command line interface and create a new {::Vertx::CommandLine} containing extracting values.
    # @overload parse(arguments)
    #   @param [Array<String>] arguments the arguments
    # @overload parse(arguments,validate)
    #   @param [Array<String>] arguments the arguments
    #   @param [true,false] validate enable / disable parsing validation
    # @return [::Vertx::CommandLine] the creates command line
    def parse(*args)
      if args[0].class == Array && !block_given? && args[1] == nil
        return ::Vertx::Util::Utils.safe_create(@j_del.java_method(:parse, [Java::JavaUtil::List.java_class]).call(args[0].map { |element| element }),::Vertx::CommandLine)
      elsif args[0].class == Array && (args[1].class == TrueClass || args[1].class == FalseClass) && !block_given?
        return ::Vertx::Util::Utils.safe_create(@j_del.java_method(:parse, [Java::JavaUtil::List.java_class,Java::boolean.java_class]).call(args[0].map { |element| element },args[1]),::Vertx::CommandLine)
      end
      if defined?(super)
        super
      else
        raise ArgumentError, "Invalid arguments when calling parse(#{args[0]},#{args[1]})"
      end
    end
    # @overload getDescription()
    # @return [String] the CLI description.
    def get_description
      if !block_given?
        return @j_del.java_method(:getDescription, []).call()
      end
      if defined?(super)
        super
      else
        raise ArgumentError, "Invalid arguments when calling get_description()"
      end
    end
    #  Removes an option identified by its name. This method does nothing if the option cannot be found.
    # @overload removeOption(name)
    #   @param [String] name the option name
    # @return [self]
    def remove_option(*args)
      if args[0].class == String && !block_given?
        @j_del.java_method(:removeOption, [Java::java.lang.String.java_class]).call(args[0])
        return self
      end
      if defined?(super)
        super
      else
        raise ArgumentError, "Invalid arguments when calling remove_option(#{args[0]})"
      end
    end
    #  Checks whether or not the current {::Vertx::CLI} instance is hidden.
    # @overload isHidden()
    # @return [true,false] <code>true</code> if the current {::Vertx::CLI} is hidden,  otherwise
    def hidden?
      if !block_given?
        return @j_del.java_method(:isHidden, []).call()
      end
      if defined?(super)
        super
      else
        raise ArgumentError, "Invalid arguments when calling hidden?()"
      end
    end
    #  Adds an argument.
    # @overload addArgument(arg)
    #   @param [Hash{String => Object}] arg the argument, must not be <code>null</code>
    # @return [self]
    def add_argument(*args)
      if args[0].class == Hash && !block_given?
        @j_del.java_method(:addArgument, [Java::IoVertxCoreCli::Argument.java_class]).call(Java::IoVertxCoreCli::Argument.new(::Vertx::Util::Utils.to_json_object(args[0])))
        return self
      end
      if defined?(super)
        super
      else
        raise ArgumentError, "Invalid arguments when calling add_argument(#{args[0]})"
      end
    end
    #  Removes an argument identified by its index. This method does nothing if the argument cannot be found.
    # @overload removeArgument(index)
    #   @param [Fixnum] index the argument index
    # @return [self]
    def remove_argument(*args)
      if args[0].class == Fixnum && !block_given?
        @j_del.java_method(:removeArgument, [Java::int.java_class]).call(args[0])
        return self
      end
      if defined?(super)
        super
      else
        raise ArgumentError, "Invalid arguments when calling remove_argument(#{args[0]})"
      end
    end
    #  Adds an option.
    # @overload addOption(option)
    #   @param [Hash{String => Object}] option the option, must not be <code>null</code>.
    # @return [self]
    def add_option(*args)
      if args[0].class == Hash && !block_given?
        @j_del.java_method(:addOption, [Java::IoVertxCoreCli::Option.java_class]).call(Java::IoVertxCoreCli::Option.new(::Vertx::Util::Utils.to_json_object(args[0])))
        return self
      end
      if defined?(super)
        super
      else
        raise ArgumentError, "Invalid arguments when calling add_option(#{args[0]})"
      end
    end
    #  Sets whether or not the current instance of {::Vertx::CLI} must be hidden. Hidden CLI are not listed when
    #  displaying usages / help messages. In other words, hidden commands are for power user.
    # @overload setHidden(hidden)
    #   @param [true,false] hidden enables or disables the hidden aspect of the CI
    # @return [self]
    def set_hidden(*args)
      if (args[0].class == TrueClass || args[0].class == FalseClass) && !block_given?
        @j_del.java_method(:setHidden, [Java::boolean.java_class]).call(args[0])
        return self
      end
      if defined?(super)
        super
      else
        raise ArgumentError, "Invalid arguments when calling set_hidden(#{args[0]})"
      end
    end
    # @overload getPriority()
    # @return [Fixnum] the CLI priority.
    def get_priority
      if !block_given?
        return @j_del.java_method(:getPriority, []).call()
      end
      if defined?(super)
        super
      else
        raise ArgumentError, "Invalid arguments when calling get_priority()"
      end
    end
    #  Sets the list of arguments.
    # @overload setArguments(args)
    #   @param [Array<Hash{String => Object}>] args the list of arguments, must not be <code>null</code>
    # @return [self]
    def set_arguments(*args)
      if args[0].class == Array && !block_given?
        @j_del.java_method(:setArguments, [Java::JavaUtil::List.java_class]).call(args[0].map { |element| Java::IoVertxCoreCli::Argument.new(::Vertx::Util::Utils.to_json_object(element)) })
        return self
      end
      if defined?(super)
        super
      else
        raise ArgumentError, "Invalid arguments when calling set_arguments(#{args[0]})"
      end
    end
    #  Gets the list of defined arguments.
    # @overload getArguments()
    # @return [Array<Hash{String => Object}>] the list of argument, empty if none.
    def get_arguments
      if !block_given?
        return @j_del.java_method(:getArguments, []).call().to_a.map { |elt| elt != nil ? JSON.parse(elt.toJson.encode) : nil }
      end
      if defined?(super)
        super
      else
        raise ArgumentError, "Invalid arguments when calling get_arguments()"
      end
    end
    #  Sets the list of arguments.
    # @overload setOptions(options)
    #   @param [Array<Hash{String => Object}>] options the list of options, must not be <code>null</code>
    # @return [self]
    def set_options(*args)
      if args[0].class == Array && !block_given?
        @j_del.java_method(:setOptions, [Java::JavaUtil::List.java_class]).call(args[0].map { |element| Java::IoVertxCoreCli::Option.new(::Vertx::Util::Utils.to_json_object(element)) })
        return self
      end
      if defined?(super)
        super
      else
        raise ArgumentError, "Invalid arguments when calling set_options(#{args[0]})"
      end
    end
    #  Creates an instance of {::Vertx::CLI} using the default implementation.
    # @overload create(name)
    #   @param [String] name the name of the CLI (must not be <code>null</code>)
    # @return [::Vertx::CLI] the created instance of {::Vertx::CLI}
    def self.create(*args)
      if args[0].class == String && !block_given?
        return ::Vertx::Util::Utils.safe_create(Java::IoVertxCoreCli::CLI.java_method(:create, [Java::java.lang.String.java_class]).call(args[0]),::Vertx::CLI)
      end
      if defined?(super)
        super
      else
        raise ArgumentError, "Invalid arguments when calling create(#{args[0]})"
      end
    end
    #  Gets the list of options.
    # @overload getOptions()
    # @return [Array<Hash{String => Object}>] the list of options, empty if none.
    def get_options
      if !block_given?
        return @j_del.java_method(:getOptions, []).call().to_a.map { |elt| elt != nil ? JSON.parse(elt.toJson.encode) : nil }
      end
      if defined?(super)
        super
      else
        raise ArgumentError, "Invalid arguments when calling get_options()"
      end
    end
    #  Sets the priority of the CLI.
    # @overload setPriority(priority)
    #   @param [Fixnum] priority the priority
    # @return [self]
    def set_priority(*args)
      if args[0].class == Fixnum && !block_given?
        @j_del.java_method(:setPriority, [Java::int.java_class]).call(args[0])
        return self
      end
      if defined?(super)
        super
      else
        raise ArgumentError, "Invalid arguments when calling set_priority(#{args[0]})"
      end
    end
    #  Adds a set of options. Unlike {::Vertx::CLI#set_options}}, this method does not remove the existing options.
    #  The given list is appended to the existing list.
    # @overload addOptions(options)
    #   @param [Array<Hash{String => Object}>] options the options, must not be <code>null</code>
    # @return [self]
    def add_options(*args)
      if args[0].class == Array && !block_given?
        @j_del.java_method(:addOptions, [Java::JavaUtil::List.java_class]).call(args[0].map { |element| Java::IoVertxCoreCli::Option.new(::Vertx::Util::Utils.to_json_object(element)) })
        return self
      end
      if defined?(super)
        super
      else
        raise ArgumentError, "Invalid arguments when calling add_options(#{args[0]})"
      end
    end
  end
end
