require 'vertx/future'
require 'vertx/future'
require 'vertx/util/utils.rb'
# Generated from io.vertx.core.shareddata.Counter
module Vertx
  #  An asynchronous counter that can be used to across the cluster to maintain a consistent count.
  #  <p>
  class Counter
    # @private
    # @param j_del [::Vertx::Counter] the java delegate
    def initialize(j_del)
      @j_del = j_del
    end
    # @private
    # @return [::Vertx::Counter] the underlying java delegate
    def j_del
      @j_del
    end
    @@j_api_type = Object.new
    def @@j_api_type.accept?(obj)
      obj.class == Counter
    end
    def @@j_api_type.wrap(obj)
      Counter.new(obj)
    end
    def @@j_api_type.unwrap(obj)
      obj.j_del
    end
    def self.j_api_type
      @@j_api_type
    end
    def self.j_class
      Java::IoVertxCoreShareddata::Counter.java_class
    end
    #  Increment the counter atomically and return the value before the increment.
    # @overload getAndIncrement(resultHandler)
    #   @yield handler which will be passed the value
    # @return [void]
    def get_and_increment
      if true
        if (block_given?)
          return @j_del.java_method(:getAndIncrement, [Java::IoVertxCore::Handler.java_class]).call(block_given? ? Proc.new { |ar| yield(ar.failed ? ar.cause : nil, ar.succeeded ? ar.result : nil) } : promise)
        else
          promise = ::Vertx::Util::Utils.promise
          @j_del.java_method(:getAndIncrement, [Java::IoVertxCore::Handler.java_class]).call(block_given? ? Proc.new { |ar| yield(ar.failed ? ar.cause : nil, ar.succeeded ? ar.result : nil) } : promise)
          return ::Vertx::Util::Utils.safe_create(promise.future(),::Vertx::Future, nil)
        end
      end
      if defined?(super)
        super
      else
        raise ArgumentError, "Invalid arguments when calling get_and_increment()"
      end
    end
    #  Increment the counter atomically and return the new count
    # @overload incrementAndGet(resultHandler)
    #   @yield handler which will be passed the value
    # @return [void]
    def increment_and_get
      if true
        if (block_given?)
          return @j_del.java_method(:incrementAndGet, [Java::IoVertxCore::Handler.java_class]).call(block_given? ? Proc.new { |ar| yield(ar.failed ? ar.cause : nil, ar.succeeded ? ar.result : nil) } : promise)
        else
          promise = ::Vertx::Util::Utils.promise
          @j_del.java_method(:incrementAndGet, [Java::IoVertxCore::Handler.java_class]).call(block_given? ? Proc.new { |ar| yield(ar.failed ? ar.cause : nil, ar.succeeded ? ar.result : nil) } : promise)
          return ::Vertx::Util::Utils.safe_create(promise.future(),::Vertx::Future, nil)
        end
      end
      if defined?(super)
        super
      else
        raise ArgumentError, "Invalid arguments when calling increment_and_get()"
      end
    end
    #  Set the counter to the specified value only if the current value is the expectec value. This happens
    #  atomically.
    # @overload compareAndSet(expected,value,resultHandler)
    #   @param [Fixnum] expected the expected value
    #   @param [Fixnum] value the new value
    #   @yield the handler will be passed true on success
    # @return [void]
    def compare_and_set(*args)
      if args[0].class == Fixnum && args[1].class == Fixnum && true
        if (block_given?)
          return @j_del.java_method(:compareAndSet, [Java::long.java_class,Java::long.java_class,Java::IoVertxCore::Handler.java_class]).call(args[0],args[1],block_given? ? Proc.new { |ar| yield(ar.failed ? ar.cause : nil, ar.succeeded ? ar.result : nil) } : promise)
        else
          promise = ::Vertx::Util::Utils.promise
          @j_del.java_method(:compareAndSet, [Java::long.java_class,Java::long.java_class,Java::IoVertxCore::Handler.java_class]).call(args[0],args[1],block_given? ? Proc.new { |ar| yield(ar.failed ? ar.cause : nil, ar.succeeded ? ar.result : nil) } : promise)
          return ::Vertx::Util::Utils.safe_create(promise.future(),::Vertx::Future, nil)
        end
      end
      if defined?(super)
        super
      else
        raise ArgumentError, "Invalid arguments when calling compare_and_set(#{args[0]},#{args[1]})"
      end
    end
    #  Get the current value of the counter
    # @overload get(resultHandler)
    #   @yield handler which will be passed the value
    # @return [void]
    def get
      if true
        if (block_given?)
          return @j_del.java_method(:get, [Java::IoVertxCore::Handler.java_class]).call(block_given? ? Proc.new { |ar| yield(ar.failed ? ar.cause : nil, ar.succeeded ? ar.result : nil) } : promise)
        else
          promise = ::Vertx::Util::Utils.promise
          @j_del.java_method(:get, [Java::IoVertxCore::Handler.java_class]).call(block_given? ? Proc.new { |ar| yield(ar.failed ? ar.cause : nil, ar.succeeded ? ar.result : nil) } : promise)
          return ::Vertx::Util::Utils.safe_create(promise.future(),::Vertx::Future, nil)
        end
      end
      if defined?(super)
        super
      else
        raise ArgumentError, "Invalid arguments when calling get()"
      end
    end
    #  Add the value to the counter atomically and return the value before the add
    # @overload getAndAdd(value,resultHandler)
    #   @param [Fixnum] value the value to add
    #   @yield handler which will be passed the value
    # @return [void]
    def get_and_add(*args)
      if args[0].class == Fixnum && true
        if (block_given?)
          return @j_del.java_method(:getAndAdd, [Java::long.java_class,Java::IoVertxCore::Handler.java_class]).call(args[0],block_given? ? Proc.new { |ar| yield(ar.failed ? ar.cause : nil, ar.succeeded ? ar.result : nil) } : promise)
        else
          promise = ::Vertx::Util::Utils.promise
          @j_del.java_method(:getAndAdd, [Java::long.java_class,Java::IoVertxCore::Handler.java_class]).call(args[0],block_given? ? Proc.new { |ar| yield(ar.failed ? ar.cause : nil, ar.succeeded ? ar.result : nil) } : promise)
          return ::Vertx::Util::Utils.safe_create(promise.future(),::Vertx::Future, nil)
        end
      end
      if defined?(super)
        super
      else
        raise ArgumentError, "Invalid arguments when calling get_and_add(#{args[0]})"
      end
    end
    #  Add the value to the counter atomically and return the new count
    # @overload addAndGet(value,resultHandler)
    #   @param [Fixnum] value the value to add
    #   @yield handler which will be passed the value
    # @return [void]
    def add_and_get(*args)
      if args[0].class == Fixnum && true
        if (block_given?)
          return @j_del.java_method(:addAndGet, [Java::long.java_class,Java::IoVertxCore::Handler.java_class]).call(args[0],block_given? ? Proc.new { |ar| yield(ar.failed ? ar.cause : nil, ar.succeeded ? ar.result : nil) } : promise)
        else
          promise = ::Vertx::Util::Utils.promise
          @j_del.java_method(:addAndGet, [Java::long.java_class,Java::IoVertxCore::Handler.java_class]).call(args[0],block_given? ? Proc.new { |ar| yield(ar.failed ? ar.cause : nil, ar.succeeded ? ar.result : nil) } : promise)
          return ::Vertx::Util::Utils.safe_create(promise.future(),::Vertx::Future, nil)
        end
      end
      if defined?(super)
        super
      else
        raise ArgumentError, "Invalid arguments when calling add_and_get(#{args[0]})"
      end
    end
    #  Decrement the counter atomically and return the new count
    # @overload decrementAndGet(resultHandler)
    #   @yield handler which will be passed the value
    # @return [void]
    def decrement_and_get
      if true
        if (block_given?)
          return @j_del.java_method(:decrementAndGet, [Java::IoVertxCore::Handler.java_class]).call(block_given? ? Proc.new { |ar| yield(ar.failed ? ar.cause : nil, ar.succeeded ? ar.result : nil) } : promise)
        else
          promise = ::Vertx::Util::Utils.promise
          @j_del.java_method(:decrementAndGet, [Java::IoVertxCore::Handler.java_class]).call(block_given? ? Proc.new { |ar| yield(ar.failed ? ar.cause : nil, ar.succeeded ? ar.result : nil) } : promise)
          return ::Vertx::Util::Utils.safe_create(promise.future(),::Vertx::Future, nil)
        end
      end
      if defined?(super)
        super
      else
        raise ArgumentError, "Invalid arguments when calling decrement_and_get()"
      end
    end
  end
end
