require 'vertx/message'
require 'vertx/future'
require 'vertx/util/utils.rb'
# Generated from io.vertx.core.eventbus.DeliveryContext
module Vertx
  # 
  #  Encapsulates a message being delivered by Vert.x as well as providing control over the message delivery.
  #  <p/>
  #  Used with event bus interceptors.
  class DeliveryContext
    # @private
    # @param j_del [::Vertx::DeliveryContext] the java delegate
    def initialize(j_del, j_arg_T=nil)
      @j_del = j_del
      @j_arg_T = j_arg_T != nil ? j_arg_T : ::Vertx::Util::unknown_type
    end
    # @private
    # @return [::Vertx::DeliveryContext] the underlying java delegate
    def j_del
      @j_del
    end
    #  Call the next interceptor
    # @overload next()
    # @return [void]
    def next
      if !block_given?
        return @j_del.java_method(:next, []).call()
      end
      if defined?(super)
        super
      else
        raise ArgumentError, "Invalid arguments when calling next()"
      end
    end
    # @overload body()
    # @return [Object] the value delivered by the message (before or after being processed by the codec)
    def body
      if !block_given?
        return ::Vertx::Util::Utils.from_object(@j_del.java_method(:body, []).call())
      end
      if defined?(super)
        super
      else
        raise ArgumentError, "Invalid arguments when calling body()"
      end
    end
    # @overload message()
    # @return [::Vertx::Message] The message being delivered
    def message
      if !block_given?
        return ::Vertx::Util::Utils.safe_create(@j_del.java_method(:message, []).call(),::Vertx::Message, nil)
      end
      if defined?(super)
        super
      else
        raise ArgumentError, "Invalid arguments when calling message()"
      end
    end
    # @overload send()
    # @return [true,false] true if the message is being sent (point to point) or False if the message is being published
    def send?
      if !block_given?
        return @j_del.java_method(:send, []).call()
      end
      if defined?(super)
        super
      else
        raise ArgumentError, "Invalid arguments when calling send?()"
      end
    end
  end
end
