require 'vertx/buffer'
require 'vertx/future'
require 'vertx/util/utils.rb'
# Generated from io.vertx.core.parsetools.JsonEvent
module Vertx
  #  A JSON event emited by the {::Vertx::JsonParser}.
  class JsonEvent
    # @private
    # @param j_del [::Vertx::JsonEvent] the java delegate
    def initialize(j_del)
      @j_del = j_del
    end
    # @private
    # @return [::Vertx::JsonEvent] the underlying java delegate
    def j_del
      @j_del
    end
    @@j_api_type = Object.new
    def @@j_api_type.accept?(obj)
      obj.class == JsonEvent
    end
    def @@j_api_type.wrap(obj)
      JsonEvent.new(obj)
    end
    def @@j_api_type.unwrap(obj)
      obj.j_del
    end
    def self.j_api_type
      @@j_api_type
    end
    def self.j_class
      Java::IoVertxCoreParsetools::JsonEvent.java_class
    end
    # @overload fieldName()
    # @return [String] the name of the field when the event is emitted as a JSON object member
    def field_name
      if !block_given?
        return @j_del.java_method(:fieldName, []).call()
      end
      if defined?(super)
        super
      else
        raise ArgumentError, "Invalid arguments when calling field_name()"
      end
    end
    # @overload isObject()
    # @return [true,false] true when the JSON value is a JSON object
    def object?
      if !block_given?
        return @j_del.java_method(:isObject, []).call()
      end
      if defined?(super)
        super
      else
        raise ArgumentError, "Invalid arguments when calling object?()"
      end
    end
    # @overload floatValue()
    # @return [Float] the <code>Float</code> value or <code>null</code> if the event has no JSON value
    def float_value
      if !block_given?
        return @j_del.java_method(:floatValue, []).call()
      end
      if defined?(super)
        super
      else
        raise ArgumentError, "Invalid arguments when calling float_value()"
      end
    end
    # @overload objectValue()
    # @return [Hash{String => Object}] the JSON object value or <code>null</code> if the event has no JSON value
    def object_value
      if !block_given?
        return @j_del.java_method(:objectValue, []).call() != nil ? JSON.parse(@j_del.java_method(:objectValue, []).call().encode) : nil
      end
      if defined?(super)
        super
      else
        raise ArgumentError, "Invalid arguments when calling object_value()"
      end
    end
    # @overload arrayValue()
    # @return [Array<String,Object>] the JSON array value or <code>null</code> if the event has no JSON value
    def array_value
      if !block_given?
        return @j_del.java_method(:arrayValue, []).call() != nil ? JSON.parse(@j_del.java_method(:arrayValue, []).call().encode) : nil
      end
      if defined?(super)
        super
      else
        raise ArgumentError, "Invalid arguments when calling array_value()"
      end
    end
    # @overload doubleValue()
    # @return [Float] the <code>Double</code> value or <code>null</code> if the event has no JSON value
    def double_value
      if !block_given?
        return @j_del.java_method(:doubleValue, []).call()
      end
      if defined?(super)
        super
      else
        raise ArgumentError, "Invalid arguments when calling double_value()"
      end
    end
    # @overload type()
    # @return [:START_OBJECT,:END_OBJECT,:START_ARRAY,:END_ARRAY,:VALUE] the type of the event
    def type
      if !block_given?
        return @j_del.java_method(:type, []).call().name.intern
      end
      if defined?(super)
        super
      else
        raise ArgumentError, "Invalid arguments when calling type()"
      end
    end
    # @overload longValue()
    # @return [Fixnum] the <code>Long</code> value or <code>null</code> if the event has no JSON value
    def long_value
      if !block_given?
        return @j_del.java_method(:longValue, []).call()
      end
      if defined?(super)
        super
      else
        raise ArgumentError, "Invalid arguments when calling long_value()"
      end
    end
    # @overload stringValue()
    # @return [String] the string value or <code>null</code> if the event has no JSON value
    def string_value
      if !block_given?
        return @j_del.java_method(:stringValue, []).call()
      end
      if defined?(super)
        super
      else
        raise ArgumentError, "Invalid arguments when calling string_value()"
      end
    end
    # @overload isBoolean()
    # @return [true,false] true when the JSON value is a boolean
    def boolean?
      if !block_given?
        return @j_del.java_method(:isBoolean, []).call()
      end
      if defined?(super)
        super
      else
        raise ArgumentError, "Invalid arguments when calling boolean?()"
      end
    end
    # @overload isNumber()
    # @return [true,false] true when the JSON value is a number
    def number?
      if !block_given?
        return @j_del.java_method(:isNumber, []).call()
      end
      if defined?(super)
        super
      else
        raise ArgumentError, "Invalid arguments when calling number?()"
      end
    end
    # @overload isNull()
    # @return [true,false] true when the JSON value is null
    def null?
      if !block_given?
        return @j_del.java_method(:isNull, []).call()
      end
      if defined?(super)
        super
      else
        raise ArgumentError, "Invalid arguments when calling null?()"
      end
    end
    # @overload isString()
    # @return [true,false] true when the JSON value is a string
    def string?
      if !block_given?
        return @j_del.java_method(:isString, []).call()
      end
      if defined?(super)
        super
      else
        raise ArgumentError, "Invalid arguments when calling string?()"
      end
    end
    #  Decodes and returns the current value as the specified <code>type</code>.
    # @overload mapTo(type)
    #   @param [Nil] type the type to decode the value to
    # @return [Object] the decoded value
    def map_to(*args)
      if args[0].class == Class && !block_given?
        return ::Vertx::Util::Utils.v_type_of(args[0]).wrap(@j_del.java_method(:mapTo, [Java::JavaLang::Class.java_class]).call(::Vertx::Util::Utils.j_class_of(args[0])))
      end
      if defined?(super)
        super
      else
        raise ArgumentError, "Invalid arguments when calling map_to(#{args[0]})"
      end
    end
    # @overload isArray()
    # @return [true,false] true when the JSON value is a JSON array
    def array?
      if !block_given?
        return @j_del.java_method(:isArray, []).call()
      end
      if defined?(super)
        super
      else
        raise ArgumentError, "Invalid arguments when calling array?()"
      end
    end
    # @overload booleanValue()
    # @return [true,false] the <code>Boolean</code> value or <code>null</code> if the event has no JSON value
    def boolean_value?
      if !block_given?
        return @j_del.java_method(:booleanValue, []).call()
      end
      if defined?(super)
        super
      else
        raise ArgumentError, "Invalid arguments when calling boolean_value?()"
      end
    end
    # @overload integerValue()
    # @return [Fixnum] the <code>Integer</code> value or <code>null</code> if the event has no JSON value
    def integer_value
      if !block_given?
        return @j_del.java_method(:integerValue, []).call()
      end
      if defined?(super)
        super
      else
        raise ArgumentError, "Invalid arguments when calling integer_value()"
      end
    end
    # @overload value()
    # @return [Object] the json value for  events
    def value
      if !block_given?
        return ::Vertx::Util::Utils.from_object(@j_del.java_method(:value, []).call())
      end
      if defined?(super)
        super
      else
        raise ArgumentError, "Invalid arguments when calling value()"
      end
    end
    #  Return the binary value.
    #  <p>
    #  JSON itself has no notion of a binary, this extension complies to the RFC-7493, so this method assumes there is a
    #  String value with the key and it contains a Base64 encoded binary, which it decodes if found and returns.
    # @overload binaryValue()
    # @return [::Vertx::Buffer] the binary value or <code>null</code> if the event has no JSON value
    def binary_value
      if !block_given?
        return ::Vertx::Util::Utils.safe_create(@j_del.java_method(:binaryValue, []).call(),::Vertx::Buffer)
      end
      if defined?(super)
        super
      else
        raise ArgumentError, "Invalid arguments when calling binary_value()"
      end
    end
  end
end
