require 'vertx/pipe'
require 'vertx/write_stream'
require 'vertx/read_stream'
require 'vertx/message'
require 'vertx/future'
require 'vertx/future'
require 'vertx/util/utils.rb'
# Generated from io.vertx.core.eventbus.MessageConsumer
module Vertx
  #  An event bus consumer object representing a stream of message to an {::Vertx::EventBus} address that can
  #  be read from.
  #  <p>
  #  The {::Vertx::EventBus#consumer} or {::Vertx::EventBus#local_consumer}
  #  creates a new consumer, the returned consumer is not yet registered against the event bus. Registration
  #  is effective after the {::Vertx::MessageConsumer#handler} method is invoked.<p>
  # 
  #  The consumer is unregistered from the event bus using the {::Vertx::MessageConsumer#unregister} method or by calling the
  #  {::Vertx::MessageConsumer#handler} with a null value..
  class MessageConsumer
    include ::Vertx::ReadStream
    # @private
    # @param j_del [::Vertx::MessageConsumer] the java delegate
    def initialize(j_del, j_arg_T=nil)
      @j_del = j_del
      @j_arg_T = j_arg_T != nil ? j_arg_T : ::Vertx::Util::unknown_type
    end
    # @private
    # @return [::Vertx::MessageConsumer] the underlying java delegate
    def j_del
      @j_del
    end
    # @overload resume()
    # @return [self]
    def resume
      if !block_given?
        @j_del.java_method(:resume, []).call()
        return self
      end
      if defined?(super)
        super
      else
        raise ArgumentError, "Invalid arguments when calling resume()"
      end
    end
    # @overload handler(handler)
    #   @yield 
    # @return [self]
    def handler
      if true
        @j_del.java_method(:handler, [Java::IoVertxCore::Handler.java_class]).call((Proc.new { |event| yield(::Vertx::Util::Utils.safe_create(event,::Vertx::Message, nil)) unless !block_given? }))
        return self
      end
      if defined?(super)
        super
      else
        raise ArgumentError, "Invalid arguments when calling handler()"
      end
    end
    #  Set the number of messages this registration will buffer when this stream is paused. The default
    #  value is <code>1000</code>.
    #  <p>
    #  When a new value is set, buffered messages may be discarded to reach the new value. The most recent
    #  messages will be kept.
    # @overload setMaxBufferedMessages(maxBufferedMessages)
    #   @param [Fixnum] maxBufferedMessages the maximum number of messages that can be buffered
    # @return [::Vertx::MessageConsumer] this registration
    def set_max_buffered_messages(*args)
      if args[0].class == Fixnum && !block_given?
        return ::Vertx::Util::Utils.safe_create(@j_del.java_method(:setMaxBufferedMessages, [Java::int.java_class]).call(args[0]),::Vertx::MessageConsumer, nil)
      end
      if defined?(super)
        super
      else
        raise ArgumentError, "Invalid arguments when calling set_max_buffered_messages(#{args[0]})"
      end
    end
    # @overload address()
    # @return [String] The address the handler was registered with.
    def address
      if !block_given?
        return @j_del.java_method(:address, []).call()
      end
      if defined?(super)
        super
      else
        raise ArgumentError, "Invalid arguments when calling address()"
      end
    end
    #  Unregisters the handler which created this registration
    # @overload unregister(completionHandler)
    #   @yield the handler called when the unregister is done. For example in a cluster when all nodes of the event bus have been unregistered.
    # @return [void]
    def unregister
      if true
        if (block_given?)
          return @j_del.java_method(:unregister, [Java::IoVertxCore::Handler.java_class]).call(block_given? ? Proc.new { |ar| yield(ar.failed ? ar.cause : nil, ar.succeeded ? nil : nil) } : promise)
        else
          promise = ::Vertx::Util::Utils.promise
          @j_del.java_method(:unregister, [Java::IoVertxCore::Handler.java_class]).call(block_given? ? Proc.new { |ar| yield(ar.failed ? ar.cause : nil, ar.succeeded ? nil : nil) } : promise)
          return ::Vertx::Util::Utils.safe_create(promise.future(),::Vertx::Future, nil)
        end
      end
      if defined?(super)
        super
      else
        raise ArgumentError, "Invalid arguments when calling unregister()"
      end
    end
    # @overload bodyStream()
    # @return [::Vertx::ReadStream] a read stream for the body of the message stream.
    def body_stream
      if !block_given?
        return ::Vertx::Util::Utils.safe_create(@j_del.java_method(:bodyStream, []).call(),::Vertx::ReadStreamImpl, nil)
      end
      if defined?(super)
        super
      else
        raise ArgumentError, "Invalid arguments when calling body_stream()"
      end
    end
    # @overload pause()
    # @return [self]
    def pause
      if !block_given?
        @j_del.java_method(:pause, []).call()
        return self
      end
      if defined?(super)
        super
      else
        raise ArgumentError, "Invalid arguments when calling pause()"
      end
    end
    # @overload getMaxBufferedMessages()
    # @return [Fixnum] the maximum number of messages that can be buffered when this stream is paused
    def get_max_buffered_messages
      if !block_given?
        return @j_del.java_method(:getMaxBufferedMessages, []).call()
      end
      if defined?(super)
        super
      else
        raise ArgumentError, "Invalid arguments when calling get_max_buffered_messages()"
      end
    end
    #  Pipe this <code>ReadStream</code> to the <code>WriteStream</code>.
    #  <p>
    #  Elements emitted by this stream will be written to the write stream until this stream ends or fails.
    #  <p>
    #  Once this stream has ended or failed, the write stream will be ended and the <code>handler</code> will be
    #  called with the result.
    # @overload pipeTo(dst,handler)
    #   @param [::Vertx::WriteStream] dst the destination write stream
    #   @yield 
    # @return [void]
    def pipe_to(*args)
      if args[0].class.method_defined?(:j_del) && true
        if (block_given?)
          return @j_del.java_method(:pipeTo, [Java::IoVertxCoreStreams::WriteStream.java_class,Java::IoVertxCore::Handler.java_class]).call(args[0].j_del,block_given? ? Proc.new { |ar| yield(ar.failed ? ar.cause : nil, ar.succeeded ? nil : nil) } : promise)
        else
          promise = ::Vertx::Util::Utils.promise
          @j_del.java_method(:pipeTo, [Java::IoVertxCoreStreams::WriteStream.java_class,Java::IoVertxCore::Handler.java_class]).call(args[0].j_del,block_given? ? Proc.new { |ar| yield(ar.failed ? ar.cause : nil, ar.succeeded ? nil : nil) } : promise)
          return ::Vertx::Util::Utils.safe_create(promise.future(),::Vertx::Future, nil)
        end
      end
      if defined?(super)
        super
      else
        raise ArgumentError, "Invalid arguments when calling pipe_to(#{args[0]})"
      end
    end
    # @overload endHandler(endHandler)
    #   @yield 
    # @return [self]
    def end_handler
      if true
        @j_del.java_method(:endHandler, [Java::IoVertxCore::Handler.java_class]).call((Proc.new { |event| yield(nil) unless !block_given? }))
        return self
      end
      if defined?(super)
        super
      else
        raise ArgumentError, "Invalid arguments when calling end_handler()"
      end
    end
    # @overload fetch(amount)
    #   @param [Fixnum] amount 
    # @return [self]
    def fetch(*args)
      if args[0].class == Fixnum && !block_given?
        @j_del.java_method(:fetch, [Java::long.java_class]).call(args[0])
        return self
      end
      if defined?(super)
        super
      else
        raise ArgumentError, "Invalid arguments when calling fetch(#{args[0]})"
      end
    end
    # @overload isRegistered()
    # @return [true,false] true if the current consumer is registered
    def registered?
      if !block_given?
        return @j_del.java_method(:isRegistered, []).call()
      end
      if defined?(super)
        super
      else
        raise ArgumentError, "Invalid arguments when calling registered?()"
      end
    end
    #  Pause this stream and return a  to transfer the elements of this stream to a destination .
    #  <p/>
    #  The stream will be resumed when the pipe will be wired to a <code>WriteStream</code>.
    # @overload pipe()
    # @return [::Vertx::Pipe] a pipe
    def pipe
      if !block_given?
        return ::Vertx::Util::Utils.safe_create(@j_del.java_method(:pipe, []).call(),::Vertx::Pipe,::Vertx::Message.j_api_type)
      end
      if defined?(super)
        super
      else
        raise ArgumentError, "Invalid arguments when calling pipe()"
      end
    end
    #  Optional method which can be called to indicate when the registration has been propagated across the cluster.
    # @overload completionHandler(completionHandler)
    #   @yield the completion handler
    # @return [void]
    def completion_handler
      if true
        if (block_given?)
          return @j_del.java_method(:completionHandler, [Java::IoVertxCore::Handler.java_class]).call(block_given? ? Proc.new { |ar| yield(ar.failed ? ar.cause : nil, ar.succeeded ? nil : nil) } : promise)
        else
          promise = ::Vertx::Util::Utils.promise
          @j_del.java_method(:completionHandler, [Java::IoVertxCore::Handler.java_class]).call(block_given? ? Proc.new { |ar| yield(ar.failed ? ar.cause : nil, ar.succeeded ? nil : nil) } : promise)
          return ::Vertx::Util::Utils.safe_create(promise.future(),::Vertx::Future, nil)
        end
      end
      if defined?(super)
        super
      else
        raise ArgumentError, "Invalid arguments when calling completion_handler()"
      end
    end
    # @overload exceptionHandler(handler)
    #   @yield 
    # @return [self]
    def exception_handler
      if true
        @j_del.java_method(:exceptionHandler, [Java::IoVertxCore::Handler.java_class]).call((Proc.new { |event| yield(::Vertx::Util::Utils.from_throwable(event)) unless !block_given? }))
        return self
      end
      if defined?(super)
        super
      else
        raise ArgumentError, "Invalid arguments when calling exception_handler()"
      end
    end
  end
end
