require 'vertx/buffer'
require 'vertx-amqp-client/amqp_message_builder'
require 'vertx/future'
require 'vertx/util/utils.rb'
# Generated from io.vertx.amqp.AmqpMessage
module VertxAmqpClient
  #  Represents an AMQP message.
  #  <p>
  #  Reference about the different metadata can be found on
  #  <a href="http://docs.oasis-open.org/amqp/core/v1.0/amqp-core-messaging-v1.0.html#type-properties">AMQP message properties</a>.
  #  <p>
  #  Note that the body is retrieved using <code>body*</code> method depending on the expected type.
  class AmqpMessage
    # @private
    # @param j_del [::VertxAmqpClient::AmqpMessage] the java delegate
    def initialize(j_del)
      @j_del = j_del
    end
    # @private
    # @return [::VertxAmqpClient::AmqpMessage] the underlying java delegate
    def j_del
      @j_del
    end
    @@j_api_type = Object.new
    def @@j_api_type.accept?(obj)
      obj.class == AmqpMessage
    end
    def @@j_api_type.wrap(obj)
      AmqpMessage.new(obj)
    end
    def @@j_api_type.unwrap(obj)
      obj.j_del
    end
    def self.j_api_type
      @@j_api_type
    end
    def self.j_class
      Java::IoVertxAmqp::AmqpMessage.java_class
    end
    # @overload bodyAsBoolean()
    # @return [true,false] the boolean value contained in the body. The value must be passed as AMQP value.
    def body_as_boolean?
      if !block_given?
        return @j_del.java_method(:bodyAsBoolean, []).call()
      end
      if defined?(super)
        super
      else
        raise ArgumentError, "Invalid arguments when calling body_as_boolean?()"
      end
    end
    # @overload creationTime()
    # @return [Fixnum]
    def creation_time
      if !block_given?
        return @j_del.java_method(:creationTime, []).call()
      end
      if defined?(super)
        super
      else
        raise ArgumentError, "Invalid arguments when calling creation_time()"
      end
    end
    #  When receiving a message, and when auto-acknowledgement is disabled, this method is used to acknowledge
    #  the incoming message as <code>rejected</code>.
    # @overload rejected()
    # @return [self]
    def rejected
      if !block_given?
        @j_del.java_method(:rejected, []).call()
        return self
      end
      if defined?(super)
        super
      else
        raise ArgumentError, "Invalid arguments when calling rejected()"
      end
    end
    # @overload bodyAsFloat()
    # @return [Float] the float value contained in the body. The value must be passed as AMQP value.
    def body_as_float
      if !block_given?
        return @j_del.java_method(:bodyAsFloat, []).call()
      end
      if defined?(super)
        super
      else
        raise ArgumentError, "Invalid arguments when calling body_as_float()"
      end
    end
    # @overload subject()
    # @return [String]
    def subject
      if !block_given?
        return @j_del.java_method(:subject, []).call()
      end
      if defined?(super)
        super
      else
        raise ArgumentError, "Invalid arguments when calling subject()"
      end
    end
    # @overload bodyAsList()
    # @return [Array<Object>] the list of values contained in the body. The value must be passed as AMQP value.
    def body_as_list
      if !block_given?
        return @j_del.java_method(:bodyAsList, []).call().to_a.map { |elt| ::Vertx::Util::Utils.from_object(elt) }
      end
      if defined?(super)
        super
      else
        raise ArgumentError, "Invalid arguments when calling body_as_list()"
      end
    end
    # @overload groupId()
    # @return [String]
    def group_id
      if !block_given?
        return @j_del.java_method(:groupId, []).call()
      end
      if defined?(super)
        super
      else
        raise ArgumentError, "Invalid arguments when calling group_id()"
      end
    end
    # @overload bodyAsJsonObject()
    # @return [Hash{String => Object}] the JSON object contained in the body. The value must be passed as AMQP data.
    def body_as_json_object
      if !block_given?
        return @j_del.java_method(:bodyAsJsonObject, []).call() != nil ? JSON.parse(@j_del.java_method(:bodyAsJsonObject, []).call().encode) : nil
      end
      if defined?(super)
        super
      else
        raise ArgumentError, "Invalid arguments when calling body_as_json_object()"
      end
    end
    # @overload bodyAsDouble()
    # @return [Float] the double value contained in the body. The value must be passed as AMQP value.
    def body_as_double
      if !block_given?
        return @j_del.java_method(:bodyAsDouble, []).call()
      end
      if defined?(super)
        super
      else
        raise ArgumentError, "Invalid arguments when calling body_as_double()"
      end
    end
    #  When receiving a message,  and when auto-acknowledgement is disabled, this method is used to acknowledge
    #  the incoming message as <code>modified</code>.
    # @overload modified(didItFail,wasItDeliveredHere)
    #   @param [true,false] didItFail pass <code>true</code> to increase the failed delivery count
    #   @param [true,false] wasItDeliveredHere pass <code>true</code> to prevent the re-delivery of the message
    # @return [self]
    def modified(*args)
      if (args[0].class == TrueClass || args[0].class == FalseClass) && (args[1].class == TrueClass || args[1].class == FalseClass) && !block_given?
        @j_del.java_method(:modified, [Java::boolean.java_class,Java::boolean.java_class]).call(args[0],args[1])
        return self
      end
      if defined?(super)
        super
      else
        raise ArgumentError, "Invalid arguments when calling modified(#{args[0]},#{args[1]})"
      end
    end
    # @overload replyToGroupId()
    # @return [String]
    def reply_to_group_id
      if !block_given?
        return @j_del.java_method(:replyToGroupId, []).call()
      end
      if defined?(super)
        super
      else
        raise ArgumentError, "Invalid arguments when calling reply_to_group_id()"
      end
    end
    # @overload contentEncoding()
    # @return [String]
    def content_encoding
      if !block_given?
        return @j_del.java_method(:contentEncoding, []).call()
      end
      if defined?(super)
        super
      else
        raise ArgumentError, "Invalid arguments when calling content_encoding()"
      end
    end
    #  Creates a builder to create a new {::VertxAmqpClient::AmqpMessage} copying the metadata from the passed message.
    # @overload create()
    # @overload create(existing)
    #   @param [::VertxAmqpClient::AmqpMessage] existing an existing message, must not be <code>null</code>.
    # @return [::VertxAmqpClient::AmqpMessageBuilder] a builder to create an {::VertxAmqpClient::AmqpMessage}.
    def self.create(*args)
      if !block_given? && args[0] == nil
        return ::Vertx::Util::Utils.safe_create(Java::IoVertxAmqp::AmqpMessage.java_method(:create, []).call(),::VertxAmqpClient::AmqpMessageBuilder)
      elsif args[0].class.method_defined?(:j_del) && !block_given?
        return ::Vertx::Util::Utils.safe_create(Java::IoVertxAmqp::AmqpMessage.java_method(:create, [Java::IoVertxAmqp::AmqpMessage.java_class]).call(args[0].j_del),::VertxAmqpClient::AmqpMessageBuilder)
      end
      if defined?(super)
        super
      else
        raise ArgumentError, "Invalid arguments when calling create(#{args[0]})"
      end
    end
    # @overload applicationProperties()
    # @return [Hash{String => Object}] the message properties as JSON object.
    def application_properties
      if !block_given?
        return @j_del.java_method(:applicationProperties, []).call() != nil ? JSON.parse(@j_del.java_method(:applicationProperties, []).call().encode) : nil
      end
      if defined?(super)
        super
      else
        raise ArgumentError, "Invalid arguments when calling application_properties()"
      end
    end
    # @overload bodyAsChar()
    # @return [Fixnum] the character value contained in the body. The value must be passed as AMQP value.
    def body_as_char
      if !block_given?
        return @j_del.java_method(:bodyAsChar, []).call()
      end
      if defined?(super)
        super
      else
        raise ArgumentError, "Invalid arguments when calling body_as_char()"
      end
    end
    # @overload bodyAsInteger()
    # @return [Fixnum] the integer value contained in the body. The value must be passed as AMQP value.
    def body_as_integer
      if !block_given?
        return @j_del.java_method(:bodyAsInteger, []).call()
      end
      if defined?(super)
        super
      else
        raise ArgumentError, "Invalid arguments when calling body_as_integer()"
      end
    end
    # @overload correlationId()
    # @return [String] The client-specific id that can be used to mark or identify messages between clients.
    def correlation_id
      if !block_given?
        return @j_del.java_method(:correlationId, []).call()
      end
      if defined?(super)
        super
      else
        raise ArgumentError, "Invalid arguments when calling correlation_id()"
      end
    end
    # @overload id()
    # @return [String] the message id
    def id
      if !block_given?
        return @j_del.java_method(:id, []).call()
      end
      if defined?(super)
        super
      else
        raise ArgumentError, "Invalid arguments when calling id()"
      end
    end
    # @overload contentType()
    # @return [String]
    def content_type
      if !block_given?
        return @j_del.java_method(:contentType, []).call()
      end
      if defined?(super)
        super
      else
        raise ArgumentError, "Invalid arguments when calling content_type()"
      end
    end
    # @overload deliveryCount()
    # @return [Fixnum] the number of unsuccessful previous attempts to deliver this message. If this value is non-zero it can be taken as an indication that the delivery might be a duplicate. On first delivery, the value is zero. It is incremented upon an outcome being settled at the sender, according to rules defined for each outcome.
    def delivery_count
      if !block_given?
        return @j_del.java_method(:deliveryCount, []).call()
      end
      if defined?(super)
        super
      else
        raise ArgumentError, "Invalid arguments when calling delivery_count()"
      end
    end
    #  When receiving a message, and when auto-acknowledgement is disabled, this method is used to acknowledge
    #  the incoming message as <code>released</code>.
    # @overload released()
    # @return [self]
    def released
      if !block_given?
        @j_del.java_method(:released, []).call()
        return self
      end
      if defined?(super)
        super
      else
        raise ArgumentError, "Invalid arguments when calling released()"
      end
    end
    # @overload bodyAsJsonArray()
    # @return [Array<String,Object>] the JSON array contained in the body. The value must be passed as AMQP data.
    def body_as_json_array
      if !block_given?
        return @j_del.java_method(:bodyAsJsonArray, []).call() != nil ? JSON.parse(@j_del.java_method(:bodyAsJsonArray, []).call().encode) : nil
      end
      if defined?(super)
        super
      else
        raise ArgumentError, "Invalid arguments when calling body_as_json_array()"
      end
    end
    # @overload isBodyNull()
    # @return [true,false] whether the body is <code>null</code>. This method returns <code>true</code> is the message does not contain a body or if the message contain a <code>null</code> AMQP value as body.
    def body_null?
      if !block_given?
        return @j_del.java_method(:isBodyNull, []).call()
      end
      if defined?(super)
        super
      else
        raise ArgumentError, "Invalid arguments when calling body_null?()"
      end
    end
    # @overload bodyAsString()
    # @return [String] the string value contained in the body. The value must be passed as AMQP value.
    def body_as_string
      if !block_given?
        return @j_del.java_method(:bodyAsString, []).call()
      end
      if defined?(super)
        super
      else
        raise ArgumentError, "Invalid arguments when calling body_as_string()"
      end
    end
    # @overload address()
    # @return [String] the message address, also named <code>to</code> field
    def address
      if !block_given?
        return @j_del.java_method(:address, []).call()
      end
      if defined?(super)
        super
      else
        raise ArgumentError, "Invalid arguments when calling address()"
      end
    end
    # @overload bodyAsLong()
    # @return [Fixnum] the long value contained in the body. The value must be passed as AMQP value.
    def body_as_long
      if !block_given?
        return @j_del.java_method(:bodyAsLong, []).call()
      end
      if defined?(super)
        super
      else
        raise ArgumentError, "Invalid arguments when calling body_as_long()"
      end
    end
    # @overload bodyAsSymbol()
    # @return [String] the symbol value contained in the body. The value must be passed as AMQP value.
    def body_as_symbol
      if !block_given?
        return @j_del.java_method(:bodyAsSymbol, []).call()
      end
      if defined?(super)
        super
      else
        raise ArgumentError, "Invalid arguments when calling body_as_symbol()"
      end
    end
    # @overload groupSequence()
    # @return [Fixnum]
    def group_sequence
      if !block_given?
        return @j_del.java_method(:groupSequence, []).call()
      end
      if defined?(super)
        super
      else
        raise ArgumentError, "Invalid arguments when calling group_sequence()"
      end
    end
    #  When receiving a message, and when auto-acknowledgement is disabled, this method is used to acknowledge
    #  the incoming message. It marks the message as delivered with the <code>accepted</code> status.
    # @overload accepted()
    # @return [self]
    def accepted
      if !block_given?
        @j_del.java_method(:accepted, []).call()
        return self
      end
      if defined?(super)
        super
      else
        raise ArgumentError, "Invalid arguments when calling accepted()"
      end
    end
    # @overload bodyAsShort()
    # @return [Fixnum] the short value contained in the body. The value must be passed as AMQP value.
    def body_as_short
      if !block_given?
        return @j_del.java_method(:bodyAsShort, []).call()
      end
      if defined?(super)
        super
      else
        raise ArgumentError, "Invalid arguments when calling body_as_short()"
      end
    end
    # @overload isDurable()
    # @return [true,false] whether or not the message is durable.
    def durable?
      if !block_given?
        return @j_del.java_method(:isDurable, []).call()
      end
      if defined?(super)
        super
      else
        raise ArgumentError, "Invalid arguments when calling durable?()"
      end
    end
    # @overload bodyAsByte()
    # @return [Fixnum] the byte value contained in the body. The value must be passed as AMQP value.
    def body_as_byte
      if !block_given?
        return @j_del.java_method(:bodyAsByte, []).call()
      end
      if defined?(super)
        super
      else
        raise ArgumentError, "Invalid arguments when calling body_as_byte()"
      end
    end
    # @overload priority()
    # @return [Fixnum] the relative message priority. Higher numbers indicate higher priority messages. Messages with higher priorities MAY be delivered before those with lower priorities.
    def priority
      if !block_given?
        return @j_del.java_method(:priority, []).call()
      end
      if defined?(super)
        super
      else
        raise ArgumentError, "Invalid arguments when calling priority()"
      end
    end
    # @overload ttl()
    # @return [Fixnum] the duration in milliseconds for which the message is to be considered "live".
    def ttl
      if !block_given?
        return @j_del.java_method(:ttl, []).call()
      end
      if defined?(super)
        super
      else
        raise ArgumentError, "Invalid arguments when calling ttl()"
      end
    end
    # @overload isFirstAcquirer()
    # @return [true,false] if <code>true</code>, then this message has not been acquired by any other link. If <code>false</code>, then this message MAY have previously been acquired by another link or links.
    def first_acquirer?
      if !block_given?
        return @j_del.java_method(:isFirstAcquirer, []).call()
      end
      if defined?(super)
        super
      else
        raise ArgumentError, "Invalid arguments when calling first_acquirer?()"
      end
    end
    # @overload bodyAsBinary()
    # @return [::Vertx::Buffer] the bytes contained in the body. The value must be passed as AMQP data.
    def body_as_binary
      if !block_given?
        return ::Vertx::Util::Utils.safe_create(@j_del.java_method(:bodyAsBinary, []).call(),::Vertx::Buffer)
      end
      if defined?(super)
        super
      else
        raise ArgumentError, "Invalid arguments when calling body_as_binary()"
      end
    end
    # @overload expiryTime()
    # @return [Fixnum]
    def expiry_time
      if !block_given?
        return @j_del.java_method(:expiryTime, []).call()
      end
      if defined?(super)
        super
      else
        raise ArgumentError, "Invalid arguments when calling expiry_time()"
      end
    end
    # @overload replyTo()
    # @return [String] The address of the node to send replies to, if any.
    def reply_to
      if !block_given?
        return @j_del.java_method(:replyTo, []).call()
      end
      if defined?(super)
        super
      else
        raise ArgumentError, "Invalid arguments when calling reply_to()"
      end
    end
  end
end
