require 'vertx-auth-common/authorization_context'
require 'vertx/future'
require 'vertx/util/utils.rb'
# Generated from io.vertx.ext.auth.authorization.Authorization
module VertxAuthCommon
  #  Interface representing any kind of authorization such as:
  #  <ul>
  #    <li>Role based authorization
  #    <li>Permission based authorization
  #    <li>Logical authorization (AND, OR, NOT)
  #    <li>Time based authorization (ie: allow access the last 5 days of the month, from 8am till 10am, etc.)
  #    <li>Context based authorization (ie: allow access if the ip address is 'xxx.xxx.xxx.xxx')
  #    <li>Custom based authorization (ie: based on a script or hard-coded code specific to an application)
  #    <li>etc.
  #  </ul>
  #  The following implementations are provided out of the box:
  #  <ul>
  #    <li>{::VertxAuthCommon::AndAuthorization}
  #    <li>{::VertxAuthCommon::NotAuthorization}
  #    <li>{::VertxAuthCommon::OrAuthorization}
  #    <li>{::VertxAuthCommon::PermissionBasedAuthorization}
  #    <li>{::VertxAuthCommon::RoleBasedAuthorization}
  #    <li>{::VertxAuthCommon::WildcardPermissionBasedAuthorization}
  #  </ul>
  class Authorization
    # @private
    # @param j_del [::VertxAuthCommon::Authorization] the java delegate
    def initialize(j_del)
      @j_del = j_del
    end
    # @private
    # @return [::VertxAuthCommon::Authorization] the underlying java delegate
    def j_del
      @j_del
    end
    @@j_api_type = Object.new
    def @@j_api_type.accept?(obj)
      obj.class == Authorization
    end
    def @@j_api_type.wrap(obj)
      Authorization.new(obj)
    end
    def @@j_api_type.unwrap(obj)
      obj.j_del
    end
    def self.j_api_type
      @@j_api_type
    end
    def self.j_class
      Java::IoVertxExtAuthAuthorization::Authorization.java_class
    end
    #  this methods verifies whether or not the authorization match the specified
    #  context.
    # @overload match(context)
    #   @param [::VertxAuthCommon::AuthorizationContext] context 
    # @return [true,false] 
    def match?(*args)
      if args[0].class.method_defined?(:j_del) && !block_given?
        return @j_del.java_method(:match, [Java::IoVertxExtAuthAuthorization::AuthorizationContext.java_class]).call(args[0].j_del)
      end
      if defined?(super)
        super
      else
        raise ArgumentError, "Invalid arguments when calling match?(#{args[0]})"
      end
    end
    #  this method verifies whether or not the authorization implies the specified
    #  authorization.
    #  </br>Note that it doesn't always mean an exact match. For instance,
    #  in the case of a {::VertxAuthCommon::WildcardPermissionBasedAuthorization}, this method
    #  may return true even if the permissions are different
    #  </br>WildcardPermissionBasedAuthorization.create('*').implies(WildcardPermissionBasedAuthorization.create('anypermission'))
    #  would return true
    # @overload verify(authorization)
    #   @param [::VertxAuthCommon::Authorization] authorization 
    # @return [true,false] 
    def verify?(*args)
      if args[0].class.method_defined?(:j_del) && !block_given?
        return @j_del.java_method(:verify, [Java::IoVertxExtAuthAuthorization::Authorization.java_class]).call(args[0].j_del)
      end
      if defined?(super)
        super
      else
        raise ArgumentError, "Invalid arguments when calling verify?(#{args[0]})"
      end
    end
  end
end
