require 'vertx-auth-common/authorization'
require 'vertx/future'
require 'vertx/util/utils.rb'
# Generated from io.vertx.ext.auth.authorization.OrAuthorization
module VertxAuthCommon
  #  Allows to perform a logical 'or' between several authorizations
  class OrAuthorization < ::VertxAuthCommon::Authorization
    # @private
    # @param j_del [::VertxAuthCommon::OrAuthorization] the java delegate
    def initialize(j_del)
      super(j_del)
      @j_del = j_del
    end
    # @private
    # @return [::VertxAuthCommon::OrAuthorization] the underlying java delegate
    def j_del
      @j_del
    end
    @@j_api_type = Object.new
    def @@j_api_type.accept?(obj)
      obj.class == OrAuthorization
    end
    def @@j_api_type.wrap(obj)
      OrAuthorization.new(obj)
    end
    def @@j_api_type.unwrap(obj)
      obj.j_del
    end
    def self.j_api_type
      @@j_api_type
    end
    def self.j_class
      Java::IoVertxExtAuthAuthorization::OrAuthorization.java_class
    end
    # @overload getAuthorizations()
    # @return [Array<::VertxAuthCommon::Authorization>]
    def get_authorizations
      if !block_given?
        return @j_del.java_method(:getAuthorizations, []).call().to_a.map { |elt| ::Vertx::Util::Utils.safe_create(elt,::VertxAuthCommon::Authorization) }
      end
      if defined?(super)
        super
      else
        raise ArgumentError, "Invalid arguments when calling get_authorizations()"
      end
    end
    # @overload create()
    # @return [::VertxAuthCommon::OrAuthorization]
    def self.create
      if !block_given?
        return ::Vertx::Util::Utils.safe_create(Java::IoVertxExtAuthAuthorization::OrAuthorization.java_method(:create, []).call(),::VertxAuthCommon::OrAuthorization)
      end
      if defined?(super)
        super
      else
        raise ArgumentError, "Invalid arguments when calling create()"
      end
    end
    # @overload addAuthorization(authorization)
    #   @param [::VertxAuthCommon::Authorization] authorization 
    # @return [::VertxAuthCommon::OrAuthorization]
    def add_authorization(*args)
      if args[0].class.method_defined?(:j_del) && !block_given?
        return ::Vertx::Util::Utils.safe_create(@j_del.java_method(:addAuthorization, [Java::IoVertxExtAuthAuthorization::Authorization.java_class]).call(args[0].j_del),::VertxAuthCommon::OrAuthorization)
      end
      if defined?(super)
        super
      else
        raise ArgumentError, "Invalid arguments when calling add_authorization(#{args[0]})"
      end
    end
  end
end
