require 'vertx-auth-common/authorization'
require 'vertx/future'
require 'vertx/util/utils.rb'
# Generated from io.vertx.ext.auth.authorization.PermissionBasedAuthorization
module VertxAuthCommon
  #  Represents a permission Note that the permission can optionally be assigned
  #  to a specific resource
  class PermissionBasedAuthorization < ::VertxAuthCommon::Authorization
    # @private
    # @param j_del [::VertxAuthCommon::PermissionBasedAuthorization] the java delegate
    def initialize(j_del)
      super(j_del)
      @j_del = j_del
    end
    # @private
    # @return [::VertxAuthCommon::PermissionBasedAuthorization] the underlying java delegate
    def j_del
      @j_del
    end
    @@j_api_type = Object.new
    def @@j_api_type.accept?(obj)
      obj.class == PermissionBasedAuthorization
    end
    def @@j_api_type.wrap(obj)
      PermissionBasedAuthorization.new(obj)
    end
    def @@j_api_type.unwrap(obj)
      obj.j_del
    end
    def self.j_api_type
      @@j_api_type
    end
    def self.j_class
      Java::IoVertxExtAuthAuthorization::PermissionBasedAuthorization.java_class
    end
    #  returns an optional resource that the permission is assigned-on
    # @overload getResource()
    # @return [String] 
    def get_resource
      if !block_given?
        return @j_del.java_method(:getResource, []).call()
      end
      if defined?(super)
        super
      else
        raise ArgumentError, "Invalid arguments when calling get_resource()"
      end
    end
    #  returns the value of the permission
    # @overload getPermission()
    # @return [String] 
    def get_permission
      if !block_given?
        return @j_del.java_method(:getPermission, []).call()
      end
      if defined?(super)
        super
      else
        raise ArgumentError, "Invalid arguments when calling get_permission()"
      end
    end
    # @overload create(permission)
    #   @param [String] permission 
    # @return [::VertxAuthCommon::PermissionBasedAuthorization]
    def self.create(*args)
      if args[0].class == String && !block_given?
        return ::Vertx::Util::Utils.safe_create(Java::IoVertxExtAuthAuthorization::PermissionBasedAuthorization.java_method(:create, [Java::java.lang.String.java_class]).call(args[0]),::VertxAuthCommon::PermissionBasedAuthorization)
      end
      if defined?(super)
        super
      else
        raise ArgumentError, "Invalid arguments when calling create(#{args[0]})"
      end
    end
    #  sets an optional resource that the permission is assigned-on
    # @overload setResource(resource)
    #   @param [String] resource 
    # @return [self]
    def set_resource(*args)
      if args[0].class == String && !block_given?
        @j_del.java_method(:setResource, [Java::java.lang.String.java_class]).call(args[0])
        return self
      end
      if defined?(super)
        super
      else
        raise ArgumentError, "Invalid arguments when calling set_resource(#{args[0]})"
      end
    end
  end
end
