require 'vertx-jdbc/jdbc_client'
require 'vertx-auth-jdbc/jdbc_hash_strategy'
require 'vertx-auth-common/auth_provider'
require 'vertx/future'
require 'vertx/util/utils.rb'
# Generated from io.vertx.ext.auth.jdbc.JDBCAuthentication
module VertxAuthJdbc
  #  Factory interface for creating {::VertxAuthCommon::AuthProvider} instances that use the Vert.x JDBC client.
  # 
  #  By default the hashing strategy is SHA-512. If you're already running in production this is backwards
  #  compatible, however for new deployments or security upgrades it is recommended to use the PBKDF2 strategy
  #  as it is the current OWASP recommendation for password storage.
  class JDBCAuthentication < ::VertxAuthCommon::AuthProvider
    # @private
    # @param j_del [::VertxAuthJdbc::JDBCAuthentication] the java delegate
    def initialize(j_del)
      super(j_del)
      @j_del = j_del
    end
    # @private
    # @return [::VertxAuthJdbc::JDBCAuthentication] the underlying java delegate
    def j_del
      @j_del
    end
    @@j_api_type = Object.new
    def @@j_api_type.accept?(obj)
      obj.class == JDBCAuthentication
    end
    def @@j_api_type.wrap(obj)
      JDBCAuthentication.new(obj)
    end
    def @@j_api_type.unwrap(obj)
      obj.j_del
    end
    def self.j_api_type
      @@j_api_type
    end
    def self.j_class
      Java::IoVertxExtAuthJdbc::JDBCAuthentication.java_class
    end
    #  Create a JDBC auth provider implementation
    # @overload create(client,hashStrategy,options)
    #   @param [::VertxJdbc::JDBCClient] client the JDBC client instance
    #   @param [::VertxAuthJdbc::JDBCHashStrategy] hashStrategy 
    #   @param [Hash{String => Object}] options authentication options
    # @return [::VertxAuthJdbc::JDBCAuthentication] the auth provider
    def self.create(*args)
      if args[0].class.method_defined?(:j_del) && args[1].class.method_defined?(:j_del) && args[2].class == Hash && !block_given?
        return ::Vertx::Util::Utils.safe_create(Java::IoVertxExtAuthJdbc::JDBCAuthentication.java_method(:create, [Java::IoVertxExtJdbc::JDBCClient.java_class,Java::IoVertxExtAuthJdbc::JDBCHashStrategy.java_class,Java::IoVertxExtAuthJdbc::JDBCAuthenticationOptions.java_class]).call(args[0].j_del,args[1].j_del,Java::IoVertxExtAuthJdbc::JDBCAuthenticationOptions.new(::Vertx::Util::Utils.to_json_object(args[2]))),::VertxAuthJdbc::JDBCAuthentication)
      end
      if defined?(super)
        super
      else
        raise ArgumentError, "Invalid arguments when calling create(#{args[0]},#{args[1]},#{args[2]})"
      end
    end
  end
end
