require 'vertx-jdbc/jdbc_client'
require 'vertx-auth-common/authorization_provider'
require 'vertx/future'
require 'vertx/util/utils.rb'
# Generated from io.vertx.ext.auth.jdbc.JDBCAuthorization
module VertxAuthJdbc
  #  Factory interface for creating  instances that use the Vert.x JDBC client.
  class JDBCAuthorization < ::VertxAuthCommon::AuthorizationProvider
    # @private
    # @param j_del [::VertxAuthJdbc::JDBCAuthorization] the java delegate
    def initialize(j_del)
      super(j_del)
      @j_del = j_del
    end
    # @private
    # @return [::VertxAuthJdbc::JDBCAuthorization] the underlying java delegate
    def j_del
      @j_del
    end
    @@j_api_type = Object.new
    def @@j_api_type.accept?(obj)
      obj.class == JDBCAuthorization
    end
    def @@j_api_type.wrap(obj)
      JDBCAuthorization.new(obj)
    end
    def @@j_api_type.unwrap(obj)
      obj.j_del
    end
    def self.j_api_type
      @@j_api_type
    end
    def self.j_class
      Java::IoVertxExtAuthJdbc::JDBCAuthorization.java_class
    end
    #  Create a JDBC authorization provider implementation
    # @overload create(providerId,client,options)
    #   @param [String] providerId the provider id
    #   @param [::VertxJdbc::JDBCClient] client the JDBC client instance
    #   @param [Hash{String => Object}] options the {Hash{String => Object}}
    # @return [::VertxAuthJdbc::JDBCAuthorization] the auth provider
    def self.create(*args)
      if args[0].class == String && args[1].class.method_defined?(:j_del) && args[2].class == Hash && !block_given?
        return ::Vertx::Util::Utils.safe_create(Java::IoVertxExtAuthJdbc::JDBCAuthorization.java_method(:create, [Java::java.lang.String.java_class,Java::IoVertxExtJdbc::JDBCClient.java_class,Java::IoVertxExtAuthJdbc::JDBCAuthorizationOptions.java_class]).call(args[0],args[1].j_del,Java::IoVertxExtAuthJdbc::JDBCAuthorizationOptions.new(::Vertx::Util::Utils.to_json_object(args[2]))),::VertxAuthJdbc::JDBCAuthorization)
      end
      if defined?(super)
        super
      else
        raise ArgumentError, "Invalid arguments when calling create(#{args[0]},#{args[1]},#{args[2]})"
      end
    end
  end
end
