require 'vertx-auth-common/user'
require 'vertx/future'
require 'vertx/util/utils.rb'
# Generated from io.vertx.ext.auth.mongo.HashStrategy
module VertxAuthMongo
  #  Determines how the hashing is computed in the implementation You can implement this to provide a different hashing
  #  strategy to the default.
  class HashStrategy
    # @private
    # @param j_del [::VertxAuthMongo::HashStrategy] the java delegate
    def initialize(j_del)
      @j_del = j_del
    end
    # @private
    # @return [::VertxAuthMongo::HashStrategy] the underlying java delegate
    def j_del
      @j_del
    end
    @@j_api_type = Object.new
    def @@j_api_type.accept?(obj)
      obj.class == HashStrategy
    end
    def @@j_api_type.wrap(obj)
      HashStrategy.new(obj)
    end
    def @@j_api_type.unwrap(obj)
      obj.j_del
    end
    def self.j_api_type
      @@j_api_type
    end
    def self.j_class
      Java::IoVertxExtAuthMongo::HashStrategy.java_class
    end
    #  Set the saltstyle as defined by HashSaltStyle.
    # @overload setSaltStyle(saltStyle)
    #   @param [:NO_SALT,:COLUMN,:EXTERNAL] saltStyle the HashSaltStyle to be used
    # @return [void]
    def set_salt_style(*args)
      if args[0].class == Symbol && !block_given?
        return @j_del.java_method(:setSaltStyle, [Java::IoVertxExtAuthMongo::HashSaltStyle.java_class]).call(Java::IoVertxExtAuthMongo::HashSaltStyle.valueOf(args[0].to_s))
      end
      if defined?(super)
        super
      else
        raise ArgumentError, "Invalid arguments when calling set_salt_style(#{args[0]})"
      end
    end
    #  Retrieve the salt. The source of the salt can be the external salt or the propriate column of the given user,
    #  depending on the defined HashSaltStyle
    # @overload getSalt(user)
    #   @param [::VertxAuthCommon::User] user the user to get the salt for. This paramter is needed, if the  is declared to be used
    # @return [String] null in case of  the salt of the user or a defined external salt
    def get_salt(*args)
      if args[0].class.method_defined?(:j_del) && !block_given?
        return @j_del.java_method(:getSalt, [Java::IoVertxExtAuth::User.java_class]).call(args[0].j_del)
      end
      if defined?(super)
        super
      else
        raise ArgumentError, "Invalid arguments when calling get_salt(#{args[0]})"
      end
    end
    #  Retrieve the password from the user, or as clear text or as hashed version, depending on the definition
    # @overload getStoredPwd(user)
    #   @param [::VertxAuthCommon::User] user the user to get the stored password for
    # @return [String] the password, either as hashed version or as cleartext, depending on the preferences
    def get_stored_pwd(*args)
      if args[0].class.method_defined?(:j_del) && !block_given?
        return @j_del.java_method(:getStoredPwd, [Java::IoVertxExtAuth::User.java_class]).call(args[0].j_del)
      end
      if defined?(super)
        super
      else
        raise ArgumentError, "Invalid arguments when calling get_stored_pwd(#{args[0]})"
      end
    end
    #  Compute the hashed password given the unhashed password and the user
    # @overload computeHash(password,user)
    #   @param [String] password the unhashed password
    #   @param [::VertxAuthCommon::User] user the user to get the salt for. This paramter is needed, if the  is declared to be used
    # @return [String] the hashed password
    def compute_hash(*args)
      if args[0].class == String && args[1].class.method_defined?(:j_del) && !block_given?
        return @j_del.java_method(:computeHash, [Java::java.lang.String.java_class,Java::IoVertxExtAuth::User.java_class]).call(args[0],args[1].j_del)
      end
      if defined?(super)
        super
      else
        raise ArgumentError, "Invalid arguments when calling compute_hash(#{args[0]},#{args[1]})"
      end
    end
    #  Allows the selection of the hashing algorithm.
    # @overload setAlgorithm(algorithm)
    #   @param [:SHA512,:PBKDF2] algorithm the choosen algorithm
    # @return [void]
    def set_algorithm(*args)
      if args[0].class == Symbol && !block_given?
        return @j_del.java_method(:setAlgorithm, [Java::IoVertxExtAuthMongo::HashAlgorithm.java_class]).call(Java::IoVertxExtAuthMongo::HashAlgorithm.valueOf(args[0].to_s))
      end
      if defined?(super)
        super
      else
        raise ArgumentError, "Invalid arguments when calling set_algorithm(#{args[0]})"
      end
    end
    #  Set an external salt. This method should be used in case of 
    # @overload setExternalSalt(salt)
    #   @param [String] salt the salt, which shall be used
    # @return [void]
    def set_external_salt(*args)
      if args[0].class == String && !block_given?
        return @j_del.java_method(:setExternalSalt, [Java::java.lang.String.java_class]).call(args[0])
      end
      if defined?(super)
        super
      else
        raise ArgumentError, "Invalid arguments when calling set_external_salt(#{args[0]})"
      end
    end
    #  Get the defined HashSaltStyle of the current instance
    # @overload getSaltStyle()
    # @return [:NO_SALT,:COLUMN,:EXTERNAL] the saltStyle
    def get_salt_style
      if !block_given?
        return @j_del.java_method(:getSaltStyle, []).call().name.intern
      end
      if defined?(super)
        super
      else
        raise ArgumentError, "Invalid arguments when calling get_salt_style()"
      end
    end
  end
end
