require 'vertx-auth-common/user'
require 'vertx/vertx'
require 'vertx-auth-oauth2/o_auth2_rbac'
require 'vertx/future'
require 'vertx-auth-oauth2/access_token'
require 'vertx-auth-common/auth_provider'
require 'vertx/future'
require 'vertx/util/utils.rb'
# Generated from io.vertx.ext.auth.oauth2.OAuth2Auth
module VertxAuthOauth2
  #  Factory interface for creating OAuth2 based {::VertxAuthCommon::AuthProvider} instances.
  class OAuth2Auth < ::VertxAuthCommon::AuthProvider
    # @private
    # @param j_del [::VertxAuthOauth2::OAuth2Auth] the java delegate
    def initialize(j_del)
      super(j_del)
      @j_del = j_del
    end
    # @private
    # @return [::VertxAuthOauth2::OAuth2Auth] the underlying java delegate
    def j_del
      @j_del
    end
    @@j_api_type = Object.new
    def @@j_api_type.accept?(obj)
      obj.class == OAuth2Auth
    end
    def @@j_api_type.wrap(obj)
      OAuth2Auth.new(obj)
    end
    def @@j_api_type.unwrap(obj)
      obj.j_del
    end
    def self.j_api_type
      @@j_api_type
    end
    def self.j_class
      Java::IoVertxExtAuthOauth2::OAuth2Auth.java_class
    end
    #  Retrieve profile information and other attributes for a logged-in end-user. More info <a href="https://openid.net/specs/openid-connect-core-1_0.html#UserInfo">https://openid.net/specs/openid-connect-core-1_0.html#UserInfo</a>
    # @overload userInfo(user,handler)
    #   @param [::VertxAuthCommon::User] user the user (access token) to fetch the user info.
    #   @yield the handler success/failure.
    # @return [self]
    def user_info(*args)
      if args[0].class.method_defined?(:j_del) && true
        if (block_given?)
          @j_del.java_method(:userInfo, [Java::IoVertxExtAuth::User.java_class,Java::IoVertxCore::Handler.java_class]).call(args[0].j_del,block_given? ? Proc.new { |ar| yield(ar.failed ? ar.cause : nil, ar.succeeded ? ar.result != nil ? JSON.parse(ar.result.encode) : nil : nil) } : promise)
          return self
        else
          promise = ::Vertx::Util::Utils.promise
          @j_del.java_method(:userInfo, [Java::IoVertxExtAuth::User.java_class,Java::IoVertxCore::Handler.java_class]).call(args[0].j_del,block_given? ? Proc.new { |ar| yield(ar.failed ? ar.cause : nil, ar.succeeded ? ar.result != nil ? JSON.parse(ar.result.encode) : nil : nil) } : promise)
          return ::Vertx::Util::Utils.safe_create(promise.future(),::Vertx::Future, nil)
        end
      end
      if defined?(super)
        super
      else
        raise ArgumentError, "Invalid arguments when calling user_info(#{args[0]})"
      end
    end
    # @overload rbacHandler(rbac)
    #   @param [::VertxAuthOauth2::OAuth2RBAC] rbac 
    # @return [self]
    def rbac_handler(*args)
      if args[0].class.method_defined?(:j_del) && !block_given?
        @j_del.java_method(:rbacHandler, [Java::IoVertxExtAuthOauth2::OAuth2RBAC.java_class]).call(args[0].j_del)
        return self
      end
      if defined?(super)
        super
      else
        raise ArgumentError, "Invalid arguments when calling rbac_handler(#{args[0]})"
      end
    end
    #  The client sends the end-user's browser to this endpoint to request their
    #  authentication and consent. This endpoint is used in the code and implicit
    #  OAuth 2.0 flows which require end-user interaction.
    # @overload authorizeURL(params)
    #   @param [Hash{String => Object}] params extra params to be included in the final URL.
    # @return [String] the url to be used to authorize the user.
    def authorize_url(*args)
      if args[0].class == Hash && !block_given?
        return @j_del.java_method(:authorizeURL, [Java::IoVertxCoreJson::JsonObject.java_class]).call(::Vertx::Util::Utils.to_json_object(args[0]))
      end
      if defined?(super)
        super
      else
        raise ArgumentError, "Invalid arguments when calling authorize_url(#{args[0]})"
      end
    end
    #  Loads a JWK Set from the remote provider.
    # 
    #  When calling this method several times, the loaded JWKs are updated in the underlying JWT object.
    # @overload loadJWK(handler)
    #   @yield 
    # @return [self]
    def load_jwk
      if true
        if (block_given?)
          @j_del.java_method(:loadJWK, [Java::IoVertxCore::Handler.java_class]).call(block_given? ? Proc.new { |ar| yield(ar.failed ? ar.cause : nil, ar.succeeded ? nil : nil) } : promise)
          return self
        else
          promise = ::Vertx::Util::Utils.promise
          @j_del.java_method(:loadJWK, [Java::IoVertxCore::Handler.java_class]).call(block_given? ? Proc.new { |ar| yield(ar.failed ? ar.cause : nil, ar.succeeded ? nil : nil) } : promise)
          return ::Vertx::Util::Utils.safe_create(promise.future(),::Vertx::Future, nil)
        end
      end
      if defined?(super)
        super
      else
        raise ArgumentError, "Invalid arguments when calling load_jwk()"
      end
    end
    #  The logout (end-session) endpoint is specified in OpenID Connect Session Management 1.0.
    #  More info: <a href="https://openid.net/specs/openid-connect-session-1_0.html">https://openid.net/specs/openid-connect-session-1_0.html</a>.
    # @overload endSessionURL(user)
    #   @param [::VertxAuthCommon::User] user the user to generate the url for
    # @overload endSessionURL(user,params)
    #   @param [::VertxAuthCommon::User] user the user to generate the url for
    #   @param [Hash{String => Object}] params extra parameters to apply to the url
    # @return [String] the url to end the session.
    def end_session_url(*args)
      if args[0].class.method_defined?(:j_del) && !block_given? && args[1] == nil
        return @j_del.java_method(:endSessionURL, [Java::IoVertxExtAuth::User.java_class]).call(args[0].j_del)
      elsif args[0].class.method_defined?(:j_del) && args[1].class == Hash && !block_given?
        return @j_del.java_method(:endSessionURL, [Java::IoVertxExtAuth::User.java_class,Java::IoVertxCoreJson::JsonObject.java_class]).call(args[0].j_del,::Vertx::Util::Utils.to_json_object(args[1]))
      end
      if defined?(super)
        super
      else
        raise ArgumentError, "Invalid arguments when calling end_session_url(#{args[0]},#{args[1]})"
      end
    end
    #  Revoke an obtained access or refresh token. More info <a href="https://tools.ietf.org/html/rfc7009">https://tools.ietf.org/html/rfc7009</a>.
    # @overload revoke(user,handler)
    #   @param [::VertxAuthCommon::User] user the user (access token) to revoke.
    #   @yield the handler success/failure.
    # @overload revoke(user,tokenType,handler)
    #   @param [::VertxAuthCommon::User] user the user (access token) to revoke.
    #   @param [String] tokenType the token type (either access_token or refresh_token).
    #   @yield the handler success/failure.
    # @return [self]
    def revoke(*args)
      if args[0].class.method_defined?(:j_del) && true && args[1] == nil
        if (block_given?)
          @j_del.java_method(:revoke, [Java::IoVertxExtAuth::User.java_class,Java::IoVertxCore::Handler.java_class]).call(args[0].j_del,block_given? ? Proc.new { |ar| yield(ar.failed ? ar.cause : nil, ar.succeeded ? nil : nil) } : promise)
          return self
        else
          promise = ::Vertx::Util::Utils.promise
          @j_del.java_method(:revoke, [Java::IoVertxExtAuth::User.java_class,Java::IoVertxCore::Handler.java_class]).call(args[0].j_del,block_given? ? Proc.new { |ar| yield(ar.failed ? ar.cause : nil, ar.succeeded ? nil : nil) } : promise)
          return ::Vertx::Util::Utils.safe_create(promise.future(),::Vertx::Future, nil)
        end
      elsif args[0].class.method_defined?(:j_del) && args[1].class == String && true
        if (block_given?)
          @j_del.java_method(:revoke, [Java::IoVertxExtAuth::User.java_class,Java::java.lang.String.java_class,Java::IoVertxCore::Handler.java_class]).call(args[0].j_del,args[1],block_given? ? Proc.new { |ar| yield(ar.failed ? ar.cause : nil, ar.succeeded ? nil : nil) } : promise)
          return self
        else
          promise = ::Vertx::Util::Utils.promise
          @j_del.java_method(:revoke, [Java::IoVertxExtAuth::User.java_class,Java::java.lang.String.java_class,Java::IoVertxCore::Handler.java_class]).call(args[0].j_del,args[1],block_given? ? Proc.new { |ar| yield(ar.failed ? ar.cause : nil, ar.succeeded ? nil : nil) } : promise)
          return ::Vertx::Util::Utils.safe_create(promise.future(),::Vertx::Future, nil)
        end
      end
      if defined?(super)
        super
      else
        raise ArgumentError, "Invalid arguments when calling revoke(#{args[0]},#{args[1]})"
      end
    end
    #  Refresh the current User (access token).
    # @overload refresh(user,handler)
    #   @param [::VertxAuthCommon::User] user the user (access token) to be refreshed.
    #   @yield the handler success/failure.
    # @return [self]
    def refresh(*args)
      if args[0].class.method_defined?(:j_del) && true
        if (block_given?)
          @j_del.java_method(:refresh, [Java::IoVertxExtAuth::User.java_class,Java::IoVertxCore::Handler.java_class]).call(args[0].j_del,block_given? ? Proc.new { |ar| yield(ar.failed ? ar.cause : nil, ar.succeeded ? ::Vertx::Util::Utils.safe_create(ar.result,::VertxAuthCommon::User) : nil) } : promise)
          return self
        else
          promise = ::Vertx::Util::Utils.promise
          @j_del.java_method(:refresh, [Java::IoVertxExtAuth::User.java_class,Java::IoVertxCore::Handler.java_class]).call(args[0].j_del,block_given? ? Proc.new { |ar| yield(ar.failed ? ar.cause : nil, ar.succeeded ? ::Vertx::Util::Utils.safe_create(ar.result,::VertxAuthCommon::User) : nil) } : promise)
          return ::Vertx::Util::Utils.safe_create(promise.future(),::Vertx::Future,::VertxAuthCommon::User.j_api_type)
        end
      end
      if defined?(super)
        super
      else
        raise ArgumentError, "Invalid arguments when calling refresh(#{args[0]})"
      end
    end
    #  Create a OAuth2 auth provider
    # @overload create(vertx)
    #   @param [::Vertx::Vertx] vertx the Vertx instance
    # @overload create(vertx,config)
    #   @param [::Vertx::Vertx] vertx the Vertx instance
    #   @param [Hash{String => Object}] config the config
    # @return [::VertxAuthOauth2::OAuth2Auth] the auth provider
    def self.create(*args)
      if args[0].class.method_defined?(:j_del) && !block_given? && args[1] == nil
        return ::Vertx::Util::Utils.safe_create(Java::IoVertxExtAuthOauth2::OAuth2Auth.java_method(:create, [Java::IoVertxCore::Vertx.java_class]).call(args[0].j_del),::VertxAuthOauth2::OAuth2Auth)
      elsif args[0].class.method_defined?(:j_del) && args[1].class == Hash && !block_given?
        return ::Vertx::Util::Utils.safe_create(Java::IoVertxExtAuthOauth2::OAuth2Auth.java_method(:create, [Java::IoVertxCore::Vertx.java_class,Java::IoVertxExtAuthOauth2::OAuth2ClientOptions.java_class]).call(args[0].j_del,Java::IoVertxExtAuthOauth2::OAuth2ClientOptions.new(::Vertx::Util::Utils.to_json_object(args[1]))),::VertxAuthOauth2::OAuth2Auth)
      end
      if defined?(super)
        super
      else
        raise ArgumentError, "Invalid arguments when calling create(#{args[0]},#{args[1]})"
      end
    end
    #  Retrieve the public server JSON Web Key (JWK) required to verify the authenticity
    #  of issued ID and access tokens.
    # @overload jWKSet(handler)
    #   @yield the handler success/failure.
    # @return [self]
    def j_wk_set
      if true
        if (block_given?)
          @j_del.java_method(:jWKSet, [Java::IoVertxCore::Handler.java_class]).call(block_given? ? Proc.new { |ar| yield(ar.failed ? ar.cause : nil, ar.succeeded ? nil : nil) } : promise)
          return self
        else
          promise = ::Vertx::Util::Utils.promise
          @j_del.java_method(:jWKSet, [Java::IoVertxCore::Handler.java_class]).call(block_given? ? Proc.new { |ar| yield(ar.failed ? ar.cause : nil, ar.succeeded ? nil : nil) } : promise)
          return ::Vertx::Util::Utils.safe_create(promise.future(),::Vertx::Future, nil)
        end
      end
      if defined?(super)
        super
      else
        raise ArgumentError, "Invalid arguments when calling j_wk_set()"
      end
    end
    #  Decode a token to a {::VertxAuthOauth2::AccessToken} object. This is useful to handle bearer JWT tokens.
    # @overload decodeToken(token,handler)
    #   @param [String] token the access token (base64 string)
    #   @yield A handler to receive the event
    # @return [self]
    def decode_token(*args)
      if args[0].class == String && true
        if (block_given?)
          @j_del.java_method(:decodeToken, [Java::java.lang.String.java_class,Java::IoVertxCore::Handler.java_class]).call(args[0],block_given? ? Proc.new { |ar| yield(ar.failed ? ar.cause : nil, ar.succeeded ? ::Vertx::Util::Utils.safe_create(ar.result,::VertxAuthOauth2::AccessToken) : nil) } : promise)
          return self
        else
          promise = ::Vertx::Util::Utils.promise
          @j_del.java_method(:decodeToken, [Java::java.lang.String.java_class,Java::IoVertxCore::Handler.java_class]).call(args[0],block_given? ? Proc.new { |ar| yield(ar.failed ? ar.cause : nil, ar.succeeded ? ::Vertx::Util::Utils.safe_create(ar.result,::VertxAuthOauth2::AccessToken) : nil) } : promise)
          return ::Vertx::Util::Utils.safe_create(promise.future(),::Vertx::Future,::VertxAuthOauth2::AccessToken.j_api_type)
        end
      end
      if defined?(super)
        super
      else
        raise ArgumentError, "Invalid arguments when calling decode_token(#{args[0]})"
      end
    end
    #  Returns the configured flow type for the Oauth2 provider.
    # @overload getFlowType()
    # @return [:AUTH_CODE,:IMPLICIT,:PASSWORD,:CLIENT,:AUTH_JWT] the flow type.
    def get_flow_type
      if !block_given?
        return @j_del.java_method(:getFlowType, []).call().name.intern
      end
      if defined?(super)
        super
      else
        raise ArgumentError, "Invalid arguments when calling get_flow_type()"
      end
    end
    #  Query an OAuth 2.0 authorization server to determine the active state of an OAuth 2.0 token and to determine
    #  meta-information about this token.
    # @overload introspectToken(token,handler)
    #   @param [String] token the access token (base64 string)
    #   @yield A handler to receive the event
    # @overload introspectToken(token,tokenType,handler)
    #   @param [String] token the access token (base64 string)
    #   @param [String] tokenType hint to the token type e.g.: `access_token`
    #   @yield A handler to receive the event
    # @return [self]
    def introspect_token(*args)
      if args[0].class == String && true && args[1] == nil
        if (block_given?)
          @j_del.java_method(:introspectToken, [Java::java.lang.String.java_class,Java::IoVertxCore::Handler.java_class]).call(args[0],block_given? ? Proc.new { |ar| yield(ar.failed ? ar.cause : nil, ar.succeeded ? ::Vertx::Util::Utils.safe_create(ar.result,::VertxAuthOauth2::AccessToken) : nil) } : promise)
          return self
        else
          promise = ::Vertx::Util::Utils.promise
          @j_del.java_method(:introspectToken, [Java::java.lang.String.java_class,Java::IoVertxCore::Handler.java_class]).call(args[0],block_given? ? Proc.new { |ar| yield(ar.failed ? ar.cause : nil, ar.succeeded ? ::Vertx::Util::Utils.safe_create(ar.result,::VertxAuthOauth2::AccessToken) : nil) } : promise)
          return ::Vertx::Util::Utils.safe_create(promise.future(),::Vertx::Future,::VertxAuthOauth2::AccessToken.j_api_type)
        end
      elsif args[0].class == String && args[1].class == String && true
        if (block_given?)
          @j_del.java_method(:introspectToken, [Java::java.lang.String.java_class,Java::java.lang.String.java_class,Java::IoVertxCore::Handler.java_class]).call(args[0],args[1],block_given? ? Proc.new { |ar| yield(ar.failed ? ar.cause : nil, ar.succeeded ? ::Vertx::Util::Utils.safe_create(ar.result,::VertxAuthOauth2::AccessToken) : nil) } : promise)
          return self
        else
          promise = ::Vertx::Util::Utils.promise
          @j_del.java_method(:introspectToken, [Java::java.lang.String.java_class,Java::java.lang.String.java_class,Java::IoVertxCore::Handler.java_class]).call(args[0],args[1],block_given? ? Proc.new { |ar| yield(ar.failed ? ar.cause : nil, ar.succeeded ? ::Vertx::Util::Utils.safe_create(ar.result,::VertxAuthOauth2::AccessToken) : nil) } : promise)
          return ::Vertx::Util::Utils.safe_create(promise.future(),::Vertx::Future,::VertxAuthOauth2::AccessToken.j_api_type)
        end
      end
      if defined?(super)
        super
      else
        raise ArgumentError, "Invalid arguments when calling introspect_token(#{args[0]},#{args[1]})"
      end
    end
  end
end
