require 'vertx/vertx'
require 'vertx-cassandra/result_set'
require 'vertx-cassandra/cassandra_row_stream'
require 'vertx/future'
require 'vertx/future'
require 'vertx/util/utils.rb'
# Generated from io.vertx.cassandra.CassandraClient
module VertxCassandra
  #  Eclipse Vert.x Cassandra client.
  class CassandraClient
    # @private
    # @param j_del [::VertxCassandra::CassandraClient] the java delegate
    def initialize(j_del)
      @j_del = j_del
    end
    # @private
    # @return [::VertxCassandra::CassandraClient] the underlying java delegate
    def j_del
      @j_del
    end
    @@j_api_type = Object.new
    def @@j_api_type.accept?(obj)
      obj.class == CassandraClient
    end
    def @@j_api_type.wrap(obj)
      CassandraClient.new(obj)
    end
    def @@j_api_type.unwrap(obj)
      obj.j_del
    end
    def self.j_api_type
      @@j_api_type
    end
    def self.j_class
      Java::IoVertxCassandra::CassandraClient.java_class
    end
    # @overload isConnected()
    # @return [true,false] whether this Cassandra client instance is connected
    def connected?
      if !block_given?
        return @j_del.java_method(:isConnected, []).call()
      end
      if defined?(super)
        super
      else
        raise ArgumentError, "Invalid arguments when calling connected?()"
      end
    end
    #  Create a Cassandra client that shares its driver session with any other client having the same name.
    # @overload createShared(vertx)
    #   @param [::Vertx::Vertx] vertx 
    # @overload createShared(vertx,clientName)
    #   @param [::Vertx::Vertx] vertx 
    #   @param [String] clientName 
    # @overload createShared(vertx,options)
    #   @param [::Vertx::Vertx] vertx 
    #   @param [Hash{String => Object}] options 
    # @overload createShared(vertx,clientName,options)
    #   @param [::Vertx::Vertx] vertx the Vert.x instance
    #   @param [String] clientName the shared client name
    #   @param [Hash{String => Object}] options the options
    # @return [::VertxCassandra::CassandraClient] the client
    def self.create_shared(*args)
      if args[0].class.method_defined?(:j_del) && !block_given? && args[1] == nil && args[2] == nil
        return ::Vertx::Util::Utils.safe_create(Java::IoVertxCassandra::CassandraClient.java_method(:createShared, [Java::IoVertxCore::Vertx.java_class]).call(args[0].j_del),::VertxCassandra::CassandraClient)
      elsif args[0].class.method_defined?(:j_del) && args[1].class == String && !block_given? && args[2] == nil
        return ::Vertx::Util::Utils.safe_create(Java::IoVertxCassandra::CassandraClient.java_method(:createShared, [Java::IoVertxCore::Vertx.java_class,Java::java.lang.String.java_class]).call(args[0].j_del,args[1]),::VertxCassandra::CassandraClient)
      elsif args[0].class.method_defined?(:j_del) && args[1].class == Hash && !block_given? && args[2] == nil
        return ::Vertx::Util::Utils.safe_create(Java::IoVertxCassandra::CassandraClient.java_method(:createShared, [Java::IoVertxCore::Vertx.java_class,Java::IoVertxCassandra::CassandraClientOptions.java_class]).call(args[0].j_del,Java::IoVertxCassandra::CassandraClientOptions.new(::Vertx::Util::Utils.to_json_object(args[1]))),::VertxCassandra::CassandraClient)
      elsif args[0].class.method_defined?(:j_del) && args[1].class == String && args[2].class == Hash && !block_given?
        return ::Vertx::Util::Utils.safe_create(Java::IoVertxCassandra::CassandraClient.java_method(:createShared, [Java::IoVertxCore::Vertx.java_class,Java::java.lang.String.java_class,Java::IoVertxCassandra::CassandraClientOptions.java_class]).call(args[0].j_del,args[1],Java::IoVertxCassandra::CassandraClientOptions.new(::Vertx::Util::Utils.to_json_object(args[2]))),::VertxCassandra::CassandraClient)
      end
      if defined?(super)
        super
      else
        raise ArgumentError, "Invalid arguments when calling create_shared(#{args[0]},#{args[1]},#{args[2]})"
      end
    end
    #  Create a Cassandra client which maintains its own driver session.
    #  <p>
    #  It is not recommended to create several non shared clients in an application.
    # @overload createNonShared(vertx)
    #   @param [::Vertx::Vertx] vertx 
    # @overload createNonShared(vertx,options)
    #   @param [::Vertx::Vertx] vertx the Vert.x instance
    #   @param [Hash{String => Object}] options the options
    # @return [::VertxCassandra::CassandraClient] the client
    def self.create_non_shared(*args)
      if args[0].class.method_defined?(:j_del) && !block_given? && args[1] == nil
        return ::Vertx::Util::Utils.safe_create(Java::IoVertxCassandra::CassandraClient.java_method(:createNonShared, [Java::IoVertxCore::Vertx.java_class]).call(args[0].j_del),::VertxCassandra::CassandraClient)
      elsif args[0].class.method_defined?(:j_del) && args[1].class == Hash && !block_given?
        return ::Vertx::Util::Utils.safe_create(Java::IoVertxCassandra::CassandraClient.java_method(:createNonShared, [Java::IoVertxCore::Vertx.java_class,Java::IoVertxCassandra::CassandraClientOptions.java_class]).call(args[0].j_del,Java::IoVertxCassandra::CassandraClientOptions.new(::Vertx::Util::Utils.to_json_object(args[1]))),::VertxCassandra::CassandraClient)
      end
      if defined?(super)
        super
      else
        raise ArgumentError, "Invalid arguments when calling create_non_shared(#{args[0]},#{args[1]})"
      end
    end
    #  Closes this client.
    # @overload close(closeHandler)
    #   @yield handler called when client is closed
    # @return [self]
    def close
      if true
        if (block_given?)
          @j_del.java_method(:close, [Java::IoVertxCore::Handler.java_class]).call(block_given? ? Proc.new { |ar| yield(ar.failed ? ar.cause : nil, ar.succeeded ? nil : nil) } : promise)
          return self
        else
          promise = ::Vertx::Util::Utils.promise
          @j_del.java_method(:close, [Java::IoVertxCore::Handler.java_class]).call(block_given? ? Proc.new { |ar| yield(ar.failed ? ar.cause : nil, ar.succeeded ? nil : nil) } : promise)
          return ::Vertx::Util::Utils.safe_create(promise.future(),::Vertx::Future, nil)
        end
      end
      if defined?(super)
        super
      else
        raise ArgumentError, "Invalid arguments when calling close()"
      end
    end
    #  Executes the given SQL <code>SELECT</code> statement which returns the results of the query as a read stream.
    # @overload queryStream(sql,rowStreamHandler)
    #   @param [String] sql the SQL to execute. For example <code>SELECT * FROM table ...</code>.
    #   @yield the handler which is called once the operation completes. It will return an instance of {::VertxCassandra::CassandraRowStream}.
    # @return [self]
    def query_stream(*args)
      if args[0].class == String && true
        if (block_given?)
          @j_del.java_method(:queryStream, [Java::java.lang.String.java_class,Java::IoVertxCore::Handler.java_class]).call(args[0],block_given? ? Proc.new { |ar| yield(ar.failed ? ar.cause : nil, ar.succeeded ? ::Vertx::Util::Utils.safe_create(ar.result,::VertxCassandra::CassandraRowStream) : nil) } : promise)
          return self
        else
          promise = ::Vertx::Util::Utils.promise
          @j_del.java_method(:queryStream, [Java::java.lang.String.java_class,Java::IoVertxCore::Handler.java_class]).call(args[0],block_given? ? Proc.new { |ar| yield(ar.failed ? ar.cause : nil, ar.succeeded ? ::Vertx::Util::Utils.safe_create(ar.result,::VertxCassandra::CassandraRowStream) : nil) } : promise)
          return ::Vertx::Util::Utils.safe_create(promise.future(),::Vertx::Future,::VertxCassandra::CassandraRowStream.j_api_type)
        end
      end
      if defined?(super)
        super
      else
        raise ArgumentError, "Invalid arguments when calling query_stream(#{args[0]})"
      end
    end
    #  Execute the query and provide a handler for consuming results.
    # @overload execute(query,resultHandler)
    #   @param [String] query the query to execute
    #   @yield handler called when result of execution is present, but can be not fully fetched
    # @return [self]
    def execute(*args)
      if args[0].class == String && true
        if (block_given?)
          @j_del.java_method(:execute, [Java::java.lang.String.java_class,Java::IoVertxCore::Handler.java_class]).call(args[0],block_given? ? Proc.new { |ar| yield(ar.failed ? ar.cause : nil, ar.succeeded ? ::Vertx::Util::Utils.safe_create(ar.result,::VertxCassandra::ResultSet) : nil) } : promise)
          return self
        else
          promise = ::Vertx::Util::Utils.promise
          @j_del.java_method(:execute, [Java::java.lang.String.java_class,Java::IoVertxCore::Handler.java_class]).call(args[0],block_given? ? Proc.new { |ar| yield(ar.failed ? ar.cause : nil, ar.succeeded ? ::Vertx::Util::Utils.safe_create(ar.result,::VertxCassandra::ResultSet) : nil) } : promise)
          return ::Vertx::Util::Utils.safe_create(promise.future(),::Vertx::Future,::VertxCassandra::ResultSet.j_api_type)
        end
      end
      if defined?(super)
        super
      else
        raise ArgumentError, "Invalid arguments when calling execute(#{args[0]})"
      end
    end
    #  The default shared client name.
    def self.DEFAULT_SHARED_CLIENT_NAME
      Java::IoVertxCassandra::CassandraClient.DEFAULT_SHARED_CLIENT_NAME
    end
  end
end
