require 'vertx/vertx'
require 'vertx/future'
require 'vertx/future'
require 'vertx/util/utils.rb'
# Generated from io.vertx.kafka.admin.KafkaAdminClient
module VertxKafkaClient
  #  Vert.x Kafka Admin client implementation
  class KafkaAdminClient
    # @private
    # @param j_del [::VertxKafkaClient::KafkaAdminClient] the java delegate
    def initialize(j_del)
      @j_del = j_del
    end
    # @private
    # @return [::VertxKafkaClient::KafkaAdminClient] the underlying java delegate
    def j_del
      @j_del
    end
    @@j_api_type = Object.new
    def @@j_api_type.accept?(obj)
      obj.class == KafkaAdminClient
    end
    def @@j_api_type.wrap(obj)
      KafkaAdminClient.new(obj)
    end
    def @@j_api_type.unwrap(obj)
      obj.j_del
    end
    def self.j_api_type
      @@j_api_type
    end
    def self.j_class
      Java::IoVertxKafkaAdmin::KafkaAdminClient.java_class
    end
    #  Get the the consumer groups available in the cluster with the default options
    # @overload listConsumerGroups(completionHandler)
    #   @yield handler called on operation completed with the consumer groups ids
    # @return [void]
    def list_consumer_groups
      if true
        if (block_given?)
          return @j_del.java_method(:listConsumerGroups, [Java::IoVertxCore::Handler.java_class]).call(block_given? ? Proc.new { |ar| yield(ar.failed ? ar.cause : nil, ar.succeeded ? ar.result.to_a.map { |elt| elt != nil ? JSON.parse(elt.toJson.encode) : nil } : nil) } : promise)
        else
          promise = ::Vertx::Util::Utils.promise
          @j_del.java_method(:listConsumerGroups, [Java::IoVertxCore::Handler.java_class]).call(block_given? ? Proc.new { |ar| yield(ar.failed ? ar.cause : nil, ar.succeeded ? ar.result.to_a.map { |elt| elt != nil ? JSON.parse(elt.toJson.encode) : nil } : nil) } : promise)
          return ::Vertx::Util::Utils.safe_create(promise.future(),::Vertx::Future, nil)
        end
      end
      if defined?(super)
        super
      else
        raise ArgumentError, "Invalid arguments when calling list_consumer_groups()"
      end
    end
    #  Creates a batch of new Kafka topics
    # @overload createTopics(topics,completionHandler)
    #   @param [Array<Hash{String => Object}>] topics topics to create
    #   @yield handler called on operation completed
    # @return [void]
    def create_topics(*args)
      if args[0].class == Array && true
        if (block_given?)
          return @j_del.java_method(:createTopics, [Java::JavaUtil::List.java_class,Java::IoVertxCore::Handler.java_class]).call(args[0].map { |element| Java::IoVertxKafkaAdmin::NewTopic.new(::Vertx::Util::Utils.to_json_object(element)) },block_given? ? Proc.new { |ar| yield(ar.failed ? ar.cause : nil, ar.succeeded ? nil : nil) } : promise)
        else
          promise = ::Vertx::Util::Utils.promise
          @j_del.java_method(:createTopics, [Java::JavaUtil::List.java_class,Java::IoVertxCore::Handler.java_class]).call(args[0].map { |element| Java::IoVertxKafkaAdmin::NewTopic.new(::Vertx::Util::Utils.to_json_object(element)) },block_given? ? Proc.new { |ar| yield(ar.failed ? ar.cause : nil, ar.succeeded ? nil : nil) } : promise)
          return ::Vertx::Util::Utils.safe_create(promise.future(),::Vertx::Future, nil)
        end
      end
      if defined?(super)
        super
      else
        raise ArgumentError, "Invalid arguments when calling create_topics(#{args[0]})"
      end
    end
    #  Describe some topics in the cluster, with the default options.
    # @overload describeTopics(topicNames,completionHandler)
    #   @param [Array<String>] topicNames the names of the topics to describe
    #   @yield handler called on operation completed with the topics descriptions
    # @return [void]
    def describe_topics(*args)
      if args[0].class == Array && true
        if (block_given?)
          return @j_del.java_method(:describeTopics, [Java::JavaUtil::List.java_class,Java::IoVertxCore::Handler.java_class]).call(args[0].map { |element| element },block_given? ? Proc.new { |ar| yield(ar.failed ? ar.cause : nil, ar.succeeded ? Java::IoVertxLangRuby::Helper.adaptingMap(ar.result, Proc.new { |val| val != nil ? JSON.parse(val.toJson.encode) : nil }, Proc.new { |val| ::Vertx::Util::Utils.to_object(val) }) : nil) } : promise)
        else
          promise = ::Vertx::Util::Utils.promise
          @j_del.java_method(:describeTopics, [Java::JavaUtil::List.java_class,Java::IoVertxCore::Handler.java_class]).call(args[0].map { |element| element },block_given? ? Proc.new { |ar| yield(ar.failed ? ar.cause : nil, ar.succeeded ? Java::IoVertxLangRuby::Helper.adaptingMap(ar.result, Proc.new { |val| val != nil ? JSON.parse(val.toJson.encode) : nil }, Proc.new { |val| ::Vertx::Util::Utils.to_object(val) }) : nil) } : promise)
          return ::Vertx::Util::Utils.safe_create(promise.future(),::Vertx::Future, nil)
        end
      end
      if defined?(super)
        super
      else
        raise ArgumentError, "Invalid arguments when calling describe_topics(#{args[0]})"
      end
    end
    #  Create a new KafkaAdminClient instance
    # @overload create(vertx,config)
    #   @param [::Vertx::Vertx] vertx Vert.x instance to use
    #   @param [Hash{String => String}] config Kafka admin client configuration
    # @return [::VertxKafkaClient::KafkaAdminClient] an instance of the KafkaAdminClient
    def self.create(*args)
      if args[0].class.method_defined?(:j_del) && args[1].class == Hash && !block_given?
        return ::Vertx::Util::Utils.safe_create(Java::IoVertxKafkaAdmin::KafkaAdminClient.java_method(:create, [Java::IoVertxCore::Vertx.java_class,Java::JavaUtil::Map.java_class]).call(args[0].j_del,Hash[args[1].map { |k,v| [k,v] }]),::VertxKafkaClient::KafkaAdminClient)
      end
      if defined?(super)
        super
      else
        raise ArgumentError, "Invalid arguments when calling create(#{args[0]},#{args[1]})"
      end
    end
    #  Describe some group ids in the cluster, with the default options
    # @overload describeConsumerGroups(groupIds,completionHandler)
    #   @param [Array<String>] groupIds the ids of the groups to describe
    #   @yield handler called on operation completed with the consumer groups descriptions
    # @return [void]
    def describe_consumer_groups(*args)
      if args[0].class == Array && true
        if (block_given?)
          return @j_del.java_method(:describeConsumerGroups, [Java::JavaUtil::List.java_class,Java::IoVertxCore::Handler.java_class]).call(args[0].map { |element| element },block_given? ? Proc.new { |ar| yield(ar.failed ? ar.cause : nil, ar.succeeded ? Java::IoVertxLangRuby::Helper.adaptingMap(ar.result, Proc.new { |val| val != nil ? JSON.parse(val.toJson.encode) : nil }, Proc.new { |val| ::Vertx::Util::Utils.to_object(val) }) : nil) } : promise)
        else
          promise = ::Vertx::Util::Utils.promise
          @j_del.java_method(:describeConsumerGroups, [Java::JavaUtil::List.java_class,Java::IoVertxCore::Handler.java_class]).call(args[0].map { |element| element },block_given? ? Proc.new { |ar| yield(ar.failed ? ar.cause : nil, ar.succeeded ? Java::IoVertxLangRuby::Helper.adaptingMap(ar.result, Proc.new { |val| val != nil ? JSON.parse(val.toJson.encode) : nil }, Proc.new { |val| ::Vertx::Util::Utils.to_object(val) }) : nil) } : promise)
          return ::Vertx::Util::Utils.safe_create(promise.future(),::Vertx::Future, nil)
        end
      end
      if defined?(super)
        super
      else
        raise ArgumentError, "Invalid arguments when calling describe_consumer_groups(#{args[0]})"
      end
    end
    #  List the topics available in the cluster with the default options.
    # @overload listTopics(completionHandler)
    #   @yield handler called on operation completed with the topics set
    # @return [void]
    def list_topics
      if true
        if (block_given?)
          return @j_del.java_method(:listTopics, [Java::IoVertxCore::Handler.java_class]).call(block_given? ? Proc.new { |ar| yield(ar.failed ? ar.cause : nil, ar.succeeded ? ::Vertx::Util::Utils.to_set(ar.result).map! { |elt| elt } : nil) } : promise)
        else
          promise = ::Vertx::Util::Utils.promise
          @j_del.java_method(:listTopics, [Java::IoVertxCore::Handler.java_class]).call(block_given? ? Proc.new { |ar| yield(ar.failed ? ar.cause : nil, ar.succeeded ? ::Vertx::Util::Utils.to_set(ar.result).map! { |elt| elt } : nil) } : promise)
          return ::Vertx::Util::Utils.safe_create(promise.future(),::Vertx::Future, nil)
        end
      end
      if defined?(super)
        super
      else
        raise ArgumentError, "Invalid arguments when calling list_topics()"
      end
    end
    #  Deletes a batch of Kafka topics
    # @overload deleteTopics(topicNames,completionHandler)
    #   @param [Array<String>] topicNames the names of the topics to delete
    #   @yield handler called on operation completed
    # @return [void]
    def delete_topics(*args)
      if args[0].class == Array && true
        if (block_given?)
          return @j_del.java_method(:deleteTopics, [Java::JavaUtil::List.java_class,Java::IoVertxCore::Handler.java_class]).call(args[0].map { |element| element },block_given? ? Proc.new { |ar| yield(ar.failed ? ar.cause : nil, ar.succeeded ? nil : nil) } : promise)
        else
          promise = ::Vertx::Util::Utils.promise
          @j_del.java_method(:deleteTopics, [Java::JavaUtil::List.java_class,Java::IoVertxCore::Handler.java_class]).call(args[0].map { |element| element },block_given? ? Proc.new { |ar| yield(ar.failed ? ar.cause : nil, ar.succeeded ? nil : nil) } : promise)
          return ::Vertx::Util::Utils.safe_create(promise.future(),::Vertx::Future, nil)
        end
      end
      if defined?(super)
        super
      else
        raise ArgumentError, "Invalid arguments when calling delete_topics(#{args[0]})"
      end
    end
  end
end
