require 'vertx-kafka-client/kafka_consumer_record'
require 'vertx/future'
require 'vertx/util/utils.rb'
# Generated from io.vertx.kafka.client.consumer.KafkaConsumerRecords
module VertxKafkaClient
  #  Vert.x Kafka consumer records
  class KafkaConsumerRecords
    # @private
    # @param j_del [::VertxKafkaClient::KafkaConsumerRecords] the java delegate
    def initialize(j_del, j_arg_K=nil, j_arg_V=nil)
      @j_del = j_del
      @j_arg_K = j_arg_K != nil ? j_arg_K : ::Vertx::Util::unknown_type
      @j_arg_V = j_arg_V != nil ? j_arg_V : ::Vertx::Util::unknown_type
    end
    # @private
    # @return [::VertxKafkaClient::KafkaConsumerRecords] the underlying java delegate
    def j_del
      @j_del
    end
    # @overload size()
    # @return [Fixnum] the total number of records in this batch
    def size
      if !block_given?
        return @j_del.java_method(:size, []).call()
      end
      if defined?(super)
        super
      else
        raise ArgumentError, "Invalid arguments when calling size()"
      end
    end
    #  Get the record at the given index
    # @overload recordAt(index)
    #   @param [Fixnum] index the index of the record to get
    # @return [::VertxKafkaClient::KafkaConsumerRecord]
    def record_at(*args)
      if args[0].class == Fixnum && !block_given?
        return ::Vertx::Util::Utils.safe_create(@j_del.java_method(:recordAt, [Java::int.java_class]).call(args[0]),::VertxKafkaClient::KafkaConsumerRecord, nil, nil)
      end
      if defined?(super)
        super
      else
        raise ArgumentError, "Invalid arguments when calling record_at(#{args[0]})"
      end
    end
    # @overload isEmpty()
    # @return [true,false] whether this batch contains any records
    def empty?
      if !block_given?
        return @j_del.java_method(:isEmpty, []).call()
      end
      if defined?(super)
        super
      else
        raise ArgumentError, "Invalid arguments when calling empty?()"
      end
    end
  end
end
