require 'vertx/buffer'
require 'vertx/read_stream'
require 'vertx/multi_map'
require 'vertx/future'
require 'vertx/util/utils.rb'
# Generated from io.vertx.ext.mail.MailAttachment
module VertxMail
  #  Represent a mail attachment that can be used in a MailMessage.
  class MailAttachment
    # @private
    # @param j_del [::VertxMail::MailAttachment] the java delegate
    def initialize(j_del)
      @j_del = j_del
    end
    # @private
    # @return [::VertxMail::MailAttachment] the underlying java delegate
    def j_del
      @j_del
    end
    @@j_api_type = Object.new
    def @@j_api_type.accept?(obj)
      obj.class == MailAttachment
    end
    def @@j_api_type.wrap(obj)
      MailAttachment.new(obj)
    end
    def @@j_api_type.unwrap(obj)
      obj.j_del
    end
    def self.j_api_type
      @@j_api_type
    end
    def self.j_class
      Java::IoVertxExtMail::MailAttachment.java_class
    end
    #  set the name
    # @overload setName(name)
    #   @param [String] name name of the attachment file
    # @return [self]
    def set_name(*args)
      if args[0].class == String && !block_given?
        @j_del.java_method(:setName, [Java::java.lang.String.java_class]).call(args[0])
        return self
      end
      if defined?(super)
        super
      else
        raise ArgumentError, "Invalid arguments when calling set_name(#{args[0]})"
      end
    end
    #  Set the headers to be added for this attachment.
    # @overload setHeaders(headers)
    #   @param [::Vertx::MultiMap] headers the headers to be added
    # @return [self]
    def set_headers(*args)
      if args[0].class.method_defined?(:j_del) && !block_given?
        @j_del.java_method(:setHeaders, [Java::IoVertxCore::MultiMap.java_class]).call(args[0].j_del)
        return self
      end
      if defined?(super)
        super
      else
        raise ArgumentError, "Invalid arguments when calling set_headers(#{args[0]})"
      end
    end
    #  Add an header to this attachment.
    # @overload addHeader(key,value)
    #   @param [String] key the header key
    #   @param [String] value the header value
    # @return [self]
    def add_header(*args)
      if args[0].class == String && args[1].class == String && !block_given?
        @j_del.java_method(:addHeader, [Java::java.lang.String.java_class,Java::java.lang.String.java_class]).call(args[0],args[1])
        return self
      end
      if defined?(super)
        super
      else
        raise ArgumentError, "Invalid arguments when calling add_header(#{args[0]},#{args[1]})"
      end
    end
    #  get the name
    # @overload getName()
    # @return [String] the name
    def get_name
      if !block_given?
        return @j_del.java_method(:getName, []).call()
      end
      if defined?(super)
        super
      else
        raise ArgumentError, "Invalid arguments when calling get_name()"
      end
    end
    #  Sets the data stream.
    # @overload setStream(stream)
    #   @param [::Vertx::ReadStream] stream data stream to be used at attachment
    # @return [self]
    def set_stream(*args)
      if args[0].class.method_defined?(:j_del) && !block_given?
        @j_del.java_method(:setStream, [Java::IoVertxCoreStreams::ReadStream.java_class]).call(args[0].j_del)
        return self
      end
      if defined?(super)
        super
      else
        raise ArgumentError, "Invalid arguments when calling set_stream(#{args[0]})"
      end
    end
    #  Get the headers to be added for this attachment.
    # @overload getHeaders()
    # @return [::Vertx::MultiMap] the headers
    def get_headers
      if !block_given?
        return ::Vertx::Util::Utils.safe_create(@j_del.java_method(:getHeaders, []).call(),::Vertx::MultiMap)
      end
      if defined?(super)
        super
      else
        raise ArgumentError, "Invalid arguments when calling get_headers()"
      end
    end
    #  set the data
    # @overload setData(data)
    #   @param [::Vertx::Buffer] data Buffer of bytes to be used at attachment
    # @return [self]
    def set_data(*args)
      if args[0].class.method_defined?(:j_del) && !block_given?
        @j_del.java_method(:setData, [Java::IoVertxCoreBuffer::Buffer.java_class]).call(args[0].j_del)
        return self
      end
      if defined?(super)
        super
      else
        raise ArgumentError, "Invalid arguments when calling set_data(#{args[0]})"
      end
    end
    #  set the description field to be used in the attachment
    # @overload setDescription(description)
    #   @param [String] description the description
    # @return [self]
    def set_description(*args)
      if args[0].class == String && !block_given?
        @j_del.java_method(:setDescription, [Java::java.lang.String.java_class]).call(args[0])
        return self
      end
      if defined?(super)
        super
      else
        raise ArgumentError, "Invalid arguments when calling set_description(#{args[0]})"
      end
    end
    #  get the description field
    # @overload getDescription()
    # @return [String] the description
    def get_description
      if !block_given?
        return @j_del.java_method(:getDescription, []).call()
      end
      if defined?(super)
        super
      else
        raise ArgumentError, "Invalid arguments when calling get_description()"
      end
    end
    #  set the Content-ID field to be used in the attachment
    # @overload setContentId(contentId)
    #   @param [String] contentId the content id
    # @return [self]
    def set_content_id(*args)
      if args[0].class == String && !block_given?
        @j_del.java_method(:setContentId, [Java::java.lang.String.java_class]).call(args[0])
        return self
      end
      if defined?(super)
        super
      else
        raise ArgumentError, "Invalid arguments when calling set_content_id(#{args[0]})"
      end
    end
    #  convert this object to JSON representation
    # @overload toJson()
    # @return [Hash{String => Object}] the JSON object
    def to_json
      if !block_given?
        return @j_del.java_method(:toJson, []).call() != nil ? JSON.parse(@j_del.java_method(:toJson, []).call().encode) : nil
      end
      if defined?(super)
        super
      else
        raise ArgumentError, "Invalid arguments when calling to_json()"
      end
    end
    #  Gets the size of the attachment.
    # @overload getSize()
    # @return [Fixnum] the size of the attachment
    def get_size
      if !block_given?
        return @j_del.java_method(:getSize, []).call()
      end
      if defined?(super)
        super
      else
        raise ArgumentError, "Invalid arguments when calling get_size()"
      end
    end
    #  Sets the size of the attachment.
    # <p>
    #  It is needed when using ReadStream for the MailAttachement.
    # </p>
    # @overload setSize(size)
    #   @param [Fixnum] size the size of the attachment
    # @return [self]
    def set_size(*args)
      if args[0].class == Fixnum && !block_given?
        @j_del.java_method(:setSize, [Java::int.java_class]).call(args[0])
        return self
      end
      if defined?(super)
        super
      else
        raise ArgumentError, "Invalid arguments when calling set_size(#{args[0]})"
      end
    end
    #  set the disposition field to be used in the attachment
    # @overload setDisposition(disposition)
    #   @param [String] disposition the disposition
    # @return [self]
    def set_disposition(*args)
      if args[0].class == String && !block_given?
        @j_del.java_method(:setDisposition, [Java::java.lang.String.java_class]).call(args[0])
        return self
      end
      if defined?(super)
        super
      else
        raise ArgumentError, "Invalid arguments when calling set_disposition(#{args[0]})"
      end
    end
    #  get the Content-ID field
    # @overload getContentId()
    # @return [String] the content id
    def get_content_id
      if !block_given?
        return @j_del.java_method(:getContentId, []).call()
      end
      if defined?(super)
        super
      else
        raise ArgumentError, "Invalid arguments when calling get_content_id()"
      end
    end
    #  get the Content-Type
    # @overload getContentType()
    # @return [String] the contentType
    def get_content_type
      if !block_given?
        return @j_del.java_method(:getContentType, []).call()
      end
      if defined?(super)
        super
      else
        raise ArgumentError, "Invalid arguments when calling get_content_type()"
      end
    end
    #  create a copy of a MailAttachment object
    # @overload create()
    # @overload create(json)
    #   @param [Hash{String => Object}] json object to be copied
    # @overload create(other)
    #   @param [::VertxMail::MailAttachment] other object to be copied
    # @return [::VertxMail::MailAttachment]
    def self.create(*args)
      if !block_given? && args[0] == nil
        return ::Vertx::Util::Utils.safe_create(Java::IoVertxExtMail::MailAttachment.java_method(:create, []).call(),::VertxMail::MailAttachment)
      elsif args[0].class == Hash && !block_given?
        return ::Vertx::Util::Utils.safe_create(Java::IoVertxExtMail::MailAttachment.java_method(:create, [Java::IoVertxCoreJson::JsonObject.java_class]).call(::Vertx::Util::Utils.to_json_object(args[0])),::VertxMail::MailAttachment)
      elsif args[0].class.method_defined?(:j_del) && !block_given?
        return ::Vertx::Util::Utils.safe_create(Java::IoVertxExtMail::MailAttachment.java_method(:create, [Java::IoVertxExtMail::MailAttachment.java_class]).call(args[0].j_del),::VertxMail::MailAttachment)
      end
      if defined?(super)
        super
      else
        raise ArgumentError, "Invalid arguments when calling create(#{args[0]})"
      end
    end
    #  get the disposition field
    # @overload getDisposition()
    # @return [String] the disposition
    def get_disposition
      if !block_given?
        return @j_del.java_method(:getDisposition, []).call()
      end
      if defined?(super)
        super
      else
        raise ArgumentError, "Invalid arguments when calling get_disposition()"
      end
    end
    #  Gets the data stream.
    # @overload getStream()
    # @return [::Vertx::ReadStream] the data stream
    def get_stream
      if !block_given?
        return ::Vertx::Util::Utils.safe_create(@j_del.java_method(:getStream, []).call(),::Vertx::ReadStreamImpl,::Vertx::Buffer.j_api_type)
      end
      if defined?(super)
        super
      else
        raise ArgumentError, "Invalid arguments when calling get_stream()"
      end
    end
    #  set the Content-Type
    # @overload setContentType(contentType)
    #   @param [String] contentType the contentType
    # @return [self]
    def set_content_type(*args)
      if args[0].class == String && !block_given?
        @j_del.java_method(:setContentType, [Java::java.lang.String.java_class]).call(args[0])
        return self
      end
      if defined?(super)
        super
      else
        raise ArgumentError, "Invalid arguments when calling set_content_type(#{args[0]})"
      end
    end
    #  get the data
    # @overload getData()
    # @return [::Vertx::Buffer] the data
    def get_data
      if !block_given?
        return ::Vertx::Util::Utils.safe_create(@j_del.java_method(:getData, []).call(),::Vertx::Buffer)
      end
      if defined?(super)
        super
      else
        raise ArgumentError, "Invalid arguments when calling get_data()"
      end
    end
  end
end
