require 'vertx/buffer'
require 'vertx/future'
require 'vertx/util/utils.rb'
# Generated from io.vertx.redis.client.Response
module VertxRedis
  #  The response received from the REDIS server. Redis responses can have several representations:
  # 
  #  <ul>
  #      <li>simple string - C string</li>
  #      <li>integer - 64bit integer value</li>
  #      <li>bulk - byte array</li>
  #      <li>multi - list</li>
  #  </ul>
  # 
  #  Due to the dynamic nature the response object will try to cast the received response to the desired type. A special
  #  case should be noted that multi responses are also handled by the response object as it implements the iterable
  #  interface. So in this case constructs like for loops on the response will give you access to the underlying elements.
  class Response
    # @private
    # @param j_del [::VertxRedis::Response] the java delegate
    def initialize(j_del)
      @j_del = j_del
    end
    # @private
    # @return [::VertxRedis::Response] the underlying java delegate
    def j_del
      @j_del
    end
    @@j_api_type = Object.new
    def @@j_api_type.accept?(obj)
      obj.class == Response
    end
    def @@j_api_type.wrap(obj)
      Response.new(obj)
    end
    def @@j_api_type.unwrap(obj)
      obj.j_del
    end
    def self.j_api_type
      @@j_api_type
    end
    def self.j_class
      Java::IoVertxRedisClient::Response.java_class
    end
    #  Get this response as a Integer.
    # @overload toInteger()
    # @return [Fixnum] int value.
    def to_integer
      if !block_given?
        return @j_del.java_method(:toInteger, []).call()
      end
      if defined?(super)
        super
      else
        raise ArgumentError, "Invalid arguments when calling to_integer()"
      end
    end
    #  Get this size of this multi response.
    # @overload size()
    # @return [Fixnum] the size of the multi.
    def size
      if !block_given?
        return @j_del.java_method(:size, []).call()
      end
      if defined?(super)
        super
      else
        raise ArgumentError, "Invalid arguments when calling size()"
      end
    end
    #  Get this response as a Boolean.
    # @overload toBoolean()
    # @return [true,false] boolean value.
    def to_boolean?
      if !block_given?
        return @j_del.java_method(:toBoolean, []).call()
      end
      if defined?(super)
        super
      else
        raise ArgumentError, "Invalid arguments when calling to_boolean?()"
      end
    end
    #  Get this response as a Long.
    # @overload toLong()
    # @return [Fixnum] long value.
    def to_long
      if !block_given?
        return @j_del.java_method(:toLong, []).call()
      end
      if defined?(super)
        super
      else
        raise ArgumentError, "Invalid arguments when calling to_long()"
      end
    end
    #  Get this multi response value at a string key. Note that REDIS does not support strings as keys but by convention
    #  it encodes hashes in lists where index i is the key, and index i+1 is the value.
    # @overload get(index)
    #   @param [Fixnum] index the required index.
    # @overload get(key)
    #   @param [String] key the required key.
    # @return [::VertxRedis::Response] Response value.
    def get(*args)
      if args[0].class == Fixnum && !block_given?
        return ::Vertx::Util::Utils.safe_create(@j_del.java_method(:get, [Java::int.java_class]).call(args[0]),::VertxRedis::Response)
      elsif args[0].class == String && !block_given?
        return ::Vertx::Util::Utils.safe_create(@j_del.java_method(:get, [Java::java.lang.String.java_class]).call(args[0]),::VertxRedis::Response)
      end
      if defined?(super)
        super
      else
        raise ArgumentError, "Invalid arguments when calling get(#{args[0]})"
      end
    end
    #  Get this response as Buffer.
    # @overload toBuffer()
    # @return [::Vertx::Buffer] buffer value.
    def to_buffer
      if !block_given?
        return ::Vertx::Util::Utils.safe_create(@j_del.java_method(:toBuffer, []).call(),::Vertx::Buffer)
      end
      if defined?(super)
        super
      else
        raise ArgumentError, "Invalid arguments when calling to_buffer()"
      end
    end
    #  Get this response as a String.
    # @overload toString()
    # @return [String] string value
    def to_string
      if !block_given?
        return @j_del.java_method(:toString, []).call()
      end
      if defined?(super)
        super
      else
        raise ArgumentError, "Invalid arguments when calling to_string()"
      end
    end
    #  Get this multi response keys from a hash. Note that REDIS does not support strings as keys but by convention
    #  it encodes hashes in lists where index i is the key, and index i+1 is the value.
    # @overload getKeys()
    # @return [Set<String>] the set of keys.
    def get_keys
      if !block_given?
        return ::Vertx::Util::Utils.to_set(@j_del.java_method(:getKeys, []).call()).map! { |elt| elt }
      end
      if defined?(super)
        super
      else
        raise ArgumentError, "Invalid arguments when calling get_keys()"
      end
    end
    #  The response return type.
    # @overload type()
    # @return [:SIMPLE,:ERROR,:INTEGER,:BULK,:MULTI] the type.
    def type
      if !block_given?
        return @j_del.java_method(:type, []).call().name.intern
      end
      if defined?(super)
        super
      else
        raise ArgumentError, "Invalid arguments when calling type()"
      end
    end
    #  Get this response as a Byte.
    # @overload toByte()
    # @return [Fixnum] byte value.
    def to_byte
      if !block_given?
        return @j_del.java_method(:toByte, []).call()
      end
      if defined?(super)
        super
      else
        raise ArgumentError, "Invalid arguments when calling to_byte()"
      end
    end
    #  Get this response as a Short.
    # @overload toShort()
    # @return [Fixnum] short value.
    def to_short
      if !block_given?
        return @j_del.java_method(:toShort, []).call()
      end
      if defined?(super)
        super
      else
        raise ArgumentError, "Invalid arguments when calling to_short()"
      end
    end
  end
end
