require 'vertx-web-client/web_client'
require 'vertx-service-discovery/service_discovery'
require 'vertx/http_client'
require 'vertx/future'
require 'vertx/util/utils.rb'
# Generated from io.vertx.servicediscovery.types.HttpEndpoint
module VertxServiceDiscovery
  #   for HTTP endpoint (REST api).
  #  Consumers receive a HTTP client configured with the host and port of the endpoint.
  class HttpEndpoint
    # @private
    # @param j_del [::VertxServiceDiscovery::HttpEndpoint] the java delegate
    def initialize(j_del)
      @j_del = j_del
    end
    # @private
    # @return [::VertxServiceDiscovery::HttpEndpoint] the underlying java delegate
    def j_del
      @j_del
    end
    @@j_api_type = Object.new
    def @@j_api_type.accept?(obj)
      obj.class == HttpEndpoint
    end
    def @@j_api_type.wrap(obj)
      HttpEndpoint.new(obj)
    end
    def @@j_api_type.unwrap(obj)
      obj.j_del
    end
    def self.j_api_type
      @@j_api_type
    end
    def self.j_class
      Java::IoVertxServicediscoveryTypes::HttpEndpoint.java_class
    end
    #  Same as {::VertxServiceDiscovery::HttpEndpoint#create_record} but let you configure whether or not the
    #  service is using <code>https</code>.
    # @overload createRecord(name,host)
    #   @param [String] name the name
    #   @param [String] host the host
    # @overload createRecord(name,host,port,root)
    #   @param [String] name the service name
    #   @param [String] host the host, must be public
    #   @param [Fixnum] port the port
    #   @param [String] root the root, if not set "/" is used
    # @overload createRecord(name,host,port,root,metadata)
    #   @param [String] name the service name
    #   @param [String] host the host (IP or DNS name), it must be the _public_ IP / name
    #   @param [Fixnum] port the port, it must be the _public_ port
    #   @param [String] root the path of the service, "/" if not set
    #   @param [Hash{String => Object}] metadata additional metadata
    # @overload createRecord(name,ssl,host,port,root,metadata)
    #   @param [String] name the service name
    #   @param [true,false] ssl whether or not the service is using HTTPS
    #   @param [String] host the host (IP or DNS name), it must be the _public_ IP / name
    #   @param [Fixnum] port the port, it must be the _public_ port
    #   @param [String] root the path of the service, "/" if not set
    #   @param [Hash{String => Object}] metadata additional metadata
    # @return [Hash{String => Object}] the created record
    def self.create_record(*args)
      if args[0].class == String && args[1].class == String && !block_given? && args[2] == nil && args[3] == nil && args[4] == nil && args[5] == nil
        return Java::IoVertxServicediscoveryTypes::HttpEndpoint.java_method(:createRecord, [Java::java.lang.String.java_class,Java::java.lang.String.java_class]).call(args[0],args[1]) != nil ? JSON.parse(Java::IoVertxServicediscoveryTypes::HttpEndpoint.java_method(:createRecord, [Java::java.lang.String.java_class,Java::java.lang.String.java_class]).call(args[0],args[1]).toJson.encode) : nil
      elsif args[0].class == String && args[1].class == String && args[2].class == Fixnum && args[3].class == String && !block_given? && args[4] == nil && args[5] == nil
        return Java::IoVertxServicediscoveryTypes::HttpEndpoint.java_method(:createRecord, [Java::java.lang.String.java_class,Java::java.lang.String.java_class,Java::int.java_class,Java::java.lang.String.java_class]).call(args[0],args[1],args[2],args[3]) != nil ? JSON.parse(Java::IoVertxServicediscoveryTypes::HttpEndpoint.java_method(:createRecord, [Java::java.lang.String.java_class,Java::java.lang.String.java_class,Java::int.java_class,Java::java.lang.String.java_class]).call(args[0],args[1],args[2],args[3]).toJson.encode) : nil
      elsif args[0].class == String && args[1].class == String && args[2].class == Fixnum && args[3].class == String && args[4].class == Hash && !block_given? && args[5] == nil
        return Java::IoVertxServicediscoveryTypes::HttpEndpoint.java_method(:createRecord, [Java::java.lang.String.java_class,Java::java.lang.String.java_class,Java::int.java_class,Java::java.lang.String.java_class,Java::IoVertxCoreJson::JsonObject.java_class]).call(args[0],args[1],args[2],args[3],::Vertx::Util::Utils.to_json_object(args[4])) != nil ? JSON.parse(Java::IoVertxServicediscoveryTypes::HttpEndpoint.java_method(:createRecord, [Java::java.lang.String.java_class,Java::java.lang.String.java_class,Java::int.java_class,Java::java.lang.String.java_class,Java::IoVertxCoreJson::JsonObject.java_class]).call(args[0],args[1],args[2],args[3],::Vertx::Util::Utils.to_json_object(args[4])).toJson.encode) : nil
      elsif args[0].class == String && (args[1].class == TrueClass || args[1].class == FalseClass) && args[2].class == String && args[3].class == Fixnum && args[4].class == String && args[5].class == Hash && !block_given?
        return Java::IoVertxServicediscoveryTypes::HttpEndpoint.java_method(:createRecord, [Java::java.lang.String.java_class,Java::boolean.java_class,Java::java.lang.String.java_class,Java::int.java_class,Java::java.lang.String.java_class,Java::IoVertxCoreJson::JsonObject.java_class]).call(args[0],args[1],args[2],args[3],args[4],::Vertx::Util::Utils.to_json_object(args[5])) != nil ? JSON.parse(Java::IoVertxServicediscoveryTypes::HttpEndpoint.java_method(:createRecord, [Java::java.lang.String.java_class,Java::boolean.java_class,Java::java.lang.String.java_class,Java::int.java_class,Java::java.lang.String.java_class,Java::IoVertxCoreJson::JsonObject.java_class]).call(args[0],args[1],args[2],args[3],args[4],::Vertx::Util::Utils.to_json_object(args[5])).toJson.encode) : nil
      end
      if defined?(super)
        super
      else
        raise ArgumentError, "Invalid arguments when calling create_record(#{args[0]},#{args[1]},#{args[2]},#{args[3]},#{args[4]},#{args[5]})"
      end
    end
    #  Convenient method that looks for a HTTP endpoint and provides the configured . The async result
    #  is marked as failed is there are no matching services, or if the lookup fails. This method accepts a
    #  configuration for the HTTP client.
    # @overload getWebClient(discovery,filter,resultHandler)
    #   @param [::VertxServiceDiscovery::ServiceDiscovery] discovery The service discovery instance
    #   @param [Hash{String => Object}] filter The filter, optional
    #   @yield The result handler
    # @overload getWebClient(discovery,filter,resultHandler)
    #   @param [::VertxServiceDiscovery::ServiceDiscovery] discovery The service discovery instance
    #   @param [Proc] filter The filter
    #   @yield The result handler
    # @overload getWebClient(discovery,filter,conf,resultHandler)
    #   @param [::VertxServiceDiscovery::ServiceDiscovery] discovery The service discovery instance
    #   @param [Hash{String => Object}] filter The filter, optional
    #   @param [Hash{String => Object}] conf the configuration of the client
    #   @yield The result handler
    # @overload getWebClient(discovery,filter,conf,resultHandler)
    #   @param [::VertxServiceDiscovery::ServiceDiscovery] discovery The service discovery instance
    #   @param [Proc] filter The filter
    #   @param [Hash{String => Object}] conf the configuration of the client
    #   @yield The result handler
    # @return [void]
    def self.get_web_client(*args)
      if args[0].class.method_defined?(:j_del) && args[1].class == Hash && true && args[2] == nil
        if (block_given?)
          return Java::IoVertxServicediscoveryTypes::HttpEndpoint.java_method(:getWebClient, [Java::IoVertxServicediscovery::ServiceDiscovery.java_class,Java::IoVertxCoreJson::JsonObject.java_class,Java::IoVertxCore::Handler.java_class]).call(args[0].j_del,::Vertx::Util::Utils.to_json_object(args[1]),block_given? ? Proc.new { |ar| yield(ar.failed ? ar.cause : nil, ar.succeeded ? ::Vertx::Util::Utils.safe_create(ar.result,::VertxWebClient::WebClient) : nil) } : promise)
        else
          promise = ::Vertx::Util::Utils.promise
          Java::IoVertxServicediscoveryTypes::HttpEndpoint.java_method(:getWebClient, [Java::IoVertxServicediscovery::ServiceDiscovery.java_class,Java::IoVertxCoreJson::JsonObject.java_class,Java::IoVertxCore::Handler.java_class]).call(args[0].j_del,::Vertx::Util::Utils.to_json_object(args[1]),block_given? ? Proc.new { |ar| yield(ar.failed ? ar.cause : nil, ar.succeeded ? ::Vertx::Util::Utils.safe_create(ar.result,::VertxWebClient::WebClient) : nil) } : promise)
          return ::Vertx::Util::Utils.safe_create(promise.future(),::Vertx::Future,::VertxWebClient::WebClient.j_api_type)
        end
      elsif args[0].class.method_defined?(:j_del) && args[1].class == Proc && true && args[2] == nil
        if (block_given?)
          return Java::IoVertxServicediscoveryTypes::HttpEndpoint.java_method(:getWebClient, [Java::IoVertxServicediscovery::ServiceDiscovery.java_class,Java::JavaUtilFunction::Function.java_class,Java::IoVertxCore::Handler.java_class]).call(args[0].j_del,(Proc.new { |event| args[1].call(event != nil ? JSON.parse(event.toJson.encode) : nil) unless args[1] == nil }),block_given? ? Proc.new { |ar| yield(ar.failed ? ar.cause : nil, ar.succeeded ? ::Vertx::Util::Utils.safe_create(ar.result,::VertxWebClient::WebClient) : nil) } : promise)
        else
          promise = ::Vertx::Util::Utils.promise
          Java::IoVertxServicediscoveryTypes::HttpEndpoint.java_method(:getWebClient, [Java::IoVertxServicediscovery::ServiceDiscovery.java_class,Java::JavaUtilFunction::Function.java_class,Java::IoVertxCore::Handler.java_class]).call(args[0].j_del,(Proc.new { |event| args[1].call(event != nil ? JSON.parse(event.toJson.encode) : nil) unless args[1] == nil }),block_given? ? Proc.new { |ar| yield(ar.failed ? ar.cause : nil, ar.succeeded ? ::Vertx::Util::Utils.safe_create(ar.result,::VertxWebClient::WebClient) : nil) } : promise)
          return ::Vertx::Util::Utils.safe_create(promise.future(),::Vertx::Future,::VertxWebClient::WebClient.j_api_type)
        end
      elsif args[0].class.method_defined?(:j_del) && args[1].class == Hash && args[2].class == Hash && true
        if (block_given?)
          return Java::IoVertxServicediscoveryTypes::HttpEndpoint.java_method(:getWebClient, [Java::IoVertxServicediscovery::ServiceDiscovery.java_class,Java::IoVertxCoreJson::JsonObject.java_class,Java::IoVertxCoreJson::JsonObject.java_class,Java::IoVertxCore::Handler.java_class]).call(args[0].j_del,::Vertx::Util::Utils.to_json_object(args[1]),::Vertx::Util::Utils.to_json_object(args[2]),block_given? ? Proc.new { |ar| yield(ar.failed ? ar.cause : nil, ar.succeeded ? ::Vertx::Util::Utils.safe_create(ar.result,::VertxWebClient::WebClient) : nil) } : promise)
        else
          promise = ::Vertx::Util::Utils.promise
          Java::IoVertxServicediscoveryTypes::HttpEndpoint.java_method(:getWebClient, [Java::IoVertxServicediscovery::ServiceDiscovery.java_class,Java::IoVertxCoreJson::JsonObject.java_class,Java::IoVertxCoreJson::JsonObject.java_class,Java::IoVertxCore::Handler.java_class]).call(args[0].j_del,::Vertx::Util::Utils.to_json_object(args[1]),::Vertx::Util::Utils.to_json_object(args[2]),block_given? ? Proc.new { |ar| yield(ar.failed ? ar.cause : nil, ar.succeeded ? ::Vertx::Util::Utils.safe_create(ar.result,::VertxWebClient::WebClient) : nil) } : promise)
          return ::Vertx::Util::Utils.safe_create(promise.future(),::Vertx::Future,::VertxWebClient::WebClient.j_api_type)
        end
      elsif args[0].class.method_defined?(:j_del) && args[1].class == Proc && args[2].class == Hash && true
        if (block_given?)
          return Java::IoVertxServicediscoveryTypes::HttpEndpoint.java_method(:getWebClient, [Java::IoVertxServicediscovery::ServiceDiscovery.java_class,Java::JavaUtilFunction::Function.java_class,Java::IoVertxCoreJson::JsonObject.java_class,Java::IoVertxCore::Handler.java_class]).call(args[0].j_del,(Proc.new { |event| args[1].call(event != nil ? JSON.parse(event.toJson.encode) : nil) unless args[1] == nil }),::Vertx::Util::Utils.to_json_object(args[2]),block_given? ? Proc.new { |ar| yield(ar.failed ? ar.cause : nil, ar.succeeded ? ::Vertx::Util::Utils.safe_create(ar.result,::VertxWebClient::WebClient) : nil) } : promise)
        else
          promise = ::Vertx::Util::Utils.promise
          Java::IoVertxServicediscoveryTypes::HttpEndpoint.java_method(:getWebClient, [Java::IoVertxServicediscovery::ServiceDiscovery.java_class,Java::JavaUtilFunction::Function.java_class,Java::IoVertxCoreJson::JsonObject.java_class,Java::IoVertxCore::Handler.java_class]).call(args[0].j_del,(Proc.new { |event| args[1].call(event != nil ? JSON.parse(event.toJson.encode) : nil) unless args[1] == nil }),::Vertx::Util::Utils.to_json_object(args[2]),block_given? ? Proc.new { |ar| yield(ar.failed ? ar.cause : nil, ar.succeeded ? ::Vertx::Util::Utils.safe_create(ar.result,::VertxWebClient::WebClient) : nil) } : promise)
          return ::Vertx::Util::Utils.safe_create(promise.future(),::Vertx::Future,::VertxWebClient::WebClient.j_api_type)
        end
      end
      if defined?(super)
        super
      else
        raise ArgumentError, "Invalid arguments when calling get_web_client(#{args[0]},#{args[1]},#{args[2]})"
      end
    end
    #  Convenient method that looks for a HTTP endpoint and provides the configured . The async result
    #  is marked as failed is there are no matching services, or if the lookup fails. This method accepts a
    #  configuration for the HTTP client.
    # @overload getClient(discovery,filter,resultHandler)
    #   @param [::VertxServiceDiscovery::ServiceDiscovery] discovery The service discovery instance
    #   @param [Hash{String => Object}] filter The filter, optional
    #   @yield The result handler
    # @overload getClient(discovery,filter,resultHandler)
    #   @param [::VertxServiceDiscovery::ServiceDiscovery] discovery The service discovery instance
    #   @param [Proc] filter The filter
    #   @yield The result handler
    # @overload getClient(discovery,filter,conf,resultHandler)
    #   @param [::VertxServiceDiscovery::ServiceDiscovery] discovery The service discovery instance
    #   @param [Hash{String => Object}] filter The filter, optional
    #   @param [Hash{String => Object}] conf the configuration of the client
    #   @yield The result handler
    # @overload getClient(discovery,filter,conf,resultHandler)
    #   @param [::VertxServiceDiscovery::ServiceDiscovery] discovery The service discovery instance
    #   @param [Proc] filter The filter
    #   @param [Hash{String => Object}] conf the configuration of the client
    #   @yield The result handler
    # @return [void]
    def self.get_client(*args)
      if args[0].class.method_defined?(:j_del) && args[1].class == Hash && true && args[2] == nil
        if (block_given?)
          return Java::IoVertxServicediscoveryTypes::HttpEndpoint.java_method(:getClient, [Java::IoVertxServicediscovery::ServiceDiscovery.java_class,Java::IoVertxCoreJson::JsonObject.java_class,Java::IoVertxCore::Handler.java_class]).call(args[0].j_del,::Vertx::Util::Utils.to_json_object(args[1]),block_given? ? Proc.new { |ar| yield(ar.failed ? ar.cause : nil, ar.succeeded ? ::Vertx::Util::Utils.safe_create(ar.result,::Vertx::HttpClient) : nil) } : promise)
        else
          promise = ::Vertx::Util::Utils.promise
          Java::IoVertxServicediscoveryTypes::HttpEndpoint.java_method(:getClient, [Java::IoVertxServicediscovery::ServiceDiscovery.java_class,Java::IoVertxCoreJson::JsonObject.java_class,Java::IoVertxCore::Handler.java_class]).call(args[0].j_del,::Vertx::Util::Utils.to_json_object(args[1]),block_given? ? Proc.new { |ar| yield(ar.failed ? ar.cause : nil, ar.succeeded ? ::Vertx::Util::Utils.safe_create(ar.result,::Vertx::HttpClient) : nil) } : promise)
          return ::Vertx::Util::Utils.safe_create(promise.future(),::Vertx::Future,::Vertx::HttpClient.j_api_type)
        end
      elsif args[0].class.method_defined?(:j_del) && args[1].class == Proc && true && args[2] == nil
        if (block_given?)
          return Java::IoVertxServicediscoveryTypes::HttpEndpoint.java_method(:getClient, [Java::IoVertxServicediscovery::ServiceDiscovery.java_class,Java::JavaUtilFunction::Function.java_class,Java::IoVertxCore::Handler.java_class]).call(args[0].j_del,(Proc.new { |event| args[1].call(event != nil ? JSON.parse(event.toJson.encode) : nil) unless args[1] == nil }),block_given? ? Proc.new { |ar| yield(ar.failed ? ar.cause : nil, ar.succeeded ? ::Vertx::Util::Utils.safe_create(ar.result,::Vertx::HttpClient) : nil) } : promise)
        else
          promise = ::Vertx::Util::Utils.promise
          Java::IoVertxServicediscoveryTypes::HttpEndpoint.java_method(:getClient, [Java::IoVertxServicediscovery::ServiceDiscovery.java_class,Java::JavaUtilFunction::Function.java_class,Java::IoVertxCore::Handler.java_class]).call(args[0].j_del,(Proc.new { |event| args[1].call(event != nil ? JSON.parse(event.toJson.encode) : nil) unless args[1] == nil }),block_given? ? Proc.new { |ar| yield(ar.failed ? ar.cause : nil, ar.succeeded ? ::Vertx::Util::Utils.safe_create(ar.result,::Vertx::HttpClient) : nil) } : promise)
          return ::Vertx::Util::Utils.safe_create(promise.future(),::Vertx::Future,::Vertx::HttpClient.j_api_type)
        end
      elsif args[0].class.method_defined?(:j_del) && args[1].class == Hash && args[2].class == Hash && true
        if (block_given?)
          return Java::IoVertxServicediscoveryTypes::HttpEndpoint.java_method(:getClient, [Java::IoVertxServicediscovery::ServiceDiscovery.java_class,Java::IoVertxCoreJson::JsonObject.java_class,Java::IoVertxCoreJson::JsonObject.java_class,Java::IoVertxCore::Handler.java_class]).call(args[0].j_del,::Vertx::Util::Utils.to_json_object(args[1]),::Vertx::Util::Utils.to_json_object(args[2]),block_given? ? Proc.new { |ar| yield(ar.failed ? ar.cause : nil, ar.succeeded ? ::Vertx::Util::Utils.safe_create(ar.result,::Vertx::HttpClient) : nil) } : promise)
        else
          promise = ::Vertx::Util::Utils.promise
          Java::IoVertxServicediscoveryTypes::HttpEndpoint.java_method(:getClient, [Java::IoVertxServicediscovery::ServiceDiscovery.java_class,Java::IoVertxCoreJson::JsonObject.java_class,Java::IoVertxCoreJson::JsonObject.java_class,Java::IoVertxCore::Handler.java_class]).call(args[0].j_del,::Vertx::Util::Utils.to_json_object(args[1]),::Vertx::Util::Utils.to_json_object(args[2]),block_given? ? Proc.new { |ar| yield(ar.failed ? ar.cause : nil, ar.succeeded ? ::Vertx::Util::Utils.safe_create(ar.result,::Vertx::HttpClient) : nil) } : promise)
          return ::Vertx::Util::Utils.safe_create(promise.future(),::Vertx::Future,::Vertx::HttpClient.j_api_type)
        end
      elsif args[0].class.method_defined?(:j_del) && args[1].class == Proc && args[2].class == Hash && true
        if (block_given?)
          return Java::IoVertxServicediscoveryTypes::HttpEndpoint.java_method(:getClient, [Java::IoVertxServicediscovery::ServiceDiscovery.java_class,Java::JavaUtilFunction::Function.java_class,Java::IoVertxCoreJson::JsonObject.java_class,Java::IoVertxCore::Handler.java_class]).call(args[0].j_del,(Proc.new { |event| args[1].call(event != nil ? JSON.parse(event.toJson.encode) : nil) unless args[1] == nil }),::Vertx::Util::Utils.to_json_object(args[2]),block_given? ? Proc.new { |ar| yield(ar.failed ? ar.cause : nil, ar.succeeded ? ::Vertx::Util::Utils.safe_create(ar.result,::Vertx::HttpClient) : nil) } : promise)
        else
          promise = ::Vertx::Util::Utils.promise
          Java::IoVertxServicediscoveryTypes::HttpEndpoint.java_method(:getClient, [Java::IoVertxServicediscovery::ServiceDiscovery.java_class,Java::JavaUtilFunction::Function.java_class,Java::IoVertxCoreJson::JsonObject.java_class,Java::IoVertxCore::Handler.java_class]).call(args[0].j_del,(Proc.new { |event| args[1].call(event != nil ? JSON.parse(event.toJson.encode) : nil) unless args[1] == nil }),::Vertx::Util::Utils.to_json_object(args[2]),block_given? ? Proc.new { |ar| yield(ar.failed ? ar.cause : nil, ar.succeeded ? ::Vertx::Util::Utils.safe_create(ar.result,::Vertx::HttpClient) : nil) } : promise)
          return ::Vertx::Util::Utils.safe_create(promise.future(),::Vertx::Future,::Vertx::HttpClient.j_api_type)
        end
      end
      if defined?(super)
        super
      else
        raise ArgumentError, "Invalid arguments when calling get_client(#{args[0]},#{args[1]},#{args[2]})"
      end
    end
    #  Unknown type.
    def self.UNKNOWN
      Java::IoVertxServicediscoveryTypes::HttpEndpoint.UNKNOWN
    end
    def self.TYPE
      Java::IoVertxServicediscoveryTypes::HttpEndpoint.TYPE
    end
  end
end
