require 'vertx/promise'
require 'vertx/vertx'
require 'vertx-service-discovery/service_publisher'
require 'vertx/future'
require 'vertx/util/utils.rb'
# Generated from io.vertx.servicediscovery.spi.ServiceImporter
module VertxServiceDiscovery
  #  The service importer allows integrate other discovery technologies with the Vert.x service discovery. It maps
  #  entries from another technology to a  and maps  to a publication in this other
  #  technology. The importer is one side of a service discovery bridge.
  class ServiceImporter
    # @private
    # @param j_del [::VertxServiceDiscovery::ServiceImporter] the java delegate
    def initialize(j_del)
      @j_del = j_del
    end
    # @private
    # @return [::VertxServiceDiscovery::ServiceImporter] the underlying java delegate
    def j_del
      @j_del
    end
    @@j_api_type = Object.new
    def @@j_api_type.accept?(obj)
      obj.class == ServiceImporter
    end
    def @@j_api_type.wrap(obj)
      ServiceImporter.new(obj)
    end
    def @@j_api_type.unwrap(obj)
      obj.j_del
    end
    def self.j_api_type
      @@j_api_type
    end
    def self.j_class
      Java::IoVertxServicediscoverySpi::ServiceImporter.java_class
    end
    #  Starts the importer.
    # @overload start(vertx,publisher,configuration,future)
    #   @param [::Vertx::Vertx] vertx the vertx instance
    #   @param [::VertxServiceDiscovery::ServicePublisher] publisher the service publisher instance
    #   @param [Hash{String => Object}] configuration the bridge configuration if any
    #   @param [::Vertx::Promise] future a future on which the bridge must report the completion of the starting
    # @return [void]
    def start(*args)
      if args[0].class.method_defined?(:j_del) && args[1].class.method_defined?(:j_del) && args[2].class == Hash && args[3].class.method_defined?(:j_del) && !block_given?
        return @j_del.java_method(:start, [Java::IoVertxCore::Vertx.java_class,Java::IoVertxServicediscoverySpi::ServicePublisher.java_class,Java::IoVertxCoreJson::JsonObject.java_class,Java::IoVertxCore::Promise.java_class]).call(args[0].j_del,args[1].j_del,::Vertx::Util::Utils.to_json_object(args[2]),args[3].j_del)
      end
      if defined?(super)
        super
      else
        raise ArgumentError, "Invalid arguments when calling start(#{args[0]},#{args[1]},#{args[2]},#{args[3]})"
      end
    end
    #  Closes the importer
    # @overload close(closeHandler)
    #   @yield the handle to be notified when importer is closed, may be <code>null</code>
    # @return [void]
    def close
      if true
        return @j_del.java_method(:close, [Java::IoVertxCore::Handler.java_class]).call((Proc.new { |event| yield(nil) unless !block_given? }))
      end
      if defined?(super)
        super
      else
        raise ArgumentError, "Invalid arguments when calling close()"
      end
    end
  end
end
