require 'vertx-shell/completion'
require 'vertx/cli'
require 'vertx-shell/cli_token'
require 'vertx-shell/process'
require 'vertx/future'
require 'vertx/util/utils.rb'
# Generated from io.vertx.ext.shell.command.Command
module VertxShell
  #  A Vert.x Shell command, it can be created from any language using the {::VertxShell::CommandBuilder#command} or from a
  #  Java class using {::VertxShell::Command#create}
  class Command
    # @private
    # @param j_del [::VertxShell::Command] the java delegate
    def initialize(j_del)
      @j_del = j_del
    end
    # @private
    # @return [::VertxShell::Command] the underlying java delegate
    def j_del
      @j_del
    end
    @@j_api_type = Object.new
    def @@j_api_type.accept?(obj)
      obj.class == Command
    end
    def @@j_api_type.wrap(obj)
      Command.new(obj)
    end
    def @@j_api_type.unwrap(obj)
      obj.j_del
    end
    def self.j_api_type
      @@j_api_type
    end
    def self.j_class
      Java::IoVertxExtShellCommand::Command.java_class
    end
    # @overload cli()
    # @return [::Vertx::CLI] the command line interface, can be null
    def cli
      if !block_given?
        return ::Vertx::Util::Utils.safe_create(@j_del.java_method(:cli, []).call(),::Vertx::CLI)
      end
      if defined?(super)
        super
      else
        raise ArgumentError, "Invalid arguments when calling cli()"
      end
    end
    #  Create a new process with the passed arguments.
    # @overload createProcess()
    # @overload createProcess(args)
    #   @param [Array<::VertxShell::CliToken>] args the process arguments
    # @return [::VertxShell::Process] the process
    def create_process(*args)
      if !block_given? && args[0] == nil
        return ::Vertx::Util::Utils.safe_create(@j_del.java_method(:createProcess, []).call(),::VertxShell::Process)
      elsif args[0].class == Array && !block_given?
        return ::Vertx::Util::Utils.safe_create(@j_del.java_method(:createProcess, [Java::JavaUtil::List.java_class]).call(args[0].map { |element| element.j_del }),::VertxShell::Process)
      end
      if defined?(super)
        super
      else
        raise ArgumentError, "Invalid arguments when calling create_process(#{args[0]})"
      end
    end
    # @overload name()
    # @return [String] the command name
    def name
      if !block_given?
        return @j_del.java_method(:name, []).call()
      end
      if defined?(super)
        super
      else
        raise ArgumentError, "Invalid arguments when calling name()"
      end
    end
    #  Perform command completion, when the command is done completing it should call 
    #  or  )} method to signal completion is done.
    # @overload complete(completion)
    #   @param [::VertxShell::Completion] completion the completion object
    # @return [void]
    def complete(*args)
      if args[0].class.method_defined?(:j_del) && !block_given?
        return @j_del.java_method(:complete, [Java::IoVertxExtShellCli::Completion.java_class]).call(args[0].j_del)
      end
      if defined?(super)
        super
      else
        raise ArgumentError, "Invalid arguments when calling complete(#{args[0]})"
      end
    end
  end
end
