require 'vertx/command_line'
require 'vertx/vertx'
require 'vertx-shell/cli_token'
require 'vertx-shell/tty'
require 'vertx-shell/session'
require 'vertx/future'
require 'vertx/util/utils.rb'
# Generated from io.vertx.ext.shell.command.CommandProcess
module VertxShell
  #  The command process provides interaction with the process of the command provided by Vert.x Shell.
  class CommandProcess < ::VertxShell::Tty
    # @private
    # @param j_del [::VertxShell::CommandProcess] the java delegate
    def initialize(j_del)
      super(j_del)
      @j_del = j_del
    end
    # @private
    # @return [::VertxShell::CommandProcess] the underlying java delegate
    def j_del
      @j_del
    end
    @@j_api_type = Object.new
    def @@j_api_type.accept?(obj)
      obj.class == CommandProcess
    end
    def @@j_api_type.wrap(obj)
      CommandProcess.new(obj)
    end
    def @@j_api_type.unwrap(obj)
      obj.j_del
    end
    def self.j_api_type
      @@j_api_type
    end
    def self.j_class
      Java::IoVertxExtShellCommand::CommandProcess.java_class
    end
    # @overload session()
    # @return [::VertxShell::Session] the shell session
    def session
      if !block_given?
        return ::Vertx::Util::Utils.safe_create(@j_del.java_method(:session, []).call(),::VertxShell::Session)
      end
      if defined?(super)
        super
      else
        raise ArgumentError, "Invalid arguments when calling session()"
      end
    end
    #  Set a resume handler, this handler is called when the command is resumed, for instance user
    #  types <code>bg</code> or <code>fg</code> to resume the command.
    # @overload resumeHandler(handler)
    #   @yield the interrupt handler
    # @return [self]
    def resume_handler
      if true
        @j_del.java_method(:resumeHandler, [Java::IoVertxCore::Handler.java_class]).call((Proc.new { |event| yield(nil) unless !block_given? }))
        return self
      end
      if defined?(super)
        super
      else
        raise ArgumentError, "Invalid arguments when calling resume_handler()"
      end
    end
    # @overload vertx()
    # @return [::Vertx::Vertx] the current Vert.x instance
    def vertx
      if !block_given?
        return ::Vertx::Util::Utils.safe_create(@j_del.java_method(:vertx, []).call(),::Vertx::Vertx)
      end
      if defined?(super)
        super
      else
        raise ArgumentError, "Invalid arguments when calling vertx()"
      end
    end
    #  Set an interrupt handler, this handler is called when the command is interrupted, for instance user
    #  press <code>Ctrl-C</code>.
    # @overload interruptHandler(handler)
    #   @yield the interrupt handler
    # @return [self]
    def interrupt_handler
      if true
        @j_del.java_method(:interruptHandler, [Java::IoVertxCore::Handler.java_class]).call((Proc.new { |event| yield(nil) unless !block_given? }))
        return self
      end
      if defined?(super)
        super
      else
        raise ArgumentError, "Invalid arguments when calling interrupt_handler()"
      end
    end
    # @overload argsTokens()
    # @return [Array<::VertxShell::CliToken>] the unparsed arguments tokens
    def args_tokens
      if !block_given?
        return @j_del.java_method(:argsTokens, []).call().to_a.map { |elt| ::Vertx::Util::Utils.safe_create(elt,::VertxShell::CliToken) }
      end
      if defined?(super)
        super
      else
        raise ArgumentError, "Invalid arguments when calling args_tokens()"
      end
    end
    # @overload args()
    # @return [Array<String>] the actual string arguments of the command
    def args
      if !block_given?
        return @j_del.java_method(:args, []).call().to_a.map { |elt| elt }
      end
      if defined?(super)
        super
      else
        raise ArgumentError, "Invalid arguments when calling args()"
      end
    end
    #  Set a background handler, this handler is called when the command is running and put to background.
    # @overload backgroundHandler(handler)
    #   @yield the background handler
    # @return [self]
    def background_handler
      if true
        @j_del.java_method(:backgroundHandler, [Java::IoVertxCore::Handler.java_class]).call((Proc.new { |event| yield(nil) unless !block_given? }))
        return self
      end
      if defined?(super)
        super
      else
        raise ArgumentError, "Invalid arguments when calling background_handler()"
      end
    end
    #  Set a foreground handler, this handler is called when the command is running and put to foreground.
    # @overload foregroundHandler(handler)
    #   @yield the foreground handler
    # @return [self]
    def foreground_handler
      if true
        @j_del.java_method(:foregroundHandler, [Java::IoVertxCore::Handler.java_class]).call((Proc.new { |event| yield(nil) unless !block_given? }))
        return self
      end
      if defined?(super)
        super
      else
        raise ArgumentError, "Invalid arguments when calling foreground_handler()"
      end
    end
    #  Set an end handler, this handler is called when the command is ended, for instance the command is running
    #  and the shell closes.
    # @overload endHandler(handler)
    #   @yield the end handler
    # @return [self]
    def end_handler
      if true
        @j_del.java_method(:endHandler, [Java::IoVertxCore::Handler.java_class]).call((Proc.new { |event| yield(nil) unless !block_given? }))
        return self
      end
      if defined?(super)
        super
      else
        raise ArgumentError, "Invalid arguments when calling end_handler()"
      end
    end
    #  Set a suspend handler, this handler is called when the command is suspended, for instance user
    #  press <code>Ctrl-Z</code>.
    # @overload suspendHandler(handler)
    #   @yield the interrupt handler
    # @return [self]
    def suspend_handler
      if true
        @j_del.java_method(:suspendHandler, [Java::IoVertxCore::Handler.java_class]).call((Proc.new { |event| yield(nil) unless !block_given? }))
        return self
      end
      if defined?(super)
        super
      else
        raise ArgumentError, "Invalid arguments when calling suspend_handler()"
      end
    end
    # @overload stdinHandler(handler)
    #   @yield 
    # @return [self]
    def stdin_handler
      if true
        @j_del.java_method(:stdinHandler, [Java::IoVertxCore::Handler.java_class]).call((Proc.new { |event| yield(event) unless !block_given? }))
        return self
      end
      if defined?(super)
        super
      else
        raise ArgumentError, "Invalid arguments when calling stdin_handler()"
      end
    end
    #  End the process.
    # @overload end()
    # @overload end(status)
    #   @param [Fixnum] status the exit status.
    # @return [void]
    def end(*args)
      if !block_given? && args[0] == nil
        return @j_del.java_method(:end, []).call()
      elsif args[0].class == Fixnum && !block_given?
        return @j_del.java_method(:end, [Java::int.java_class]).call(args[0])
      end
      if defined?(super)
        super
      else
        raise ArgumentError, "Invalid arguments when calling end(#{args[0]})"
      end
    end
    # @overload commandLine()
    # @return [::Vertx::CommandLine] the command line object or null
    def command_line
      if !block_given?
        return ::Vertx::Util::Utils.safe_create(@j_del.java_method(:commandLine, []).call(),::Vertx::CommandLine)
      end
      if defined?(super)
        super
      else
        raise ArgumentError, "Invalid arguments when calling command_line()"
      end
    end
    #  Write some text to the standard output.
    # @overload write(data)
    #   @param [String] data the text
    # @return [self]
    def write(*args)
      if args[0].class == String && !block_given?
        @j_del.java_method(:write, [Java::java.lang.String.java_class]).call(args[0])
        return self
      end
      if defined?(super)
        super
      else
        raise ArgumentError, "Invalid arguments when calling write(#{args[0]})"
      end
    end
    # @overload isForeground()
    # @return [true,false] true if the command is running in foreground
    def foreground?
      if !block_given?
        return @j_del.java_method(:isForeground, []).call()
      end
      if defined?(super)
        super
      else
        raise ArgumentError, "Invalid arguments when calling foreground?()"
      end
    end
    # @overload resizehandler(handler)
    #   @yield 
    # @return [self]
    def resizehandler
      if true
        @j_del.java_method(:resizehandler, [Java::IoVertxCore::Handler.java_class]).call((Proc.new { |event| yield(nil) unless !block_given? }))
        return self
      end
      if defined?(super)
        super
      else
        raise ArgumentError, "Invalid arguments when calling resizehandler()"
      end
    end
  end
end
