require 'vertx-shell/job'
require 'vertx-shell/process'
require 'vertx/future'
require 'vertx/util/utils.rb'
# Generated from io.vertx.ext.shell.system.JobController
module VertxShell
  #  The job controller.<p/>
  class JobController
    # @private
    # @param j_del [::VertxShell::JobController] the java delegate
    def initialize(j_del)
      @j_del = j_del
    end
    # @private
    # @return [::VertxShell::JobController] the underlying java delegate
    def j_del
      @j_del
    end
    @@j_api_type = Object.new
    def @@j_api_type.accept?(obj)
      obj.class == JobController
    end
    def @@j_api_type.wrap(obj)
      JobController.new(obj)
    end
    def @@j_api_type.unwrap(obj)
      obj.j_del
    end
    def self.j_api_type
      @@j_api_type
    end
    def self.j_class
      Java::IoVertxExtShellSystem::JobController.java_class
    end
    # @overload jobs()
    # @return [Set<::VertxShell::Job>] the active jobs
    def jobs
      if !block_given?
        return ::Vertx::Util::Utils.to_set(@j_del.java_method(:jobs, []).call()).map! { |elt| ::Vertx::Util::Utils.safe_create(elt,::VertxShell::Job) }
      end
      if defined?(super)
        super
      else
        raise ArgumentError, "Invalid arguments when calling jobs()"
      end
    end
    # @overload foregroundJob()
    # @return [::VertxShell::Job] the current foreground job
    def foreground_job
      if !block_given?
        return ::Vertx::Util::Utils.safe_create(@j_del.java_method(:foregroundJob, []).call(),::VertxShell::Job)
      end
      if defined?(super)
        super
      else
        raise ArgumentError, "Invalid arguments when calling foreground_job()"
      end
    end
    #  Create a job wrapping a process.
    # @overload createJob(process,line)
    #   @param [::VertxShell::Process] process the process
    #   @param [String] line the line
    # @return [::VertxShell::Job] the created job
    def create_job(*args)
      if args[0].class.method_defined?(:j_del) && args[1].class == String && !block_given?
        return ::Vertx::Util::Utils.safe_create(@j_del.java_method(:createJob, [Java::IoVertxExtShellSystem::Process.java_class,Java::java.lang.String.java_class]).call(args[0].j_del,args[1]),::VertxShell::Job)
      end
      if defined?(super)
        super
      else
        raise ArgumentError, "Invalid arguments when calling create_job(#{args[0]},#{args[1]})"
      end
    end
    #  Close the controller and terminate all the underlying jobs, a closed controller does not accept anymore jobs.
    # @overload close()
    # @overload close(completionHandler)
    #   @yield 
    # @return [void]
    def close
      if !block_given?
        return @j_del.java_method(:close, []).call()
      elsif true
        return @j_del.java_method(:close, [Java::IoVertxCore::Handler.java_class]).call((Proc.new { |event| yield(nil) unless !block_given? }))
      end
      if defined?(super)
        super
      else
        raise ArgumentError, "Invalid arguments when calling close()"
      end
    end
    #  Returns an active job in this session by its .
    # @overload getJob(id)
    #   @param [Fixnum] id the job id
    # @return [::VertxShell::Job] the job of  when not found
    def get_job(*args)
      if args[0].class == Fixnum && !block_given?
        return ::Vertx::Util::Utils.safe_create(@j_del.java_method(:getJob, [Java::int.java_class]).call(args[0]),::VertxShell::Job)
      end
      if defined?(super)
        super
      else
        raise ArgumentError, "Invalid arguments when calling get_job(#{args[0]})"
      end
    end
  end
end
