require 'vertx/vertx'
require 'vertx-web/router'
require 'vertx/future'
require 'vertx-shell/term'
require 'vertx-auth-common/auth_provider'
require 'vertx/future'
require 'vertx/util/utils.rb'
# Generated from io.vertx.ext.shell.term.TermServer
module VertxShell
  #  A server for terminal based applications.
  class TermServer
    # @private
    # @param j_del [::VertxShell::TermServer] the java delegate
    def initialize(j_del)
      @j_del = j_del
    end
    # @private
    # @return [::VertxShell::TermServer] the underlying java delegate
    def j_del
      @j_del
    end
    @@j_api_type = Object.new
    def @@j_api_type.accept?(obj)
      obj.class == TermServer
    end
    def @@j_api_type.wrap(obj)
      TermServer.new(obj)
    end
    def @@j_api_type.unwrap(obj)
      obj.j_del
    end
    def self.j_api_type
      @@j_api_type
    end
    def self.j_class
      Java::IoVertxExtShellTerm::TermServer.java_class
    end
    #  Set an auth provider to use, any provider configured in options will override this provider. This should be used
    #  when a custom auth provider should be used.
    # @overload authProvider(provider)
    #   @param [::VertxAuthCommon::AuthProvider] provider the auth to use
    # @return [self]
    def auth_provider(*args)
      if args[0].class.method_defined?(:j_del) && !block_given?
        @j_del.java_method(:authProvider, [Java::IoVertxExtAuth::AuthProvider.java_class]).call(args[0].j_del)
        return self
      end
      if defined?(super)
        super
      else
        raise ArgumentError, "Invalid arguments when calling auth_provider(#{args[0]})"
      end
    end
    #  Create a term server for the Telnet protocol.
    # @overload createTelnetTermServer(vertx)
    #   @param [::Vertx::Vertx] vertx the vertx instance
    # @overload createTelnetTermServer(vertx,options)
    #   @param [::Vertx::Vertx] vertx the vertx instance
    #   @param [Hash{String => Object}] options the term options
    # @return [::VertxShell::TermServer] the term server
    def self.create_telnet_term_server(*args)
      if args[0].class.method_defined?(:j_del) && !block_given? && args[1] == nil
        return ::Vertx::Util::Utils.safe_create(Java::IoVertxExtShellTerm::TermServer.java_method(:createTelnetTermServer, [Java::IoVertxCore::Vertx.java_class]).call(args[0].j_del),::VertxShell::TermServer)
      elsif args[0].class.method_defined?(:j_del) && args[1].class == Hash && !block_given?
        return ::Vertx::Util::Utils.safe_create(Java::IoVertxExtShellTerm::TermServer.java_method(:createTelnetTermServer, [Java::IoVertxCore::Vertx.java_class,Java::IoVertxExtShellTerm::TelnetTermOptions.java_class]).call(args[0].j_del,Java::IoVertxExtShellTerm::TelnetTermOptions.new(::Vertx::Util::Utils.to_json_object(args[1]))),::VertxShell::TermServer)
      end
      if defined?(super)
        super
      else
        raise ArgumentError, "Invalid arguments when calling create_telnet_term_server(#{args[0]},#{args[1]})"
      end
    end
    #  The actual port the server is listening on. This is useful if you bound the server specifying 0 as port number
    #  signifying an ephemeral port
    # @overload actualPort()
    # @return [Fixnum] the actual port the server is listening on.
    def actual_port
      if !block_given?
        return @j_del.java_method(:actualPort, []).call()
      end
      if defined?(super)
        super
      else
        raise ArgumentError, "Invalid arguments when calling actual_port()"
      end
    end
    #  Set the term handler that will receive incoming client connections. When a remote terminal connects
    #  the <code>handler</code> will be called with the {::VertxShell::Term} which can be used to interact with the remote
    #  terminal.
    # @overload termHandler(handler)
    #   @yield the term handler
    # @return [self]
    def term_handler
      if true
        @j_del.java_method(:termHandler, [Java::IoVertxCore::Handler.java_class]).call((Proc.new { |event| yield(::Vertx::Util::Utils.safe_create(event,::VertxShell::Term)) unless !block_given? }))
        return self
      end
      if defined?(super)
        super
      else
        raise ArgumentError, "Invalid arguments when calling term_handler()"
      end
    end
    #  Create a term server for the HTTP protocol, using an existing router.
    # @overload createHttpTermServer(vertx)
    #   @param [::Vertx::Vertx] vertx the vertx instance
    # @overload createHttpTermServer(vertx,options)
    #   @param [::Vertx::Vertx] vertx the vertx instance
    #   @param [Hash{String => Object}] options the term options
    # @overload createHttpTermServer(vertx,router)
    #   @param [::Vertx::Vertx] vertx the vertx instance
    #   @param [::VertxWeb::Router] router the router
    # @overload createHttpTermServer(vertx,router,options)
    #   @param [::Vertx::Vertx] vertx the vertx instance
    #   @param [::VertxWeb::Router] router the router
    #   @param [Hash{String => Object}] options the term options
    # @return [::VertxShell::TermServer] the term server
    def self.create_http_term_server(*args)
      if args[0].class.method_defined?(:j_del) && !block_given? && args[1] == nil && args[2] == nil
        return ::Vertx::Util::Utils.safe_create(Java::IoVertxExtShellTerm::TermServer.java_method(:createHttpTermServer, [Java::IoVertxCore::Vertx.java_class]).call(args[0].j_del),::VertxShell::TermServer)
      elsif args[0].class.method_defined?(:j_del) && args[1].class == Hash && !block_given? && args[2] == nil
        return ::Vertx::Util::Utils.safe_create(Java::IoVertxExtShellTerm::TermServer.java_method(:createHttpTermServer, [Java::IoVertxCore::Vertx.java_class,Java::IoVertxExtShellTerm::HttpTermOptions.java_class]).call(args[0].j_del,Java::IoVertxExtShellTerm::HttpTermOptions.new(::Vertx::Util::Utils.to_json_object(args[1]))),::VertxShell::TermServer)
      elsif args[0].class.method_defined?(:j_del) && args[1].class.method_defined?(:j_del) && !block_given? && args[2] == nil
        return ::Vertx::Util::Utils.safe_create(Java::IoVertxExtShellTerm::TermServer.java_method(:createHttpTermServer, [Java::IoVertxCore::Vertx.java_class,Java::IoVertxExtWeb::Router.java_class]).call(args[0].j_del,args[1].j_del),::VertxShell::TermServer)
      elsif args[0].class.method_defined?(:j_del) && args[1].class.method_defined?(:j_del) && args[2].class == Hash && !block_given?
        return ::Vertx::Util::Utils.safe_create(Java::IoVertxExtShellTerm::TermServer.java_method(:createHttpTermServer, [Java::IoVertxCore::Vertx.java_class,Java::IoVertxExtWeb::Router.java_class,Java::IoVertxExtShellTerm::HttpTermOptions.java_class]).call(args[0].j_del,args[1].j_del,Java::IoVertxExtShellTerm::HttpTermOptions.new(::Vertx::Util::Utils.to_json_object(args[2]))),::VertxShell::TermServer)
      end
      if defined?(super)
        super
      else
        raise ArgumentError, "Invalid arguments when calling create_http_term_server(#{args[0]},#{args[1]},#{args[2]})"
      end
    end
    #  Like {::VertxShell::TermServer#close} but supplying a handler that will be notified when close is complete.
    # @overload close(completionHandler)
    #   @yield the handler to be notified when the term server is closed
    # @return [void]
    def close
      if true
        if (block_given?)
          return @j_del.java_method(:close, [Java::IoVertxCore::Handler.java_class]).call(block_given? ? Proc.new { |ar| yield(ar.failed ? ar.cause : nil, ar.succeeded ? nil : nil) } : promise)
        else
          promise = ::Vertx::Util::Utils.promise
          @j_del.java_method(:close, [Java::IoVertxCore::Handler.java_class]).call(block_given? ? Proc.new { |ar| yield(ar.failed ? ar.cause : nil, ar.succeeded ? nil : nil) } : promise)
          return ::Vertx::Util::Utils.safe_create(promise.future(),::Vertx::Future, nil)
        end
      end
      if defined?(super)
        super
      else
        raise ArgumentError, "Invalid arguments when calling close()"
      end
    end
    #  Bind the term server, the {::VertxShell::TermServer#term_handler} must be set before.
    # @overload listen(listenHandler)
    #   @yield the listen handler
    # @return [self]
    def listen
      if true
        if (block_given?)
          @j_del.java_method(:listen, [Java::IoVertxCore::Handler.java_class]).call(block_given? ? Proc.new { |ar| yield(ar.failed ? ar.cause : nil, ar.succeeded ? nil : nil) } : promise)
          return self
        else
          promise = ::Vertx::Util::Utils.promise
          @j_del.java_method(:listen, [Java::IoVertxCore::Handler.java_class]).call(block_given? ? Proc.new { |ar| yield(ar.failed ? ar.cause : nil, ar.succeeded ? nil : nil) } : promise)
          return ::Vertx::Util::Utils.safe_create(promise.future(),::Vertx::Future, nil)
        end
      end
      if defined?(super)
        super
      else
        raise ArgumentError, "Invalid arguments when calling listen()"
      end
    end
    #  Create a term server for the SSH protocol.
    # @overload createSSHTermServer(vertx)
    #   @param [::Vertx::Vertx] vertx the vertx instance
    # @overload createSSHTermServer(vertx,options)
    #   @param [::Vertx::Vertx] vertx the vertx instance
    #   @param [Hash{String => Object}] options the ssh options
    # @return [::VertxShell::TermServer] the term server
    def self.create_ssh_term_server(*args)
      if args[0].class.method_defined?(:j_del) && !block_given? && args[1] == nil
        return ::Vertx::Util::Utils.safe_create(Java::IoVertxExtShellTerm::TermServer.java_method(:createSSHTermServer, [Java::IoVertxCore::Vertx.java_class]).call(args[0].j_del),::VertxShell::TermServer)
      elsif args[0].class.method_defined?(:j_del) && args[1].class == Hash && !block_given?
        return ::Vertx::Util::Utils.safe_create(Java::IoVertxExtShellTerm::TermServer.java_method(:createSSHTermServer, [Java::IoVertxCore::Vertx.java_class,Java::IoVertxExtShellTerm::SSHTermOptions.java_class]).call(args[0].j_del,Java::IoVertxExtShellTerm::SSHTermOptions.new(::Vertx::Util::Utils.to_json_object(args[1]))),::VertxShell::TermServer)
      end
      if defined?(super)
        super
      else
        raise ArgumentError, "Invalid arguments when calling create_ssh_term_server(#{args[0]},#{args[1]})"
      end
    end
  end
end
