require 'vertx-sql-client/property_kind'
require 'vertx/future'
require 'vertx/util/utils.rb'
# Generated from io.vertx.sqlclient.SqlResult
module VertxSqlClient
  #  Represents the result of an operation on database.
  class SqlResult
    # @private
    # @param j_del [::VertxSqlClient::SqlResult] the java delegate
    def initialize(j_del, j_arg_T=nil)
      @j_del = j_del
      @j_arg_T = j_arg_T != nil ? j_arg_T : ::Vertx::Util::unknown_type
    end
    # @private
    # @return [::VertxSqlClient::SqlResult] the underlying java delegate
    def j_del
      @j_del
    end
    #  Return the next available result or <code>null</code>, e.g for a simple query that executed multiple queries or for
    #  a batch result.
    # @overload next()
    # @return [::VertxSqlClient::SqlResult] the next available result or <code>null</code> if none is available
    def next
      if !block_given?
        return ::Vertx::Util::Utils.safe_create(@j_del.java_method(:next, []).call(),::VertxSqlClient::SqlResult, nil)
      end
      if defined?(super)
        super
      else
        raise ArgumentError, "Invalid arguments when calling next()"
      end
    end
    #  Get the number of rows retrieved in the SqlResult.
    # @overload size()
    # @return [Fixnum] the count of rows.
    def size
      if !block_given?
        return @j_del.java_method(:size, []).call()
      end
      if defined?(super)
        super
      else
        raise ArgumentError, "Invalid arguments when calling size()"
      end
    end
    #  Get the property with the specified {::VertxSqlClient::PropertyKind}.
    # @overload property(propertyKind)
    #   @param [::VertxSqlClient::PropertyKind] propertyKind the kind of the property
    # @return [Object] the value of the property
    def property(*args)
      if args[0].class.method_defined?(:j_del) && !block_given?
        return ::Vertx::Util::Utils.from_object(@j_del.java_method(:property, [Java::IoVertxSqlclient::PropertyKind.java_class]).call(args[0].j_del))
      end
      if defined?(super)
        super
      else
        raise ArgumentError, "Invalid arguments when calling property(#{args[0]})"
      end
    end
    #  Get the names of columns in the SqlResult.
    # @overload columnsNames()
    # @return [Array<String>] the list of names of columns.
    def columns_names
      if !block_given?
        return @j_del.java_method(:columnsNames, []).call().to_a.map { |elt| elt }
      end
      if defined?(super)
        super
      else
        raise ArgumentError, "Invalid arguments when calling columns_names()"
      end
    end
    #  Get the number of the affected rows in the operation to this SqlResult.
    # @overload rowCount()
    # @return [Fixnum] the count of affected rows.
    def row_count
      if !block_given?
        return @j_del.java_method(:rowCount, []).call()
      end
      if defined?(super)
        super
      else
        raise ArgumentError, "Invalid arguments when calling row_count()"
      end
    end
    #  Get the result value.
    # @overload value()
    # @return [Object] the result
    def value
      if !block_given?
        return @j_arg_T.wrap(@j_del.java_method(:value, []).call())
      end
      if defined?(super)
        super
      else
        raise ArgumentError, "Invalid arguments when calling value()"
      end
    end
  end
end
