require 'vertx/buffer'
require 'vertx/future'
require 'vertx/future'
require 'vertx/util/utils.rb'
# Generated from io.vertx.ext.stomp.StompClientConnection
module VertxStomp
  #  Once a connection to the STOMP server has been made, client receives a {::VertxStomp::StompClientConnection}, that let
  #  send and receive STOMP frames.
  class StompClientConnection
    # @private
    # @param j_del [::VertxStomp::StompClientConnection] the java delegate
    def initialize(j_del)
      @j_del = j_del
    end
    # @private
    # @return [::VertxStomp::StompClientConnection] the underlying java delegate
    def j_del
      @j_del
    end
    @@j_api_type = Object.new
    def @@j_api_type.accept?(obj)
      obj.class == StompClientConnection
    end
    def @@j_api_type.wrap(obj)
      StompClientConnection.new(obj)
    end
    def @@j_api_type.unwrap(obj)
      obj.j_del
    end
    def self.j_api_type
      @@j_api_type
    end
    def self.j_class
      Java::IoVertxExtStomp::StompClientConnection.java_class
    end
    #  Sets a handler notified when the server does not respond to a <code>ping</code> request in time. In other
    #  words, this handler is invoked when the heartbeat has detected a connection failure with the server.
    #  The handler can decide to reconnect to the server.
    # @overload connectionDroppedHandler(handler)
    #   @yield the handler
    # @return [self]
    def connection_dropped_handler
      if true
        @j_del.java_method(:connectionDroppedHandler, [Java::IoVertxCore::Handler.java_class]).call((Proc.new { |event| yield(::Vertx::Util::Utils.safe_create(event,::VertxStomp::StompClientConnection)) unless !block_given? }))
        return self
      end
      if defined?(super)
        super
      else
        raise ArgumentError, "Invalid arguments when calling connection_dropped_handler()"
      end
    end
    #  Disconnects the client. Unlike the {::VertxStomp::StompClientConnection#close} method, this method send the <code>DISCONNECT</code> frame to the
    #  server. This method lets you customize the <code>DISCONNECT</code> frame.
    # @overload disconnect(receiptHandler)
    #   @yield the handler invoked when the <code>RECEIPT</code> frame associated with the disconnection has been processed by the server. The handler receives the sent frame (<code>DISCONNECT</code>).
    # @overload disconnect(frame,receiptHandler)
    #   @param [Hash{String => Object}] frame the <code>DISCONNECT</code> frame.
    #   @yield the handler invoked when the <code>RECEIPT</code> frame associated with the disconnection has been processed by the server. The handler receives the sent frame (<code>DISCONNECT</code>).
    # @return [self]
    def disconnect(*args)
      if true && args[0] == nil
        if (block_given?)
          @j_del.java_method(:disconnect, [Java::IoVertxCore::Handler.java_class]).call(block_given? ? Proc.new { |ar| yield(ar.failed ? ar.cause : nil, ar.succeeded ? ar.result != nil ? JSON.parse(ar.result.toJson.encode) : nil : nil) } : promise)
          return self
        else
          promise = ::Vertx::Util::Utils.promise
          @j_del.java_method(:disconnect, [Java::IoVertxCore::Handler.java_class]).call(block_given? ? Proc.new { |ar| yield(ar.failed ? ar.cause : nil, ar.succeeded ? ar.result != nil ? JSON.parse(ar.result.toJson.encode) : nil : nil) } : promise)
          return ::Vertx::Util::Utils.safe_create(promise.future(),::Vertx::Future,::Vertx::Util::data_object_type(Java::IoVertxExtStomp::Frame))
        end
      elsif args[0].class == Hash && true
        if (block_given?)
          @j_del.java_method(:disconnect, [Java::IoVertxExtStomp::Frame.java_class,Java::IoVertxCore::Handler.java_class]).call(Java::IoVertxExtStomp::Frame.new(::Vertx::Util::Utils.to_json_object(args[0])),block_given? ? Proc.new { |ar| yield(ar.failed ? ar.cause : nil, ar.succeeded ? ar.result != nil ? JSON.parse(ar.result.toJson.encode) : nil : nil) } : promise)
          return self
        else
          promise = ::Vertx::Util::Utils.promise
          @j_del.java_method(:disconnect, [Java::IoVertxExtStomp::Frame.java_class,Java::IoVertxCore::Handler.java_class]).call(Java::IoVertxExtStomp::Frame.new(::Vertx::Util::Utils.to_json_object(args[0])),block_given? ? Proc.new { |ar| yield(ar.failed ? ar.cause : nil, ar.succeeded ? ar.result != nil ? JSON.parse(ar.result.toJson.encode) : nil : nil) } : promise)
          return ::Vertx::Util::Utils.safe_create(promise.future(),::Vertx::Future,::Vertx::Util::data_object_type(Java::IoVertxExtStomp::Frame))
        end
      end
      if defined?(super)
        super
      else
        raise ArgumentError, "Invalid arguments when calling disconnect(#{args[0]})"
      end
    end
    # @overload server()
    # @return [String] the server name.
    def server
      if !block_given?
        return @j_del.java_method(:server, []).call()
      end
      if defined?(super)
        super
      else
        raise ArgumentError, "Invalid arguments when calling server()"
      end
    end
    #  Configures a received handler that get notified when a STOMP frame is received by the client.
    #  This handler can be used for logging, debugging or ad-hoc behavior. The frame can still be modified by the handler.
    #  <p>
    #  Unlike {::VertxStomp::StompClient#received_frame_handler}, the given handler won't receive the <code>CONNECTED</code> frame. If a received frame handler is set on the {::VertxStomp::StompClient}, it will be used by all
    #  clients connection, so calling this method is useless, except if you want to use a different handler.
    # @overload receivedFrameHandler(handler)
    #   @yield the handler
    # @return [self]
    def received_frame_handler
      if true
        @j_del.java_method(:receivedFrameHandler, [Java::IoVertxCore::Handler.java_class]).call((Proc.new { |event| yield(event != nil ? JSON.parse(event.toJson.encode) : nil) unless !block_given? }))
        return self
      end
      if defined?(super)
        super
      else
        raise ArgumentError, "Invalid arguments when calling received_frame_handler()"
      end
    end
    #  Subscribes to the given destination.
    # @overload subscribe(destination,handler,receiptHandler)
    #   @param [String] destination the destination, must not be <code>null</code>
    #   @param [Proc] handler the handler invoked when a message is received on the given destination. Must not be <code>null</code>.
    #   @yield the handler invoked when the <code>RECEIPT</code> frame associated with the subscription has been received. The handler receives the subscription id.
    # @overload subscribe(destination,headers,handler,receiptHandler)
    #   @param [String] destination the destination, must not be <code>null</code>
    #   @param [Hash{String => String}] headers the headers to configure the subscription. It may contain the <code>ack</code> header to configure the acknowledgment policy. If the given set of headers contains the <code>id</code> header, this value is used as subscription id.
    #   @param [Proc] handler the handler invoked when a message is received on the given destination. Must not be <code>null</code>.
    #   @yield the handler invoked when the <code>RECEIPT</code> frame associated with the subscription has been received. The handler receives the subscription id.
    # @return [self]
    def subscribe(*args)
      if args[0].class == String && args[1].class == Proc && true && args[2] == nil
        if (block_given?)
          @j_del.java_method(:subscribe, [Java::java.lang.String.java_class,Java::IoVertxCore::Handler.java_class,Java::IoVertxCore::Handler.java_class]).call(args[0],(Proc.new { |event| args[1].call(event != nil ? JSON.parse(event.toJson.encode) : nil) unless args[1] == nil }),block_given? ? Proc.new { |ar| yield(ar.failed ? ar.cause : nil, ar.succeeded ? ar.result : nil) } : promise)
          return self
        else
          promise = ::Vertx::Util::Utils.promise
          @j_del.java_method(:subscribe, [Java::java.lang.String.java_class,Java::IoVertxCore::Handler.java_class,Java::IoVertxCore::Handler.java_class]).call(args[0],(Proc.new { |event| args[1].call(event != nil ? JSON.parse(event.toJson.encode) : nil) unless args[1] == nil }),block_given? ? Proc.new { |ar| yield(ar.failed ? ar.cause : nil, ar.succeeded ? ar.result : nil) } : promise)
          return ::Vertx::Util::Utils.safe_create(promise.future(),::Vertx::Future, nil)
        end
      elsif args[0].class == String && args[1].class == Hash && args[2].class == Proc && true
        if (block_given?)
          @j_del.java_method(:subscribe, [Java::java.lang.String.java_class,Java::JavaUtil::Map.java_class,Java::IoVertxCore::Handler.java_class,Java::IoVertxCore::Handler.java_class]).call(args[0],Hash[args[1].map { |k,v| [k,v] }],(Proc.new { |event| args[2].call(event != nil ? JSON.parse(event.toJson.encode) : nil) unless args[2] == nil }),block_given? ? Proc.new { |ar| yield(ar.failed ? ar.cause : nil, ar.succeeded ? ar.result : nil) } : promise)
          return self
        else
          promise = ::Vertx::Util::Utils.promise
          @j_del.java_method(:subscribe, [Java::java.lang.String.java_class,Java::JavaUtil::Map.java_class,Java::IoVertxCore::Handler.java_class,Java::IoVertxCore::Handler.java_class]).call(args[0],Hash[args[1].map { |k,v| [k,v] }],(Proc.new { |event| args[2].call(event != nil ? JSON.parse(event.toJson.encode) : nil) unless args[2] == nil }),block_given? ? Proc.new { |ar| yield(ar.failed ? ar.cause : nil, ar.succeeded ? ar.result : nil) } : promise)
          return ::Vertx::Util::Utils.safe_create(promise.future(),::Vertx::Future, nil)
        end
      end
      if defined?(super)
        super
      else
        raise ArgumentError, "Invalid arguments when calling subscribe(#{args[0]},#{args[1]},#{args[2]})"
      end
    end
    # @overload session()
    # @return [String] the session id.
    def session
      if !block_given?
        return @j_del.java_method(:session, []).call()
      end
      if defined?(super)
        super
      else
        raise ArgumentError, "Invalid arguments when calling session()"
      end
    end
    #  Returns whether or not the `CONNECTED` frame has been receive meaning that the Stomp connection is established.
    # @overload isConnected()
    # @return [true,false] <code>true</code> if the connection is established, <code>false</code> otherwise
    def connected?
      if !block_given?
        return @j_del.java_method(:isConnected, []).call()
      end
      if defined?(super)
        super
      else
        raise ArgumentError, "Invalid arguments when calling connected?()"
      end
    end
    #  Sends a non-acknowledgement for the given frame. It means that the frame has not been handled by the client.
    #  The sent non-acknowledgement is part of the transaction identified by the given id.
    # @overload nack(id,receiptHandler)
    #   @param [String] id the message id of the message to acknowledge
    #   @yield the handler invoked when the <code>RECEIPT</code> frame associated with the non-acknowledgment has been processed by the server. The handler receives the sent frame (<code>NACK</code>).
    # @overload nack(id,txId,receiptHandler)
    #   @param [String] id the message id of the message to acknowledge
    #   @param [String] txId the transaction id
    #   @yield the handler invoked when the <code>RECEIPT</code> frame associated with the non-acknowledgment has been processed by the server. The handler receives the sent frame (<code>NACK</code>).
    # @return [self]
    def nack(*args)
      if args[0].class == String && true && args[1] == nil
        if (block_given?)
          @j_del.java_method(:nack, [Java::java.lang.String.java_class,Java::IoVertxCore::Handler.java_class]).call(args[0],block_given? ? Proc.new { |ar| yield(ar.failed ? ar.cause : nil, ar.succeeded ? ar.result != nil ? JSON.parse(ar.result.toJson.encode) : nil : nil) } : promise)
          return self
        else
          promise = ::Vertx::Util::Utils.promise
          @j_del.java_method(:nack, [Java::java.lang.String.java_class,Java::IoVertxCore::Handler.java_class]).call(args[0],block_given? ? Proc.new { |ar| yield(ar.failed ? ar.cause : nil, ar.succeeded ? ar.result != nil ? JSON.parse(ar.result.toJson.encode) : nil : nil) } : promise)
          return ::Vertx::Util::Utils.safe_create(promise.future(),::Vertx::Future,::Vertx::Util::data_object_type(Java::IoVertxExtStomp::Frame))
        end
      elsif args[0].class == String && args[1].class == String && true
        if (block_given?)
          @j_del.java_method(:nack, [Java::java.lang.String.java_class,Java::java.lang.String.java_class,Java::IoVertxCore::Handler.java_class]).call(args[0],args[1],block_given? ? Proc.new { |ar| yield(ar.failed ? ar.cause : nil, ar.succeeded ? ar.result != nil ? JSON.parse(ar.result.toJson.encode) : nil : nil) } : promise)
          return self
        else
          promise = ::Vertx::Util::Utils.promise
          @j_del.java_method(:nack, [Java::java.lang.String.java_class,Java::java.lang.String.java_class,Java::IoVertxCore::Handler.java_class]).call(args[0],args[1],block_given? ? Proc.new { |ar| yield(ar.failed ? ar.cause : nil, ar.succeeded ? ar.result != nil ? JSON.parse(ar.result.toJson.encode) : nil : nil) } : promise)
          return ::Vertx::Util::Utils.safe_create(promise.future(),::Vertx::Future,::Vertx::Util::data_object_type(Java::IoVertxExtStomp::Frame))
        end
      end
      if defined?(super)
        super
      else
        raise ArgumentError, "Invalid arguments when calling nack(#{args[0]},#{args[1]})"
      end
    end
    #  Sends an acknowledgement for the given frame. It means that the frame has been handled and processed by the
    #  client. The sent acknowledgement is part of the transaction identified by the given id.
    # @overload ack(id,receiptHandler)
    #   @param [String] id the message id of the message to acknowledge
    #   @yield the handler invoked when the <code>RECEIPT</code> frame associated with the acknowledgment has been processed by the server. The handler receives the sent frame (<code>ACK</code>).
    # @overload ack(id,txId,receiptHandler)
    #   @param [String] id the message id of the message to acknowledge
    #   @param [String] txId the transaction id
    #   @yield the handler invoked when the <code>RECEIPT</code> frame associated with the acknowledgment has been processed by the server. The handler receives the sent frame (<code>ACK</code>).
    # @return [self]
    def ack(*args)
      if args[0].class == String && true && args[1] == nil
        if (block_given?)
          @j_del.java_method(:ack, [Java::java.lang.String.java_class,Java::IoVertxCore::Handler.java_class]).call(args[0],block_given? ? Proc.new { |ar| yield(ar.failed ? ar.cause : nil, ar.succeeded ? ar.result != nil ? JSON.parse(ar.result.toJson.encode) : nil : nil) } : promise)
          return self
        else
          promise = ::Vertx::Util::Utils.promise
          @j_del.java_method(:ack, [Java::java.lang.String.java_class,Java::IoVertxCore::Handler.java_class]).call(args[0],block_given? ? Proc.new { |ar| yield(ar.failed ? ar.cause : nil, ar.succeeded ? ar.result != nil ? JSON.parse(ar.result.toJson.encode) : nil : nil) } : promise)
          return ::Vertx::Util::Utils.safe_create(promise.future(),::Vertx::Future,::Vertx::Util::data_object_type(Java::IoVertxExtStomp::Frame))
        end
      elsif args[0].class == String && args[1].class == String && true
        if (block_given?)
          @j_del.java_method(:ack, [Java::java.lang.String.java_class,Java::java.lang.String.java_class,Java::IoVertxCore::Handler.java_class]).call(args[0],args[1],block_given? ? Proc.new { |ar| yield(ar.failed ? ar.cause : nil, ar.succeeded ? ar.result != nil ? JSON.parse(ar.result.toJson.encode) : nil : nil) } : promise)
          return self
        else
          promise = ::Vertx::Util::Utils.promise
          @j_del.java_method(:ack, [Java::java.lang.String.java_class,Java::java.lang.String.java_class,Java::IoVertxCore::Handler.java_class]).call(args[0],args[1],block_given? ? Proc.new { |ar| yield(ar.failed ? ar.cause : nil, ar.succeeded ? ar.result != nil ? JSON.parse(ar.result.toJson.encode) : nil : nil) } : promise)
          return ::Vertx::Util::Utils.safe_create(promise.future(),::Vertx::Future,::Vertx::Util::data_object_type(Java::IoVertxExtStomp::Frame))
        end
      end
      if defined?(super)
        super
      else
        raise ArgumentError, "Invalid arguments when calling ack(#{args[0]},#{args[1]})"
      end
    end
    #  Commits a transaction.
    # @overload commit(id,receiptHandler)
    #   @param [String] id the transaction id, must not be <code>null</code>
    #   @yield the handler invoked when the <code>RECEIPT</code> frame associated with the transaction commit has been processed by the server. The handler receives the sent frame (<code>COMMIT</code>).
    # @overload commit(id,headers,receiptHandler)
    #   @param [String] id the transaction id, must not be <code>null</code>
    #   @param [Hash{String => String}] headers additional headers to send to the server. The <code>transaction</code> header is replaced by the value passed in the @{code id} parameter
    #   @yield the handler invoked when the <code>RECEIPT</code> frame associated with the transaction commit has been processed by the server. The handler receives the sent frame (<code>COMMIT</code>).
    # @return [self]
    def commit(*args)
      if args[0].class == String && true && args[1] == nil
        if (block_given?)
          @j_del.java_method(:commit, [Java::java.lang.String.java_class,Java::IoVertxCore::Handler.java_class]).call(args[0],block_given? ? Proc.new { |ar| yield(ar.failed ? ar.cause : nil, ar.succeeded ? ar.result != nil ? JSON.parse(ar.result.toJson.encode) : nil : nil) } : promise)
          return self
        else
          promise = ::Vertx::Util::Utils.promise
          @j_del.java_method(:commit, [Java::java.lang.String.java_class,Java::IoVertxCore::Handler.java_class]).call(args[0],block_given? ? Proc.new { |ar| yield(ar.failed ? ar.cause : nil, ar.succeeded ? ar.result != nil ? JSON.parse(ar.result.toJson.encode) : nil : nil) } : promise)
          return ::Vertx::Util::Utils.safe_create(promise.future(),::Vertx::Future,::Vertx::Util::data_object_type(Java::IoVertxExtStomp::Frame))
        end
      elsif args[0].class == String && args[1].class == Hash && true
        if (block_given?)
          @j_del.java_method(:commit, [Java::java.lang.String.java_class,Java::JavaUtil::Map.java_class,Java::IoVertxCore::Handler.java_class]).call(args[0],Hash[args[1].map { |k,v| [k,v] }],block_given? ? Proc.new { |ar| yield(ar.failed ? ar.cause : nil, ar.succeeded ? ar.result != nil ? JSON.parse(ar.result.toJson.encode) : nil : nil) } : promise)
          return self
        else
          promise = ::Vertx::Util::Utils.promise
          @j_del.java_method(:commit, [Java::java.lang.String.java_class,Java::JavaUtil::Map.java_class,Java::IoVertxCore::Handler.java_class]).call(args[0],Hash[args[1].map { |k,v| [k,v] }],block_given? ? Proc.new { |ar| yield(ar.failed ? ar.cause : nil, ar.succeeded ? ar.result != nil ? JSON.parse(ar.result.toJson.encode) : nil : nil) } : promise)
          return ::Vertx::Util::Utils.safe_create(promise.future(),::Vertx::Future,::Vertx::Util::data_object_type(Java::IoVertxExtStomp::Frame))
        end
      end
      if defined?(super)
        super
      else
        raise ArgumentError, "Invalid arguments when calling commit(#{args[0]},#{args[1]})"
      end
    end
    #  Sets a handler that let customize the behavior when a ping needs to be sent to the server. Be aware that
    #  changing the default behavior may break the compliance with the STOMP specification.
    # @overload pingHandler(handler)
    #   @yield the handler
    # @return [self]
    def ping_handler
      if true
        @j_del.java_method(:pingHandler, [Java::IoVertxCore::Handler.java_class]).call((Proc.new { |event| yield(::Vertx::Util::Utils.safe_create(event,::VertxStomp::StompClientConnection)) unless !block_given? }))
        return self
      end
      if defined?(super)
        super
      else
        raise ArgumentError, "Invalid arguments when calling ping_handler()"
      end
    end
    #  Sets a handler notified when the STOMP connection is closed.
    # @overload closeHandler(handler)
    #   @yield the handler
    # @return [self]
    def close_handler
      if true
        @j_del.java_method(:closeHandler, [Java::IoVertxCore::Handler.java_class]).call((Proc.new { |event| yield(::Vertx::Util::Utils.safe_create(event,::VertxStomp::StompClientConnection)) unless !block_given? }))
        return self
      end
      if defined?(super)
        super
      else
        raise ArgumentError, "Invalid arguments when calling close_handler()"
      end
    end
    # @overload version()
    # @return [String] the STOMP protocol version negotiated with the server.
    def version
      if !block_given?
        return @j_del.java_method(:version, []).call()
      end
      if defined?(super)
        super
      else
        raise ArgumentError, "Invalid arguments when calling version()"
      end
    end
    #  Aborts a transaction.
    # @overload abort(id,receiptHandler)
    #   @param [String] id the transaction id, must not be <code>null</code>
    #   @yield the handler invoked when the <code>RECEIPT</code> frame associated with the transaction cancellation has been processed by the server. The handler receives the sent frame (<code>ABORT</code>).
    # @overload abort(id,headers,receiptHandler)
    #   @param [String] id the transaction id, must not be <code>null</code>
    #   @param [Hash{String => String}] headers additional headers to send to the server. The <code>transaction</code> header is replaced by the value passed in the @{code id} parameter
    #   @yield the handler invoked when the <code>RECEIPT</code> frame associated with the transaction cancellation has been processed by the server. The handler receives the sent frame (<code>ABORT</code>).
    # @return [self]
    def abort(*args)
      if args[0].class == String && true && args[1] == nil
        if (block_given?)
          @j_del.java_method(:abort, [Java::java.lang.String.java_class,Java::IoVertxCore::Handler.java_class]).call(args[0],block_given? ? Proc.new { |ar| yield(ar.failed ? ar.cause : nil, ar.succeeded ? ar.result != nil ? JSON.parse(ar.result.toJson.encode) : nil : nil) } : promise)
          return self
        else
          promise = ::Vertx::Util::Utils.promise
          @j_del.java_method(:abort, [Java::java.lang.String.java_class,Java::IoVertxCore::Handler.java_class]).call(args[0],block_given? ? Proc.new { |ar| yield(ar.failed ? ar.cause : nil, ar.succeeded ? ar.result != nil ? JSON.parse(ar.result.toJson.encode) : nil : nil) } : promise)
          return ::Vertx::Util::Utils.safe_create(promise.future(),::Vertx::Future,::Vertx::Util::data_object_type(Java::IoVertxExtStomp::Frame))
        end
      elsif args[0].class == String && args[1].class == Hash && true
        if (block_given?)
          @j_del.java_method(:abort, [Java::java.lang.String.java_class,Java::JavaUtil::Map.java_class,Java::IoVertxCore::Handler.java_class]).call(args[0],Hash[args[1].map { |k,v| [k,v] }],block_given? ? Proc.new { |ar| yield(ar.failed ? ar.cause : nil, ar.succeeded ? ar.result != nil ? JSON.parse(ar.result.toJson.encode) : nil : nil) } : promise)
          return self
        else
          promise = ::Vertx::Util::Utils.promise
          @j_del.java_method(:abort, [Java::java.lang.String.java_class,Java::JavaUtil::Map.java_class,Java::IoVertxCore::Handler.java_class]).call(args[0],Hash[args[1].map { |k,v| [k,v] }],block_given? ? Proc.new { |ar| yield(ar.failed ? ar.cause : nil, ar.succeeded ? ar.result != nil ? JSON.parse(ar.result.toJson.encode) : nil : nil) } : promise)
          return ::Vertx::Util::Utils.safe_create(promise.future(),::Vertx::Future,::Vertx::Util::data_object_type(Java::IoVertxExtStomp::Frame))
        end
      end
      if defined?(super)
        super
      else
        raise ArgumentError, "Invalid arguments when calling abort(#{args[0]},#{args[1]})"
      end
    end
    #  Begins a transaction.
    # @overload beginTX(id,receiptHandler)
    #   @param [String] id the transaction id, must not be <code>null</code>
    #   @yield the handler invoked when the <code>RECEIPT</code> frame associated with the transaction begin has been processed by the server. The handler receives the sent frame (<code>BEGIN</code>).
    # @overload beginTX(id,headers,receiptHandler)
    #   @param [String] id the transaction id, must not be <code>null</code>
    #   @param [Hash{String => String}] headers additional headers to send to the server. The <code>transaction</code> header is replaced by the value passed in the @{code id} parameter
    #   @yield the handler invoked when the <code>RECEIPT</code> frame associated with the transaction begin has been processed by the server. The handler receives the sent frame (<code>BEGIN</code>).
    # @return [self]
    def begin_tx(*args)
      if args[0].class == String && true && args[1] == nil
        if (block_given?)
          @j_del.java_method(:beginTX, [Java::java.lang.String.java_class,Java::IoVertxCore::Handler.java_class]).call(args[0],block_given? ? Proc.new { |ar| yield(ar.failed ? ar.cause : nil, ar.succeeded ? ar.result != nil ? JSON.parse(ar.result.toJson.encode) : nil : nil) } : promise)
          return self
        else
          promise = ::Vertx::Util::Utils.promise
          @j_del.java_method(:beginTX, [Java::java.lang.String.java_class,Java::IoVertxCore::Handler.java_class]).call(args[0],block_given? ? Proc.new { |ar| yield(ar.failed ? ar.cause : nil, ar.succeeded ? ar.result != nil ? JSON.parse(ar.result.toJson.encode) : nil : nil) } : promise)
          return ::Vertx::Util::Utils.safe_create(promise.future(),::Vertx::Future,::Vertx::Util::data_object_type(Java::IoVertxExtStomp::Frame))
        end
      elsif args[0].class == String && args[1].class == Hash && true
        if (block_given?)
          @j_del.java_method(:beginTX, [Java::java.lang.String.java_class,Java::JavaUtil::Map.java_class,Java::IoVertxCore::Handler.java_class]).call(args[0],Hash[args[1].map { |k,v| [k,v] }],block_given? ? Proc.new { |ar| yield(ar.failed ? ar.cause : nil, ar.succeeded ? ar.result != nil ? JSON.parse(ar.result.toJson.encode) : nil : nil) } : promise)
          return self
        else
          promise = ::Vertx::Util::Utils.promise
          @j_del.java_method(:beginTX, [Java::java.lang.String.java_class,Java::JavaUtil::Map.java_class,Java::IoVertxCore::Handler.java_class]).call(args[0],Hash[args[1].map { |k,v| [k,v] }],block_given? ? Proc.new { |ar| yield(ar.failed ? ar.cause : nil, ar.succeeded ? ar.result != nil ? JSON.parse(ar.result.toJson.encode) : nil : nil) } : promise)
          return ::Vertx::Util::Utils.safe_create(promise.future(),::Vertx::Future,::Vertx::Util::data_object_type(Java::IoVertxExtStomp::Frame))
        end
      end
      if defined?(super)
        super
      else
        raise ArgumentError, "Invalid arguments when calling begin_tx(#{args[0]},#{args[1]})"
      end
    end
    #  Un-subscribes from the given destination. This method computes the subscription id as follows. If the given
    #  headers contains the <code>id</code> header, the header value is used. Otherwise the destination is used.
    # @overload unsubscribe(destination,receiptHandler)
    #   @param [String] destination the destination
    #   @yield the handler invoked when the <code>RECEIPT</code> frame associated with the un-subscription has been received. The handler receives the sent frame (<code>UNSUBSCRIBE</code>).
    # @overload unsubscribe(destination,headers,receiptHandler)
    #   @param [String] destination the destination
    #   @param [Hash{String => String}] headers the headers
    #   @yield the handler invoked when the <code>RECEIPT</code> frame associated with the un-subscription has been received. The handler receives the sent frame (<code>UNSUBSCRIBE</code>).
    # @return [self]
    def unsubscribe(*args)
      if args[0].class == String && true && args[1] == nil
        if (block_given?)
          @j_del.java_method(:unsubscribe, [Java::java.lang.String.java_class,Java::IoVertxCore::Handler.java_class]).call(args[0],block_given? ? Proc.new { |ar| yield(ar.failed ? ar.cause : nil, ar.succeeded ? ar.result != nil ? JSON.parse(ar.result.toJson.encode) : nil : nil) } : promise)
          return self
        else
          promise = ::Vertx::Util::Utils.promise
          @j_del.java_method(:unsubscribe, [Java::java.lang.String.java_class,Java::IoVertxCore::Handler.java_class]).call(args[0],block_given? ? Proc.new { |ar| yield(ar.failed ? ar.cause : nil, ar.succeeded ? ar.result != nil ? JSON.parse(ar.result.toJson.encode) : nil : nil) } : promise)
          return ::Vertx::Util::Utils.safe_create(promise.future(),::Vertx::Future,::Vertx::Util::data_object_type(Java::IoVertxExtStomp::Frame))
        end
      elsif args[0].class == String && args[1].class == Hash && true
        if (block_given?)
          @j_del.java_method(:unsubscribe, [Java::java.lang.String.java_class,Java::JavaUtil::Map.java_class,Java::IoVertxCore::Handler.java_class]).call(args[0],Hash[args[1].map { |k,v| [k,v] }],block_given? ? Proc.new { |ar| yield(ar.failed ? ar.cause : nil, ar.succeeded ? ar.result != nil ? JSON.parse(ar.result.toJson.encode) : nil : nil) } : promise)
          return self
        else
          promise = ::Vertx::Util::Utils.promise
          @j_del.java_method(:unsubscribe, [Java::java.lang.String.java_class,Java::JavaUtil::Map.java_class,Java::IoVertxCore::Handler.java_class]).call(args[0],Hash[args[1].map { |k,v| [k,v] }],block_given? ? Proc.new { |ar| yield(ar.failed ? ar.cause : nil, ar.succeeded ? ar.result != nil ? JSON.parse(ar.result.toJson.encode) : nil : nil) } : promise)
          return ::Vertx::Util::Utils.safe_create(promise.future(),::Vertx::Future,::Vertx::Util::data_object_type(Java::IoVertxExtStomp::Frame))
        end
      end
      if defined?(super)
        super
      else
        raise ArgumentError, "Invalid arguments when calling unsubscribe(#{args[0]},#{args[1]})"
      end
    end
    #  Configures a handler notified when a frame is going to be written on the wire. This handler can be used from
    #  logging, debugging. The handler can modify the received frame.
    #  <p>
    #  If a writing frame handler is set on the {::VertxStomp::StompClient}, it will be used by all
    #  clients connection, so calling this method is useless, except if you want to use a different handler.
    # @overload writingFrameHandler(handler)
    #   @yield the handler
    # @return [self]
    def writing_frame_handler
      if true
        @j_del.java_method(:writingFrameHandler, [Java::IoVertxCore::Handler.java_class]).call((Proc.new { |event| yield(event != nil ? JSON.parse(event.toJson.encode) : nil) unless !block_given? }))
        return self
      end
      if defined?(super)
        super
      else
        raise ArgumentError, "Invalid arguments when calling writing_frame_handler()"
      end
    end
    #  Sets a handler notified when an <code>ERROR</code> frame is received by the client. The handler receives the <code>ERROR</code> frame and a reference on the {::VertxStomp::StompClientConnection}.
    # @overload errorHandler(handler)
    #   @yield the handler
    # @return [::VertxStomp::StompClientConnection] the current {::VertxStomp::StompClientConnection}
    def error_handler
      if true
        return ::Vertx::Util::Utils.safe_create(@j_del.java_method(:errorHandler, [Java::IoVertxCore::Handler.java_class]).call((Proc.new { |event| yield(event != nil ? JSON.parse(event.toJson.encode) : nil) unless !block_given? })),::VertxStomp::StompClientConnection)
      end
      if defined?(super)
        super
      else
        raise ArgumentError, "Invalid arguments when calling error_handler()"
      end
    end
    #  Configures the exception handler notified upon TCP-level errors.
    # @overload exceptionHandler(exceptionHandler)
    #   @yield the handler
    # @return [self]
    def exception_handler
      if true
        @j_del.java_method(:exceptionHandler, [Java::IoVertxCore::Handler.java_class]).call((Proc.new { |event| yield(::Vertx::Util::Utils.from_throwable(event)) unless !block_given? }))
        return self
      end
      if defined?(super)
        super
      else
        raise ArgumentError, "Invalid arguments when calling exception_handler()"
      end
    end
    #  Sends a <code>SEND</code> frame to the server to the given destination.
    # @overload send(frame,receiptHandler)
    #   @param [Hash{String => Object}] frame the frame
    #   @yield the handler invoked when the <code>RECEIPT</code> frame associated with the sent frame has been received. The handler receives the sent frame.
    # @overload send(headers,body,receiptHandler)
    #   @param [Hash{String => String}] headers the headers, must not be <code>null</code>
    #   @param [::Vertx::Buffer] body the body, may be <code>null</code>
    #   @yield the handler invoked when the <code>RECEIPT</code> frame associated with the sent frame has been received. The handler receives the sent frame.
    # @overload send(destination,body,receiptHandler)
    #   @param [String] destination the destination, must not be <code>null</code>
    #   @param [::Vertx::Buffer] body the body, may be <code>null</code>
    #   @yield the handler invoked when the <code>RECEIPT</code> frame associated with the sent frame has been received. The handler receives the sent frame.
    # @overload send(destination,headers,body,receiptHandler)
    #   @param [String] destination the destination, must not be <code>null</code>
    #   @param [Hash{String => String}] headers the header. The <code>destination</code> header is replaced by the value given to the <code>destination</code> parameter
    #   @param [::Vertx::Buffer] body the body, may be <code>null</code>
    #   @yield the handler invoked when the <code>RECEIPT</code> frame associated with the sent frame has been received. The handler receives the sent frame.
    # @return [self]
    def send(*args)
      if args[0].class == Hash && true && args[1] == nil && args[2] == nil
        if (block_given?)
          @j_del.java_method(:send, [Java::IoVertxExtStomp::Frame.java_class,Java::IoVertxCore::Handler.java_class]).call(Java::IoVertxExtStomp::Frame.new(::Vertx::Util::Utils.to_json_object(args[0])),block_given? ? Proc.new { |ar| yield(ar.failed ? ar.cause : nil, ar.succeeded ? ar.result != nil ? JSON.parse(ar.result.toJson.encode) : nil : nil) } : promise)
          return self
        else
          promise = ::Vertx::Util::Utils.promise
          @j_del.java_method(:send, [Java::IoVertxExtStomp::Frame.java_class,Java::IoVertxCore::Handler.java_class]).call(Java::IoVertxExtStomp::Frame.new(::Vertx::Util::Utils.to_json_object(args[0])),block_given? ? Proc.new { |ar| yield(ar.failed ? ar.cause : nil, ar.succeeded ? ar.result != nil ? JSON.parse(ar.result.toJson.encode) : nil : nil) } : promise)
          return ::Vertx::Util::Utils.safe_create(promise.future(),::Vertx::Future,::Vertx::Util::data_object_type(Java::IoVertxExtStomp::Frame))
        end
      elsif args[0].class == Hash && args[1].class.method_defined?(:j_del) && true && args[2] == nil
        if (block_given?)
          @j_del.java_method(:send, [Java::JavaUtil::Map.java_class,Java::IoVertxCoreBuffer::Buffer.java_class,Java::IoVertxCore::Handler.java_class]).call(Hash[args[0].map { |k,v| [k,v] }],args[1].j_del,block_given? ? Proc.new { |ar| yield(ar.failed ? ar.cause : nil, ar.succeeded ? ar.result != nil ? JSON.parse(ar.result.toJson.encode) : nil : nil) } : promise)
          return self
        else
          promise = ::Vertx::Util::Utils.promise
          @j_del.java_method(:send, [Java::JavaUtil::Map.java_class,Java::IoVertxCoreBuffer::Buffer.java_class,Java::IoVertxCore::Handler.java_class]).call(Hash[args[0].map { |k,v| [k,v] }],args[1].j_del,block_given? ? Proc.new { |ar| yield(ar.failed ? ar.cause : nil, ar.succeeded ? ar.result != nil ? JSON.parse(ar.result.toJson.encode) : nil : nil) } : promise)
          return ::Vertx::Util::Utils.safe_create(promise.future(),::Vertx::Future,::Vertx::Util::data_object_type(Java::IoVertxExtStomp::Frame))
        end
      elsif args[0].class == String && args[1].class.method_defined?(:j_del) && true && args[2] == nil
        if (block_given?)
          @j_del.java_method(:send, [Java::java.lang.String.java_class,Java::IoVertxCoreBuffer::Buffer.java_class,Java::IoVertxCore::Handler.java_class]).call(args[0],args[1].j_del,block_given? ? Proc.new { |ar| yield(ar.failed ? ar.cause : nil, ar.succeeded ? ar.result != nil ? JSON.parse(ar.result.toJson.encode) : nil : nil) } : promise)
          return self
        else
          promise = ::Vertx::Util::Utils.promise
          @j_del.java_method(:send, [Java::java.lang.String.java_class,Java::IoVertxCoreBuffer::Buffer.java_class,Java::IoVertxCore::Handler.java_class]).call(args[0],args[1].j_del,block_given? ? Proc.new { |ar| yield(ar.failed ? ar.cause : nil, ar.succeeded ? ar.result != nil ? JSON.parse(ar.result.toJson.encode) : nil : nil) } : promise)
          return ::Vertx::Util::Utils.safe_create(promise.future(),::Vertx::Future,::Vertx::Util::data_object_type(Java::IoVertxExtStomp::Frame))
        end
      elsif args[0].class == String && args[1].class == Hash && args[2].class.method_defined?(:j_del) && true
        if (block_given?)
          @j_del.java_method(:send, [Java::java.lang.String.java_class,Java::JavaUtil::Map.java_class,Java::IoVertxCoreBuffer::Buffer.java_class,Java::IoVertxCore::Handler.java_class]).call(args[0],Hash[args[1].map { |k,v| [k,v] }],args[2].j_del,block_given? ? Proc.new { |ar| yield(ar.failed ? ar.cause : nil, ar.succeeded ? ar.result != nil ? JSON.parse(ar.result.toJson.encode) : nil : nil) } : promise)
          return self
        else
          promise = ::Vertx::Util::Utils.promise
          @j_del.java_method(:send, [Java::java.lang.String.java_class,Java::JavaUtil::Map.java_class,Java::IoVertxCoreBuffer::Buffer.java_class,Java::IoVertxCore::Handler.java_class]).call(args[0],Hash[args[1].map { |k,v| [k,v] }],args[2].j_del,block_given? ? Proc.new { |ar| yield(ar.failed ? ar.cause : nil, ar.succeeded ? ar.result != nil ? JSON.parse(ar.result.toJson.encode) : nil : nil) } : promise)
          return ::Vertx::Util::Utils.safe_create(promise.future(),::Vertx::Future,::Vertx::Util::data_object_type(Java::IoVertxExtStomp::Frame))
        end
      end
      if defined?(super)
        super
      else
        raise ArgumentError, "Invalid arguments when calling send(#{args[0]},#{args[1]},#{args[2]})"
      end
    end
    #  Closes the connection without sending the <code>DISCONNECT</code> frame.
    # @overload close()
    # @return [void]
    def close
      if !block_given?
        return @j_del.java_method(:close, []).call()
      end
      if defined?(super)
        super
      else
        raise ArgumentError, "Invalid arguments when calling close()"
      end
    end
  end
end
