require 'vertx-unit/completion'
require 'vertx/promise'
require 'vertx/future'
require 'vertx/util/utils.rb'
# Generated from io.vertx.ext.unit.TestCompletion
module VertxUnit
  #  This object provides callback-ability for the end of a test suite, the completion <i>succeeds</i>
  #  when all tests pass otherwise it fails.
  class TestCompletion < ::VertxUnit::Completion
    # @private
    # @param j_del [::VertxUnit::TestCompletion] the java delegate
    def initialize(j_del)
      super(j_del, nil)
      @j_del = j_del
    end
    # @private
    # @return [::VertxUnit::TestCompletion] the underlying java delegate
    def j_del
      @j_del
    end
    @@j_api_type = Object.new
    def @@j_api_type.accept?(obj)
      obj.class == TestCompletion
    end
    def @@j_api_type.wrap(obj)
      TestCompletion.new(obj)
    end
    def @@j_api_type.unwrap(obj)
      obj.j_del
    end
    def self.j_api_type
      @@j_api_type
    end
    def self.j_class
      Java::IoVertxExtUnit::TestCompletion.java_class
    end
    #  Completion handler to receive a completion signal when this completions completes.
    # @overload handler(completionHandler)
    #   @yield the completion handler
    # @return [void]
    def handler
      if true
        if (block_given?)
          return @j_del.java_method(:handler, [Java::IoVertxCore::Handler.java_class]).call(block_given? ? Proc.new { |ar| yield(ar.failed ? ar.cause : nil, ar.succeeded ? nil : nil) } : promise)
        else
          promise = ::Vertx::Util::Utils.promise
          @j_del.java_method(:handler, [Java::IoVertxCore::Handler.java_class]).call(block_given? ? Proc.new { |ar| yield(ar.failed ? ar.cause : nil, ar.succeeded ? nil : nil) } : promise)
          return ::Vertx::Util::Utils.safe_create(promise.future(),::Vertx::Future, nil)
        end
      end
      if defined?(super)
        super
      else
        raise ArgumentError, "Invalid arguments when calling handler()"
      end
    end
    #  Completes the future upon completion, otherwise fails it.
    # @overload resolve(future)
    #   @param [::Vertx::Promise] future the future to resolve
    # @return [void]
    def resolve(*args)
      if args[0].class.method_defined?(:j_del) && !block_given?
        return @j_del.java_method(:resolve, [Java::IoVertxCore::Promise.java_class]).call(args[0].j_del)
      end
      if defined?(super)
        super
      else
        raise ArgumentError, "Invalid arguments when calling resolve(#{args[0]})"
      end
    end
  end
end
