require 'vertx-unit/test_context'
require 'vertx/vertx'
require 'vertx-unit/test_completion'
require 'vertx/future'
require 'vertx/util/utils.rb'
# Generated from io.vertx.ext.unit.TestSuite
module VertxUnit
  #  A named suite of test cases that are executed altogether. The suite suite is created with
  #  the {::VertxUnit::TestSuite#create} and the returned suite contains initially no tests.<p/>
  # 
  #  The suite can declare a callback before the suite with {::VertxUnit::TestSuite#before} or after
  #  the suite with {::VertxUnit::TestSuite#after}.<p/>
  # 
  #  The suite can declare a callback before each test with {::VertxUnit::TestSuite#before_each} or after
  #  each test with {::VertxUnit::TestSuite#after_each}.<p/>
  # 
  #  Each test case of the suite is declared by calling the {::VertxUnit::TestSuite#test} method.
  class TestSuite
    # @private
    # @param j_del [::VertxUnit::TestSuite] the java delegate
    def initialize(j_del)
      @j_del = j_del
    end
    # @private
    # @return [::VertxUnit::TestSuite] the underlying java delegate
    def j_del
      @j_del
    end
    @@j_api_type = Object.new
    def @@j_api_type.accept?(obj)
      obj.class == TestSuite
    end
    def @@j_api_type.wrap(obj)
      TestSuite.new(obj)
    end
    def @@j_api_type.unwrap(obj)
      obj.j_del
    end
    def self.j_api_type
      @@j_api_type
    end
    def self.j_class
      Java::IoVertxExtUnit::TestSuite.java_class
    end
    #  Set a callback executed before each test and after the suite <code>before</code> callback.
    # @overload beforeEach(callback)
    #   @yield the callback
    # @return [self]
    def before_each
      if true
        @j_del.java_method(:beforeEach, [Java::IoVertxCore::Handler.java_class]).call((Proc.new { |event| yield(::Vertx::Util::Utils.safe_create(event,::VertxUnit::TestContext)) unless !block_given? }))
        return self
      end
      if defined?(super)
        super
      else
        raise ArgumentError, "Invalid arguments when calling before_each()"
      end
    end
    #  Add a new test case to the suite.
    # @overload test(name,testCase)
    #   @param [String] name the test case name
    #   @yield the test case
    # @overload test(name,repeat,testCase)
    #   @param [String] name the test case name
    #   @param [Fixnum] repeat the number of times the test should be repeated
    #   @yield the test case
    # @return [self]
    def test(*args)
      if args[0].class == String && true && args[1] == nil
        @j_del.java_method(:test, [Java::java.lang.String.java_class,Java::IoVertxCore::Handler.java_class]).call(args[0],(Proc.new { |event| yield(::Vertx::Util::Utils.safe_create(event,::VertxUnit::TestContext)) unless !block_given? }))
        return self
      elsif args[0].class == String && args[1].class == Fixnum && true
        @j_del.java_method(:test, [Java::java.lang.String.java_class,Java::int.java_class,Java::IoVertxCore::Handler.java_class]).call(args[0],args[1],(Proc.new { |event| yield(::Vertx::Util::Utils.safe_create(event,::VertxUnit::TestContext)) unless !block_given? }))
        return self
      end
      if defined?(super)
        super
      else
        raise ArgumentError, "Invalid arguments when calling test(#{args[0]},#{args[1]})"
      end
    end
    #  Set a callback executed after each test and before the suite <code>after</code> callback.
    # @overload afterEach(callback)
    #   @yield the callback
    # @return [self]
    def after_each
      if true
        @j_del.java_method(:afterEach, [Java::IoVertxCore::Handler.java_class]).call((Proc.new { |event| yield(::Vertx::Util::Utils.safe_create(event,::VertxUnit::TestContext)) unless !block_given? }))
        return self
      end
      if defined?(super)
        super
      else
        raise ArgumentError, "Invalid arguments when calling after_each()"
      end
    end
    #  Set a callback executed before the tests.
    # @overload before(callback)
    #   @yield the callback
    # @return [self]
    def before
      if true
        @j_del.java_method(:before, [Java::IoVertxCore::Handler.java_class]).call((Proc.new { |event| yield(::Vertx::Util::Utils.safe_create(event,::VertxUnit::TestContext)) unless !block_given? }))
        return self
      end
      if defined?(super)
        super
      else
        raise ArgumentError, "Invalid arguments when calling before()"
      end
    end
    #  Create and return a new test suite.
    # @overload create(name)
    #   @param [String] name the test suite name
    # @return [::VertxUnit::TestSuite] the created test suite
    def self.create(*args)
      if args[0].class == String && !block_given?
        return ::Vertx::Util::Utils.safe_create(Java::IoVertxExtUnit::TestSuite.java_method(:create, [Java::java.lang.String.java_class]).call(args[0]),::VertxUnit::TestSuite)
      end
      if defined?(super)
        super
      else
        raise ArgumentError, "Invalid arguments when calling create(#{args[0]})"
      end
    end
    #  Run the testsuite with the specified <code>options</code> and the specified <code>vertx</code> instance.<p/>
    # 
    #  The test suite will be executed on the event loop provided by the <code>vertx</code> argument when
    #  {Hash{String => Object}#set_use_event_loop} is not set to <code>false</code>. The returned
    #  {::VertxUnit::Completion} object can be used to get a completion callback.
    # @overload run()
    # @overload run(options)
    #   @param [Hash{String => Object}] options the test options
    # @overload run(vertx)
    #   @param [::Vertx::Vertx] vertx the vertx instance
    # @overload run(vertx,options)
    #   @param [::Vertx::Vertx] vertx the vertx instance
    #   @param [Hash{String => Object}] options the test options
    # @return [::VertxUnit::TestCompletion] the related test completion
    def run(*args)
      if !block_given? && args[0] == nil && args[1] == nil
        return ::Vertx::Util::Utils.safe_create(@j_del.java_method(:run, []).call(),::VertxUnit::TestCompletion)
      elsif args[0].class == Hash && !block_given? && args[1] == nil
        return ::Vertx::Util::Utils.safe_create(@j_del.java_method(:run, [Java::IoVertxExtUnit::TestOptions.java_class]).call(Java::IoVertxExtUnit::TestOptions.new(::Vertx::Util::Utils.to_json_object(args[0]))),::VertxUnit::TestCompletion)
      elsif args[0].class.method_defined?(:j_del) && !block_given? && args[1] == nil
        return ::Vertx::Util::Utils.safe_create(@j_del.java_method(:run, [Java::IoVertxCore::Vertx.java_class]).call(args[0].j_del),::VertxUnit::TestCompletion)
      elsif args[0].class.method_defined?(:j_del) && args[1].class == Hash && !block_given?
        return ::Vertx::Util::Utils.safe_create(@j_del.java_method(:run, [Java::IoVertxCore::Vertx.java_class,Java::IoVertxExtUnit::TestOptions.java_class]).call(args[0].j_del,Java::IoVertxExtUnit::TestOptions.new(::Vertx::Util::Utils.to_json_object(args[1]))),::VertxUnit::TestCompletion)
      end
      if defined?(super)
        super
      else
        raise ArgumentError, "Invalid arguments when calling run(#{args[0]},#{args[1]})"
      end
    end
    #  Set a callback executed after the tests.
    # @overload after(callback)
    #   @yield the callback
    # @return [self]
    def after
      if true
        @j_del.java_method(:after, [Java::IoVertxCore::Handler.java_class]).call((Proc.new { |event| yield(::Vertx::Util::Utils.safe_create(event,::VertxUnit::TestContext)) unless !block_given? }))
        return self
      end
      if defined?(super)
        super
      else
        raise ArgumentError, "Invalid arguments when calling after()"
      end
    end
  end
end
