require 'vertx/buffer'
require 'vertx/multi_map'
require 'vertx/future'
require 'vertx/util/utils.rb'
# Generated from io.vertx.ext.web.client.HttpResponse
module VertxWebClient
  #  An HTTP response.
  #  <p>
  #  The usual HTTP response attributes are available:
  #  <ul>
  #    <li>{::VertxWebClient::HttpResponse#status_code} the HTTP status code</li>
  #    <li>{::VertxWebClient::HttpResponse#status_message} the HTTP status message</li>
  #    <li>{::VertxWebClient::HttpResponse#headers} the HTTP headers</li>
  #    <li>{::VertxWebClient::HttpResponse#version} the HTTP version</li>
  #  </ul>
  #  <p>
  #  The body of the response is returned by {::VertxWebClient::HttpResponse#body} decoded as the format specified by the {::VertxWebCommon::BodyCodec} that
  #  built the response.
  #  <p>
  #  Keep in mind that using this <code>HttpResponse</code> impose to fully buffer the response body and should be used for payload
  #  that can fit in memory.
  class HttpResponse
    # @private
    # @param j_del [::VertxWebClient::HttpResponse] the java delegate
    def initialize(j_del, j_arg_T=nil)
      @j_del = j_del
      @j_arg_T = j_arg_T != nil ? j_arg_T : ::Vertx::Util::unknown_type
    end
    # @private
    # @return [::VertxWebClient::HttpResponse] the underlying java delegate
    def j_del
      @j_del
    end
    # @overload headers()
    # @return [::Vertx::MultiMap] the headers
    def headers
      if !block_given?
        if @cached_headers != nil
          return @cached_headers
        end
        return @cached_headers = ::Vertx::Util::Utils.safe_create(@j_del.java_method(:headers, []).call(),::Vertx::MultiMap)
      end
      if defined?(super)
        super
      else
        raise ArgumentError, "Invalid arguments when calling headers()"
      end
    end
    # @overload bodyAsJsonArray()
    # @return [Array<String,Object>] the response body decoded as a , or <code>null</code> if a codec other than  was used
    def body_as_json_array
      if !block_given?
        if @cached_body_as_json_array != nil
          return @cached_body_as_json_array
        end
        return @cached_body_as_json_array = @j_del.java_method(:bodyAsJsonArray, []).call() != nil ? JSON.parse(@j_del.java_method(:bodyAsJsonArray, []).call().encode) : nil
      end
      if defined?(super)
        super
      else
        raise ArgumentError, "Invalid arguments when calling body_as_json_array()"
      end
    end
    # @overload bodyAsString()
    # @overload bodyAsString(encoding)
    #   @param [String] encoding 
    # @return [String] the response body decoded as a <code>String</code> given a specific <code>encoding</code>, or <code>null</code> if a codec other than  was used
    def body_as_string(*args)
      if !block_given? && args[0] == nil
        if @cached_body_as_string != nil
          return @cached_body_as_string
        end
        return @cached_body_as_string = @j_del.java_method(:bodyAsString, []).call()
      elsif args[0].class == String && !block_given?
        return @j_del.java_method(:bodyAsString, [Java::java.lang.String.java_class]).call(args[0])
      end
      if defined?(super)
        super
      else
        raise ArgumentError, "Invalid arguments when calling body_as_string(#{args[0]})"
      end
    end
    # @overload bodyAsJsonObject()
    # @return [Hash{String => Object}] the response body decoded as , or <code>null</code> if a codec other than  was used
    def body_as_json_object
      if !block_given?
        if @cached_body_as_json_object != nil
          return @cached_body_as_json_object
        end
        return @cached_body_as_json_object = @j_del.java_method(:bodyAsJsonObject, []).call() != nil ? JSON.parse(@j_del.java_method(:bodyAsJsonObject, []).call().encode) : nil
      end
      if defined?(super)
        super
      else
        raise ArgumentError, "Invalid arguments when calling body_as_json_object()"
      end
    end
    # @overload body()
    # @return [Object] the response body in the format it was decoded.
    def body
      if !block_given?
        if @cached_body != nil
          return @cached_body
        end
        return @cached_body = @j_arg_T.wrap(@j_del.java_method(:body, []).call())
      end
      if defined?(super)
        super
      else
        raise ArgumentError, "Invalid arguments when calling body()"
      end
    end
    #  Return the first trailer value with the specified name
    # @overload getTrailer(trailerName)
    #   @param [String] trailerName the trailer name
    # @return [String] the trailer value
    def get_trailer(*args)
      if args[0].class == String && !block_given?
        return @j_del.java_method(:getTrailer, [Java::java.lang.String.java_class]).call(args[0])
      end
      if defined?(super)
        super
      else
        raise ArgumentError, "Invalid arguments when calling get_trailer(#{args[0]})"
      end
    end
    # @overload version()
    # @return [:HTTP_1_0,:HTTP_1_1,:HTTP_2] the version of the response
    def version
      if !block_given?
        if @cached_version != nil
          return @cached_version
        end
        return @cached_version = @j_del.java_method(:version, []).call().name.intern
      end
      if defined?(super)
        super
      else
        raise ArgumentError, "Invalid arguments when calling version()"
      end
    end
    # @overload cookies()
    # @return [Array<String>] the Set-Cookie headers (including trailers)
    def cookies
      if !block_given?
        if @cached_cookies != nil
          return @cached_cookies
        end
        return @cached_cookies = @j_del.java_method(:cookies, []).call().to_a.map { |elt| elt }
      end
      if defined?(super)
        super
      else
        raise ArgumentError, "Invalid arguments when calling cookies()"
      end
    end
    # @overload statusMessage()
    # @return [String] the status message of the response
    def status_message
      if !block_given?
        if @cached_status_message != nil
          return @cached_status_message
        end
        return @cached_status_message = @j_del.java_method(:statusMessage, []).call()
      end
      if defined?(super)
        super
      else
        raise ArgumentError, "Invalid arguments when calling status_message()"
      end
    end
    # @overload bodyAsJson(type)
    #   @param [Nil] type 
    # @return [Object] the response body decoded as the specified <code>type</code> with the Jackson mapper, or <code>null</code> if a codec other than  was used
    def body_as_json(*args)
      if args[0].class == Class && !block_given?
        return ::Vertx::Util::Utils.v_type_of(args[0]).wrap(@j_del.java_method(:bodyAsJson, [Java::JavaLang::Class.java_class]).call(::Vertx::Util::Utils.j_class_of(args[0])))
      end
      if defined?(super)
        super
      else
        raise ArgumentError, "Invalid arguments when calling body_as_json(#{args[0]})"
      end
    end
    # @overload trailers()
    # @return [::Vertx::MultiMap] the trailers
    def trailers
      if !block_given?
        if @cached_trailers != nil
          return @cached_trailers
        end
        return @cached_trailers = ::Vertx::Util::Utils.safe_create(@j_del.java_method(:trailers, []).call(),::Vertx::MultiMap)
      end
      if defined?(super)
        super
      else
        raise ArgumentError, "Invalid arguments when calling trailers()"
      end
    end
    #  Return the first header value with the specified name
    # @overload getHeader(headerName)
    #   @param [String] headerName the header name
    # @return [String] the header value
    def get_header(*args)
      if args[0].class == String && !block_given?
        return @j_del.java_method(:getHeader, [Java::java.lang.String.java_class]).call(args[0])
      end
      if defined?(super)
        super
      else
        raise ArgumentError, "Invalid arguments when calling get_header(#{args[0]})"
      end
    end
    # @overload followedRedirects()
    # @return [Array<String>] the list of all followed redirects, including the final location.
    def followed_redirects
      if !block_given?
        if @cached_followed_redirects != nil
          return @cached_followed_redirects
        end
        return @cached_followed_redirects = @j_del.java_method(:followedRedirects, []).call().to_a.map { |elt| elt }
      end
      if defined?(super)
        super
      else
        raise ArgumentError, "Invalid arguments when calling followed_redirects()"
      end
    end
    # @overload bodyAsBuffer()
    # @return [::Vertx::Buffer] the response body decoded as a , or <code>null</code> if a codec other than  was used
    def body_as_buffer
      if !block_given?
        if @cached_body_as_buffer != nil
          return @cached_body_as_buffer
        end
        return @cached_body_as_buffer = ::Vertx::Util::Utils.safe_create(@j_del.java_method(:bodyAsBuffer, []).call(),::Vertx::Buffer)
      end
      if defined?(super)
        super
      else
        raise ArgumentError, "Invalid arguments when calling body_as_buffer()"
      end
    end
    # @overload statusCode()
    # @return [Fixnum] the status code of the response
    def status_code
      if !block_given?
        if @cached_status_code != nil
          return @cached_status_code
        end
        return @cached_status_code = @j_del.java_method(:statusCode, []).call()
      end
      if defined?(super)
        super
      else
        raise ArgumentError, "Invalid arguments when calling status_code()"
      end
    end
  end
end
