require 'vertx/buffer'
require 'vertx/write_stream'
require 'vertx/json_parser'
require 'vertx/future'
require 'vertx/util/utils.rb'
# Generated from io.vertx.ext.web.codec.BodyCodec
module VertxWebCommon
  #  A codec for encoding and decoding HTTP bodies.
  class BodyCodec
    # @private
    # @param j_del [::VertxWebCommon::BodyCodec] the java delegate
    def initialize(j_del, j_arg_T=nil)
      @j_del = j_del
      @j_arg_T = j_arg_T != nil ? j_arg_T : ::Vertx::Util::unknown_type
    end
    # @private
    # @return [::VertxWebCommon::BodyCodec] the underlying java delegate
    def j_del
      @j_del
    end
    #  A codec for strings using a specific <code>encoding</code>.
    # @overload string()
    # @overload string(encoding)
    #   @param [String] encoding the encoding
    # @return [::VertxWebCommon::BodyCodec] the codec
    def self.string(*args)
      if !block_given? && args[0] == nil
        return ::Vertx::Util::Utils.safe_create(Java::IoVertxExtWebCodec::BodyCodec.java_method(:string, []).call(),::VertxWebCommon::BodyCodec, nil)
      elsif args[0].class == String && !block_given?
        return ::Vertx::Util::Utils.safe_create(Java::IoVertxExtWebCodec::BodyCodec.java_method(:string, [Java::java.lang.String.java_class]).call(args[0]),::VertxWebCommon::BodyCodec, nil)
      end
      if defined?(super)
        super
      else
        raise ArgumentError, "Invalid arguments when calling string(#{args[0]})"
      end
    end
    #  A body codec that parse the response as a JSON stream.
    # @overload jsonStream(parser)
    #   @param [::Vertx::JsonParser] parser the non-null JSON parser to emits the JSON object. The parser must be configured for the stream. Not e that you need to keep a reference on the parser to retrieved the JSON events.
    # @return [::VertxWebCommon::BodyCodec] the body codec for a write stream
    def self.json_stream(*args)
      if args[0].class.method_defined?(:j_del) && !block_given?
        return ::Vertx::Util::Utils.safe_create(Java::IoVertxExtWebCodec::BodyCodec.java_method(:jsonStream, [Java::IoVertxCoreParsetools::JsonParser.java_class]).call(args[0].j_del),::VertxWebCommon::BodyCodec, nil)
      end
      if defined?(super)
        super
      else
        raise ArgumentError, "Invalid arguments when calling json_stream(#{args[0]})"
      end
    end
    #  Create a codec that buffers the entire body and then apply the <code>decode</code> function and returns the result.
    # @overload create(decode)
    #   @yield the decode function
    # @return [::VertxWebCommon::BodyCodec] the created codec
    def self.create(*args)
      if block_given? && args[0] == nil
        return ::Vertx::Util::Utils.safe_create(Java::IoVertxExtWebCodec::BodyCodec.java_method(:create, [Java::JavaUtilFunction::Function.java_class]).call((Proc.new { |event| ::Vertx::Util::Utils.to_object(yield(::Vertx::Util::Utils.safe_create(event,::Vertx::Buffer))) unless !block_given? })),::VertxWebCommon::BodyCodec, nil)
      end
      if defined?(super)
        super
      else
        raise ArgumentError, "Invalid arguments when calling create(#{args[0]})"
      end
    end
    #  Create and return a codec for Java objects encoded using Jackson mapper.
    # @overload json(type)
    #   @param [Nil] type 
    # @return [::VertxWebCommon::BodyCodec] a codec for mapping POJO to Json
    def self.json(*args)
      if args[0].class == Class && !block_given?
        return ::Vertx::Util::Utils.safe_create(Java::IoVertxExtWebCodec::BodyCodec.java_method(:json, [Java::JavaLang::Class.java_class]).call(::Vertx::Util::Utils.j_class_of(args[0])),::VertxWebCommon::BodyCodec, ::Vertx::Util::Utils.v_type_of(args[0]))
      end
      if defined?(super)
        super
      else
        raise ArgumentError, "Invalid arguments when calling json(#{args[0]})"
      end
    end
    #  A body codec that pipes the body to a write stream.
    # @overload pipe(stream)
    #   @param [::Vertx::WriteStream] stream the destination stream
    # @overload pipe(stream,close)
    #   @param [::Vertx::WriteStream] stream the destination stream
    #   @param [true,false] close whether the destination stream should be closed
    # @return [::VertxWebCommon::BodyCodec] the body codec for a write stream
    def self.pipe(*args)
      if args[0].class.method_defined?(:j_del) && !block_given? && args[1] == nil
        return ::Vertx::Util::Utils.safe_create(Java::IoVertxExtWebCodec::BodyCodec.java_method(:pipe, [Java::IoVertxCoreStreams::WriteStream.java_class]).call(args[0].j_del),::VertxWebCommon::BodyCodec, nil)
      elsif args[0].class.method_defined?(:j_del) && (args[1].class == TrueClass || args[1].class == FalseClass) && !block_given?
        return ::Vertx::Util::Utils.safe_create(Java::IoVertxExtWebCodec::BodyCodec.java_method(:pipe, [Java::IoVertxCoreStreams::WriteStream.java_class,Java::boolean.java_class]).call(args[0].j_del,args[1]),::VertxWebCommon::BodyCodec, nil)
      end
      if defined?(super)
        super
      else
        raise ArgumentError, "Invalid arguments when calling pipe(#{args[0]},#{args[1]})"
      end
    end
    # @overload none()
    # @return [::VertxWebCommon::BodyCodec] a codec that simply discards the response
    def self.none
      if !block_given?
        return ::Vertx::Util::Utils.safe_create(Java::IoVertxExtWebCodec::BodyCodec.java_method(:none, []).call(),::VertxWebCommon::BodyCodec, nil)
      end
      if defined?(super)
        super
      else
        raise ArgumentError, "Invalid arguments when calling none()"
      end
    end
    # @overload jsonObject()
    # @return [::VertxWebCommon::BodyCodec] the  codec
    def self.json_object
      if !block_given?
        return ::Vertx::Util::Utils.safe_create(Java::IoVertxExtWebCodec::BodyCodec.java_method(:jsonObject, []).call(),::VertxWebCommon::BodyCodec, nil)
      end
      if defined?(super)
        super
      else
        raise ArgumentError, "Invalid arguments when calling json_object()"
      end
    end
    # @overload buffer()
    # @return [::VertxWebCommon::BodyCodec] the  codec
    def self.buffer
      if !block_given?
        return ::Vertx::Util::Utils.safe_create(Java::IoVertxExtWebCodec::BodyCodec.java_method(:buffer, []).call(),::VertxWebCommon::BodyCodec,::Vertx::Buffer.j_api_type)
      end
      if defined?(super)
        super
      else
        raise ArgumentError, "Invalid arguments when calling buffer()"
      end
    end
    # @overload jsonArray()
    # @return [::VertxWebCommon::BodyCodec] the  codec
    def self.json_array
      if !block_given?
        return ::Vertx::Util::Utils.safe_create(Java::IoVertxExtWebCodec::BodyCodec.java_method(:jsonArray, []).call(),::VertxWebCommon::BodyCodec, nil)
      end
      if defined?(super)
        super
      else
        raise ArgumentError, "Invalid arguments when calling json_array()"
      end
    end
  end
end
