require 'vertx-web/routing_context'
require 'vertx/future'
require 'vertx/util/utils.rb'
# Generated from io.vertx.ext.web.handler.BodyHandler
module VertxWeb
  #  A handler which gathers the entire request body and sets it on the .
  #  <p>
  #  It also handles HTTP file uploads and can be used to limit body sizes.
  class BodyHandler
    # @private
    # @param j_del [::VertxWeb::BodyHandler] the java delegate
    def initialize(j_del)
      @j_del = j_del
    end
    # @private
    # @return [::VertxWeb::BodyHandler] the underlying java delegate
    def j_del
      @j_del
    end
    @@j_api_type = Object.new
    def @@j_api_type.accept?(obj)
      obj.class == BodyHandler
    end
    def @@j_api_type.wrap(obj)
      BodyHandler.new(obj)
    end
    def @@j_api_type.unwrap(obj)
      obj.j_del
    end
    def self.j_api_type
      @@j_api_type
    end
    def self.j_class
      Java::IoVertxExtWebHandler::BodyHandler.java_class
    end
    #  Set whether file uploads will be handled
    # @overload setHandleFileUploads(handleFileUploads)
    #   @param [true,false] handleFileUploads true if they should be handled
    # @return [self]
    def set_handle_file_uploads(*args)
      if (args[0].class == TrueClass || args[0].class == FalseClass) && !block_given?
        @j_del.java_method(:setHandleFileUploads, [Java::boolean.java_class]).call(args[0])
        return self
      end
      if defined?(super)
        super
      else
        raise ArgumentError, "Invalid arguments when calling set_handle_file_uploads(#{args[0]})"
      end
    end
    #  Set whether form attributes will be added to the request parameters
    # @overload setMergeFormAttributes(mergeFormAttributes)
    #   @param [true,false] mergeFormAttributes true if they should be merged
    # @return [self]
    def set_merge_form_attributes(*args)
      if (args[0].class == TrueClass || args[0].class == FalseClass) && !block_given?
        @j_del.java_method(:setMergeFormAttributes, [Java::boolean.java_class]).call(args[0])
        return self
      end
      if defined?(super)
        super
      else
        raise ArgumentError, "Invalid arguments when calling set_merge_form_attributes(#{args[0]})"
      end
    end
    #  Set the maximum body size -1 means unlimited
    # @overload setBodyLimit(bodyLimit)
    #   @param [Fixnum] bodyLimit the max size
    # @return [self]
    def set_body_limit(*args)
      if args[0].class == Fixnum && !block_given?
        @j_del.java_method(:setBodyLimit, [Java::long.java_class]).call(args[0])
        return self
      end
      if defined?(super)
        super
      else
        raise ArgumentError, "Invalid arguments when calling set_body_limit(#{args[0]})"
      end
    end
    #  Pre-allocate the body buffer according to the value parsed from content-length header.
    #  The buffer is capped at 64KB
    # @overload setPreallocateBodyBuffer(isPreallocateBodyBuffer)
    #   @param [true,false] isPreallocateBodyBuffer <code>true</code> if body buffer is pre-allocated according to the size read from content-length Header. {code false} if body buffer is pre-allocated to 1KB, and is resized dynamically
    # @return [self]
    def set_preallocate_body_buffer(*args)
      if (args[0].class == TrueClass || args[0].class == FalseClass) && !block_given?
        @j_del.java_method(:setPreallocateBodyBuffer, [Java::boolean.java_class]).call(args[0])
        return self
      end
      if defined?(super)
        super
      else
        raise ArgumentError, "Invalid arguments when calling set_preallocate_body_buffer(#{args[0]})"
      end
    end
    #  Set the uploads directory to use
    # @overload setUploadsDirectory(uploadsDirectory)
    #   @param [String] uploadsDirectory the uploads directory
    # @return [self]
    def set_uploads_directory(*args)
      if args[0].class == String && !block_given?
        @j_del.java_method(:setUploadsDirectory, [Java::java.lang.String.java_class]).call(args[0])
        return self
      end
      if defined?(super)
        super
      else
        raise ArgumentError, "Invalid arguments when calling set_uploads_directory(#{args[0]})"
      end
    end
    #  Create a body handler and use the given upload directory.
    # @overload create()
    # @overload create(handleFileUploads)
    #   @param [true,false] handleFileUploads true if files upload should be handled
    # @overload create(uploadDirectory)
    #   @param [String] uploadDirectory the uploads directory
    # @return [::VertxWeb::BodyHandler] the body handler
    def self.create(*args)
      if !block_given? && args[0] == nil
        return ::Vertx::Util::Utils.safe_create(Java::IoVertxExtWebHandler::BodyHandler.java_method(:create, []).call(),::VertxWeb::BodyHandler)
      elsif (args[0].class == TrueClass || args[0].class == FalseClass) && !block_given?
        return ::Vertx::Util::Utils.safe_create(Java::IoVertxExtWebHandler::BodyHandler.java_method(:create, [Java::boolean.java_class]).call(args[0]),::VertxWeb::BodyHandler)
      elsif args[0].class == String && !block_given?
        return ::Vertx::Util::Utils.safe_create(Java::IoVertxExtWebHandler::BodyHandler.java_method(:create, [Java::java.lang.String.java_class]).call(args[0]),::VertxWeb::BodyHandler)
      end
      if defined?(super)
        super
      else
        raise ArgumentError, "Invalid arguments when calling create(#{args[0]})"
      end
    end
    #  Something has happened, so handle it.
    # @overload handle(event)
    #   @param [::VertxWeb::RoutingContext] event the event to handle
    # @return [void]
    def handle(*args)
      if args[0].class.method_defined?(:j_del) && !block_given?
        return @j_del.java_method(:handle, [Java::IoVertxExtWeb::RoutingContext.java_class]).call(args[0].j_del)
      end
      if defined?(super)
        super
      else
        raise ArgumentError, "Invalid arguments when calling handle(#{args[0]})"
      end
    end
    #  Set whether uploaded files should be removed after handling the request
    # @overload setDeleteUploadedFilesOnEnd(deleteUploadedFilesOnEnd)
    #   @param [true,false] deleteUploadedFilesOnEnd true if uploaded files should be removed after handling the request
    # @return [self]
    def set_delete_uploaded_files_on_end(*args)
      if (args[0].class == TrueClass || args[0].class == FalseClass) && !block_given?
        @j_del.java_method(:setDeleteUploadedFilesOnEnd, [Java::boolean.java_class]).call(args[0])
        return self
      end
      if defined?(super)
        super
      else
        raise ArgumentError, "Invalid arguments when calling set_delete_uploaded_files_on_end(#{args[0]})"
      end
    end
    #  Default max size for a request body. -1 means unlimited
    def self.DEFAULT_BODY_LIMIT
      Java::IoVertxExtWebHandler::BodyHandler.DEFAULT_BODY_LIMIT
    end
    #  Default uploads directory on server for file uploads
    def self.DEFAULT_UPLOADS_DIRECTORY
      Java::IoVertxExtWebHandler::BodyHandler.DEFAULT_UPLOADS_DIRECTORY
    end
    #  Default value of whether form attributes should be merged into request params
    def self.DEFAULT_MERGE_FORM_ATTRIBUTES
      Java::IoVertxExtWebHandler::BodyHandler.DEFAULT_MERGE_FORM_ATTRIBUTES
    end
    #  Default value of whether uploaded files should be removed after handling the request
    def self.DEFAULT_DELETE_UPLOADED_FILES_ON_END
      Java::IoVertxExtWebHandler::BodyHandler.DEFAULT_DELETE_UPLOADED_FILES_ON_END
    end
    #  Default value of whether to pre-allocate the body buffer size according to the content-length HTTP request header
    def self.DEFAULT_PREALLOCATE_BODY_BUFFER
      Java::IoVertxExtWebHandler::BodyHandler.DEFAULT_PREALLOCATE_BODY_BUFFER
    end
  end
end
