require 'vertx-web/routing_context'
require 'vertx/future'
require 'vertx/util/utils.rb'
# Generated from io.vertx.ext.web.handler.CorsHandler
module VertxWeb
  #  A handler which implements server side http://www.w3.org/TR/cors/[CORS] support for Vert.x-Web.
  class CorsHandler
    # @private
    # @param j_del [::VertxWeb::CorsHandler] the java delegate
    def initialize(j_del)
      @j_del = j_del
    end
    # @private
    # @return [::VertxWeb::CorsHandler] the underlying java delegate
    def j_del
      @j_del
    end
    @@j_api_type = Object.new
    def @@j_api_type.accept?(obj)
      obj.class == CorsHandler
    end
    def @@j_api_type.wrap(obj)
      CorsHandler.new(obj)
    end
    def @@j_api_type.unwrap(obj)
      obj.j_del
    end
    def self.j_api_type
      @@j_api_type
    end
    def self.j_class
      Java::IoVertxExtWebHandler::CorsHandler.java_class
    end
    #  Add an allowed method
    # @overload allowedMethod(method)
    #   @param [:OPTIONS,:GET,:HEAD,:POST,:PUT,:DELETE,:TRACE,:CONNECT,:PATCH,:OTHER] method the method to add
    # @return [self]
    def allowed_method(*args)
      if args[0].class == Symbol && !block_given?
        @j_del.java_method(:allowedMethod, [Java::IoVertxCoreHttp::HttpMethod.java_class]).call(Java::IoVertxCoreHttp::HttpMethod.valueOf(args[0].to_s))
        return self
      end
      if defined?(super)
        super
      else
        raise ArgumentError, "Invalid arguments when calling allowed_method(#{args[0]})"
      end
    end
    #  Add a set of exposed headers
    # @overload exposedHeaders(headerNames)
    #   @param [Set<String>] headerNames the exposed header names
    # @return [self]
    def exposed_headers(*args)
      if args[0].class == Set && !block_given?
        @j_del.java_method(:exposedHeaders, [Java::JavaUtil::Set.java_class]).call(Java::JavaUtil::LinkedHashSet.new(args[0].map { |element| element }))
        return self
      end
      if defined?(super)
        super
      else
        raise ArgumentError, "Invalid arguments when calling exposed_headers(#{args[0]})"
      end
    end
    #  Add an exposed header
    # @overload exposedHeader(headerName)
    #   @param [String] headerName the exposed header name
    # @return [self]
    def exposed_header(*args)
      if args[0].class == String && !block_given?
        @j_del.java_method(:exposedHeader, [Java::java.lang.String.java_class]).call(args[0])
        return self
      end
      if defined?(super)
        super
      else
        raise ArgumentError, "Invalid arguments when calling exposed_header(#{args[0]})"
      end
    end
    #  Create a CORS handler
    # @overload create(allowedOriginPattern)
    #   @param [String] allowedOriginPattern the allowed origin pattern
    # @return [::VertxWeb::CorsHandler] the handler
    def self.create(*args)
      if args[0].class == String && !block_given?
        return ::Vertx::Util::Utils.safe_create(Java::IoVertxExtWebHandler::CorsHandler.java_method(:create, [Java::java.lang.String.java_class]).call(args[0]),::VertxWeb::CorsHandler)
      end
      if defined?(super)
        super
      else
        raise ArgumentError, "Invalid arguments when calling create(#{args[0]})"
      end
    end
    #  Add a set of allowed headers
    # @overload allowedHeaders(headerNames)
    #   @param [Set<String>] headerNames the allowed header names
    # @return [self]
    def allowed_headers(*args)
      if args[0].class == Set && !block_given?
        @j_del.java_method(:allowedHeaders, [Java::JavaUtil::Set.java_class]).call(Java::JavaUtil::LinkedHashSet.new(args[0].map { |element| element }))
        return self
      end
      if defined?(super)
        super
      else
        raise ArgumentError, "Invalid arguments when calling allowed_headers(#{args[0]})"
      end
    end
    #  Something has happened, so handle it.
    # @overload handle(event)
    #   @param [::VertxWeb::RoutingContext] event the event to handle
    # @return [void]
    def handle(*args)
      if args[0].class.method_defined?(:j_del) && !block_given?
        return @j_del.java_method(:handle, [Java::IoVertxExtWeb::RoutingContext.java_class]).call(args[0].j_del)
      end
      if defined?(super)
        super
      else
        raise ArgumentError, "Invalid arguments when calling handle(#{args[0]})"
      end
    end
    #  Add a set of  allowed methods
    # @overload allowedMethods(methods)
    #   @param [Set<:OPTIONS,:GET,:HEAD,:POST,:PUT,:DELETE,:TRACE,:CONNECT,:PATCH,:OTHER>] methods the methods to add
    # @return [self]
    def allowed_methods(*args)
      if args[0].class == Set && !block_given?
        @j_del.java_method(:allowedMethods, [Java::JavaUtil::Set.java_class]).call(Java::JavaUtil::LinkedHashSet.new(args[0].map { |element| Java::IoVertxCoreHttp::HttpMethod.valueOf(element.to_s) }))
        return self
      end
      if defined?(super)
        super
      else
        raise ArgumentError, "Invalid arguments when calling allowed_methods(#{args[0]})"
      end
    end
    #  Set how long the browser should cache the information
    # @overload maxAgeSeconds(maxAgeSeconds)
    #   @param [Fixnum] maxAgeSeconds max age in seconds
    # @return [self]
    def max_age_seconds(*args)
      if args[0].class == Fixnum && !block_given?
        @j_del.java_method(:maxAgeSeconds, [Java::int.java_class]).call(args[0])
        return self
      end
      if defined?(super)
        super
      else
        raise ArgumentError, "Invalid arguments when calling max_age_seconds(#{args[0]})"
      end
    end
    #  Add an allowed header
    # @overload allowedHeader(headerName)
    #   @param [String] headerName the allowed header name
    # @return [self]
    def allowed_header(*args)
      if args[0].class == String && !block_given?
        @j_del.java_method(:allowedHeader, [Java::java.lang.String.java_class]).call(args[0])
        return self
      end
      if defined?(super)
        super
      else
        raise ArgumentError, "Invalid arguments when calling allowed_header(#{args[0]})"
      end
    end
    #  Set whether credentials are allowed. Note that user agents will block
    #  requests that use a wildcard as origin and include credentials.
    # 
    #  From the MDN documentation you can read:
    # 
    #  <blockquote>
    #  Important note: when responding to a credentialed request,
    #  server must specify a domain, and cannot use wild carding.
    #  </blockquote>
    # @overload allowCredentials(allow)
    #   @param [true,false] allow true if allowed
    # @return [self]
    def allow_credentials(*args)
      if (args[0].class == TrueClass || args[0].class == FalseClass) && !block_given?
        @j_del.java_method(:allowCredentials, [Java::boolean.java_class]).call(args[0])
        return self
      end
      if defined?(super)
        super
      else
        raise ArgumentError, "Invalid arguments when calling allow_credentials(#{args[0]})"
      end
    end
  end
end
