require 'vertx-web/routing_context'
require 'vertx/future'
require 'vertx/util/utils.rb'
# Generated from io.vertx.ext.web.handler.ErrorHandler
module VertxWeb
  #  A pretty error handler for rendering error pages. When working in development mode
  #  exception details will be returned in the server responses, otherwise or when
  #  manually specified no exception details are returned in the HTTP response.
  # 
  #  The reason the display of the exception details is by default dependent of the mode
  #  is to follow the security best practices:
  #  <a href="https://www.owasp.org/index.php/Improper_Error_Handling">https://www.owasp.org/index.php/Improper_Error_Handling</a>
  class ErrorHandler
    # @private
    # @param j_del [::VertxWeb::ErrorHandler] the java delegate
    def initialize(j_del)
      @j_del = j_del
    end
    # @private
    # @return [::VertxWeb::ErrorHandler] the underlying java delegate
    def j_del
      @j_del
    end
    @@j_api_type = Object.new
    def @@j_api_type.accept?(obj)
      obj.class == ErrorHandler
    end
    def @@j_api_type.wrap(obj)
      ErrorHandler.new(obj)
    end
    def @@j_api_type.unwrap(obj)
      obj.j_del
    end
    def self.j_api_type
      @@j_api_type
    end
    def self.j_class
      Java::IoVertxExtWebHandler::ErrorHandler.java_class
    end
    #  Create an error handler
    # @overload create()
    # @overload create(displayExceptionDetails)
    #   @param [true,false] displayExceptionDetails true if exception details should be displayed
    # @overload create(errorTemplateName)
    #   @param [String] errorTemplateName the error template name - will be looked up from the classpath
    # @overload create(errorTemplateName,displayExceptionDetails)
    #   @param [String] errorTemplateName the error template name - will be looked up from the classpath
    #   @param [true,false] displayExceptionDetails true if exception details should be displayed
    # @return [::VertxWeb::ErrorHandler] the handler
    def self.create(*args)
      if !block_given? && args[0] == nil && args[1] == nil
        return ::Vertx::Util::Utils.safe_create(Java::IoVertxExtWebHandler::ErrorHandler.java_method(:create, []).call(),::VertxWeb::ErrorHandler)
      elsif (args[0].class == TrueClass || args[0].class == FalseClass) && !block_given? && args[1] == nil
        return ::Vertx::Util::Utils.safe_create(Java::IoVertxExtWebHandler::ErrorHandler.java_method(:create, [Java::boolean.java_class]).call(args[0]),::VertxWeb::ErrorHandler)
      elsif args[0].class == String && !block_given? && args[1] == nil
        return ::Vertx::Util::Utils.safe_create(Java::IoVertxExtWebHandler::ErrorHandler.java_method(:create, [Java::java.lang.String.java_class]).call(args[0]),::VertxWeb::ErrorHandler)
      elsif args[0].class == String && (args[1].class == TrueClass || args[1].class == FalseClass) && !block_given?
        return ::Vertx::Util::Utils.safe_create(Java::IoVertxExtWebHandler::ErrorHandler.java_method(:create, [Java::java.lang.String.java_class,Java::boolean.java_class]).call(args[0],args[1]),::VertxWeb::ErrorHandler)
      end
      if defined?(super)
        super
      else
        raise ArgumentError, "Invalid arguments when calling create(#{args[0]},#{args[1]})"
      end
    end
    #  Something has happened, so handle it.
    # @overload handle(event)
    #   @param [::VertxWeb::RoutingContext] event the event to handle
    # @return [void]
    def handle(*args)
      if args[0].class.method_defined?(:j_del) && !block_given?
        return @j_del.java_method(:handle, [Java::IoVertxExtWeb::RoutingContext.java_class]).call(args[0].j_del)
      end
      if defined?(super)
        super
      else
        raise ArgumentError, "Invalid arguments when calling handle(#{args[0]})"
      end
    end
    #  The default template to use for rendering
    def self.DEFAULT_ERROR_HANDLER_TEMPLATE
      Java::IoVertxExtWebHandler::ErrorHandler.DEFAULT_ERROR_HANDLER_TEMPLATE
    end
  end
end
