require 'vertx-web/routing_context'
require 'vertx-auth-common/authentication_provider'
require 'vertx-auth-common/auth_provider'
require 'vertx/future'
require 'vertx/util/utils.rb'
# Generated from io.vertx.ext.web.handler.FormLoginHandler
module VertxWeb
  #  Handler that handles login from a form on a custom login page.
  #  <p>
  #  Used in conjunction with the {::VertxWeb::RedirectAuthHandler}.
  class FormLoginHandler
    # @private
    # @param j_del [::VertxWeb::FormLoginHandler] the java delegate
    def initialize(j_del)
      @j_del = j_del
    end
    # @private
    # @return [::VertxWeb::FormLoginHandler] the underlying java delegate
    def j_del
      @j_del
    end
    @@j_api_type = Object.new
    def @@j_api_type.accept?(obj)
      obj.class == FormLoginHandler
    end
    def @@j_api_type.wrap(obj)
      FormLoginHandler.new(obj)
    end
    def @@j_api_type.unwrap(obj)
      obj.j_del
    end
    def self.j_api_type
      @@j_api_type
    end
    def self.j_class
      Java::IoVertxExtWebHandler::FormLoginHandler.java_class
    end
    #  Set the name of the form param used to submit the password
    # @overload setPasswordParam(passwordParam)
    #   @param [String] passwordParam the name of the param
    # @return [self]
    def set_password_param(*args)
      if args[0].class == String && !block_given?
        @j_del.java_method(:setPasswordParam, [Java::java.lang.String.java_class]).call(args[0])
        return self
      end
      if defined?(super)
        super
      else
        raise ArgumentError, "Invalid arguments when calling set_password_param(#{args[0]})"
      end
    end
    #  Set the name of the form param used to submit the username
    # @overload setUsernameParam(usernameParam)
    #   @param [String] usernameParam the name of the param
    # @return [self]
    def set_username_param(*args)
      if args[0].class == String && !block_given?
        @j_del.java_method(:setUsernameParam, [Java::java.lang.String.java_class]).call(args[0])
        return self
      end
      if defined?(super)
        super
      else
        raise ArgumentError, "Invalid arguments when calling set_username_param(#{args[0]})"
      end
    end
    #  Create a handler
    # @overload create(authProvider)
    #   @param [::VertxAuthCommon::AuthenticationProvider] authProvider the auth service to use
    # @overload create(authProvider,usernameParam,passwordParam,returnURLParam,directLoggedInOKURL)
    #   @param [::VertxAuthCommon::AuthProvider] authProvider the auth service to use
    #   @param [String] usernameParam the value of the form attribute which will contain the username
    #   @param [String] passwordParam the value of the form attribute which will contain the password
    #   @param [String] returnURLParam the value of the session attribute which will contain the return url
    #   @param [String] directLoggedInOKURL a url to redirect to if the user logs in directly at the url of the form login handler without being redirected here first
    # @return [::VertxWeb::FormLoginHandler] the handler
    def self.create(*args)
      if args[0].class.method_defined?(:j_del) && !block_given? && args[1] == nil && args[2] == nil && args[3] == nil && args[4] == nil
        return ::Vertx::Util::Utils.safe_create(Java::IoVertxExtWebHandler::FormLoginHandler.java_method(:create, [Java::IoVertxExtAuthAuthentication::AuthenticationProvider.java_class]).call(args[0].j_del),::VertxWeb::FormLoginHandler)
      elsif args[0].class.method_defined?(:j_del) && args[1].class == String && args[2].class == String && args[3].class == String && args[4].class == String && !block_given?
        return ::Vertx::Util::Utils.safe_create(Java::IoVertxExtWebHandler::FormLoginHandler.java_method(:create, [Java::IoVertxExtAuth::AuthProvider.java_class,Java::java.lang.String.java_class,Java::java.lang.String.java_class,Java::java.lang.String.java_class,Java::java.lang.String.java_class]).call(args[0].j_del,args[1],args[2],args[3],args[4]),::VertxWeb::FormLoginHandler)
      end
      if defined?(super)
        super
      else
        raise ArgumentError, "Invalid arguments when calling create(#{args[0]},#{args[1]},#{args[2]},#{args[3]},#{args[4]})"
      end
    end
    #  Something has happened, so handle it.
    # @overload handle(event)
    #   @param [::VertxWeb::RoutingContext] event the event to handle
    # @return [void]
    def handle(*args)
      if args[0].class.method_defined?(:j_del) && !block_given?
        return @j_del.java_method(:handle, [Java::IoVertxExtWeb::RoutingContext.java_class]).call(args[0].j_del)
      end
      if defined?(super)
        super
      else
        raise ArgumentError, "Invalid arguments when calling handle(#{args[0]})"
      end
    end
    #  Set the name of the session attrioute used to specify the return url
    # @overload setReturnURLParam(returnURLParam)
    #   @param [String] returnURLParam the name of the param
    # @return [self]
    def set_return_url_param(*args)
      if args[0].class == String && !block_given?
        @j_del.java_method(:setReturnURLParam, [Java::java.lang.String.java_class]).call(args[0])
        return self
      end
      if defined?(super)
        super
      else
        raise ArgumentError, "Invalid arguments when calling set_return_url_param(#{args[0]})"
      end
    end
    #  Set the url to redirect to if the user logs in directly at the url of the form login handler
    #  without being redirected here first
    # @overload setDirectLoggedInOKURL(directLoggedInOKURL)
    #   @param [String] directLoggedInOKURL the URL to redirect to
    # @return [self]
    def set_direct_logged_in_okurl(*args)
      if args[0].class == String && !block_given?
        @j_del.java_method(:setDirectLoggedInOKURL, [Java::java.lang.String.java_class]).call(args[0])
        return self
      end
      if defined?(super)
        super
      else
        raise ArgumentError, "Invalid arguments when calling set_direct_logged_in_okurl(#{args[0]})"
      end
    end
    #  The default value of the form attribute which will contain the username
    def self.DEFAULT_USERNAME_PARAM
      Java::IoVertxExtWebHandler::FormLoginHandler.DEFAULT_USERNAME_PARAM
    end
    #  The default value of the form attribute which will contain the password
    def self.DEFAULT_PASSWORD_PARAM
      Java::IoVertxExtWebHandler::FormLoginHandler.DEFAULT_PASSWORD_PARAM
    end
    #  The default value of the session attribute which will contain the return url
    def self.DEFAULT_RETURN_URL_PARAM
      Java::IoVertxExtWebHandler::FormLoginHandler.DEFAULT_RETURN_URL_PARAM
    end
  end
end
