require 'vertx-web/routing_context'
require 'vertx/future'
require 'vertx/util/utils.rb'
# Generated from io.vertx.ext.web.handler.LoggerHandler
module VertxWeb
  #  A handler which logs request information to the Vert.x logger.
  #  You should mount this handler before any handler that could fail the routing context
  class LoggerHandler
    # @private
    # @param j_del [::VertxWeb::LoggerHandler] the java delegate
    def initialize(j_del)
      @j_del = j_del
    end
    # @private
    # @return [::VertxWeb::LoggerHandler] the underlying java delegate
    def j_del
      @j_del
    end
    @@j_api_type = Object.new
    def @@j_api_type.accept?(obj)
      obj.class == LoggerHandler
    end
    def @@j_api_type.wrap(obj)
      LoggerHandler.new(obj)
    end
    def @@j_api_type.unwrap(obj)
      obj.j_del
    end
    def self.j_api_type
      @@j_api_type
    end
    def self.j_class
      Java::IoVertxExtWebHandler::LoggerHandler.java_class
    end
    #  Create a handler with he specified format
    # @overload create()
    # @overload create(format)
    #   @param [:DEFAULT,:SHORT,:TINY] format the format
    # @overload create(immediate,format)
    #   @param [true,false] immediate true if logging should occur as soon as request arrives
    #   @param [:DEFAULT,:SHORT,:TINY] format the format
    # @return [::VertxWeb::LoggerHandler] the handler
    def self.create(*args)
      if !block_given? && args[0] == nil && args[1] == nil
        return ::Vertx::Util::Utils.safe_create(Java::IoVertxExtWebHandler::LoggerHandler.java_method(:create, []).call(),::VertxWeb::LoggerHandler)
      elsif args[0].class == Symbol && !block_given? && args[1] == nil
        return ::Vertx::Util::Utils.safe_create(Java::IoVertxExtWebHandler::LoggerHandler.java_method(:create, [Java::IoVertxExtWebHandler::LoggerFormat.java_class]).call(Java::IoVertxExtWebHandler::LoggerFormat.valueOf(args[0].to_s)),::VertxWeb::LoggerHandler)
      elsif (args[0].class == TrueClass || args[0].class == FalseClass) && args[1].class == Symbol && !block_given?
        return ::Vertx::Util::Utils.safe_create(Java::IoVertxExtWebHandler::LoggerHandler.java_method(:create, [Java::boolean.java_class,Java::IoVertxExtWebHandler::LoggerFormat.java_class]).call(args[0],Java::IoVertxExtWebHandler::LoggerFormat.valueOf(args[1].to_s)),::VertxWeb::LoggerHandler)
      end
      if defined?(super)
        super
      else
        raise ArgumentError, "Invalid arguments when calling create(#{args[0]},#{args[1]})"
      end
    end
    #  Something has happened, so handle it.
    # @overload handle(event)
    #   @param [::VertxWeb::RoutingContext] event the event to handle
    # @return [void]
    def handle(*args)
      if args[0].class.method_defined?(:j_del) && !block_given?
        return @j_del.java_method(:handle, [Java::IoVertxExtWeb::RoutingContext.java_class]).call(args[0].j_del)
      end
      if defined?(super)
        super
      else
        raise ArgumentError, "Invalid arguments when calling handle(#{args[0]})"
      end
    end
    def self.DEFAULT_FORMAT
      Java::IoVertxExtWebHandler::LoggerHandler.DEFAULT_FORMAT.name.intern
    end
  end
end
