require 'vertx/future'
require 'vertx/util/utils.rb'
# Generated from io.vertx.ext.web.Session
module VertxWeb
  #  Represents a browser session.
  #  <p>
  #  Sessions persist between HTTP requests for a single browser session. They are deleted when the browser is closed, or
  #  they time-out. Session cookies are used to maintain sessions using a secure UUID.
  #  <p>
  #  Sessions can be used to maintain data for a browser session, e.g. a shopping basket.
  #  <p>
  #  The context must have first been routed to a {::VertxWeb::SessionHandler}
  #  for sessions to be available.
  class Session
    # @private
    # @param j_del [::VertxWeb::Session] the java delegate
    def initialize(j_del)
      @j_del = j_del
    end
    # @private
    # @return [::VertxWeb::Session] the underlying java delegate
    def j_del
      @j_del
    end
    @@j_api_type = Object.new
    def @@j_api_type.accept?(obj)
      obj.class == Session
    end
    def @@j_api_type.wrap(obj)
      Session.new(obj)
    end
    def @@j_api_type.unwrap(obj)
      obj.j_del
    end
    def self.j_api_type
      @@j_api_type
    end
    def self.j_class
      Java::IoVertxExtWeb::Session.java_class
    end
    #  Mark the session as being accessed.
    # @overload setAccessed()
    # @return [void]
    def set_accessed
      if !block_given?
        return @j_del.java_method(:setAccessed, []).call()
      end
      if defined?(super)
        super
      else
        raise ArgumentError, "Invalid arguments when calling set_accessed()"
      end
    end
    # @overload isDestroyed()
    # @return [true,false] has the session been destroyed?
    def destroyed?
      if !block_given?
        return @j_del.java_method(:isDestroyed, []).call()
      end
      if defined?(super)
        super
      else
        raise ArgumentError, "Invalid arguments when calling destroyed?()"
      end
    end
    # @overload isEmpty()
    # @return [true,false] true if the session has data
    def empty?
      if !block_given?
        return @j_del.java_method(:isEmpty, []).call()
      end
      if defined?(super)
        super
      else
        raise ArgumentError, "Invalid arguments when calling empty?()"
      end
    end
    #  Destroy the session
    # @overload destroy()
    # @return [void]
    def destroy
      if !block_given?
        return @j_del.java_method(:destroy, []).call()
      end
      if defined?(super)
        super
      else
        raise ArgumentError, "Invalid arguments when calling destroy()"
      end
    end
    # @overload oldId()
    # @return [String] old ID if renewed
    def old_id
      if !block_given?
        return @j_del.java_method(:oldId, []).call()
      end
      if defined?(super)
        super
      else
        raise ArgumentError, "Invalid arguments when calling old_id()"
      end
    end
    # @overload regenerateId()
    # @return [::VertxWeb::Session] The new unique ID of the session.
    def regenerate_id
      if !block_given?
        return ::Vertx::Util::Utils.safe_create(@j_del.java_method(:regenerateId, []).call(),::VertxWeb::Session)
      end
      if defined?(super)
        super
      else
        raise ArgumentError, "Invalid arguments when calling regenerate_id()"
      end
    end
    # @overload timeout()
    # @return [Fixnum] the amount of time in ms, after which the session will expire, if not accessed.
    def timeout
      if !block_given?
        return @j_del.java_method(:timeout, []).call()
      end
      if defined?(super)
        super
      else
        raise ArgumentError, "Invalid arguments when calling timeout()"
      end
    end
    #  Remove some data from the session
    # @overload remove(key)
    #   @param [String] key the key of the data
    # @return [Object] the data that was there or null if none there
    def remove(*args)
      if args[0].class == String && !block_given?
        return ::Vertx::Util::Utils.from_object(@j_del.java_method(:remove, [Java::java.lang.String.java_class]).call(args[0]))
      end
      if defined?(super)
        super
      else
        raise ArgumentError, "Invalid arguments when calling remove(#{args[0]})"
      end
    end
    #  Put some data in a session
    # @overload put(key,obj)
    #   @param [String] key the key for the data
    #   @param [Object] obj the data
    # @return [self]
    def put(*args)
      if args[0].class == String && ::Vertx::Util::unknown_type.accept?(args[1]) && !block_given?
        @j_del.java_method(:put, [Java::java.lang.String.java_class,Java::java.lang.Object.java_class]).call(args[0],::Vertx::Util::Utils.to_object(args[1]))
        return self
      end
      if defined?(super)
        super
      else
        raise ArgumentError, "Invalid arguments when calling put(#{args[0]},#{args[1]})"
      end
    end
    # @overload isRegenerated()
    # @return [true,false] has the session been renewed?
    def regenerated?
      if !block_given?
        return @j_del.java_method(:isRegenerated, []).call()
      end
      if defined?(super)
        super
      else
        raise ArgumentError, "Invalid arguments when calling regenerated?()"
      end
    end
    #  Get some data from the session
    # @overload get(key)
    #   @param [String] key the key of the data
    # @return [Object] the data
    def get(*args)
      if args[0].class == String && !block_given?
        return ::Vertx::Util::Utils.from_object(@j_del.java_method(:get, [Java::java.lang.String.java_class]).call(args[0]))
      end
      if defined?(super)
        super
      else
        raise ArgumentError, "Invalid arguments when calling get(#{args[0]})"
      end
    end
    # @overload lastAccessed()
    # @return [Fixnum] the time the session was last accessed
    def last_accessed
      if !block_given?
        return @j_del.java_method(:lastAccessed, []).call()
      end
      if defined?(super)
        super
      else
        raise ArgumentError, "Invalid arguments when calling last_accessed()"
      end
    end
    # @overload id()
    # @return [String] The unique ID of the session. This is generated using a random secure UUID.
    def id
      if !block_given?
        return @j_del.java_method(:id, []).call()
      end
      if defined?(super)
        super
      else
        raise ArgumentError, "Invalid arguments when calling id()"
      end
    end
    #  The short representation of the session to be added to the session cookie. By default is the session id.
    # @overload value()
    # @return [String] short representation string.
    def value
      if !block_given?
        return @j_del.java_method(:value, []).call()
      end
      if defined?(super)
        super
      else
        raise ArgumentError, "Invalid arguments when calling value()"
      end
    end
  end
end
