require 'vertx/pipe'
require 'vertx/buffer'
require 'vertx/write_stream'
require 'vertx/read_stream'
require 'vertx/future'
require 'vertx/future'
require 'vertx/util/utils.rb'
# Generated from io.vertx.core.file.AsyncFile
module Vertx
  #  Represents a file on the file-system which can be read from, or written to asynchronously.
  #  <p>
  #  This class also implements {::Vertx::ReadStream} and
  #  {::Vertx::WriteStream}. This allows the data to be pumped to and from
  #  other streams, e.g. an {::Vertx::HttpClientRequest} instance,
  #  using the {::Vertx::Pump} class
  class AsyncFile
    include ::Vertx::ReadStream
    include ::Vertx::WriteStream
    # @private
    # @param j_del [::Vertx::AsyncFile] the java delegate
    def initialize(j_del)
      @j_del = j_del
    end
    # @private
    # @return [::Vertx::AsyncFile] the underlying java delegate
    def j_del
      @j_del
    end
    @@j_api_type = Object.new
    def @@j_api_type.accept?(obj)
      obj.class == AsyncFile
    end
    def @@j_api_type.wrap(obj)
      AsyncFile.new(obj)
    end
    def @@j_api_type.unwrap(obj)
      obj.j_del
    end
    def self.j_api_type
      @@j_api_type
    end
    def self.j_class
      Java::IoVertxCoreFile::AsyncFile.java_class
    end
    #  Sets the buffer size that will be used to read the data from the file. Changing this value will impact how much
    #  the data will be read at a time from the file system.
    # @overload setReadBufferSize(readBufferSize)
    #   @param [Fixnum] readBufferSize the buffer size
    # @return [self]
    def set_read_buffer_size(*args)
      if args[0].class == Fixnum && !block_given?
        @j_del.java_method(:setReadBufferSize, [Java::int.java_class]).call(args[0])
        return self
      end
      if defined?(super)
        super
      else
        raise ArgumentError, "Invalid arguments when calling set_read_buffer_size(#{args[0]})"
      end
    end
    # @overload getWritePos()
    # @return [Fixnum] the current write position the file is at
    def get_write_pos
      if !block_given?
        return @j_del.java_method(:getWritePos, []).call()
      end
      if defined?(super)
        super
      else
        raise ArgumentError, "Invalid arguments when calling get_write_pos()"
      end
    end
    # @overload resume()
    # @return [self]
    def resume
      if !block_given?
        @j_del.java_method(:resume, []).call()
        return self
      end
      if defined?(super)
        super
      else
        raise ArgumentError, "Invalid arguments when calling resume()"
      end
    end
    # @overload handler(handler)
    #   @yield 
    # @return [self]
    def handler
      if true
        @j_del.java_method(:handler, [Java::IoVertxCore::Handler.java_class]).call((Proc.new { |event| yield(::Vertx::Util::Utils.safe_create(event,::Vertx::Buffer)) unless !block_given? }))
        return self
      end
      if defined?(super)
        super
      else
        raise ArgumentError, "Invalid arguments when calling handler()"
      end
    end
    #  Reads <code>length</code> bytes of data from the file at position <code>position</code> in the file, asynchronously.
    #  <p>
    #  The read data will be written into the specified <code>Buffer buffer</code> at position <code>offset</code>.
    #  <p>
    #  If data is read past the end of the file then zero bytes will be read.<p>
    #  When multiple reads are invoked on the same file there are no guarantees as to order in which those reads actually occur.
    #  <p>
    #  The handler will be called when the close is complete, or if an error occurs.
    # @overload read(buffer,offset,position,length,handler)
    #   @param [::Vertx::Buffer] buffer the buffer to read into
    #   @param [Fixnum] offset the offset into the buffer where the data will be read
    #   @param [Fixnum] position the position in the file where to start reading
    #   @param [Fixnum] length the number of bytes to read
    #   @yield the handler to call when the write is complete
    # @return [self]
    def read(*args)
      if args[0].class.method_defined?(:j_del) && args[1].class == Fixnum && args[2].class == Fixnum && args[3].class == Fixnum && true
        if (block_given?)
          @j_del.java_method(:read, [Java::IoVertxCoreBuffer::Buffer.java_class,Java::int.java_class,Java::long.java_class,Java::int.java_class,Java::IoVertxCore::Handler.java_class]).call(args[0].j_del,args[1],args[2],args[3],block_given? ? Proc.new { |ar| yield(ar.failed ? ar.cause : nil, ar.succeeded ? ::Vertx::Util::Utils.safe_create(ar.result,::Vertx::Buffer) : nil) } : promise)
          return self
        else
          promise = ::Vertx::Util::Utils.promise
          @j_del.java_method(:read, [Java::IoVertxCoreBuffer::Buffer.java_class,Java::int.java_class,Java::long.java_class,Java::int.java_class,Java::IoVertxCore::Handler.java_class]).call(args[0].j_del,args[1],args[2],args[3],block_given? ? Proc.new { |ar| yield(ar.failed ? ar.cause : nil, ar.succeeded ? ::Vertx::Util::Utils.safe_create(ar.result,::Vertx::Buffer) : nil) } : promise)
          return ::Vertx::Util::Utils.safe_create(promise.future(),::Vertx::Future,::Vertx::Buffer.j_api_type)
        end
      end
      if defined?(super)
        super
      else
        raise ArgumentError, "Invalid arguments when calling read(#{args[0]},#{args[1]},#{args[2]},#{args[3]})"
      end
    end
    #  This will return <code>true</code> if there are more bytes in the write queue than the value set using {::Vertx::AsyncFile#set_write_queue_max_size}
    # @overload writeQueueFull()
    # @return [true,false] true if write queue is full
    def write_queue_full?
      if !block_given?
        return @j_del.java_method(:writeQueueFull, []).call()
      end
      if defined?(super)
        super
      else
        raise ArgumentError, "Invalid arguments when calling write_queue_full?()"
      end
    end
    # @overload setWriteQueueMaxSize(maxSize)
    #   @param [Fixnum] maxSize 
    # @return [self]
    def set_write_queue_max_size(*args)
      if args[0].class == Fixnum && !block_given?
        @j_del.java_method(:setWriteQueueMaxSize, [Java::int.java_class]).call(args[0])
        return self
      end
      if defined?(super)
        super
      else
        raise ArgumentError, "Invalid arguments when calling set_write_queue_max_size(#{args[0]})"
      end
    end
    # @overload pause()
    # @return [self]
    def pause
      if !block_given?
        @j_del.java_method(:pause, []).call()
        return self
      end
      if defined?(super)
        super
      else
        raise ArgumentError, "Invalid arguments when calling pause()"
      end
    end
    #  Sets the number of bytes that will be read when using the file as a {::Vertx::ReadStream}.
    # @overload setReadLength(readLength)
    #   @param [Fixnum] readLength the bytes that will be read from the file
    # @return [self]
    def set_read_length(*args)
      if args[0].class == Fixnum && !block_given?
        @j_del.java_method(:setReadLength, [Java::long.java_class]).call(args[0])
        return self
      end
      if defined?(super)
        super
      else
        raise ArgumentError, "Invalid arguments when calling set_read_length(#{args[0]})"
      end
    end
    #  Pipe this <code>ReadStream</code> to the <code>WriteStream</code>.
    #  <p>
    #  Elements emitted by this stream will be written to the write stream until this stream ends or fails.
    #  <p>
    #  Once this stream has ended or failed, the write stream will be ended and the <code>handler</code> will be
    #  called with the result.
    # @overload pipeTo(dst,handler)
    #   @param [::Vertx::WriteStream] dst the destination write stream
    #   @yield 
    # @return [void]
    def pipe_to(*args)
      if args[0].class.method_defined?(:j_del) && true
        if (block_given?)
          return @j_del.java_method(:pipeTo, [Java::IoVertxCoreStreams::WriteStream.java_class,Java::IoVertxCore::Handler.java_class]).call(args[0].j_del,block_given? ? Proc.new { |ar| yield(ar.failed ? ar.cause : nil, ar.succeeded ? nil : nil) } : promise)
        else
          promise = ::Vertx::Util::Utils.promise
          @j_del.java_method(:pipeTo, [Java::IoVertxCoreStreams::WriteStream.java_class,Java::IoVertxCore::Handler.java_class]).call(args[0].j_del,block_given? ? Proc.new { |ar| yield(ar.failed ? ar.cause : nil, ar.succeeded ? nil : nil) } : promise)
          return ::Vertx::Util::Utils.safe_create(promise.future(),::Vertx::Future, nil)
        end
      end
      if defined?(super)
        super
      else
        raise ArgumentError, "Invalid arguments when calling pipe_to(#{args[0]})"
      end
    end
    #  Sets the position from which data will be written when using the file as a {::Vertx::WriteStream}.
    # @overload setWritePos(writePos)
    #   @param [Fixnum] writePos the position in the file
    # @return [self]
    def set_write_pos(*args)
      if args[0].class == Fixnum && !block_given?
        @j_del.java_method(:setWritePos, [Java::long.java_class]).call(args[0])
        return self
      end
      if defined?(super)
        super
      else
        raise ArgumentError, "Invalid arguments when calling set_write_pos(#{args[0]})"
      end
    end
    #  Same as {::Vertx::AsyncFile#flush} but the handler will be called when the flush is complete or if an error occurs
    # @overload flush(handler)
    #   @yield 
    # @return [self]
    def flush
      if true
        if (block_given?)
          @j_del.java_method(:flush, [Java::IoVertxCore::Handler.java_class]).call(block_given? ? Proc.new { |ar| yield(ar.failed ? ar.cause : nil, ar.succeeded ? nil : nil) } : promise)
          return self
        else
          promise = ::Vertx::Util::Utils.promise
          @j_del.java_method(:flush, [Java::IoVertxCore::Handler.java_class]).call(block_given? ? Proc.new { |ar| yield(ar.failed ? ar.cause : nil, ar.succeeded ? nil : nil) } : promise)
          return ::Vertx::Util::Utils.safe_create(promise.future(),::Vertx::Future, nil)
        end
      end
      if defined?(super)
        super
      else
        raise ArgumentError, "Invalid arguments when calling flush()"
      end
    end
    # @overload drainHandler(handler)
    #   @yield 
    # @return [self]
    def drain_handler
      if true
        @j_del.java_method(:drainHandler, [Java::IoVertxCore::Handler.java_class]).call((Proc.new { |event| yield(nil) unless !block_given? }))
        return self
      end
      if defined?(super)
        super
      else
        raise ArgumentError, "Invalid arguments when calling drain_handler()"
      end
    end
    # @overload endHandler(endHandler)
    #   @yield 
    # @return [self]
    def end_handler
      if true
        @j_del.java_method(:endHandler, [Java::IoVertxCore::Handler.java_class]).call((Proc.new { |event| yield(nil) unless !block_given? }))
        return self
      end
      if defined?(super)
        super
      else
        raise ArgumentError, "Invalid arguments when calling end_handler()"
      end
    end
    # @overload fetch(amount)
    #   @param [Fixnum] amount 
    # @return [self]
    def fetch(*args)
      if args[0].class == Fixnum && !block_given?
        @j_del.java_method(:fetch, [Java::long.java_class]).call(args[0])
        return self
      end
      if defined?(super)
        super
      else
        raise ArgumentError, "Invalid arguments when calling fetch(#{args[0]})"
      end
    end
    #  Pause this stream and return a  to transfer the elements of this stream to a destination .
    #  <p/>
    #  The stream will be resumed when the pipe will be wired to a <code>WriteStream</code>.
    # @overload pipe()
    # @return [::Vertx::Pipe] a pipe
    def pipe
      if !block_given?
        return ::Vertx::Util::Utils.safe_create(@j_del.java_method(:pipe, []).call(),::Vertx::Pipe,::Vertx::Buffer.j_api_type)
      end
      if defined?(super)
        super
      else
        raise ArgumentError, "Invalid arguments when calling pipe()"
      end
    end
    #  Same as  but with an <code>handler</code> called when the operation completes
    # @overload end(handler)
    #   @yield 
    # @overload end(data,handler)
    #   @param [::Vertx::Buffer] data 
    #   @yield 
    # @return [void]
    def end(*args)
      if true && args[0] == nil
        if (block_given?)
          return @j_del.java_method(:end, [Java::IoVertxCore::Handler.java_class]).call(block_given? ? Proc.new { |ar| yield(ar.failed ? ar.cause : nil, ar.succeeded ? nil : nil) } : promise)
        else
          promise = ::Vertx::Util::Utils.promise
          @j_del.java_method(:end, [Java::IoVertxCore::Handler.java_class]).call(block_given? ? Proc.new { |ar| yield(ar.failed ? ar.cause : nil, ar.succeeded ? nil : nil) } : promise)
          return ::Vertx::Util::Utils.safe_create(promise.future(),::Vertx::Future, nil)
        end
      elsif args[0].class.method_defined?(:j_del) && true
        if (block_given?)
          return @j_del.java_method(:end, [Java::IoVertxCoreBuffer::Buffer.java_class,Java::IoVertxCore::Handler.java_class]).call(args[0].j_del,block_given? ? Proc.new { |ar| yield(ar.failed ? ar.cause : nil, ar.succeeded ? nil : nil) } : promise)
        else
          promise = ::Vertx::Util::Utils.promise
          @j_del.java_method(:end, [Java::IoVertxCoreBuffer::Buffer.java_class,Java::IoVertxCore::Handler.java_class]).call(args[0].j_del,block_given? ? Proc.new { |ar| yield(ar.failed ? ar.cause : nil, ar.succeeded ? nil : nil) } : promise)
          return ::Vertx::Util::Utils.safe_create(promise.future(),::Vertx::Future, nil)
        end
      end
      if defined?(super)
        super
      else
        raise ArgumentError, "Invalid arguments when calling end(#{args[0]})"
      end
    end
    # @overload getReadLength()
    # @return [Fixnum] the number of bytes that will be read when using the file as a {::Vertx::ReadStream}
    def get_read_length
      if !block_given?
        return @j_del.java_method(:getReadLength, []).call()
      end
      if defined?(super)
        super
      else
        raise ArgumentError, "Invalid arguments when calling get_read_length()"
      end
    end
    #  Close the file. The actual close happens asynchronously.
    #  The handler will be called when the close is complete, or an error occurs.
    # @overload close(handler)
    #   @yield the handler
    # @return [void]
    def close
      if true
        if (block_given?)
          return @j_del.java_method(:close, [Java::IoVertxCore::Handler.java_class]).call(block_given? ? Proc.new { |ar| yield(ar.failed ? ar.cause : nil, ar.succeeded ? nil : nil) } : promise)
        else
          promise = ::Vertx::Util::Utils.promise
          @j_del.java_method(:close, [Java::IoVertxCore::Handler.java_class]).call(block_given? ? Proc.new { |ar| yield(ar.failed ? ar.cause : nil, ar.succeeded ? nil : nil) } : promise)
          return ::Vertx::Util::Utils.safe_create(promise.future(),::Vertx::Future, nil)
        end
      end
      if defined?(super)
        super
      else
        raise ArgumentError, "Invalid arguments when calling close()"
      end
    end
    # @overload exceptionHandler(handler)
    #   @yield 
    # @return [self]
    def exception_handler
      if true
        @j_del.java_method(:exceptionHandler, [Java::IoVertxCore::Handler.java_class]).call((Proc.new { |event| yield(::Vertx::Util::Utils.from_throwable(event)) unless !block_given? }))
        return self
      end
      if defined?(super)
        super
      else
        raise ArgumentError, "Invalid arguments when calling exception_handler()"
      end
    end
    #  Write a {::Vertx::Buffer} to the file at position <code>position</code> in the file, asynchronously.
    #  <p>
    #  If <code>position</code> lies outside of the current size
    #  of the file, the file will be enlarged to encompass it.
    #  <p>
    #  When multiple writes are invoked on the same file
    #  there are no guarantees as to order in which those writes actually occur
    #  <p>
    #  The handler will be called when the write is complete, or if an error occurs.
    # @overload write(data,handler)
    #   @param [::Vertx::Buffer] data 
    #   @yield 
    # @overload write(buffer,position,handler)
    #   @param [::Vertx::Buffer] buffer the buffer to write
    #   @param [Fixnum] position the position in the file to write it at
    #   @yield the handler to call when the write is complete
    # @return [void]
    def write(*args)
      if args[0].class.method_defined?(:j_del) && true && args[1] == nil
        if (block_given?)
          return @j_del.java_method(:write, [Java::IoVertxCoreBuffer::Buffer.java_class,Java::IoVertxCore::Handler.java_class]).call(args[0].j_del,block_given? ? Proc.new { |ar| yield(ar.failed ? ar.cause : nil, ar.succeeded ? nil : nil) } : promise)
        else
          promise = ::Vertx::Util::Utils.promise
          @j_del.java_method(:write, [Java::IoVertxCoreBuffer::Buffer.java_class,Java::IoVertxCore::Handler.java_class]).call(args[0].j_del,block_given? ? Proc.new { |ar| yield(ar.failed ? ar.cause : nil, ar.succeeded ? nil : nil) } : promise)
          return ::Vertx::Util::Utils.safe_create(promise.future(),::Vertx::Future, nil)
        end
      elsif args[0].class.method_defined?(:j_del) && args[1].class == Fixnum && true
        if (block_given?)
          return @j_del.java_method(:write, [Java::IoVertxCoreBuffer::Buffer.java_class,Java::long.java_class,Java::IoVertxCore::Handler.java_class]).call(args[0].j_del,args[1],block_given? ? Proc.new { |ar| yield(ar.failed ? ar.cause : nil, ar.succeeded ? nil : nil) } : promise)
        else
          promise = ::Vertx::Util::Utils.promise
          @j_del.java_method(:write, [Java::IoVertxCoreBuffer::Buffer.java_class,Java::long.java_class,Java::IoVertxCore::Handler.java_class]).call(args[0].j_del,args[1],block_given? ? Proc.new { |ar| yield(ar.failed ? ar.cause : nil, ar.succeeded ? nil : nil) } : promise)
          return ::Vertx::Util::Utils.safe_create(promise.future(),::Vertx::Future, nil)
        end
      end
      if defined?(super)
        super
      else
        raise ArgumentError, "Invalid arguments when calling write(#{args[0]},#{args[1]})"
      end
    end
    #  Sets the position from which data will be read from when using the file as a {::Vertx::ReadStream}.
    # @overload setReadPos(readPos)
    #   @param [Fixnum] readPos the position in the file
    # @return [self]
    def set_read_pos(*args)
      if args[0].class == Fixnum && !block_given?
        @j_del.java_method(:setReadPos, [Java::long.java_class]).call(args[0])
        return self
      end
      if defined?(super)
        super
      else
        raise ArgumentError, "Invalid arguments when calling set_read_pos(#{args[0]})"
      end
    end
  end
end
