require 'vertx/cli'
require 'vertx/future'
require 'vertx/util/utils.rb'
# Generated from io.vertx.core.cli.CommandLine
module Vertx
  #  The parser transforms a CLI (a model) into an {::Vertx::CommandLine}. This {::Vertx::CommandLine}
  #  has stored the argument and option values. Only  instance of parser should create
  #  objects of this type.
  class CommandLine
    # @private
    # @param j_del [::Vertx::CommandLine] the java delegate
    def initialize(j_del)
      @j_del = j_del
    end
    # @private
    # @return [::Vertx::CommandLine] the underlying java delegate
    def j_del
      @j_del
    end
    @@j_api_type = Object.new
    def @@j_api_type.accept?(obj)
      obj.class == CommandLine
    end
    def @@j_api_type.wrap(obj)
      CommandLine.new(obj)
    end
    def @@j_api_type.unwrap(obj)
      obj.j_del
    end
    def self.j_api_type
      @@j_api_type
    end
    def self.j_class
      Java::IoVertxCoreCli::CommandLine.java_class
    end
    #  Gets the raw values of the given argument. Raw values are simple "String", not converted to the argument type.
    # @overload getRawValuesForArgument(argument)
    #   @param [Hash{String => Object}] argument the argument
    # @return [Array<String>] the list of values, empty if none
    def get_raw_values_for_argument(*args)
      if args[0].class == Hash && !block_given?
        return @j_del.java_method(:getRawValuesForArgument, [Java::IoVertxCoreCli::Argument.java_class]).call(Java::IoVertxCoreCli::Argument.new(::Vertx::Util::Utils.to_json_object(args[0]))).to_a.map { |elt| elt }
      end
      if defined?(super)
        super
      else
        raise ArgumentError, "Invalid arguments when calling get_raw_values_for_argument(#{args[0]})"
      end
    end
    # @overload cli()
    # @return [::Vertx::CLI] the model of this command line object.
    def cli
      if !block_given?
        return ::Vertx::Util::Utils.safe_create(@j_del.java_method(:cli, []).call(),::Vertx::CLI)
      end
      if defined?(super)
        super
      else
        raise ArgumentError, "Invalid arguments when calling cli()"
      end
    end
    #  Gets the value of an argument with the given index.
    # @overload getArgumentValue(name)
    #   @param [String] name the name
    # @overload getArgumentValue(index)
    #   @param [Fixnum] index the index
    # @return [Object] the value, <code>null</code> if not set
    def get_argument_value(*args)
      if args[0].class == String && !block_given?
        return ::Vertx::Util::Utils.from_object(@j_del.java_method(:getArgumentValue, [Java::java.lang.String.java_class]).call(args[0]))
      elsif args[0].class == Fixnum && !block_given?
        return ::Vertx::Util::Utils.from_object(@j_del.java_method(:getArgumentValue, [Java::int.java_class]).call(args[0]))
      end
      if defined?(super)
        super
      else
        raise ArgumentError, "Invalid arguments when calling get_argument_value(#{args[0]})"
      end
    end
    #  Checks whether or not the command line is valid, i.e. all constraints from arguments and options have been
    #  satisfied. This method is used when the parser validation is disabled.
    # @overload isValid()
    # @return [true,false] <code>true</code> if the current {::Vertx::CommandLine} object is valid.  otherwise.
    def valid?
      if !block_given?
        return @j_del.java_method(:isValid, []).call()
      end
      if defined?(super)
        super
      else
        raise ArgumentError, "Invalid arguments when calling valid?()"
      end
    end
    #  Checks whether or not the given option accept more values.
    # @overload acceptMoreValues(option)
    #   @param [Hash{String => Object}] option the option
    # @return [true,false]  if the option accepts more values,  otherwise.
    def accept_more_values?(*args)
      if args[0].class == Hash && !block_given?
        return @j_del.java_method(:acceptMoreValues, [Java::IoVertxCoreCli::Option.java_class]).call(Java::IoVertxCoreCli::Option.new(::Vertx::Util::Utils.to_json_object(args[0])))
      end
      if defined?(super)
        super
      else
        raise ArgumentError, "Invalid arguments when calling accept_more_values?(#{args[0]})"
      end
    end
    #  Gets the raw value of the given argument. Raw values are the values as given in the user command line.
    # @overload getRawValueForArgument(arg)
    #   @param [Hash{String => Object}] arg the argument
    # @return [String] the value, <code>null</code> if none.
    def get_raw_value_for_argument(*args)
      if args[0].class == Hash && !block_given?
        return @j_del.java_method(:getRawValueForArgument, [Java::IoVertxCoreCli::Argument.java_class]).call(Java::IoVertxCoreCli::Argument.new(::Vertx::Util::Utils.to_json_object(args[0])))
      end
      if defined?(super)
        super
      else
        raise ArgumentError, "Invalid arguments when calling get_raw_value_for_argument(#{args[0]})"
      end
    end
    #  Checks whether or not the given argument has been assigned in the command line.
    # @overload isArgumentAssigned(arg)
    #   @param [Hash{String => Object}] arg the argument
    # @return [true,false] <code>true</code> if the argument has received a value,  otherwise.
    def argument_assigned?(*args)
      if args[0].class == Hash && !block_given?
        return @j_del.java_method(:isArgumentAssigned, [Java::IoVertxCoreCli::Argument.java_class]).call(Java::IoVertxCoreCli::Argument.new(::Vertx::Util::Utils.to_json_object(args[0])))
      end
      if defined?(super)
        super
      else
        raise ArgumentError, "Invalid arguments when calling argument_assigned?(#{args[0]})"
      end
    end
    #  Checks whether or not the given option has been assigned in the command line.
    # @overload isOptionAssigned(option)
    #   @param [Hash{String => Object}] option the option
    # @return [true,false] <code>true</code> if the option has received a value,  otherwise.
    def option_assigned?(*args)
      if args[0].class == Hash && !block_given?
        return @j_del.java_method(:isOptionAssigned, [Java::IoVertxCoreCli::Option.java_class]).call(Java::IoVertxCoreCli::Option.new(::Vertx::Util::Utils.to_json_object(args[0])))
      end
      if defined?(super)
        super
      else
        raise ArgumentError, "Invalid arguments when calling option_assigned?(#{args[0]})"
      end
    end
    # @overload allArguments()
    # @return [Array<String>] the ordered list of arguments. Arguments are command line arguments not matching an option.
    def all_arguments
      if !block_given?
        return @j_del.java_method(:allArguments, []).call().to_a.map { |elt| elt }
      end
      if defined?(super)
        super
      else
        raise ArgumentError, "Invalid arguments when calling all_arguments()"
      end
    end
    #  Gets the raw values of the given option. Raw values are simple "String", not converted to the option type.
    # @overload getRawValuesForOption(option)
    #   @param [Hash{String => Object}] option the option
    # @return [Array<String>] the list of values, empty if none
    def get_raw_values_for_option(*args)
      if args[0].class == Hash && !block_given?
        return @j_del.java_method(:getRawValuesForOption, [Java::IoVertxCoreCli::Option.java_class]).call(Java::IoVertxCoreCli::Option.new(::Vertx::Util::Utils.to_json_object(args[0]))).to_a.map { |elt| elt }
      end
      if defined?(super)
        super
      else
        raise ArgumentError, "Invalid arguments when calling get_raw_values_for_option(#{args[0]})"
      end
    end
    #  Checks whether or not the given option has been seen in the user command line.
    # @overload isSeenInCommandLine(option)
    #   @param [Hash{String => Object}] option the option
    # @return [true,false] <code>true</code> if the user command line has used the option
    def seen_in_command_line?(*args)
      if args[0].class == Hash && !block_given?
        return @j_del.java_method(:isSeenInCommandLine, [Java::IoVertxCoreCli::Option.java_class]).call(Java::IoVertxCoreCli::Option.new(::Vertx::Util::Utils.to_json_object(args[0])))
      end
      if defined?(super)
        super
      else
        raise ArgumentError, "Invalid arguments when calling seen_in_command_line?(#{args[0]})"
      end
    end
    #  Gets the value of an option marked as a flag.
    #  <p/>
    #  Calling this method an a non-flag option throws an IllegalStateException.
    # @overload isFlagEnabled(name)
    #   @param [String] name the option name
    # @return [true,false] <code>true</code> if the flag has been set in the command line, <code>false</code> otherwise.
    def flag_enabled?(*args)
      if args[0].class == String && !block_given?
        return @j_del.java_method(:isFlagEnabled, [Java::java.lang.String.java_class]).call(args[0])
      end
      if defined?(super)
        super
      else
        raise ArgumentError, "Invalid arguments when calling flag_enabled?(#{args[0]})"
      end
    end
    #  Gets the value of an option with the matching name (can be the long name, short name or arg name).
    # @overload getOptionValue(name)
    #   @param [String] name the name
    # @return [Object] the value, <code>null</code> if not set
    def get_option_value(*args)
      if args[0].class == String && !block_given?
        return ::Vertx::Util::Utils.from_object(@j_del.java_method(:getOptionValue, [Java::java.lang.String.java_class]).call(args[0]))
      end
      if defined?(super)
        super
      else
        raise ArgumentError, "Invalid arguments when calling get_option_value(#{args[0]})"
      end
    end
    #  Checks whether or not the user has passed a "help" option and is asking for help.
    # @overload isAskingForHelp()
    # @return [true,false] <code>true</code> if the user command line has enabled a "Help" option,  otherwise.
    def asking_for_help?
      if !block_given?
        return @j_del.java_method(:isAskingForHelp, []).call()
      end
      if defined?(super)
        super
      else
        raise ArgumentError, "Invalid arguments when calling asking_for_help?()"
      end
    end
    #  Creates a command line object from the {::Vertx::CLI}. This object is intended to be used by
    #  the parser to set the argument and option values.
    # @overload create(cli)
    #   @param [::Vertx::CLI] cli the CLI definition
    # @return [::Vertx::CommandLine] the command line object
    def self.create(*args)
      if args[0].class.method_defined?(:j_del) && !block_given?
        return ::Vertx::Util::Utils.safe_create(Java::IoVertxCoreCli::CommandLine.java_method(:create, [Java::IoVertxCoreCli::CLI.java_class]).call(args[0].j_del),::Vertx::CommandLine)
      end
      if defined?(super)
        super
      else
        raise ArgumentError, "Invalid arguments when calling create(#{args[0]})"
      end
    end
    #  Gets the raw value of the given option. Raw values are the values as given in the user command line.
    # @overload getRawValueForOption(option)
    #   @param [Hash{String => Object}] option the option
    # @return [String] the value, <code>null</code> if none.
    def get_raw_value_for_option(*args)
      if args[0].class == Hash && !block_given?
        return @j_del.java_method(:getRawValueForOption, [Java::IoVertxCoreCli::Option.java_class]).call(Java::IoVertxCoreCli::Option.new(::Vertx::Util::Utils.to_json_object(args[0])))
      end
      if defined?(super)
        super
      else
        raise ArgumentError, "Invalid arguments when calling get_raw_value_for_option(#{args[0]})"
      end
    end
    #  Gets the raw values of the given option. Raw values are simple "String", not converted to the option type.
    # @overload getRawValues(option)
    #   @param [Hash{String => Object}] option the option
    # @return [Array<String>] the list of values, empty if none
    def get_raw_values(*args)
      if args[0].class == Hash && !block_given?
        return @j_del.java_method(:getRawValues, [Java::IoVertxCoreCli::Option.java_class]).call(Java::IoVertxCoreCli::Option.new(::Vertx::Util::Utils.to_json_object(args[0]))).to_a.map { |elt| elt }
      end
      if defined?(super)
        super
      else
        raise ArgumentError, "Invalid arguments when calling get_raw_values(#{args[0]})"
      end
    end
  end
end
