require 'vertx/delivery_context'
require 'vertx/measured'
require 'vertx/message'
require 'vertx/message_consumer'
require 'vertx/future'
require 'vertx/message_producer'
require 'vertx/future'
require 'vertx/util/utils.rb'
# Generated from io.vertx.core.eventbus.EventBus
module Vertx
  #  A Vert.x event-bus is a light-weight distributed messaging system which allows different parts of your application,
  #  or different applications and services to communicate with each in a loosely coupled way.
  #  <p>
  #  An event-bus supports publish-subscribe messaging, point-to-point messaging and request-response messaging.
  #  <p>
  #  Message delivery is best-effort and messages can be lost if failure of all or part of the event bus occurs.
  #  <p>
  #  Please refer to the documentation for more information on the event bus.
  class EventBus
    include ::Vertx::Measured
    # @private
    # @param j_del [::Vertx::EventBus] the java delegate
    def initialize(j_del)
      @j_del = j_del
    end
    # @private
    # @return [::Vertx::EventBus] the underlying java delegate
    def j_del
      @j_del
    end
    @@j_api_type = Object.new
    def @@j_api_type.accept?(obj)
      obj.class == EventBus
    end
    def @@j_api_type.wrap(obj)
      EventBus.new(obj)
    end
    def @@j_api_type.unwrap(obj)
      obj.j_del
    end
    def self.j_api_type
      @@j_api_type
    end
    def self.j_class
      Java::IoVertxCoreEventbus::EventBus.java_class
    end
    #  Whether the metrics are enabled for this measured object
    # @overload isMetricsEnabled()
    # @return [true,false] <code>true</code> if metrics are enabled
    def metrics_enabled?
      if !block_given?
        return @j_del.java_method(:isMetricsEnabled, []).call()
      end
      if defined?(super)
        super
      else
        raise ArgumentError, "Invalid arguments when calling metrics_enabled?()"
      end
    end
    #  Like  but specifying <code>options</code> that can be used to configure the delivery.
    # @overload request(address,message,replyHandler)
    #   @param [String] address the address to send it to
    #   @param [Object] message the message body, may be <code>null</code>
    #   @yield reply handler will be called when any reply from the recipient is received
    # @overload request(address,message,options,replyHandler)
    #   @param [String] address the address to send it to
    #   @param [Object] message the message body, may be <code>null</code>
    #   @param [Hash{String => Object}] options delivery options
    #   @yield reply handler will be called when any reply from the recipient is received
    # @return [self]
    def request(*args)
      if args[0].class == String && ::Vertx::Util::unknown_type.accept?(args[1]) && true && args[2] == nil
        if (block_given?)
          @j_del.java_method(:request, [Java::java.lang.String.java_class,Java::java.lang.Object.java_class,Java::IoVertxCore::Handler.java_class]).call(args[0],::Vertx::Util::Utils.to_object(args[1]),block_given? ? Proc.new { |ar| yield(ar.failed ? ar.cause : nil, ar.succeeded ? ::Vertx::Util::Utils.safe_create(ar.result,::Vertx::Message, nil) : nil) } : promise)
          return self
        else
          promise = ::Vertx::Util::Utils.promise
          @j_del.java_method(:request, [Java::java.lang.String.java_class,Java::java.lang.Object.java_class,Java::IoVertxCore::Handler.java_class]).call(args[0],::Vertx::Util::Utils.to_object(args[1]),block_given? ? Proc.new { |ar| yield(ar.failed ? ar.cause : nil, ar.succeeded ? ::Vertx::Util::Utils.safe_create(ar.result,::Vertx::Message, nil) : nil) } : promise)
          return ::Vertx::Util::Utils.safe_create(promise.future(),::Vertx::Future,::Vertx::Message.j_api_type)
        end
      elsif args[0].class == String && ::Vertx::Util::unknown_type.accept?(args[1]) && args[2].class == Hash && true
        if (block_given?)
          @j_del.java_method(:request, [Java::java.lang.String.java_class,Java::java.lang.Object.java_class,Java::IoVertxCoreEventbus::DeliveryOptions.java_class,Java::IoVertxCore::Handler.java_class]).call(args[0],::Vertx::Util::Utils.to_object(args[1]),Java::IoVertxCoreEventbus::DeliveryOptions.new(::Vertx::Util::Utils.to_json_object(args[2])),block_given? ? Proc.new { |ar| yield(ar.failed ? ar.cause : nil, ar.succeeded ? ::Vertx::Util::Utils.safe_create(ar.result,::Vertx::Message, nil) : nil) } : promise)
          return self
        else
          promise = ::Vertx::Util::Utils.promise
          @j_del.java_method(:request, [Java::java.lang.String.java_class,Java::java.lang.Object.java_class,Java::IoVertxCoreEventbus::DeliveryOptions.java_class,Java::IoVertxCore::Handler.java_class]).call(args[0],::Vertx::Util::Utils.to_object(args[1]),Java::IoVertxCoreEventbus::DeliveryOptions.new(::Vertx::Util::Utils.to_json_object(args[2])),block_given? ? Proc.new { |ar| yield(ar.failed ? ar.cause : nil, ar.succeeded ? ::Vertx::Util::Utils.safe_create(ar.result,::Vertx::Message, nil) : nil) } : promise)
          return ::Vertx::Util::Utils.safe_create(promise.future(),::Vertx::Future,::Vertx::Message.j_api_type)
        end
      end
      if defined?(super)
        super
      else
        raise ArgumentError, "Invalid arguments when calling request(#{args[0]},#{args[1]},#{args[2]})"
      end
    end
    #  Like {::Vertx::EventBus#sender} but specifying delivery options that will be used for configuring the delivery of
    #  the message.
    # @overload sender(address)
    #   @param [String] address the address to send it to
    # @overload sender(address,options)
    #   @param [String] address the address to send it to
    #   @param [Hash{String => Object}] options the delivery options
    # @return [::Vertx::MessageProducer] The sender
    def sender(*args)
      if args[0].class == String && !block_given? && args[1] == nil
        return ::Vertx::Util::Utils.safe_create(@j_del.java_method(:sender, [Java::java.lang.String.java_class]).call(args[0]),::Vertx::MessageProducer, nil)
      elsif args[0].class == String && args[1].class == Hash && !block_given?
        return ::Vertx::Util::Utils.safe_create(@j_del.java_method(:sender, [Java::java.lang.String.java_class,Java::IoVertxCoreEventbus::DeliveryOptions.java_class]).call(args[0],Java::IoVertxCoreEventbus::DeliveryOptions.new(::Vertx::Util::Utils.to_json_object(args[1]))),::Vertx::MessageProducer, nil)
      end
      if defined?(super)
        super
      else
        raise ArgumentError, "Invalid arguments when calling sender(#{args[0]},#{args[1]})"
      end
    end
    #  Like {::Vertx::EventBus#consumer} but the address won't be propagated across the cluster.
    # @overload localConsumer(address)
    #   @param [String] address the address to register it at
    # @overload localConsumer(address,handler)
    #   @param [String] address the address that will register it at
    #   @yield the handler that will process the received messages
    # @return [::Vertx::MessageConsumer] the event bus message consumer
    def local_consumer(*args)
      if args[0].class == String && !block_given?
        return ::Vertx::Util::Utils.safe_create(@j_del.java_method(:localConsumer, [Java::java.lang.String.java_class]).call(args[0]),::Vertx::MessageConsumer, nil)
      elsif args[0].class == String && true
        return ::Vertx::Util::Utils.safe_create(@j_del.java_method(:localConsumer, [Java::java.lang.String.java_class,Java::IoVertxCore::Handler.java_class]).call(args[0],(Proc.new { |event| yield(::Vertx::Util::Utils.safe_create(event,::Vertx::Message, nil)) unless !block_given? })),::Vertx::MessageConsumer, nil)
      end
      if defined?(super)
        super
      else
        raise ArgumentError, "Invalid arguments when calling local_consumer(#{args[0]})"
      end
    end
    #  Like  but specifying <code>options</code> that can be used to configure the delivery.
    # @overload publish(address,message)
    #   @param [String] address the address to publish it to
    #   @param [Object] message the message, may be <code>null</code>
    # @overload publish(address,message,options)
    #   @param [String] address the address to publish it to
    #   @param [Object] message the message, may be <code>null</code>
    #   @param [Hash{String => Object}] options the delivery options
    # @return [self]
    def publish(*args)
      if args[0].class == String && ::Vertx::Util::unknown_type.accept?(args[1]) && !block_given? && args[2] == nil
        @j_del.java_method(:publish, [Java::java.lang.String.java_class,Java::java.lang.Object.java_class]).call(args[0],::Vertx::Util::Utils.to_object(args[1]))
        return self
      elsif args[0].class == String && ::Vertx::Util::unknown_type.accept?(args[1]) && args[2].class == Hash && !block_given?
        @j_del.java_method(:publish, [Java::java.lang.String.java_class,Java::java.lang.Object.java_class,Java::IoVertxCoreEventbus::DeliveryOptions.java_class]).call(args[0],::Vertx::Util::Utils.to_object(args[1]),Java::IoVertxCoreEventbus::DeliveryOptions.new(::Vertx::Util::Utils.to_json_object(args[2])))
        return self
      end
      if defined?(super)
        super
      else
        raise ArgumentError, "Invalid arguments when calling publish(#{args[0]},#{args[1]},#{args[2]})"
      end
    end
    #  Add an interceptor that will be called whenever a message is sent from Vert.x
    # @overload addOutboundInterceptor(interceptor)
    #   @yield the interceptor
    # @return [self]
    def add_outbound_interceptor
      if true
        @j_del.java_method(:addOutboundInterceptor, [Java::IoVertxCore::Handler.java_class]).call((Proc.new { |event| yield(::Vertx::Util::Utils.safe_create(event,::Vertx::DeliveryContext, nil)) unless !block_given? }))
        return self
      end
      if defined?(super)
        super
      else
        raise ArgumentError, "Invalid arguments when calling add_outbound_interceptor()"
      end
    end
    #  Like {::Vertx::EventBus#publisher} but specifying delivery options that will be used for configuring the delivery of
    #  the message.
    # @overload publisher(address)
    #   @param [String] address The address to publish it to
    # @overload publisher(address,options)
    #   @param [String] address the address to publish it to
    #   @param [Hash{String => Object}] options the delivery options
    # @return [::Vertx::MessageProducer] The publisher
    def publisher(*args)
      if args[0].class == String && !block_given? && args[1] == nil
        return ::Vertx::Util::Utils.safe_create(@j_del.java_method(:publisher, [Java::java.lang.String.java_class]).call(args[0]),::Vertx::MessageProducer, nil)
      elsif args[0].class == String && args[1].class == Hash && !block_given?
        return ::Vertx::Util::Utils.safe_create(@j_del.java_method(:publisher, [Java::java.lang.String.java_class,Java::IoVertxCoreEventbus::DeliveryOptions.java_class]).call(args[0],Java::IoVertxCoreEventbus::DeliveryOptions.new(::Vertx::Util::Utils.to_json_object(args[1]))),::Vertx::MessageProducer, nil)
      end
      if defined?(super)
        super
      else
        raise ArgumentError, "Invalid arguments when calling publisher(#{args[0]},#{args[1]})"
      end
    end
    #  Like  but specifying <code>options</code> that can be used to configure the delivery.
    # @overload send(address,message)
    #   @param [String] address the address to send it to
    #   @param [Object] message the message, may be <code>null</code>
    # @overload send(address,message,options)
    #   @param [String] address the address to send it to
    #   @param [Object] message the message, may be <code>null</code>
    #   @param [Hash{String => Object}] options delivery options
    # @return [self]
    def send(*args)
      if args[0].class == String && ::Vertx::Util::unknown_type.accept?(args[1]) && !block_given? && args[2] == nil
        @j_del.java_method(:send, [Java::java.lang.String.java_class,Java::java.lang.Object.java_class]).call(args[0],::Vertx::Util::Utils.to_object(args[1]))
        return self
      elsif args[0].class == String && ::Vertx::Util::unknown_type.accept?(args[1]) && args[2].class == Hash && !block_given?
        @j_del.java_method(:send, [Java::java.lang.String.java_class,Java::java.lang.Object.java_class,Java::IoVertxCoreEventbus::DeliveryOptions.java_class]).call(args[0],::Vertx::Util::Utils.to_object(args[1]),Java::IoVertxCoreEventbus::DeliveryOptions.new(::Vertx::Util::Utils.to_json_object(args[2])))
        return self
      end
      if defined?(super)
        super
      else
        raise ArgumentError, "Invalid arguments when calling send(#{args[0]},#{args[1]},#{args[2]})"
      end
    end
    #  Add an interceptor that will be called whenever a message is received by Vert.x
    # @overload addInboundInterceptor(interceptor)
    #   @yield the interceptor
    # @return [self]
    def add_inbound_interceptor
      if true
        @j_del.java_method(:addInboundInterceptor, [Java::IoVertxCore::Handler.java_class]).call((Proc.new { |event| yield(::Vertx::Util::Utils.safe_create(event,::Vertx::DeliveryContext, nil)) unless !block_given? }))
        return self
      end
      if defined?(super)
        super
      else
        raise ArgumentError, "Invalid arguments when calling add_inbound_interceptor()"
      end
    end
    #  Create a consumer and register it against the specified address.
    # @overload consumer(address)
    #   @param [String] address the address that it will register it at
    # @overload consumer(address,handler)
    #   @param [String] address the address that will register it at
    #   @yield the handler that will process the received messages
    # @return [::Vertx::MessageConsumer] the event bus message consumer
    def consumer(*args)
      if args[0].class == String && !block_given?
        return ::Vertx::Util::Utils.safe_create(@j_del.java_method(:consumer, [Java::java.lang.String.java_class]).call(args[0]),::Vertx::MessageConsumer, nil)
      elsif args[0].class == String && true
        return ::Vertx::Util::Utils.safe_create(@j_del.java_method(:consumer, [Java::java.lang.String.java_class,Java::IoVertxCore::Handler.java_class]).call(args[0],(Proc.new { |event| yield(::Vertx::Util::Utils.safe_create(event,::Vertx::Message, nil)) unless !block_given? })),::Vertx::MessageConsumer, nil)
      end
      if defined?(super)
        super
      else
        raise ArgumentError, "Invalid arguments when calling consumer(#{args[0]})"
      end
    end
    #  Remove an interceptor that was added by {::Vertx::EventBus#add_inbound_interceptor}
    # @overload removeInboundInterceptor(interceptor)
    #   @yield the interceptor
    # @return [self]
    def remove_inbound_interceptor
      if true
        @j_del.java_method(:removeInboundInterceptor, [Java::IoVertxCore::Handler.java_class]).call((Proc.new { |event| yield(::Vertx::Util::Utils.safe_create(event,::Vertx::DeliveryContext, nil)) unless !block_given? }))
        return self
      end
      if defined?(super)
        super
      else
        raise ArgumentError, "Invalid arguments when calling remove_inbound_interceptor()"
      end
    end
    #  Remove an interceptor that was added by {::Vertx::EventBus#add_outbound_interceptor}
    # @overload removeOutboundInterceptor(interceptor)
    #   @yield the interceptor
    # @return [self]
    def remove_outbound_interceptor
      if true
        @j_del.java_method(:removeOutboundInterceptor, [Java::IoVertxCore::Handler.java_class]).call((Proc.new { |event| yield(::Vertx::Util::Utils.safe_create(event,::Vertx::DeliveryContext, nil)) unless !block_given? }))
        return self
      end
      if defined?(super)
        super
      else
        raise ArgumentError, "Invalid arguments when calling remove_outbound_interceptor()"
      end
    end
  end
end
