require 'vertx/pipe'
require 'vertx/buffer'
require 'vertx/write_stream'
require 'vertx/read_stream'
require 'vertx/future'
require 'vertx/socket_address'
require 'vertx/future'
require 'vertx/util/utils.rb'
# Generated from io.vertx.core.net.NetSocket
module Vertx
  #  Represents a socket-like interface to a TCP connection on either the
  #  client or the server side.
  #  <p>
  #  Instances of this class are created on the client side by an {::Vertx::NetClient}
  #  when a connection to a server is made, or on the server side by a {::Vertx::NetServer}
  #  when a server accepts a connection.
  #  <p>
  #  It implements both  and  so it can be used with
  #  {::Vertx::Pump} to pump data with flow control.
  class NetSocket
    include ::Vertx::ReadStream
    include ::Vertx::WriteStream
    # @private
    # @param j_del [::Vertx::NetSocket] the java delegate
    def initialize(j_del)
      @j_del = j_del
    end
    # @private
    # @return [::Vertx::NetSocket] the underlying java delegate
    def j_del
      @j_del
    end
    @@j_api_type = Object.new
    def @@j_api_type.accept?(obj)
      obj.class == NetSocket
    end
    def @@j_api_type.wrap(obj)
      NetSocket.new(obj)
    end
    def @@j_api_type.unwrap(obj)
      obj.j_del
    end
    def self.j_api_type
      @@j_api_type
    end
    def self.j_class
      Java::IoVertxCoreNet::NetSocket.java_class
    end
    # @overload resume()
    # @return [self]
    def resume
      if !block_given?
        @j_del.java_method(:resume, []).call()
        return self
      end
      if defined?(super)
        super
      else
        raise ArgumentError, "Invalid arguments when calling resume()"
      end
    end
    # @overload handler(handler)
    #   @yield 
    # @return [self]
    def handler
      if true
        @j_del.java_method(:handler, [Java::IoVertxCore::Handler.java_class]).call((Proc.new { |event| yield(::Vertx::Util::Utils.safe_create(event,::Vertx::Buffer)) unless !block_given? }))
        return self
      end
      if defined?(super)
        super
      else
        raise ArgumentError, "Invalid arguments when calling handler()"
      end
    end
    #  Upgrade channel to use SSL/TLS. Be aware that for this to work SSL must be configured.
    # @overload upgradeToSsl(handler)
    #   @yield the handler will be notified when it's upgraded
    # @overload upgradeToSsl(serverName,handler)
    #   @param [String] serverName the server name
    #   @yield the handler will be notified when it's upgraded
    # @return [self]
    def upgrade_to_ssl(*args)
      if true && args[0] == nil
        if (block_given?)
          @j_del.java_method(:upgradeToSsl, [Java::IoVertxCore::Handler.java_class]).call(block_given? ? Proc.new { |ar| yield(ar.failed ? ar.cause : nil, ar.succeeded ? nil : nil) } : promise)
          return self
        else
          promise = ::Vertx::Util::Utils.promise
          @j_del.java_method(:upgradeToSsl, [Java::IoVertxCore::Handler.java_class]).call(block_given? ? Proc.new { |ar| yield(ar.failed ? ar.cause : nil, ar.succeeded ? nil : nil) } : promise)
          return ::Vertx::Util::Utils.safe_create(promise.future(),::Vertx::Future, nil)
        end
      elsif args[0].class == String && true
        if (block_given?)
          @j_del.java_method(:upgradeToSsl, [Java::java.lang.String.java_class,Java::IoVertxCore::Handler.java_class]).call(args[0],block_given? ? Proc.new { |ar| yield(ar.failed ? ar.cause : nil, ar.succeeded ? nil : nil) } : promise)
          return self
        else
          promise = ::Vertx::Util::Utils.promise
          @j_del.java_method(:upgradeToSsl, [Java::java.lang.String.java_class,Java::IoVertxCore::Handler.java_class]).call(args[0],block_given? ? Proc.new { |ar| yield(ar.failed ? ar.cause : nil, ar.succeeded ? nil : nil) } : promise)
          return ::Vertx::Util::Utils.safe_create(promise.future(),::Vertx::Future, nil)
        end
      end
      if defined?(super)
        super
      else
        raise ArgumentError, "Invalid arguments when calling upgrade_to_ssl(#{args[0]})"
      end
    end
    #  This will return <code>true</code> if there are more bytes in the write queue than the value set using {::Vertx::NetSocket#set_write_queue_max_size}
    # @overload writeQueueFull()
    # @return [true,false] true if write queue is full
    def write_queue_full?
      if !block_given?
        return @j_del.java_method(:writeQueueFull, []).call()
      end
      if defined?(super)
        super
      else
        raise ArgumentError, "Invalid arguments when calling write_queue_full?()"
      end
    end
    #  When a <code>NetSocket</code> is created it automatically registers an event handler with the event bus, the ID of that
    #  handler is given by <code>writeHandlerID</code>.
    #  <p>
    #  Given this ID, a different event loop can send a buffer to that event handler using the event bus and
    #  that buffer will be received by this instance in its own event loop and written to the underlying connection. This
    #  allows you to write data to other connections which are owned by different event loops.
    # @overload writeHandlerID()
    # @return [String] the write handler ID
    def write_handler_id
      if !block_given?
        return @j_del.java_method(:writeHandlerID, []).call()
      end
      if defined?(super)
        super
      else
        raise ArgumentError, "Invalid arguments when calling write_handler_id()"
      end
    end
    #  Set a handler that will be called when the NetSocket is closed
    # @overload closeHandler(handler)
    #   @yield the handler
    # @return [self]
    def close_handler
      if true
        @j_del.java_method(:closeHandler, [Java::IoVertxCore::Handler.java_class]).call((Proc.new { |event| yield(nil) unless !block_given? }))
        return self
      end
      if defined?(super)
        super
      else
        raise ArgumentError, "Invalid arguments when calling close_handler()"
      end
    end
    # @overload setWriteQueueMaxSize(maxSize)
    #   @param [Fixnum] maxSize 
    # @return [self]
    def set_write_queue_max_size(*args)
      if args[0].class == Fixnum && !block_given?
        @j_del.java_method(:setWriteQueueMaxSize, [Java::int.java_class]).call(args[0])
        return self
      end
      if defined?(super)
        super
      else
        raise ArgumentError, "Invalid arguments when calling set_write_queue_max_size(#{args[0]})"
      end
    end
    # @overload pause()
    # @return [self]
    def pause
      if !block_given?
        @j_del.java_method(:pause, []).call()
        return self
      end
      if defined?(super)
        super
      else
        raise ArgumentError, "Invalid arguments when calling pause()"
      end
    end
    #  Same as {::Vertx::NetSocket#send_file} but also takes a handler that will be called when the send has completed or
    #  a failure has occurred
    # @overload sendFile(filename,resultHandler)
    #   @param [String] filename file name of the file to send
    #   @yield handler
    # @overload sendFile(filename,offset,resultHandler)
    #   @param [String] filename file name of the file to send
    #   @param [Fixnum] offset offset
    #   @yield handler
    # @overload sendFile(filename,offset,length,resultHandler)
    #   @param [String] filename file name of the file to send
    #   @param [Fixnum] offset offset
    #   @param [Fixnum] length length
    #   @yield handler
    # @return [self]
    def send_file(*args)
      if args[0].class == String && true && args[1] == nil && args[2] == nil
        if (block_given?)
          @j_del.java_method(:sendFile, [Java::java.lang.String.java_class,Java::IoVertxCore::Handler.java_class]).call(args[0],block_given? ? Proc.new { |ar| yield(ar.failed ? ar.cause : nil, ar.succeeded ? nil : nil) } : promise)
          return self
        else
          promise = ::Vertx::Util::Utils.promise
          @j_del.java_method(:sendFile, [Java::java.lang.String.java_class,Java::IoVertxCore::Handler.java_class]).call(args[0],block_given? ? Proc.new { |ar| yield(ar.failed ? ar.cause : nil, ar.succeeded ? nil : nil) } : promise)
          return ::Vertx::Util::Utils.safe_create(promise.future(),::Vertx::Future, nil)
        end
      elsif args[0].class == String && args[1].class == Fixnum && true && args[2] == nil
        if (block_given?)
          @j_del.java_method(:sendFile, [Java::java.lang.String.java_class,Java::long.java_class,Java::IoVertxCore::Handler.java_class]).call(args[0],args[1],block_given? ? Proc.new { |ar| yield(ar.failed ? ar.cause : nil, ar.succeeded ? nil : nil) } : promise)
          return self
        else
          promise = ::Vertx::Util::Utils.promise
          @j_del.java_method(:sendFile, [Java::java.lang.String.java_class,Java::long.java_class,Java::IoVertxCore::Handler.java_class]).call(args[0],args[1],block_given? ? Proc.new { |ar| yield(ar.failed ? ar.cause : nil, ar.succeeded ? nil : nil) } : promise)
          return ::Vertx::Util::Utils.safe_create(promise.future(),::Vertx::Future, nil)
        end
      elsif args[0].class == String && args[1].class == Fixnum && args[2].class == Fixnum && true
        if (block_given?)
          @j_del.java_method(:sendFile, [Java::java.lang.String.java_class,Java::long.java_class,Java::long.java_class,Java::IoVertxCore::Handler.java_class]).call(args[0],args[1],args[2],block_given? ? Proc.new { |ar| yield(ar.failed ? ar.cause : nil, ar.succeeded ? nil : nil) } : promise)
          return self
        else
          promise = ::Vertx::Util::Utils.promise
          @j_del.java_method(:sendFile, [Java::java.lang.String.java_class,Java::long.java_class,Java::long.java_class,Java::IoVertxCore::Handler.java_class]).call(args[0],args[1],args[2],block_given? ? Proc.new { |ar| yield(ar.failed ? ar.cause : nil, ar.succeeded ? nil : nil) } : promise)
          return ::Vertx::Util::Utils.safe_create(promise.future(),::Vertx::Future, nil)
        end
      end
      if defined?(super)
        super
      else
        raise ArgumentError, "Invalid arguments when calling send_file(#{args[0]},#{args[1]},#{args[2]})"
      end
    end
    #  Returns the SNI server name presented during the SSL handshake by the client.
    # @overload indicatedServerName()
    # @return [String] the indicated server name
    def indicated_server_name
      if !block_given?
        return @j_del.java_method(:indicatedServerName, []).call()
      end
      if defined?(super)
        super
      else
        raise ArgumentError, "Invalid arguments when calling indicated_server_name()"
      end
    end
    #  Pipe this <code>ReadStream</code> to the <code>WriteStream</code>.
    #  <p>
    #  Elements emitted by this stream will be written to the write stream until this stream ends or fails.
    #  <p>
    #  Once this stream has ended or failed, the write stream will be ended and the <code>handler</code> will be
    #  called with the result.
    # @overload pipeTo(dst,handler)
    #   @param [::Vertx::WriteStream] dst the destination write stream
    #   @yield 
    # @return [void]
    def pipe_to(*args)
      if args[0].class.method_defined?(:j_del) && true
        if (block_given?)
          return @j_del.java_method(:pipeTo, [Java::IoVertxCoreStreams::WriteStream.java_class,Java::IoVertxCore::Handler.java_class]).call(args[0].j_del,block_given? ? Proc.new { |ar| yield(ar.failed ? ar.cause : nil, ar.succeeded ? nil : nil) } : promise)
        else
          promise = ::Vertx::Util::Utils.promise
          @j_del.java_method(:pipeTo, [Java::IoVertxCoreStreams::WriteStream.java_class,Java::IoVertxCore::Handler.java_class]).call(args[0].j_del,block_given? ? Proc.new { |ar| yield(ar.failed ? ar.cause : nil, ar.succeeded ? nil : nil) } : promise)
          return ::Vertx::Util::Utils.safe_create(promise.future(),::Vertx::Future, nil)
        end
      end
      if defined?(super)
        super
      else
        raise ArgumentError, "Invalid arguments when calling pipe_to(#{args[0]})"
      end
    end
    # @overload drainHandler(handler)
    #   @yield 
    # @return [self]
    def drain_handler
      if true
        @j_del.java_method(:drainHandler, [Java::IoVertxCore::Handler.java_class]).call((Proc.new { |event| yield(nil) unless !block_given? }))
        return self
      end
      if defined?(super)
        super
      else
        raise ArgumentError, "Invalid arguments when calling drain_handler()"
      end
    end
    #  
    #  <p>
    #  This handler might be called after the close handler when the socket is paused and there are still
    #  buffers to deliver.
    # @overload endHandler(endHandler)
    #   @yield 
    # @return [self]
    def end_handler
      if true
        @j_del.java_method(:endHandler, [Java::IoVertxCore::Handler.java_class]).call((Proc.new { |event| yield(nil) unless !block_given? }))
        return self
      end
      if defined?(super)
        super
      else
        raise ArgumentError, "Invalid arguments when calling end_handler()"
      end
    end
    # @overload localAddress()
    # @return [::Vertx::SocketAddress] the local address for this socket
    def local_address
      if !block_given?
        if @cached_local_address != nil
          return @cached_local_address
        end
        return @cached_local_address = ::Vertx::Util::Utils.safe_create(@j_del.java_method(:localAddress, []).call(),::Vertx::SocketAddress)
      end
      if defined?(super)
        super
      else
        raise ArgumentError, "Invalid arguments when calling local_address()"
      end
    end
    # @overload fetch(amount)
    #   @param [Fixnum] amount 
    # @return [self]
    def fetch(*args)
      if args[0].class == Fixnum && !block_given?
        @j_del.java_method(:fetch, [Java::long.java_class]).call(args[0])
        return self
      end
      if defined?(super)
        super
      else
        raise ArgumentError, "Invalid arguments when calling fetch(#{args[0]})"
      end
    end
    #  Pause this stream and return a  to transfer the elements of this stream to a destination .
    #  <p/>
    #  The stream will be resumed when the pipe will be wired to a <code>WriteStream</code>.
    # @overload pipe()
    # @return [::Vertx::Pipe] a pipe
    def pipe
      if !block_given?
        return ::Vertx::Util::Utils.safe_create(@j_del.java_method(:pipe, []).call(),::Vertx::Pipe,::Vertx::Buffer.j_api_type)
      end
      if defined?(super)
        super
      else
        raise ArgumentError, "Invalid arguments when calling pipe()"
      end
    end
    #  Same as  but with an <code>handler</code> called when the operation completes
    # @overload end(handler)
    #   @yield 
    # @overload end(data,handler)
    #   @param [::Vertx::Buffer] data 
    #   @yield 
    # @return [void]
    def end(*args)
      if true && args[0] == nil
        if (block_given?)
          return @j_del.java_method(:end, [Java::IoVertxCore::Handler.java_class]).call(block_given? ? Proc.new { |ar| yield(ar.failed ? ar.cause : nil, ar.succeeded ? nil : nil) } : promise)
        else
          promise = ::Vertx::Util::Utils.promise
          @j_del.java_method(:end, [Java::IoVertxCore::Handler.java_class]).call(block_given? ? Proc.new { |ar| yield(ar.failed ? ar.cause : nil, ar.succeeded ? nil : nil) } : promise)
          return ::Vertx::Util::Utils.safe_create(promise.future(),::Vertx::Future, nil)
        end
      elsif args[0].class.method_defined?(:j_del) && true
        if (block_given?)
          return @j_del.java_method(:end, [Java::IoVertxCoreBuffer::Buffer.java_class,Java::IoVertxCore::Handler.java_class]).call(args[0].j_del,block_given? ? Proc.new { |ar| yield(ar.failed ? ar.cause : nil, ar.succeeded ? nil : nil) } : promise)
        else
          promise = ::Vertx::Util::Utils.promise
          @j_del.java_method(:end, [Java::IoVertxCoreBuffer::Buffer.java_class,Java::IoVertxCore::Handler.java_class]).call(args[0].j_del,block_given? ? Proc.new { |ar| yield(ar.failed ? ar.cause : nil, ar.succeeded ? nil : nil) } : promise)
          return ::Vertx::Util::Utils.safe_create(promise.future(),::Vertx::Future, nil)
        end
      end
      if defined?(super)
        super
      else
        raise ArgumentError, "Invalid arguments when calling end(#{args[0]})"
      end
    end
    #  Close the NetSocket and notify the <code>handler</code> when the operation completes.
    # @overload close(handler)
    #   @yield 
    # @return [void]
    def close
      if true
        if (block_given?)
          return @j_del.java_method(:close, [Java::IoVertxCore::Handler.java_class]).call(block_given? ? Proc.new { |ar| yield(ar.failed ? ar.cause : nil, ar.succeeded ? nil : nil) } : promise)
        else
          promise = ::Vertx::Util::Utils.promise
          @j_del.java_method(:close, [Java::IoVertxCore::Handler.java_class]).call(block_given? ? Proc.new { |ar| yield(ar.failed ? ar.cause : nil, ar.succeeded ? nil : nil) } : promise)
          return ::Vertx::Util::Utils.safe_create(promise.future(),::Vertx::Future, nil)
        end
      end
      if defined?(super)
        super
      else
        raise ArgumentError, "Invalid arguments when calling close()"
      end
    end
    #  Same as {::Vertx::NetSocket#write} but with an <code>handler</code> called when the operation completes
    # @overload write(str,handler)
    #   @param [String] str 
    #   @yield 
    # @overload write(message,handler)
    #   @param [::Vertx::Buffer] message 
    #   @yield 
    # @overload write(str,enc,handler)
    #   @param [String] str 
    #   @param [String] enc 
    #   @yield 
    # @return [void]
    def write(*args)
      if args[0].class == String && true && args[1] == nil
        if (block_given?)
          return @j_del.java_method(:write, [Java::java.lang.String.java_class,Java::IoVertxCore::Handler.java_class]).call(args[0],block_given? ? Proc.new { |ar| yield(ar.failed ? ar.cause : nil, ar.succeeded ? nil : nil) } : promise)
        else
          promise = ::Vertx::Util::Utils.promise
          @j_del.java_method(:write, [Java::java.lang.String.java_class,Java::IoVertxCore::Handler.java_class]).call(args[0],block_given? ? Proc.new { |ar| yield(ar.failed ? ar.cause : nil, ar.succeeded ? nil : nil) } : promise)
          return ::Vertx::Util::Utils.safe_create(promise.future(),::Vertx::Future, nil)
        end
      elsif args[0].class.method_defined?(:j_del) && true && args[1] == nil
        if (block_given?)
          return @j_del.java_method(:write, [Java::IoVertxCoreBuffer::Buffer.java_class,Java::IoVertxCore::Handler.java_class]).call(args[0].j_del,block_given? ? Proc.new { |ar| yield(ar.failed ? ar.cause : nil, ar.succeeded ? nil : nil) } : promise)
        else
          promise = ::Vertx::Util::Utils.promise
          @j_del.java_method(:write, [Java::IoVertxCoreBuffer::Buffer.java_class,Java::IoVertxCore::Handler.java_class]).call(args[0].j_del,block_given? ? Proc.new { |ar| yield(ar.failed ? ar.cause : nil, ar.succeeded ? nil : nil) } : promise)
          return ::Vertx::Util::Utils.safe_create(promise.future(),::Vertx::Future, nil)
        end
      elsif args[0].class == String && args[1].class == String && true
        if (block_given?)
          return @j_del.java_method(:write, [Java::java.lang.String.java_class,Java::java.lang.String.java_class,Java::IoVertxCore::Handler.java_class]).call(args[0],args[1],block_given? ? Proc.new { |ar| yield(ar.failed ? ar.cause : nil, ar.succeeded ? nil : nil) } : promise)
        else
          promise = ::Vertx::Util::Utils.promise
          @j_del.java_method(:write, [Java::java.lang.String.java_class,Java::java.lang.String.java_class,Java::IoVertxCore::Handler.java_class]).call(args[0],args[1],block_given? ? Proc.new { |ar| yield(ar.failed ? ar.cause : nil, ar.succeeded ? nil : nil) } : promise)
          return ::Vertx::Util::Utils.safe_create(promise.future(),::Vertx::Future, nil)
        end
      end
      if defined?(super)
        super
      else
        raise ArgumentError, "Invalid arguments when calling write(#{args[0]},#{args[1]})"
      end
    end
    # @overload exceptionHandler(handler)
    #   @yield 
    # @return [self]
    def exception_handler
      if true
        @j_del.java_method(:exceptionHandler, [Java::IoVertxCore::Handler.java_class]).call((Proc.new { |event| yield(::Vertx::Util::Utils.from_throwable(event)) unless !block_given? }))
        return self
      end
      if defined?(super)
        super
      else
        raise ArgumentError, "Invalid arguments when calling exception_handler()"
      end
    end
    # @overload remoteAddress()
    # @return [::Vertx::SocketAddress] the remote address for this socket
    def remote_address
      if !block_given?
        if @cached_remote_address != nil
          return @cached_remote_address
        end
        return @cached_remote_address = ::Vertx::Util::Utils.safe_create(@j_del.java_method(:remoteAddress, []).call(),::Vertx::SocketAddress)
      end
      if defined?(super)
        super
      else
        raise ArgumentError, "Invalid arguments when calling remote_address()"
      end
    end
    # @overload isSsl()
    # @return [true,false] true if this {::Vertx::NetSocket} is encrypted via SSL/TLS.
    def ssl?
      if !block_given?
        return @j_del.java_method(:isSsl, []).call()
      end
      if defined?(super)
        super
      else
        raise ArgumentError, "Invalid arguments when calling ssl?()"
      end
    end
  end
end
