require 'vertx/pipe'
require 'vertx/buffer'
require 'vertx/write_stream'
require 'vertx/read_stream'
require 'vertx/future'
require 'vertx/future'
require 'vertx/util/utils.rb'
# Generated from io.vertx.core.parsetools.RecordParser
module Vertx
  #  A helper class which allows you to easily parse protocols which are delimited by a sequence of bytes, or fixed
  #  size records.
  #  <p>
  #  Instances of this class take as input {::Vertx::Buffer} instances containing raw bytes,
  #  and output records.
  #  <p>
  #  For example, if I had a simple ASCII text protocol delimited by '\n' and the input was the following:
  #  <p>
  #  <pre>
  #  buffer1:HELLO\nHOW ARE Y
  #  buffer2:OU?\nI AM
  #  buffer3: DOING OK
  #  buffer4:\n
  #  </pre>
  #  Then the output would be:<p>
  #  <pre>
  #  buffer1:HELLO
  #  buffer2:HOW ARE YOU?
  #  buffer3:I AM DOING OK
  #  </pre>
  #  Instances of this class can be changed between delimited mode and fixed size record mode on the fly as
  #  individual records are read, this allows you to parse protocols where, for example, the first 5 records might
  #  all be fixed size (of potentially different sizes), followed by some delimited records, followed by more fixed
  #  size records.
  #  <p>
  #  Instances of this class can't currently be used for protocols where the text is encoded with something other than
  #  a 1-1 byte-char mapping.
  #  <p>
  #  Please see the documentation for more information.
  class RecordParser
    include ::Vertx::ReadStream
    # @private
    # @param j_del [::Vertx::RecordParser] the java delegate
    def initialize(j_del)
      @j_del = j_del
    end
    # @private
    # @return [::Vertx::RecordParser] the underlying java delegate
    def j_del
      @j_del
    end
    @@j_api_type = Object.new
    def @@j_api_type.accept?(obj)
      obj.class == RecordParser
    end
    def @@j_api_type.wrap(obj)
      RecordParser.new(obj)
    end
    def @@j_api_type.unwrap(obj)
      obj.j_del
    end
    def self.j_api_type
      @@j_api_type
    end
    def self.j_class
      Java::IoVertxCoreParsetools::RecordParser.java_class
    end
    # @overload resume()
    # @return [self]
    def resume
      if !block_given?
        @j_del.java_method(:resume, []).call()
        return self
      end
      if defined?(super)
        super
      else
        raise ArgumentError, "Invalid arguments when calling resume()"
      end
    end
    # @overload handler(handler)
    #   @yield 
    # @return [self]
    def handler
      if true
        @j_del.java_method(:handler, [Java::IoVertxCore::Handler.java_class]).call((Proc.new { |event| yield(::Vertx::Util::Utils.safe_create(event,::Vertx::Buffer)) unless !block_given? }))
        return self
      end
      if defined?(super)
        super
      else
        raise ArgumentError, "Invalid arguments when calling handler()"
      end
    end
    #  Like {::Vertx::RecordParser#new_fixed} but wraps the <code>stream</code>. The <code>stream</code> handlers will be set/unset
    #  when the {::Vertx::RecordParser#handler} is set.
    #  <p/>
    #  The <code>pause()</code>/<code>resume()</code> operations are propagated to the <code>stream</code>.
    # @overload newFixed(size)
    #   @param [Fixnum] size the initial record size
    # @overload newFixed(size,output)
    #   @param [Fixnum] size the initial record size
    #   @yield handler that will receive the output
    # @overload newFixed(size,stream)
    #   @param [Fixnum] size the initial record size
    #   @param [::Vertx::ReadStream] stream the wrapped stream
    # @return [::Vertx::RecordParser]
    def self.new_fixed(*args)
      if args[0].class == Fixnum && !block_given? && args[1] == nil
        return ::Vertx::Util::Utils.safe_create(Java::IoVertxCoreParsetools::RecordParser.java_method(:newFixed, [Java::int.java_class]).call(args[0]),::Vertx::RecordParser)
      elsif args[0].class == Fixnum && true && args[1] == nil
        return ::Vertx::Util::Utils.safe_create(Java::IoVertxCoreParsetools::RecordParser.java_method(:newFixed, [Java::int.java_class,Java::IoVertxCore::Handler.java_class]).call(args[0],(Proc.new { |event| yield(::Vertx::Util::Utils.safe_create(event,::Vertx::Buffer)) unless !block_given? })),::Vertx::RecordParser)
      elsif args[0].class == Fixnum && args[1].class.method_defined?(:j_del) && !block_given?
        return ::Vertx::Util::Utils.safe_create(Java::IoVertxCoreParsetools::RecordParser.java_method(:newFixed, [Java::int.java_class,Java::IoVertxCoreStreams::ReadStream.java_class]).call(args[0],args[1].j_del),::Vertx::RecordParser)
      end
      if defined?(super)
        super
      else
        raise ArgumentError, "Invalid arguments when calling new_fixed(#{args[0]},#{args[1]})"
      end
    end
    #  This method is called to provide the parser with data.
    # @overload handle(buffer)
    #   @param [::Vertx::Buffer] buffer a chunk of data
    # @return [void]
    def handle(*args)
      if args[0].class.method_defined?(:j_del) && !block_given?
        return @j_del.java_method(:handle, [Java::IoVertxCoreBuffer::Buffer.java_class]).call(args[0].j_del)
      end
      if defined?(super)
        super
      else
        raise ArgumentError, "Invalid arguments when calling handle(#{args[0]})"
      end
    end
    #  Flip the parser into delimited mode, and where the delimiter can be represented
    #  by the delimiter <code>delim</code>.
    #  <p>
    #  This method can be called multiple times with different values of delim while data is being parsed.
    # @overload delimitedMode(delim)
    #   @param [String] delim the new delimeter
    # @overload delimitedMode(delim)
    #   @param [::Vertx::Buffer] delim the new delimiter
    # @return [void]
    def delimited_mode(*args)
      if args[0].class == String && !block_given?
        return @j_del.java_method(:delimitedMode, [Java::java.lang.String.java_class]).call(args[0])
      elsif args[0].class.method_defined?(:j_del) && !block_given?
        return @j_del.java_method(:delimitedMode, [Java::IoVertxCoreBuffer::Buffer.java_class]).call(args[0].j_del)
      end
      if defined?(super)
        super
      else
        raise ArgumentError, "Invalid arguments when calling delimited_mode(#{args[0]})"
      end
    end
    # @overload pause()
    # @return [self]
    def pause
      if !block_given?
        @j_del.java_method(:pause, []).call()
        return self
      end
      if defined?(super)
        super
      else
        raise ArgumentError, "Invalid arguments when calling pause()"
      end
    end
    #  Like {::Vertx::RecordParser#new_delimited} but wraps the <code>stream</code>. The <code>stream</code> handlers will be set/unset
    #  when the {::Vertx::RecordParser#handler} is set.
    #  <p/>
    #  The <code>pause()</code>/<code>resume()</code> operations are propagated to the <code>stream</code>.
    # @overload newDelimited(delim)
    #   @param [String] delim the initial delimiter string
    # @overload newDelimited(delim)
    #   @param [::Vertx::Buffer] delim the initial delimiter buffer
    # @overload newDelimited(delim,output)
    #   @param [String] delim the initial delimiter string
    #   @yield handler that will receive the output
    # @overload newDelimited(delim,stream)
    #   @param [String] delim the initial delimiter string
    #   @param [::Vertx::ReadStream] stream the wrapped stream
    # @overload newDelimited(delim,output)
    #   @param [::Vertx::Buffer] delim the initial delimiter buffer
    #   @yield handler that will receive the output
    # @overload newDelimited(delim,stream)
    #   @param [::Vertx::Buffer] delim the initial delimiter buffer
    #   @param [::Vertx::ReadStream] stream the wrapped stream
    # @return [::Vertx::RecordParser]
    def self.new_delimited(*args)
      if args[0].class == String && !block_given? && args[1] == nil
        return ::Vertx::Util::Utils.safe_create(Java::IoVertxCoreParsetools::RecordParser.java_method(:newDelimited, [Java::java.lang.String.java_class]).call(args[0]),::Vertx::RecordParser)
      elsif args[0].class.method_defined?(:j_del) && !block_given? && args[1] == nil
        return ::Vertx::Util::Utils.safe_create(Java::IoVertxCoreParsetools::RecordParser.java_method(:newDelimited, [Java::IoVertxCoreBuffer::Buffer.java_class]).call(args[0].j_del),::Vertx::RecordParser)
      elsif args[0].class == String && true && args[1] == nil
        return ::Vertx::Util::Utils.safe_create(Java::IoVertxCoreParsetools::RecordParser.java_method(:newDelimited, [Java::java.lang.String.java_class,Java::IoVertxCore::Handler.java_class]).call(args[0],(Proc.new { |event| yield(::Vertx::Util::Utils.safe_create(event,::Vertx::Buffer)) unless !block_given? })),::Vertx::RecordParser)
      elsif args[0].class == String && args[1].class.method_defined?(:j_del) && !block_given?
        return ::Vertx::Util::Utils.safe_create(Java::IoVertxCoreParsetools::RecordParser.java_method(:newDelimited, [Java::java.lang.String.java_class,Java::IoVertxCoreStreams::ReadStream.java_class]).call(args[0],args[1].j_del),::Vertx::RecordParser)
      elsif args[0].class.method_defined?(:j_del) && true && args[1] == nil
        return ::Vertx::Util::Utils.safe_create(Java::IoVertxCoreParsetools::RecordParser.java_method(:newDelimited, [Java::IoVertxCoreBuffer::Buffer.java_class,Java::IoVertxCore::Handler.java_class]).call(args[0].j_del,(Proc.new { |event| yield(::Vertx::Util::Utils.safe_create(event,::Vertx::Buffer)) unless !block_given? })),::Vertx::RecordParser)
      elsif args[0].class.method_defined?(:j_del) && args[1].class.method_defined?(:j_del) && !block_given?
        return ::Vertx::Util::Utils.safe_create(Java::IoVertxCoreParsetools::RecordParser.java_method(:newDelimited, [Java::IoVertxCoreBuffer::Buffer.java_class,Java::IoVertxCoreStreams::ReadStream.java_class]).call(args[0].j_del,args[1].j_del),::Vertx::RecordParser)
      end
      if defined?(super)
        super
      else
        raise ArgumentError, "Invalid arguments when calling new_delimited(#{args[0]},#{args[1]})"
      end
    end
    #  Pipe this <code>ReadStream</code> to the <code>WriteStream</code>.
    #  <p>
    #  Elements emitted by this stream will be written to the write stream until this stream ends or fails.
    #  <p>
    #  Once this stream has ended or failed, the write stream will be ended and the <code>handler</code> will be
    #  called with the result.
    # @overload pipeTo(dst,handler)
    #   @param [::Vertx::WriteStream] dst the destination write stream
    #   @yield 
    # @return [void]
    def pipe_to(*args)
      if args[0].class.method_defined?(:j_del) && true
        if (block_given?)
          return @j_del.java_method(:pipeTo, [Java::IoVertxCoreStreams::WriteStream.java_class,Java::IoVertxCore::Handler.java_class]).call(args[0].j_del,block_given? ? Proc.new { |ar| yield(ar.failed ? ar.cause : nil, ar.succeeded ? nil : nil) } : promise)
        else
          promise = ::Vertx::Util::Utils.promise
          @j_del.java_method(:pipeTo, [Java::IoVertxCoreStreams::WriteStream.java_class,Java::IoVertxCore::Handler.java_class]).call(args[0].j_del,block_given? ? Proc.new { |ar| yield(ar.failed ? ar.cause : nil, ar.succeeded ? nil : nil) } : promise)
          return ::Vertx::Util::Utils.safe_create(promise.future(),::Vertx::Future, nil)
        end
      end
      if defined?(super)
        super
      else
        raise ArgumentError, "Invalid arguments when calling pipe_to(#{args[0]})"
      end
    end
    # @overload endHandler(endHandler)
    #   @yield 
    # @return [self]
    def end_handler
      if true
        @j_del.java_method(:endHandler, [Java::IoVertxCore::Handler.java_class]).call((Proc.new { |event| yield(nil) unless !block_given? }))
        return self
      end
      if defined?(super)
        super
      else
        raise ArgumentError, "Invalid arguments when calling end_handler()"
      end
    end
    #  Flip the parser into fixed size mode, where the record size is specified by <code>size</code> in bytes.
    #  <p>
    #  This method can be called multiple times with different values of size while data is being parsed.
    # @overload fixedSizeMode(size)
    #   @param [Fixnum] size the new record size
    # @return [void]
    def fixed_size_mode(*args)
      if args[0].class == Fixnum && !block_given?
        return @j_del.java_method(:fixedSizeMode, [Java::int.java_class]).call(args[0])
      end
      if defined?(super)
        super
      else
        raise ArgumentError, "Invalid arguments when calling fixed_size_mode(#{args[0]})"
      end
    end
    # @overload fetch(amount)
    #   @param [Fixnum] amount 
    # @return [self]
    def fetch(*args)
      if args[0].class == Fixnum && !block_given?
        @j_del.java_method(:fetch, [Java::long.java_class]).call(args[0])
        return self
      end
      if defined?(super)
        super
      else
        raise ArgumentError, "Invalid arguments when calling fetch(#{args[0]})"
      end
    end
    #  Set the maximum allowed size for a record when using the delimited mode.
    #  The delimiter itself does not count for the record size.
    #  <p>
    #  If a record is longer than specified, an IllegalStateException will be thrown.
    # @overload maxRecordSize(size)
    #   @param [Fixnum] size the maximum record size
    # @return [self]
    def max_record_size(*args)
      if args[0].class == Fixnum && !block_given?
        @j_del.java_method(:maxRecordSize, [Java::int.java_class]).call(args[0])
        return self
      end
      if defined?(super)
        super
      else
        raise ArgumentError, "Invalid arguments when calling max_record_size(#{args[0]})"
      end
    end
    #  Pause this stream and return a  to transfer the elements of this stream to a destination .
    #  <p/>
    #  The stream will be resumed when the pipe will be wired to a <code>WriteStream</code>.
    # @overload pipe()
    # @return [::Vertx::Pipe] a pipe
    def pipe
      if !block_given?
        return ::Vertx::Util::Utils.safe_create(@j_del.java_method(:pipe, []).call(),::Vertx::Pipe,::Vertx::Buffer.j_api_type)
      end
      if defined?(super)
        super
      else
        raise ArgumentError, "Invalid arguments when calling pipe()"
      end
    end
    # @overload exceptionHandler(handler)
    #   @yield 
    # @return [self]
    def exception_handler
      if true
        @j_del.java_method(:exceptionHandler, [Java::IoVertxCore::Handler.java_class]).call((Proc.new { |event| yield(::Vertx::Util::Utils.from_throwable(event)) unless !block_given? }))
        return self
      end
      if defined?(super)
        super
      else
        raise ArgumentError, "Invalid arguments when calling exception_handler()"
      end
    end
    # @overload setOutput(output)
    #   @yield 
    # @return [void]
    def set_output
      if true
        return @j_del.java_method(:setOutput, [Java::IoVertxCore::Handler.java_class]).call((Proc.new { |event| yield(::Vertx::Util::Utils.safe_create(event,::Vertx::Buffer)) unless !block_given? }))
      end
      if defined?(super)
        super
      else
        raise ArgumentError, "Invalid arguments when calling set_output()"
      end
    end
  end
end
