require 'vertx/future'
require 'vertx/util/utils.rb'
# Generated from io.vertx.core.dns.SrvRecord
module Vertx
  #  Represent a Service-Record (SRV) which was resolved for a domain.
  class SrvRecord
    # @private
    # @param j_del [::Vertx::SrvRecord] the java delegate
    def initialize(j_del)
      @j_del = j_del
    end
    # @private
    # @return [::Vertx::SrvRecord] the underlying java delegate
    def j_del
      @j_del
    end
    @@j_api_type = Object.new
    def @@j_api_type.accept?(obj)
      obj.class == SrvRecord
    end
    def @@j_api_type.wrap(obj)
      SrvRecord.new(obj)
    end
    def @@j_api_type.unwrap(obj)
      obj.j_del
    end
    def self.j_api_type
      @@j_api_type
    end
    def self.j_class
      Java::IoVertxCoreDns::SrvRecord.java_class
    end
    #  Returns the protocol for the service being queried (i.e. "_tcp").
    # @overload protocol()
    # @return [String]
    def protocol
      if !block_given?
        return @j_del.java_method(:protocol, []).call()
      end
      if defined?(super)
        super
      else
        raise ArgumentError, "Invalid arguments when calling protocol()"
      end
    end
    #  Returns the port the service is running on.
    # @overload port()
    # @return [Fixnum]
    def port
      if !block_given?
        return @j_del.java_method(:port, []).call()
      end
      if defined?(super)
        super
      else
        raise ArgumentError, "Invalid arguments when calling port()"
      end
    end
    #  Returns the service's name (i.e. "_http").
    # @overload service()
    # @return [String]
    def service
      if !block_given?
        return @j_del.java_method(:service, []).call()
      end
      if defined?(super)
        super
      else
        raise ArgumentError, "Invalid arguments when calling service()"
      end
    end
    #  Returns the name for the server being queried.
    # @overload name()
    # @return [String]
    def name
      if !block_given?
        return @j_del.java_method(:name, []).call()
      end
      if defined?(super)
        super
      else
        raise ArgumentError, "Invalid arguments when calling name()"
      end
    end
    #  Returns the weight of this service record.
    # @overload weight()
    # @return [Fixnum]
    def weight
      if !block_given?
        return @j_del.java_method(:weight, []).call()
      end
      if defined?(super)
        super
      else
        raise ArgumentError, "Invalid arguments when calling weight()"
      end
    end
    #  Returns the priority for this service record.
    # @overload priority()
    # @return [Fixnum]
    def priority
      if !block_given?
        return @j_del.java_method(:priority, []).call()
      end
      if defined?(super)
        super
      else
        raise ArgumentError, "Invalid arguments when calling priority()"
      end
    end
    #  Returns the name of the host for the service.
    # @overload target()
    # @return [String]
    def target
      if !block_given?
        return @j_del.java_method(:target, []).call()
      end
      if defined?(super)
        super
      else
        raise ArgumentError, "Invalid arguments when calling target()"
      end
    end
  end
end
