require 'vertx/datagram_socket'
require 'vertx/http_server'
require 'vertx/promise'
require 'vertx/context'
require 'vertx/future'
require 'vertx/shared_data'
require 'vertx/worker_executor'
require 'vertx/timeout_stream'
require 'vertx/dns_client'
require 'vertx/event_bus'
require 'vertx/measured'
require 'vertx/net_server'
require 'vertx/file_system'
require 'vertx/net_client'
require 'vertx/http_client'
require 'vertx/future'
require 'vertx/util/utils.rb'
# Generated from io.vertx.core.Vertx
module Vertx
  #  The entry point into the Vert.x Core API.
  #  <p>
  #  You use an instance of this class for functionality including:
  #  <ul>
  #    <li>Creating TCP clients and servers</li>
  #    <li>Creating HTTP clients and servers</li>
  #    <li>Creating DNS clients</li>
  #    <li>Creating Datagram sockets</li>
  #    <li>Setting and cancelling periodic and one-shot timers</li>
  #    <li>Getting a reference to the event bus API</li>
  #    <li>Getting a reference to the file system API</li>
  #    <li>Getting a reference to the shared data API</li>
  #    <li>Deploying and undeploying verticles</li>
  #  </ul>
  #  <p>
  #  Most functionality in Vert.x core is fairly low level.
  #  <p>
  #  To create an instance of this class you can use the static factory methods: {::Vertx::Vertx#vertx},
  #  {::Vertx::Vertx#vertx} and {::Vertx::Vertx#clustered_vertx}.
  #  <p>
  #  Please see the user manual for more detailed usage information.
  class Vertx
    include ::Vertx::Measured
    # @private
    # @param j_del [::Vertx::Vertx] the java delegate
    def initialize(j_del)
      @j_del = j_del
    end
    # @private
    # @return [::Vertx::Vertx] the underlying java delegate
    def j_del
      @j_del
    end
    @@j_api_type = Object.new
    def @@j_api_type.accept?(obj)
      obj.class == Vertx
    end
    def @@j_api_type.wrap(obj)
      Vertx.new(obj)
    end
    def @@j_api_type.unwrap(obj)
      obj.j_del
    end
    def self.j_api_type
      @@j_api_type
    end
    def self.j_class
      Java::IoVertxCore::Vertx.java_class
    end
    #  Create a TCP/SSL server using the specified options
    # @overload createNetServer()
    # @overload createNetServer(options)
    #   @param [Hash{String => Object}] options the options to use
    # @return [::Vertx::NetServer] the server
    def create_net_server(*args)
      if !block_given? && args[0] == nil
        return ::Vertx::Util::Utils.safe_create(@j_del.java_method(:createNetServer, []).call(),::Vertx::NetServer)
      elsif args[0].class == Hash && !block_given?
        return ::Vertx::Util::Utils.safe_create(@j_del.java_method(:createNetServer, [Java::IoVertxCoreNet::NetServerOptions.java_class]).call(Java::IoVertxCoreNet::NetServerOptions.new(::Vertx::Util::Utils.to_json_object(args[0]))),::Vertx::NetServer)
      end
      if defined?(super)
        super
      else
        raise ArgumentError, "Invalid arguments when calling create_net_server(#{args[0]})"
      end
    end
    #  Like {::Vertx::Vertx#deploy_verticle} but {Hash{String => Object}} are provided to configure the
    #  deployment.
    # @overload deployVerticle(name,completionHandler)
    #   @param [String] name The identifier
    #   @yield a handler which will be notified when the deployment is complete
    # @overload deployVerticle(name,options,completionHandler)
    #   @param [String] name the name
    #   @param [Hash{String => Object}] options the deployment options.
    #   @yield a handler which will be notified when the deployment is complete
    # @return [void]
    def deploy_verticle(*args)
      if args[0].class == String && true && args[1] == nil
        if (block_given?)
          return @j_del.java_method(:deployVerticle, [Java::java.lang.String.java_class,Java::IoVertxCore::Handler.java_class]).call(args[0],block_given? ? Proc.new { |ar| yield(ar.failed ? ar.cause : nil, ar.succeeded ? ar.result : nil) } : promise)
        else
          promise = ::Vertx::Util::Utils.promise
          @j_del.java_method(:deployVerticle, [Java::java.lang.String.java_class,Java::IoVertxCore::Handler.java_class]).call(args[0],block_given? ? Proc.new { |ar| yield(ar.failed ? ar.cause : nil, ar.succeeded ? ar.result : nil) } : promise)
          return ::Vertx::Util::Utils.safe_create(promise.future(),::Vertx::Future, nil)
        end
      elsif args[0].class == String && args[1].class == Hash && true
        if (block_given?)
          return @j_del.java_method(:deployVerticle, [Java::java.lang.String.java_class,Java::IoVertxCore::DeploymentOptions.java_class,Java::IoVertxCore::Handler.java_class]).call(args[0],Java::IoVertxCore::DeploymentOptions.new(::Vertx::Util::Utils.to_json_object(args[1])),block_given? ? Proc.new { |ar| yield(ar.failed ? ar.cause : nil, ar.succeeded ? ar.result : nil) } : promise)
        else
          promise = ::Vertx::Util::Utils.promise
          @j_del.java_method(:deployVerticle, [Java::java.lang.String.java_class,Java::IoVertxCore::DeploymentOptions.java_class,Java::IoVertxCore::Handler.java_class]).call(args[0],Java::IoVertxCore::DeploymentOptions.new(::Vertx::Util::Utils.to_json_object(args[1])),block_given? ? Proc.new { |ar| yield(ar.failed ? ar.cause : nil, ar.succeeded ? ar.result : nil) } : promise)
          return ::Vertx::Util::Utils.safe_create(promise.future(),::Vertx::Future, nil)
        end
      end
      if defined?(super)
        super
      else
        raise ArgumentError, "Invalid arguments when calling deploy_verticle(#{args[0]},#{args[1]})"
      end
    end
    #  Gets the current context
    # @overload currentContext()
    # @return [::Vertx::Context] The current context or null if no current context
    def self.current_context
      if !block_given?
        return ::Vertx::Util::Utils.safe_create(Java::IoVertxCore::Vertx.java_method(:currentContext, []).call(),::Vertx::Context)
      end
      if defined?(super)
        super
      else
        raise ArgumentError, "Invalid arguments when calling current_context()"
      end
    end
    #  Creates a non clustered instance using the specified options
    # @overload vertx()
    # @overload vertx(options)
    #   @param [Hash{String => Object}] options the options to use
    # @return [::Vertx::Vertx] the instance
    def self.vertx(*args)
      if !block_given? && args[0] == nil
        return ::Vertx::Util::Utils.safe_create(Java::IoVertxCore::Vertx.java_method(:vertx, []).call(),::Vertx::Vertx)
      elsif args[0].class == Hash && !block_given?
        return ::Vertx::Util::Utils.safe_create(Java::IoVertxCore::Vertx.java_method(:vertx, [Java::IoVertxCore::VertxOptions.java_class]).call(Java::IoVertxCore::VertxOptions.new(::Vertx::Util::Utils.to_json_object(args[0]))),::Vertx::Vertx)
      end
      if defined?(super)
        super
      else
        raise ArgumentError, "Invalid arguments when calling vertx(#{args[0]})"
      end
    end
    #  Get the event bus object. There is a single instance of EventBus per Vertx instance.
    # @overload eventBus()
    # @return [::Vertx::EventBus] the event bus object
    def event_bus
      if !block_given?
        if @cached_event_bus != nil
          return @cached_event_bus
        end
        return @cached_event_bus = ::Vertx::Util::Utils.safe_create(@j_del.java_method(:eventBus, []).call(),::Vertx::EventBus)
      end
      if defined?(super)
        super
      else
        raise ArgumentError, "Invalid arguments when calling event_bus()"
      end
    end
    #  Create an HTTP/HTTPS server using the specified options
    # @overload createHttpServer()
    # @overload createHttpServer(options)
    #   @param [Hash{String => Object}] options the options to use
    # @return [::Vertx::HttpServer] the server
    def create_http_server(*args)
      if !block_given? && args[0] == nil
        return ::Vertx::Util::Utils.safe_create(@j_del.java_method(:createHttpServer, []).call(),::Vertx::HttpServer)
      elsif args[0].class == Hash && !block_given?
        return ::Vertx::Util::Utils.safe_create(@j_del.java_method(:createHttpServer, [Java::IoVertxCoreHttp::HttpServerOptions.java_class]).call(Java::IoVertxCoreHttp::HttpServerOptions.new(::Vertx::Util::Utils.to_json_object(args[0]))),::Vertx::HttpServer)
      end
      if defined?(super)
        super
      else
        raise ArgumentError, "Invalid arguments when calling create_http_server(#{args[0]})"
      end
    end
    #  Create a TCP/SSL client using the specified options
    # @overload createNetClient()
    # @overload createNetClient(options)
    #   @param [Hash{String => Object}] options the options to use
    # @return [::Vertx::NetClient] the client
    def create_net_client(*args)
      if !block_given? && args[0] == nil
        return ::Vertx::Util::Utils.safe_create(@j_del.java_method(:createNetClient, []).call(),::Vertx::NetClient)
      elsif args[0].class == Hash && !block_given?
        return ::Vertx::Util::Utils.safe_create(@j_del.java_method(:createNetClient, [Java::IoVertxCoreNet::NetClientOptions.java_class]).call(Java::IoVertxCoreNet::NetClientOptions.new(::Vertx::Util::Utils.to_json_object(args[0]))),::Vertx::NetClient)
      end
      if defined?(super)
        super
      else
        raise ArgumentError, "Invalid arguments when calling create_net_client(#{args[0]})"
      end
    end
    #  Cancels the timer with the specified <code>id</code>.
    # @overload cancelTimer(id)
    #   @param [Fixnum] id The id of the timer to cancel
    # @return [true,false] true if the timer was successfully cancelled, or false if the timer does not exist.
    def cancel_timer?(*args)
      if args[0].class == Fixnum && !block_given?
        return @j_del.java_method(:cancelTimer, [Java::long.java_class]).call(args[0])
      end
      if defined?(super)
        super
      else
        raise ArgumentError, "Invalid arguments when calling cancel_timer?(#{args[0]})"
      end
    end
    #  Like {::Vertx::Vertx#close} but the completionHandler will be called when the close is complete
    # @overload close(completionHandler)
    #   @yield The handler will be notified when the close is complete.
    # @return [void]
    def close
      if true
        if (block_given?)
          return @j_del.java_method(:close, [Java::IoVertxCore::Handler.java_class]).call(block_given? ? Proc.new { |ar| yield(ar.failed ? ar.cause : nil, ar.succeeded ? nil : nil) } : promise)
        else
          promise = ::Vertx::Util::Utils.promise
          @j_del.java_method(:close, [Java::IoVertxCore::Handler.java_class]).call(block_given? ? Proc.new { |ar| yield(ar.failed ? ar.cause : nil, ar.succeeded ? nil : nil) } : promise)
          return ::Vertx::Util::Utils.safe_create(promise.future(),::Vertx::Future, nil)
        end
      end
      if defined?(super)
        super
      else
        raise ArgumentError, "Invalid arguments when calling close()"
      end
    end
    #  Return a Set of deployment IDs for the currently deployed deploymentIDs.
    # @overload deploymentIDs()
    # @return [Set<String>] Set of deployment IDs
    def deployment_i_ds
      if !block_given?
        return ::Vertx::Util::Utils.to_set(@j_del.java_method(:deploymentIDs, []).call()).map! { |elt| elt }
      end
      if defined?(super)
        super
      else
        raise ArgumentError, "Invalid arguments when calling deployment_i_ds()"
      end
    end
    #  Returns a one-shot timer as a read stream. The timer will be fired after <code>delay</code> milliseconds after
    #  the  has been called.
    # @overload timerStream(delay)
    #   @param [Fixnum] delay the delay in milliseconds, after which the timer will fire
    # @return [::Vertx::TimeoutStream] the timer stream
    def timer_stream(*args)
      if args[0].class == Fixnum && !block_given?
        return ::Vertx::Util::Utils.safe_create(@j_del.java_method(:timerStream, [Java::long.java_class]).call(args[0]),::Vertx::TimeoutStream)
      end
      if defined?(super)
        super
      else
        raise ArgumentError, "Invalid arguments when calling timer_stream(#{args[0]})"
      end
    end
    #  Whether the metrics are enabled for this measured object
    # @overload isMetricsEnabled()
    # @return [true,false] <code>true</code> if metrics are enabled
    def metrics_enabled?
      if !block_given?
        return @j_del.java_method(:isMetricsEnabled, []).call()
      end
      if defined?(super)
        super
      else
        raise ArgumentError, "Invalid arguments when calling metrics_enabled?()"
      end
    end
    #  Get the filesystem object. There is a single instance of FileSystem per Vertx instance.
    # @overload fileSystem()
    # @return [::Vertx::FileSystem] the filesystem object
    def file_system
      if !block_given?
        if @cached_file_system != nil
          return @cached_file_system
        end
        return @cached_file_system = ::Vertx::Util::Utils.safe_create(@j_del.java_method(:fileSystem, []).call(),::Vertx::FileSystem)
      end
      if defined?(super)
        super
      else
        raise ArgumentError, "Invalid arguments when calling file_system()"
      end
    end
    #  Creates a clustered instance using the specified options.
    #  <p>
    #  The instance is created asynchronously and the resultHandler is called with the result when it is ready.
    # @overload clusteredVertx(options,resultHandler)
    #   @param [Hash{String => Object}] options the options to use
    #   @yield the result handler that will receive the result
    # @return [void]
    def self.clustered_vertx(*args)
      if args[0].class == Hash && true
        if (block_given?)
          return Java::IoVertxCore::Vertx.java_method(:clusteredVertx, [Java::IoVertxCore::VertxOptions.java_class,Java::IoVertxCore::Handler.java_class]).call(Java::IoVertxCore::VertxOptions.new(::Vertx::Util::Utils.to_json_object(args[0])),block_given? ? Proc.new { |ar| yield(ar.failed ? ar.cause : nil, ar.succeeded ? ::Vertx::Util::Utils.safe_create(ar.result,::Vertx::Vertx) : nil) } : promise)
        else
          promise = ::Vertx::Util::Utils.promise
          Java::IoVertxCore::Vertx.java_method(:clusteredVertx, [Java::IoVertxCore::VertxOptions.java_class,Java::IoVertxCore::Handler.java_class]).call(Java::IoVertxCore::VertxOptions.new(::Vertx::Util::Utils.to_json_object(args[0])),block_given? ? Proc.new { |ar| yield(ar.failed ? ar.cause : nil, ar.succeeded ? ::Vertx::Util::Utils.safe_create(ar.result,::Vertx::Vertx) : nil) } : promise)
          return ::Vertx::Util::Utils.safe_create(promise.future(),::Vertx::Future,::Vertx::Vertx.j_api_type)
        end
      end
      if defined?(super)
        super
      else
        raise ArgumentError, "Invalid arguments when calling clustered_vertx(#{args[0]})"
      end
    end
    # @overload isNativeTransportEnabled()
    # @return [true,false] whether the native transport is used
    def native_transport_enabled?
      if !block_given?
        if @cached_is_native_transport_enabled != nil
          return @cached_is_native_transport_enabled
        end
        return @cached_is_native_transport_enabled = @j_del.java_method(:isNativeTransportEnabled, []).call()
      end
      if defined?(super)
        super
      else
        raise ArgumentError, "Invalid arguments when calling native_transport_enabled?()"
      end
    end
    #  Create a named worker executor, the executor should be closed when it's not needed anymore to release
    #  resources.<p/>
    # 
    #  This method can be called mutiple times with the same <code>name</code>. Executors with the same name will share
    #  the same worker pool. The worker pool size , max execute time and unit of max execute time are set when the worker pool is created and
    #  won't change after.<p>
    # 
    #  The worker pool is released when all the {::Vertx::WorkerExecutor} sharing the same name are closed.
    # @overload createSharedWorkerExecutor(name)
    #   @param [String] name 
    # @overload createSharedWorkerExecutor(name,poolSize)
    #   @param [String] name 
    #   @param [Fixnum] poolSize 
    # @overload createSharedWorkerExecutor(name,poolSize,maxExecuteTime)
    #   @param [String] name 
    #   @param [Fixnum] poolSize 
    #   @param [Fixnum] maxExecuteTime 
    # @overload createSharedWorkerExecutor(name,poolSize,maxExecuteTime,maxExecuteTimeUnit)
    #   @param [String] name the name of the worker executor
    #   @param [Fixnum] poolSize the size of the pool
    #   @param [Fixnum] maxExecuteTime the value of max worker execute time
    #   @param [:NANOSECONDS,:MICROSECONDS,:MILLISECONDS,:SECONDS,:MINUTES,:HOURS,:DAYS] maxExecuteTimeUnit the value of unit of max worker execute time
    # @return [::Vertx::WorkerExecutor] the named worker executor
    def create_shared_worker_executor(*args)
      if args[0].class == String && !block_given? && args[1] == nil && args[2] == nil && args[3] == nil
        return ::Vertx::Util::Utils.safe_create(@j_del.java_method(:createSharedWorkerExecutor, [Java::java.lang.String.java_class]).call(args[0]),::Vertx::WorkerExecutor)
      elsif args[0].class == String && args[1].class == Fixnum && !block_given? && args[2] == nil && args[3] == nil
        return ::Vertx::Util::Utils.safe_create(@j_del.java_method(:createSharedWorkerExecutor, [Java::java.lang.String.java_class,Java::int.java_class]).call(args[0],args[1]),::Vertx::WorkerExecutor)
      elsif args[0].class == String && args[1].class == Fixnum && args[2].class == Fixnum && !block_given? && args[3] == nil
        return ::Vertx::Util::Utils.safe_create(@j_del.java_method(:createSharedWorkerExecutor, [Java::java.lang.String.java_class,Java::int.java_class,Java::long.java_class]).call(args[0],args[1],args[2]),::Vertx::WorkerExecutor)
      elsif args[0].class == String && args[1].class == Fixnum && args[2].class == Fixnum && args[3].class == Symbol && !block_given?
        return ::Vertx::Util::Utils.safe_create(@j_del.java_method(:createSharedWorkerExecutor, [Java::java.lang.String.java_class,Java::int.java_class,Java::long.java_class,Java::JavaUtilConcurrent::TimeUnit.java_class]).call(args[0],args[1],args[2],Java::JavaUtilConcurrent::TimeUnit.valueOf(args[3].to_s)),::Vertx::WorkerExecutor)
      end
      if defined?(super)
        super
      else
        raise ArgumentError, "Invalid arguments when calling create_shared_worker_executor(#{args[0]},#{args[1]},#{args[2]},#{args[3]})"
      end
    end
    #  Create a HTTP/HTTPS client using the specified options
    # @overload createHttpClient()
    # @overload createHttpClient(options)
    #   @param [Hash{String => Object}] options the options to use
    # @return [::Vertx::HttpClient] the client
    def create_http_client(*args)
      if !block_given? && args[0] == nil
        return ::Vertx::Util::Utils.safe_create(@j_del.java_method(:createHttpClient, []).call(),::Vertx::HttpClient)
      elsif args[0].class == Hash && !block_given?
        return ::Vertx::Util::Utils.safe_create(@j_del.java_method(:createHttpClient, [Java::IoVertxCoreHttp::HttpClientOptions.java_class]).call(Java::IoVertxCoreHttp::HttpClientOptions.new(::Vertx::Util::Utils.to_json_object(args[0]))),::Vertx::HttpClient)
      end
      if defined?(super)
        super
      else
        raise ArgumentError, "Invalid arguments when calling create_http_client(#{args[0]})"
      end
    end
    #  Returns a periodic timer as a read stream. The timer will be fired every <code>delay</code> milliseconds after
    #  the  has been called.
    # @overload periodicStream(delay)
    #   @param [Fixnum] delay the delay in milliseconds, after which the timer will fire
    # @return [::Vertx::TimeoutStream] the periodic stream
    def periodic_stream(*args)
      if args[0].class == Fixnum && !block_given?
        return ::Vertx::Util::Utils.safe_create(@j_del.java_method(:periodicStream, [Java::long.java_class]).call(args[0]),::Vertx::TimeoutStream)
      end
      if defined?(super)
        super
      else
        raise ArgumentError, "Invalid arguments when calling periodic_stream(#{args[0]})"
      end
    end
    #  Get the shared data object. There is a single instance of SharedData per Vertx instance.
    # @overload sharedData()
    # @return [::Vertx::SharedData] the shared data object
    def shared_data
      if !block_given?
        if @cached_shared_data != nil
          return @cached_shared_data
        end
        return @cached_shared_data = ::Vertx::Util::Utils.safe_create(@j_del.java_method(:sharedData, []).call(),::Vertx::SharedData)
      end
      if defined?(super)
        super
      else
        raise ArgumentError, "Invalid arguments when calling shared_data()"
      end
    end
    #  Set a periodic timer to fire every <code>delay</code> milliseconds, at which point <code>handler</code> will be called with
    #  the id of the timer.
    # @overload setPeriodic(delay,handler)
    #   @param [Fixnum] delay the delay in milliseconds, after which the timer will fire
    #   @yield the handler that will be called with the timer ID when the timer fires
    # @return [Fixnum] the unique ID of the timer
    def set_periodic(*args)
      if args[0].class == Fixnum && true
        return @j_del.java_method(:setPeriodic, [Java::long.java_class,Java::IoVertxCore::Handler.java_class]).call(args[0],(Proc.new { |event| yield(event) unless !block_given? }))
      end
      if defined?(super)
        super
      else
        raise ArgumentError, "Invalid arguments when calling set_periodic(#{args[0]})"
      end
    end
    #  Is this Vert.x instance clustered?
    # @overload isClustered()
    # @return [true,false] true if clustered
    def clustered?
      if !block_given?
        return @j_del.java_method(:isClustered, []).call()
      end
      if defined?(super)
        super
      else
        raise ArgumentError, "Invalid arguments when calling clustered?()"
      end
    end
    #  Create a DNS client to connect to a DNS server at the specified host and port, with the default query timeout (5 seconds)
    #  <p/>
    # @overload createDnsClient()
    # @overload createDnsClient(options)
    #   @param [Hash{String => Object}] options the client options
    # @overload createDnsClient(port,host)
    #   @param [Fixnum] port the port
    #   @param [String] host the host
    # @return [::Vertx::DnsClient] the DNS client
    def create_dns_client(*args)
      if !block_given? && args[0] == nil && args[1] == nil
        return ::Vertx::Util::Utils.safe_create(@j_del.java_method(:createDnsClient, []).call(),::Vertx::DnsClient)
      elsif args[0].class == Hash && !block_given? && args[1] == nil
        return ::Vertx::Util::Utils.safe_create(@j_del.java_method(:createDnsClient, [Java::IoVertxCoreDns::DnsClientOptions.java_class]).call(Java::IoVertxCoreDns::DnsClientOptions.new(::Vertx::Util::Utils.to_json_object(args[0]))),::Vertx::DnsClient)
      elsif args[0].class == Fixnum && args[1].class == String && !block_given?
        return ::Vertx::Util::Utils.safe_create(@j_del.java_method(:createDnsClient, [Java::int.java_class,Java::java.lang.String.java_class]).call(args[0],args[1]),::Vertx::DnsClient)
      end
      if defined?(super)
        super
      else
        raise ArgumentError, "Invalid arguments when calling create_dns_client(#{args[0]},#{args[1]})"
      end
    end
    #  Puts the handler on the event queue for the current context so it will be run asynchronously ASAP after all
    #  preceeding events have been handled.
    # @overload runOnContext(action)
    #   @yield - a handler representing the action to execute
    # @return [void]
    def run_on_context
      if true
        return @j_del.java_method(:runOnContext, [Java::IoVertxCore::Handler.java_class]).call((Proc.new { |event| yield(nil) unless !block_given? }))
      end
      if defined?(super)
        super
      else
        raise ArgumentError, "Invalid arguments when calling run_on_context()"
      end
    end
    #  Safely execute some blocking code.
    #  <p>
    #  Executes the blocking code in the handler <code>blockingCodeHandler</code> using a thread from the worker pool.
    #  <p>
    #  When the code is complete the handler <code>resultHandler</code> will be called with the result on the original context
    #  (e.g. on the original event loop of the caller).
    #  <p>
    #  A <code>Future</code> instance is passed into <code>blockingCodeHandler</code>. When the blocking code successfully completes,
    #  the handler should call the {::Vertx::Promise#complete} or {::Vertx::Promise#complete} method, or the {::Vertx::Promise#fail}
    #  method if it failed.
    #  <p>
    #  In the <code>blockingCodeHandler</code> the current context remains the original context and therefore any task
    #  scheduled in the <code>blockingCodeHandler</code> will be executed on the this context and not on the worker thread.
    #  <p>
    #  The blocking code should block for a reasonable amount of time (i.e no more than a few seconds). Long blocking operations
    #  or polling operations (i.e a thread that spin in a loop polling events in a blocking fashion) are precluded.
    #  <p>
    #  When the blocking operation lasts more than the 10 seconds, a message will be printed on the console by the
    #  blocked thread checker.
    #  <p>
    #  Long blocking operations should use a dedicated thread managed by the application, which can interact with
    #  verticles using the event-bus or {::Vertx::Context#run_on_context}
    # @overload executeBlocking(blockingCodeHandler,resultHandler)
    #   @param [Proc] blockingCodeHandler 
    #   @yield 
    # @overload executeBlocking(blockingCodeHandler,ordered,resultHandler)
    #   @param [Proc] blockingCodeHandler handler representing the blocking code to run
    #   @param [true,false] ordered if true then if executeBlocking is called several times on the same context, the executions for that context will be executed serially, not in parallel. if false then they will be no ordering guarantees
    #   @yield handler that will be called when the blocking code is complete
    # @return [void]
    def execute_blocking(*args)
      if args[0].class == Proc && true && args[1] == nil
        if (block_given?)
          return @j_del.java_method(:executeBlocking, [Java::IoVertxCore::Handler.java_class,Java::IoVertxCore::Handler.java_class]).call((Proc.new { |event| args[0].call(::Vertx::Util::Utils.safe_create(event,::Vertx::Promise, nil)) unless args[0] == nil }),block_given? ? Proc.new { |ar| yield(ar.failed ? ar.cause : nil, ar.succeeded ? ::Vertx::Util::Utils.from_object(ar.result) : nil) } : promise)
        else
          promise = ::Vertx::Util::Utils.promise
          @j_del.java_method(:executeBlocking, [Java::IoVertxCore::Handler.java_class,Java::IoVertxCore::Handler.java_class]).call((Proc.new { |event| args[0].call(::Vertx::Util::Utils.safe_create(event,::Vertx::Promise, nil)) unless args[0] == nil }),block_given? ? Proc.new { |ar| yield(ar.failed ? ar.cause : nil, ar.succeeded ? ::Vertx::Util::Utils.from_object(ar.result) : nil) } : promise)
          return ::Vertx::Util::Utils.safe_create(promise.future(),::Vertx::Future, nil)
        end
      elsif args[0].class == Proc && (args[1].class == TrueClass || args[1].class == FalseClass) && true
        if (block_given?)
          return @j_del.java_method(:executeBlocking, [Java::IoVertxCore::Handler.java_class,Java::boolean.java_class,Java::IoVertxCore::Handler.java_class]).call((Proc.new { |event| args[0].call(::Vertx::Util::Utils.safe_create(event,::Vertx::Promise, nil)) unless args[0] == nil }),args[1],block_given? ? Proc.new { |ar| yield(ar.failed ? ar.cause : nil, ar.succeeded ? ::Vertx::Util::Utils.from_object(ar.result) : nil) } : promise)
        else
          promise = ::Vertx::Util::Utils.promise
          @j_del.java_method(:executeBlocking, [Java::IoVertxCore::Handler.java_class,Java::boolean.java_class,Java::IoVertxCore::Handler.java_class]).call((Proc.new { |event| args[0].call(::Vertx::Util::Utils.safe_create(event,::Vertx::Promise, nil)) unless args[0] == nil }),args[1],block_given? ? Proc.new { |ar| yield(ar.failed ? ar.cause : nil, ar.succeeded ? ::Vertx::Util::Utils.from_object(ar.result) : nil) } : promise)
          return ::Vertx::Util::Utils.safe_create(promise.future(),::Vertx::Future, nil)
        end
      end
      if defined?(super)
        super
      else
        raise ArgumentError, "Invalid arguments when calling execute_blocking(#{args[0]},#{args[1]})"
      end
    end
    #  Set a one-shot timer to fire after <code>delay</code> milliseconds, at which point <code>handler</code> will be called with
    #  the id of the timer.
    # @overload setTimer(delay,handler)
    #   @param [Fixnum] delay the delay in milliseconds, after which the timer will fire
    #   @yield the handler that will be called with the timer ID when the timer fires
    # @return [Fixnum] the unique ID of the timer
    def set_timer(*args)
      if args[0].class == Fixnum && true
        return @j_del.java_method(:setTimer, [Java::long.java_class,Java::IoVertxCore::Handler.java_class]).call(args[0],(Proc.new { |event| yield(event) unless !block_given? }))
      end
      if defined?(super)
        super
      else
        raise ArgumentError, "Invalid arguments when calling set_timer(#{args[0]})"
      end
    end
    #  Create a datagram socket using the specified options
    # @overload createDatagramSocket()
    # @overload createDatagramSocket(options)
    #   @param [Hash{String => Object}] options the options to use
    # @return [::Vertx::DatagramSocket] the socket
    def create_datagram_socket(*args)
      if !block_given? && args[0] == nil
        return ::Vertx::Util::Utils.safe_create(@j_del.java_method(:createDatagramSocket, []).call(),::Vertx::DatagramSocket)
      elsif args[0].class == Hash && !block_given?
        return ::Vertx::Util::Utils.safe_create(@j_del.java_method(:createDatagramSocket, [Java::IoVertxCoreDatagram::DatagramSocketOptions.java_class]).call(Java::IoVertxCoreDatagram::DatagramSocketOptions.new(::Vertx::Util::Utils.to_json_object(args[0]))),::Vertx::DatagramSocket)
      end
      if defined?(super)
        super
      else
        raise ArgumentError, "Invalid arguments when calling create_datagram_socket(#{args[0]})"
      end
    end
    #  Gets the current context, or creates one if there isn't one
    # @overload getOrCreateContext()
    # @return [::Vertx::Context] The current context (created if didn't exist)
    def get_or_create_context
      if !block_given?
        return ::Vertx::Util::Utils.safe_create(@j_del.java_method(:getOrCreateContext, []).call(),::Vertx::Context)
      end
      if defined?(super)
        super
      else
        raise ArgumentError, "Invalid arguments when calling get_or_create_context()"
      end
    end
    #  Set a default exception handler for {::Vertx::Context}, set on  at creation.
    # @overload exceptionHandler(handler)
    #   @yield the exception handler
    # @return [self]
    def exception_handler
      if true
        @j_del.java_method(:exceptionHandler, [Java::IoVertxCore::Handler.java_class]).call((Proc.new { |event| yield(::Vertx::Util::Utils.from_throwable(event)) unless !block_given? }))
        return self
      end
      if defined?(super)
        super
      else
        raise ArgumentError, "Invalid arguments when calling exception_handler()"
      end
    end
    #  Like {::Vertx::Vertx#undeploy(String)} but the completionHandler will be notified when the undeployment is complete.
    # @overload undeploy(deploymentID,completionHandler)
    #   @param [String] deploymentID the deployment ID
    #   @yield a handler which will be notified when the undeployment is complete
    # @return [void]
    def undeploy(*args)
      if args[0].class == String && true
        if (block_given?)
          return @j_del.java_method(:undeploy, [Java::java.lang.String.java_class,Java::IoVertxCore::Handler.java_class]).call(args[0],block_given? ? Proc.new { |ar| yield(ar.failed ? ar.cause : nil, ar.succeeded ? nil : nil) } : promise)
        else
          promise = ::Vertx::Util::Utils.promise
          @j_del.java_method(:undeploy, [Java::java.lang.String.java_class,Java::IoVertxCore::Handler.java_class]).call(args[0],block_given? ? Proc.new { |ar| yield(ar.failed ? ar.cause : nil, ar.succeeded ? nil : nil) } : promise)
          return ::Vertx::Util::Utils.safe_create(promise.future(),::Vertx::Future, nil)
        end
      end
      if defined?(super)
        super
      else
        raise ArgumentError, "Invalid arguments when calling undeploy(#{args[0]})"
      end
    end
  end
end
