/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.launcher.application;

import io.vertx.core.Verticle;
import io.vertx.core.Vertx;
import io.vertx.core.VertxBuilder;
import io.vertx.core.VertxOptions;
import io.vertx.launcher.application.HookContext;
import java.util.function.Supplier;

public interface VertxApplicationHooks {
    public static final VertxApplicationHooks DEFAULT = new VertxApplicationHooks(){};

    default public void beforeStartingVertx(HookContext context) {
    }

    default public VertxBuilder createVertxBuilder(VertxOptions options) {
        return Vertx.builder().with(options);
    }

    default public void afterVertxStarted(HookContext context) {
    }

    default public void afterFailureToStartVertx(HookContext context, Throwable t) {
    }

    default public Supplier<Verticle> verticleSupplier() {
        return null;
    }

    default public void beforeDeployingVerticle(HookContext context) {
    }

    default public void afterVerticleDeployed(HookContext context) {
    }

    default public void afterFailureToDeployVerticle(HookContext context, Throwable t) {
        context.vertx().close();
    }

    default public void beforeStoppingVertx(HookContext context) {
    }

    default public void afterVertxStopped(HookContext context) {
    }

    default public void afterFailureToStopVertx(HookContext context, Throwable t) {
    }
}

