/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.launcher.application.impl;

import io.vertx.core.VertxException;
import io.vertx.core.buffer.Buffer;
import io.vertx.core.internal.logging.Logger;
import io.vertx.core.json.DecodeException;
import io.vertx.core.json.JsonObject;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Method;
import java.net.URL;
import java.nio.file.Files;
import java.nio.file.InvalidPathException;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Arrays;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.jar.Attributes;
import java.util.jar.Manifest;

public class Utils {
    public static JsonObject readJsonFileOrString(Logger log, String optionName, String jsonFileOrString) {
        if (jsonFileOrString == null) {
            return null;
        }
        try {
            Path path = Paths.get(jsonFileOrString, new String[0]);
            byte[] bytes = Files.readAllBytes(path);
            return new JsonObject(Buffer.buffer((byte[])bytes));
        }
        catch (DecodeException | IOException | InvalidPathException throwable) {
            try {
                return new JsonObject(jsonFileOrString);
            }
            catch (DecodeException decodeException) {
                log.warn((Object)("The " + optionName + " option does not point to an valid JSON file or is not a valid JSON object."));
                return null;
            }
        }
    }

    public static void configureFromSystemProperties(Logger log, Object options, String prefix) {
        Properties props = System.getProperties();
        Enumeration<?> e = props.propertyNames();
        while (e.hasMoreElements()) {
            Object arg;
            Method setter;
            block11: {
                String propName = (String)e.nextElement();
                String propVal = props.getProperty(propName);
                if (!propName.startsWith(prefix)) continue;
                String fieldName = propName.substring(prefix.length());
                setter = Utils.getSetter(fieldName, options.getClass());
                if (setter == null) {
                    log.warn((Object)("No such property to configure on options: " + options.getClass().getName() + "." + fieldName));
                    continue;
                }
                Class<?> argType = setter.getParameterTypes()[0];
                try {
                    if (argType.equals(String.class)) {
                        arg = propVal;
                        break block11;
                    }
                    if (argType.equals(Integer.TYPE)) {
                        arg = Integer.valueOf(propVal);
                        break block11;
                    }
                    if (argType.equals(Long.TYPE)) {
                        arg = Long.valueOf(propVal);
                        break block11;
                    }
                    if (argType.equals(Boolean.TYPE)) {
                        arg = Boolean.valueOf(propVal);
                        break block11;
                    }
                    if (argType.isEnum()) {
                        arg = Enum.valueOf(argType, propVal);
                        break block11;
                    }
                    log.warn((Object)("Invalid type for setter: " + argType));
                }
                catch (IllegalArgumentException e2) {
                    log.warn((Object)("Invalid argtype:" + argType + " on options: " + options.getClass().getName() + "." + fieldName));
                }
                continue;
            }
            try {
                setter.invoke(options, arg);
            }
            catch (Exception ex) {
                throw new VertxException("Failed to invoke setter: " + setter, (Throwable)ex);
            }
        }
    }

    private static Method getSetter(String fieldName, Class<?> clazz) {
        Method[] meths;
        for (Method meth : meths = clazz.getDeclaredMethods()) {
            if (!("set" + fieldName).equalsIgnoreCase(meth.getName())) continue;
            return meth;
        }
        for (Method meth : meths = clazz.getMethods()) {
            if (!("set" + fieldName).equalsIgnoreCase(meth.getName())) continue;
            return meth;
        }
        return null;
    }

    public static String computeVerticleName(Class<?> mainClass, String mainVerticle) {
        Object verticleName;
        Map<String, String> manifestAttributes;
        List<String> attributeNames = Arrays.asList("Main-Verticle", "Default-Verticle-Factory");
        try {
            manifestAttributes = Utils.getAttributesFromManifest(mainClass, attributeNames);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        String mainVerticleAttribute = manifestAttributes.get("Main-Verticle");
        String defaultVerticleFactory = manifestAttributes.get("Default-Verticle-Factory");
        Object object = verticleName = mainVerticle != null ? mainVerticle : mainVerticleAttribute;
        if (defaultVerticleFactory != null && verticleName != null && ((String)verticleName).indexOf(58) == -1) {
            verticleName = defaultVerticleFactory + ":" + (String)verticleName;
        }
        return verticleName;
    }

    private static Map<String, String> getAttributesFromManifest(Class<?> mainClass, List<String> attributeNames) throws IOException {
        Enumeration<URL> resources = Utils.class.getClassLoader().getResources("META-INF/MANIFEST.MF");
        while (resources.hasMoreElements()) {
            InputStream stream = resources.nextElement().openStream();
            try {
                Manifest manifest = new Manifest(stream);
                Attributes attributes = manifest.getMainAttributes();
                String mainClassAttributeValue = attributes.getValue("Main-Class");
                if (!mainClass.getName().equals(mainClassAttributeValue)) continue;
                HashMap<String, String> map = new HashMap<String, String>();
                for (String attributeName : attributeNames) {
                    String attributeValue = attributes.getValue(attributeName);
                    if (attributeValue == null) continue;
                    map.put(attributeName, attributeValue);
                }
                Map map2 = Collections.unmodifiableMap(map);
                return map2;
            }
            finally {
                if (stream == null) continue;
                stream.close();
            }
        }
        return Collections.emptyMap();
    }

    private Utils() {
    }
}

