/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.launcher.application;

import io.vertx.core.internal.logging.Logger;
import io.vertx.core.internal.logging.LoggerFactory;
import io.vertx.launcher.application.VertxApplicationHooks;
import io.vertx.launcher.application.impl.CommandExceptionHandler;
import io.vertx.launcher.application.impl.VertxApplicationCommand;
import java.io.PrintStream;
import java.util.Objects;
import picocli.CommandLine;

public class VertxApplication {
    private static final Logger log = LoggerFactory.getLogger(VertxApplication.class);
    private final String[] args;
    private final VertxApplicationHooks hooks;
    private final boolean printUsageOnFailure;
    private final boolean exitOnFailure;

    public static void main(String[] args) {
        VertxApplication vertxApplication = new VertxApplication(args);
        vertxApplication.launch();
    }

    public VertxApplication(String[] args) {
        this(args, null);
    }

    public VertxApplication(String[] args, VertxApplicationHooks hooks) {
        this(args, hooks, true, true);
    }

    protected VertxApplication(String[] args, VertxApplicationHooks hooks, boolean printUsageOnFailure, boolean exitOnFailure) {
        this.args = Objects.requireNonNull(args);
        this.hooks = hooks == null ? (this instanceof VertxApplicationHooks ? (VertxApplicationHooks)((Object)this) : VertxApplicationHooks.DEFAULT) : hooks;
        this.printUsageOnFailure = printUsageOnFailure;
        this.exitOnFailure = exitOnFailure;
    }

    public int launch() {
        VertxApplicationCommand command = new VertxApplicationCommand(this, Objects.requireNonNull(this.hooks), log);
        CommandLine commandLine = new CommandLine((Object)command).setOptionsCaseInsensitive(true).setExecutionExceptionHandler((CommandLine.IExecutionExceptionHandler)new CommandExceptionHandler());
        int exitCode = commandLine.execute(this.args);
        if (exitCode == 2) {
            if (this.printUsageOnFailure) {
                CommandLine.usage((Object)command, (PrintStream)System.out, (CommandLine.Help.Ansi)CommandLine.Help.Ansi.ON);
            }
            if (this.exitOnFailure) {
                System.exit(exitCode);
            }
        }
        return exitCode;
    }
}

