/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.launcher.application.impl;

import io.vertx.core.AsyncResult;
import io.vertx.core.DeploymentOptions;
import io.vertx.core.Future;
import io.vertx.core.Promise;
import io.vertx.core.ThreadingModel;
import io.vertx.core.Verticle;
import io.vertx.core.Vertx;
import io.vertx.core.VertxBuilder;
import io.vertx.core.VertxOptions;
import io.vertx.core.eventbus.EventBusOptions;
import io.vertx.core.impl.ServiceHelper;
import io.vertx.core.internal.VertxInternal;
import io.vertx.core.internal.logging.Logger;
import io.vertx.core.json.JsonObject;
import io.vertx.core.metrics.MetricsOptions;
import io.vertx.core.spi.VertxMetricsFactory;
import io.vertx.core.spi.VertxServiceProvider;
import io.vertx.core.spi.VertxTracerFactory;
import io.vertx.core.tracing.TracingOptions;
import io.vertx.launcher.application.VertxApplication;
import io.vertx.launcher.application.VertxApplicationHooks;
import io.vertx.launcher.application.impl.CommandException;
import io.vertx.launcher.application.impl.FailureHook;
import io.vertx.launcher.application.impl.HookContextImpl;
import io.vertx.launcher.application.impl.ShutdownHook;
import io.vertx.launcher.application.impl.Utils;
import java.time.Duration;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import picocli.CommandLine;

@CommandLine.Command(name="VertxApplication", description={"Runs a Vert.x application."}, sortOptions=false)
public class VertxApplicationCommand
implements Runnable {
    private static final String VERTX_OPTIONS_PROP_PREFIX = "vertx.options.";
    private static final String VERTX_EVENTBUS_PROP_PREFIX = "vertx.eventBus.options.";
    private static final String DEPLOYMENT_OPTIONS_PROP_PREFIX = "vertx.deployment.options.";
    private static final String METRICS_OPTIONS_PROP_PREFIX = "vertx.metrics.options.";
    @CommandLine.Option(names={"-options", "--options", "-vertx-options", "--vertx-options"}, description={"Specifies the Vert.x options.", "It should reference either a JSON file which represents the options OR be a JSON string."}, defaultValue="_NULL_")
    private String vertxOptionsStr;
    @CommandLine.Option(names={"-c", "-cluster", "--cluster"}, description={"If specified, then the Vert.x instance will form a cluster with any other Vert.x instances on the network."}, arity="0")
    private Boolean clustered;
    @CommandLine.Option(names={"-cluster-port", "--cluster-port"}, description={"Port to use for cluster communication.", "By default, a spare random port is chosen."})
    private Integer clusterPort;
    @CommandLine.Option(names={"-cluster-host", "--cluster-host"}, description={"Host to bind to for cluster communication.", "If this is not specified, Vert.x will attempt to choose one from the available interfaces."})
    private String clusterHost;
    @CommandLine.Option(names={"-cluster-public-port", "--cluster-public-port"}, description={"Public port to use for cluster communication.", "By default, Vert.x uses the same as the cluster port."})
    private Integer clusterPublicPort;
    @CommandLine.Option(names={"-cluster-public-host", "--cluster-public-host"}, description={"Public host to bind to for cluster communication.", "By default, Vert.x uses the same as the cluster host."})
    private String clusterPublicHost;
    @CommandLine.Option(names={"-deployment-options", "--deployment-options"}, description={"Specifies the main verticle deployment options."})
    private String deploymentOptionsStr;
    @CommandLine.Option(names={"-w", "-worker", "--worker"}, description={"If specified, then the main verticle is deployed with the worker threading model.", "Takes precedence over the value defined in deployment options."}, arity="0")
    private Boolean worker;
    @CommandLine.Option(names={"-vt", "-virtual-thread", "--virtual-thread"}, description={"If specified, then the main verticle is deployed with the virtual thread threading model.", "Takes precedence over the value defined in deployment options."}, arity="0")
    private Boolean virtualThread;
    @CommandLine.Option(names={"-instances", "--instances"}, description={"Specifies how many instances of the verticle will be deployed.", "Takes precedence over the value defined in deployment options."})
    private Integer instances;
    @CommandLine.Option(names={"-conf", "--conf"}, description={"Specifies configuration that should be provided to the verticle.", "It should reference either a JSON file which represents the options OR be a JSON string."})
    private String configStr;
    @CommandLine.Option(names={"-h", "-help", "--help"}, usageHelp=true, description={"Display a help message."}, arity="0")
    private boolean helpRequested;
    @CommandLine.Parameters(index="0", description={"The main verticle fully qualified class name."}, defaultValue="_NULL_")
    private String mainVerticle;
    private final VertxApplication vertxApplication;
    private final VertxApplicationHooks hooks;
    private final Logger log;
    private final HookContextImpl hookContext = new HookContextImpl();
    private volatile VertxInternal vertx;

    public VertxApplicationCommand(VertxApplication vertxApplication, VertxApplicationHooks hooks, Logger log) {
        this.vertxApplication = vertxApplication;
        this.hooks = hooks;
        this.log = log;
    }

    @Override
    public void run() {
        Supplier deployer;
        JsonObject optionsJson = Utils.readJsonFileOrString(this.log, "options", this.vertxOptionsStr);
        VertxOptions options = optionsJson != null ? new VertxOptions(optionsJson) : new VertxOptions();
        VertxBuilder builder = this.hooks.createVertxBuilder(options);
        this.processVertxOptions(options, optionsJson);
        this.hookContext.setVertxOptions(options);
        this.hooks.beforeStartingVertx(this.hookContext);
        this.vertx = (VertxInternal)this.withTCCLAwait(() -> this.createVertx(builder), Duration.ofMinutes(2L), "startup", VertxApplicationHooks::afterFailureToStartVertx, 11);
        this.hookContext.setVertx((Vertx)this.vertx);
        this.hooks.afterVertxStarted(this.hookContext);
        this.vertx.addCloseHook(this::beforeStoppingVertx);
        Runtime.getRuntime().addShutdownHook(new Thread(new ShutdownHook((Vertx)this.vertx, this::afterShutdownHookExecuted)));
        DeploymentOptions deploymentOptions = this.createDeploymentOptions();
        Supplier<Verticle> verticleSupplier = this.hooks.verticleSupplier();
        if (verticleSupplier == null) {
            String verticleName = Utils.computeVerticleName(this.vertxApplication.getClass(), this.mainVerticle);
            if (verticleName == null) {
                this.log.error((Object)"If the <mainVerticle> parameter is not provided, the 'Main-Verticle' manifest attribute must be provided.");
                throw new CommandException(15);
            }
            deployer = () -> this.vertx.deployVerticle(verticleName, deploymentOptions);
            this.hookContext.readyToDeploy(verticleName, deploymentOptions);
        } else {
            deployer = () -> this.vertx.deployVerticle(verticleSupplier, deploymentOptions);
            this.hookContext.readyToDeploy(null, deploymentOptions);
        }
        this.hooks.beforeDeployingVerticle(this.hookContext);
        String message = this.hookContext.deploymentOptions().getThreadingModel() == ThreadingModel.WORKER ? "deploying worker verticle" : "deploying verticle";
        String deploymentId = (String)this.withTCCLAwait(deployer, Duration.ofMinutes(2L), message, VertxApplicationHooks::afterFailureToDeployVerticle, 15);
        this.log.info((Object)("Succeeded in " + message));
        this.hookContext.setDeploymentId(deploymentId);
        this.hooks.afterVerticleDeployed(this.hookContext);
    }

    private void processVertxOptions(VertxOptions vertxOptions, JsonObject optionsJson) {
        VertxTracerFactory tracerFactory;
        if (this.clustered == Boolean.TRUE) {
            EventBusOptions eventBusOptions = vertxOptions.getEventBusOptions();
            if (this.clusterHost != null) {
                eventBusOptions.setHost(this.clusterHost);
            }
            if (this.clusterPort != null) {
                eventBusOptions.setPort(this.clusterPort.intValue());
            }
            if (this.clusterPublicHost != null) {
                eventBusOptions.setClusterPublicHost(this.clusterPublicHost);
            }
            if (this.clusterPublicPort != null) {
                eventBusOptions.setClusterPublicPort(this.clusterPublicPort.intValue());
            }
            Utils.configureFromSystemProperties(this.log, eventBusOptions, VERTX_EVENTBUS_PROP_PREFIX);
        }
        Utils.configureFromSystemProperties(this.log, vertxOptions, VERTX_OPTIONS_PROP_PREFIX);
        VertxMetricsFactory metricsFactory = this.findServiceProvider(VertxMetricsFactory.class);
        if (metricsFactory != null) {
            MetricsOptions metricsOptions;
            metricsOptions = optionsJson != null && optionsJson.containsKey("metricsOptions") ? metricsFactory.newOptions(optionsJson.getJsonObject("metricsOptions")) : ((metricsOptions = vertxOptions.getMetricsOptions()) == null ? metricsFactory.newOptions() : metricsFactory.newOptions(metricsOptions));
            Utils.configureFromSystemProperties(this.log, metricsOptions, METRICS_OPTIONS_PROP_PREFIX);
            vertxOptions.setMetricsOptions(metricsOptions);
        }
        if ((tracerFactory = this.findServiceProvider(VertxTracerFactory.class)) != null && optionsJson != null && optionsJson.containsKey("tracingOptions")) {
            TracingOptions tracingOptions = tracerFactory.newOptions(optionsJson.getJsonObject("tracingOptions"));
            vertxOptions.setTracingOptions(tracingOptions);
        }
    }

    private <SP> SP findServiceProvider(Class<SP> serviceProviderClass) {
        List serviceProviders = ServiceHelper.loadFactories(VertxServiceProvider.class).stream().filter(vertxServiceProvider -> serviceProviderClass.isAssignableFrom(vertxServiceProvider.getClass())).map(serviceProviderClass::cast).collect(Collectors.toList());
        if (serviceProviders.size() == 0) {
            return null;
        }
        if (serviceProviders.size() != 1) {
            this.log.warn((Object)("Cannot convert options, there are several implementations of " + serviceProviderClass));
            return null;
        }
        return (SP)serviceProviders.get(0);
    }

    private DeploymentOptions createDeploymentOptions() {
        JsonObject conf;
        DeploymentOptions deploymentOptions;
        JsonObject deploymentOptionsJson = Utils.readJsonFileOrString(this.log, "deploymentOptions", this.deploymentOptionsStr);
        DeploymentOptions deploymentOptions2 = deploymentOptions = deploymentOptionsJson != null ? new DeploymentOptions(deploymentOptionsJson) : new DeploymentOptions();
        if (this.worker == Boolean.TRUE) {
            if (this.virtualThread == Boolean.TRUE) {
                this.log.error((Object)"Cannot choose the threading model, the virtual thread and worker options are both set.");
                throw new CommandException(15);
            }
            deploymentOptions.setThreadingModel(ThreadingModel.WORKER);
        } else if (this.virtualThread == Boolean.TRUE) {
            deploymentOptions.setThreadingModel(ThreadingModel.VIRTUAL_THREAD);
        }
        if (this.instances != null) {
            deploymentOptions.setInstances(this.instances.intValue());
        }
        if ((conf = Utils.readJsonFileOrString(this.log, "conf", this.configStr)) == null) {
            conf = new JsonObject();
        }
        deploymentOptions.setConfig(conf);
        Utils.configureFromSystemProperties(this.log, deploymentOptions, DEPLOYMENT_OPTIONS_PROP_PREFIX);
        return deploymentOptions;
    }

    private Future<Vertx> createVertx(VertxBuilder builder) {
        try {
            if (this.clustered == Boolean.TRUE) {
                this.log.info((Object)"Starting clustering...");
                return builder.buildClustered().onFailure(t -> this.log.error((Object)"Failed to form cluster", t));
            }
            return Future.succeededFuture((Object)builder.build());
        }
        catch (Exception e) {
            this.log.error((Object)"Failed to create the Vert.x instance", (Throwable)e);
            return Future.failedFuture((Throwable)e);
        }
    }

    private <T> T withTCCLAwait(Supplier<Future<T>> supplier, Duration duration, String logMessage, FailureHook failureHook, int exitCode) {
        ClassLoader originalClassLoader = Thread.currentThread().getContextClassLoader();
        try {
            CompletableFuture future = supplier.get().toCompletionStage().toCompletableFuture();
            Object t = future.get(duration.toMillis(), TimeUnit.MILLISECONDS);
            return t;
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            this.log.error((Object)("Thread interrupted in " + logMessage));
            failureHook.invokeHook(this.hooks, this.hookContext, e);
            throw new CommandException(exitCode);
        }
        catch (ExecutionException e) {
            Throwable cause = e.getCause();
            failureHook.invokeHook(this.hooks, this.hookContext, cause);
            this.log.error((Object)("Failed in " + logMessage), cause);
            throw new CommandException(exitCode);
        }
        catch (TimeoutException e) {
            this.log.error((Object)("Timed out in " + logMessage));
            failureHook.invokeHook(this.hooks, this.hookContext, null);
            throw new CommandException(exitCode);
        }
        finally {
            Thread.currentThread().setContextClassLoader(originalClassLoader);
        }
    }

    private void beforeStoppingVertx(Promise<Void> promise) {
        try {
            this.hooks.beforeStoppingVertx(this.hookContext);
            promise.complete();
        }
        catch (Exception e) {
            promise.fail((Throwable)e);
        }
    }

    private void afterShutdownHookExecuted(AsyncResult<Void> ar) {
        if (ar == null) {
            this.log.error((Object)"Timed out waiting for Vert.x to be closed");
            this.hooks.afterFailureToStopVertx(this.hookContext, null);
        } else if (ar.failed()) {
            this.log.error((Object)"Failure in stopping Vert.x", ar.cause());
            this.hooks.afterFailureToStopVertx(this.hookContext, ar.cause());
        } else {
            this.hooks.afterVertxStopped(this.hookContext);
        }
    }
}

