/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.core.impl.launcher.commands;

import io.vertx.core.AsyncResult;
import io.vertx.core.Vertx;
import io.vertx.core.VertxBuilder;
import io.vertx.core.VertxException;
import io.vertx.core.VertxOptions;
import io.vertx.core.cli.annotations.DefaultValue;
import io.vertx.core.cli.annotations.Description;
import io.vertx.core.cli.annotations.Name;
import io.vertx.core.cli.annotations.Option;
import io.vertx.core.cli.annotations.Summary;
import io.vertx.core.eventbus.EventBusOptions;
import io.vertx.core.eventbus.impl.clustered.ClusteredEventBus;
import io.vertx.core.impl.ServiceHelper;
import io.vertx.core.impl.launcher.VertxLifecycleHooks;
import io.vertx.core.impl.launcher.commands.ClasspathHandler;
import io.vertx.core.internal.logging.Logger;
import io.vertx.core.json.DecodeException;
import io.vertx.core.json.JsonObject;
import io.vertx.core.metrics.MetricsOptions;
import io.vertx.core.spi.VertxMetricsFactory;
import io.vertx.core.spi.VertxServiceProvider;
import io.vertx.core.spi.VertxTracerFactory;
import io.vertx.core.spi.launcher.ExecutionContext;
import io.vertx.core.tracing.TracingOptions;
import java.io.File;
import java.io.FileNotFoundException;
import java.lang.reflect.Method;
import java.util.Enumeration;
import java.util.List;
import java.util.Objects;
import java.util.Properties;
import java.util.Scanner;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Supplier;
import java.util.stream.Collectors;

@Summary(value="Creates a bare instance of vert.x.")
@Description(value="This command launches a vert.x instance but do not deploy any verticles. It will receive a verticle if another node of the cluster dies.")
@Name(value="bare")
public class BareCommand
extends ClasspathHandler {
    public static final String VERTX_OPTIONS_PROP_PREFIX = "vertx.options.";
    public static final String VERTX_EVENTBUS_PROP_PREFIX = "vertx.eventBus.options.";
    public static final String DEPLOYMENT_OPTIONS_PROP_PREFIX = "vertx.deployment.options.";
    public static final String METRICS_OPTIONS_PROP_PREFIX = "vertx.metrics.options.";
    protected Vertx vertx;
    protected int clusterPort;
    protected String clusterHost;
    protected int clusterPublicPort;
    protected String clusterPublicHost;
    protected int quorum;
    protected String haGroup;
    protected String vertxOptions;
    protected VertxOptions options;
    protected Runnable finalAction;
    private static final ThreadLocal<Logger> configureFromSystemProperties = new ThreadLocal();

    @Option(longName="quorum", argName="q")
    @Description(value="Used in conjunction with -ha this specifies the minimum number of nodes in the cluster for any HA deploymentIDs to be active. Defaults to 1.")
    @DefaultValue(value="-1")
    public void setQuorum(int quorum) {
        this.quorum = quorum;
    }

    @Option(longName="hagroup", argName="group")
    @Description(value="used in conjunction with -ha this specifies the HA group this node will join. There can be multiple HA groups in a cluster. Nodes will only failover to other nodes in the same group. Defaults to '__DEFAULT__'.")
    @DefaultValue(value="__DEFAULT__")
    public void setHAGroup(String group) {
        this.haGroup = group;
    }

    @Option(longName="cluster-port", argName="port")
    @Description(value="Port to use for cluster communication. Default is 0 which means choose a spare random port.")
    @DefaultValue(value="0")
    public void setClusterPort(int port) {
        this.clusterPort = port;
    }

    @Option(longName="cluster-host", argName="host")
    @Description(value="host to bind to for cluster communication. If this is not specified vert.x will attempt to choose one from the available interfaces.")
    public void setClusterHost(String host) {
        this.clusterHost = host;
    }

    @Option(longName="cluster-public-port", argName="public-port")
    @Description(value="Public port to use for cluster communication. Default is -1 which means same as cluster port.")
    @DefaultValue(value="-1")
    public void setClusterPublicPort(int port) {
        this.clusterPublicPort = port;
    }

    @Option(longName="cluster-public-host", argName="public-host")
    @Description(value="Public host to bind to for cluster communication. If not specified, Vert.x will use the same as cluster host.")
    public void setClusterPublicHost(String host) {
        this.clusterPublicHost = host;
    }

    @Option(longName="options", argName="options")
    @Description(value="Specifies the Vert.x options. It should reference either a JSON file which represents the options OR be a JSON string.")
    public void setVertxOptions(String vertxOptions) {
        this.vertxOptions = vertxOptions != null ? vertxOptions.trim().replaceAll("^\"|\"$", "").replaceAll("^'|'$", "") : null;
    }

    public boolean isClustered() {
        return true;
    }

    public boolean getHA() {
        return true;
    }

    @Override
    public void run() {
        this.run(null);
    }

    public void run(Runnable action) {
        this.finalAction = action;
        this.vertx = this.startVertx();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Vertx startVertx() {
        Vertx instance;
        VertxTracerFactory tracerFactory;
        EventBusOptions eventBusOptions;
        JsonObject optionsJson = this.getJsonFromFileOrString(this.vertxOptions, "options");
        if (optionsJson == null) {
            this.options = new VertxOptions();
            eventBusOptions = this.getEventBusOptions();
        } else {
            this.options = new VertxOptions(optionsJson);
            eventBusOptions = this.getEventBusOptions(optionsJson.getJsonObject("eventBusOptions"));
        }
        this.options.setEventBusOptions(eventBusOptions);
        VertxMetricsFactory metricsFactory = this.findServiceProvider(VertxMetricsFactory.class);
        if (metricsFactory != null) {
            MetricsOptions metricsOptions;
            metricsOptions = optionsJson != null && optionsJson.containsKey("metricsOptions") ? metricsFactory.newOptions(optionsJson.getJsonObject("metricsOptions")) : ((metricsOptions = this.options.getMetricsOptions()) == null ? metricsFactory.newOptions() : metricsFactory.newOptions(metricsOptions));
            configureFromSystemProperties.set(this.log);
            try {
                BareCommand.configureFromSystemProperties(metricsOptions, METRICS_OPTIONS_PROP_PREFIX);
            }
            finally {
                configureFromSystemProperties.set(null);
            }
            this.options.setMetricsOptions(metricsOptions);
        }
        if ((tracerFactory = this.findServiceProvider(VertxTracerFactory.class)) != null && optionsJson != null && optionsJson.containsKey("tracingOptions")) {
            TracingOptions tracingOptions = tracerFactory.newOptions(optionsJson.getJsonObject("tracingOptions"));
            this.options.setTracingOptions(tracingOptions);
        }
        this.beforeStartingVertx(this.options);
        VertxBuilder builder = this.createVertxBuilder(this.options);
        if (metricsFactory != null) {
            builder.withMetrics(metricsFactory);
        }
        if (this.isClustered()) {
            this.log.info((Object)"Starting clustering...");
            eventBusOptions = this.options.getEventBusOptions();
            if (!Objects.equals(eventBusOptions.getHost(), EventBusOptions.DEFAULT_CLUSTER_HOST)) {
                this.clusterHost = eventBusOptions.getHost();
            }
            if (eventBusOptions.getPort() != 0) {
                this.clusterPort = eventBusOptions.getPort();
            }
            if (!Objects.equals(eventBusOptions.getClusterPublicHost(), EventBusOptions.DEFAULT_CLUSTER_PUBLIC_HOST)) {
                this.clusterPublicHost = eventBusOptions.getClusterPublicHost();
            }
            if (eventBusOptions.getClusterPublicPort() != -1) {
                this.clusterPublicPort = eventBusOptions.getClusterPublicPort();
            }
            eventBusOptions.setHost(this.clusterHost).setPort(this.clusterPort).setClusterPublicHost(this.clusterPublicHost);
            if (this.clusterPublicPort != -1) {
                eventBusOptions.setClusterPublicPort(this.clusterPublicPort);
            }
            if (this.getHA()) {
                this.options.setHAEnabled(true);
                if (this.haGroup != null) {
                    this.options.setHAGroup(this.haGroup);
                }
                if (this.quorum != -1) {
                    this.options.setQuorumSize(this.quorum);
                }
            }
            AtomicReference result = new AtomicReference();
            CountDownLatch latch = new CountDownLatch(1);
            this.configureFromSystemProperties(this.options, () -> {
                this.createClustered(builder).onComplete(ar -> {
                    result.set(ar);
                    latch.countDown();
                });
                return null;
            });
            try {
                if (!latch.await(2L, TimeUnit.MINUTES)) {
                    this.log.error((Object)"Timed out in starting clustered Vert.x");
                    return null;
                }
            }
            catch (InterruptedException e) {
                this.log.error((Object)"Thread interrupted in startup");
                Thread.currentThread().interrupt();
                return null;
            }
            if (((AsyncResult)result.get()).failed()) {
                this.log.error((Object)"Failed to form cluster", ((AsyncResult)result.get()).cause());
                return null;
            }
            instance = (Vertx)((AsyncResult)result.get()).result();
        } else {
            instance = this.configureFromSystemProperties(this.options, () -> this.create(builder));
        }
        BareCommand.addShutdownHook(instance, this.log, this.finalAction);
        this.afterStartingVertx(instance);
        return instance;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private <T> T configureFromSystemProperties(VertxOptions options, Supplier<T> callback) {
        configureFromSystemProperties.set(this.log);
        try {
            BareCommand.configureFromSystemProperties(options, VERTX_OPTIONS_PROP_PREFIX);
            if (options.getMetricsOptions() != null) {
                BareCommand.configureFromSystemProperties(options.getMetricsOptions(), METRICS_OPTIONS_PROP_PREFIX);
            }
            T t = callback.get();
            return t;
        }
        finally {
            configureFromSystemProperties.set(null);
        }
    }

    private <SP> SP findServiceProvider(Class<SP> serviceProviderClass) {
        List serviceProviders = ServiceHelper.loadFactories(VertxServiceProvider.class).stream().filter(vertxServiceProvider -> serviceProviderClass.isAssignableFrom(vertxServiceProvider.getClass())).map(serviceProviderClass::cast).collect(Collectors.toList());
        if (serviceProviders.size() == 0) {
            return null;
        }
        if (serviceProviders.size() != 1) {
            this.log.warn((Object)("Cannot convert options, there are several implementations of " + serviceProviderClass));
            return null;
        }
        return (SP)serviceProviders.get(0);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected JsonObject getJsonFromFileOrString(String jsonFileOrString, String argName) {
        if (jsonFileOrString == null) {
            return null;
        }
        try (Scanner scanner = new Scanner(new File(jsonFileOrString), "UTF-8").useDelimiter("\\A");){
            String sconf2 = scanner.next();
            try {
                JsonObject conf = new JsonObject(sconf2);
                return conf;
            }
            catch (DecodeException e) {
                this.log.error((Object)("Configuration file " + sconf2 + " does not contain a valid JSON object"));
                JsonObject jsonObject = null;
                if (scanner == null) return jsonObject;
                scanner.close();
                return jsonObject;
            }
        }
        catch (FileNotFoundException e) {
            try {
                return new JsonObject(jsonFileOrString);
            }
            catch (DecodeException e2) {
                this.log.error((Object)("The -" + argName + " argument does not point to an existing file or is not a valid JSON object"), (Throwable)e2);
                return null;
            }
        }
    }

    protected void afterStartingVertx(Vertx instance) {
        Object main = this.executionContext.main();
        if (main instanceof VertxLifecycleHooks) {
            ((VertxLifecycleHooks)main).afterStartingVertx(instance);
        }
    }

    protected void beforeStartingVertx(VertxOptions options) {
        Object main = this.executionContext.main();
        if (main instanceof VertxLifecycleHooks) {
            ((VertxLifecycleHooks)main).beforeStartingVertx(options);
        }
    }

    protected VertxBuilder createVertxBuilder(VertxOptions options) {
        Object main = this.executionContext.main();
        if (main instanceof VertxLifecycleHooks) {
            return ((VertxLifecycleHooks)main).createVertxBuilder(options);
        }
        return Vertx.builder().with(options);
    }

    protected EventBusOptions getEventBusOptions() {
        return this.getEventBusOptions(null);
    }

    protected EventBusOptions getEventBusOptions(JsonObject jsonObject) {
        EventBusOptions eventBusOptions = jsonObject == null ? new EventBusOptions() : new EventBusOptions(jsonObject);
        configureFromSystemProperties.set(this.log);
        try {
            BareCommand.configureFromSystemProperties(eventBusOptions, VERTX_EVENTBUS_PROP_PREFIX);
        }
        finally {
            configureFromSystemProperties.set(null);
        }
        return eventBusOptions;
    }

    public static void configureFromSystemProperties(Object options, String prefix) {
        Logger log = configureFromSystemProperties.get();
        if (log == null) {
            return;
        }
        Properties props = System.getProperties();
        Enumeration<?> e = props.propertyNames();
        while (e.hasMoreElements()) {
            Object arg;
            Method setter;
            block12: {
                String propName = (String)e.nextElement();
                String propVal = props.getProperty(propName);
                if (!propName.startsWith(prefix)) continue;
                String fieldName = propName.substring(prefix.length());
                setter = BareCommand.getSetter(fieldName, options.getClass());
                if (setter == null) {
                    log.warn((Object)("No such property to configure on options: " + options.getClass().getName() + "." + fieldName));
                    continue;
                }
                Class<?> argType = setter.getParameterTypes()[0];
                try {
                    if (argType.equals(String.class)) {
                        arg = propVal;
                        break block12;
                    }
                    if (argType.equals(Integer.TYPE)) {
                        arg = Integer.valueOf(propVal);
                        break block12;
                    }
                    if (argType.equals(Long.TYPE)) {
                        arg = Long.valueOf(propVal);
                        break block12;
                    }
                    if (argType.equals(Boolean.TYPE)) {
                        arg = Boolean.valueOf(propVal);
                        break block12;
                    }
                    if (argType.isEnum()) {
                        arg = Enum.valueOf(argType, propVal);
                        break block12;
                    }
                    log.warn((Object)("Invalid type for setter: " + argType));
                }
                catch (IllegalArgumentException e2) {
                    log.warn((Object)("Invalid argtype:" + argType + " on options: " + options.getClass().getName() + "." + fieldName));
                }
                continue;
            }
            try {
                setter.invoke(options, arg);
            }
            catch (Exception ex) {
                throw new VertxException("Failed to invoke setter: " + setter, (Throwable)ex);
            }
        }
    }

    private static Method getSetter(String fieldName, Class<?> clazz) {
        Method[] meths;
        for (Method meth : meths = clazz.getDeclaredMethods()) {
            if (!("set" + fieldName).equalsIgnoreCase(meth.getName())) continue;
            return meth;
        }
        for (Method meth : meths = clazz.getMethods()) {
            if (!("set" + fieldName).equalsIgnoreCase(meth.getName())) continue;
            return meth;
        }
        return null;
    }

    protected static void addShutdownHook(Vertx vertx, Logger log, Runnable action) {
        Runtime.getRuntime().addShutdownHook(new Thread(BareCommand.getTerminationRunnable(vertx, log, action)));
    }

    public static Runnable getTerminationRunnable(Vertx vertx, Logger log, Runnable action) {
        return () -> {
            CountDownLatch latch = new CountDownLatch(1);
            if (vertx != null) {
                vertx.close().onComplete(ar -> {
                    if (!ar.succeeded()) {
                        log.error((Object)"Failure in stopping Vert.x", ar.cause());
                    }
                    latch.countDown();
                });
                try {
                    if (!latch.await(2L, TimeUnit.MINUTES)) {
                        log.error((Object)"Timed out waiting to undeploy all");
                    }
                    if (action != null) {
                        action.run();
                    }
                }
                catch (InterruptedException e) {
                    throw new IllegalStateException(e);
                }
            }
        };
    }

    @Deprecated
    protected String getDefaultAddress() {
        return ClusteredEventBus.defaultAddress();
    }

    public void setExecutionContext(ExecutionContext context) {
        this.executionContext = context;
    }

    public synchronized Vertx vertx() {
        return this.vertx;
    }
}

