/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.ext.mail.impl;

import io.vertx.core.AsyncResult;
import io.vertx.core.Future;
import io.vertx.core.Handler;
import io.vertx.core.logging.Logger;
import io.vertx.core.logging.LoggerFactory;
import io.vertx.ext.mail.impl.SMTPConnection;
import io.vertx.ext.mail.impl.StatusCode;

class SMTPReset {
    SMTPConnection connection;
    Handler<AsyncResult<Void>> handler;
    private static final Logger log = LoggerFactory.getLogger(SMTPReset.class);

    public SMTPReset(SMTPConnection connection, Handler<AsyncResult<Void>> finishedHandler) {
        this.connection = connection;
        this.handler = finishedHandler;
    }

    public void start() {
        this.connection.setErrorHandler((Handler<Throwable>)((Handler)th -> {
            log.info((Object)("exception on RSET " + th));
            this.connection.resetErrorHandler();
            this.connection.setBroken();
            this.connection.shutdown();
            this.handleError("exception on RSET " + th);
        }));
        this.connection.write("RSET", (Handler<String>)((Handler)message -> {
            log.debug((Object)("RSET result: " + message));
            this.connection.resetErrorHandler();
            if (!StatusCode.isStatusOk(message)) {
                log.warn((Object)("RSET failed: " + message));
                this.handleError("reset command failed: " + message);
            } else {
                this.finished();
            }
        }));
    }

    private void finished() {
        this.handler.handle((Object)Future.succeededFuture(null));
    }

    private void handleError(String message) {
        this.handler.handle((Object)Future.failedFuture((String)message));
    }
}

