/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.ext.mail.mailencoder;

import io.vertx.core.http.CaseInsensitiveHeaders;
import io.vertx.ext.mail.MailAttachment;
import io.vertx.ext.mail.mailencoder.EncodedPart;
import io.vertx.ext.mail.mailencoder.Utils;

class AttachmentPart
extends EncodedPart {
    public AttachmentPart(MailAttachment attachment) {
        this.headers = new CaseInsensitiveHeaders();
        String name = attachment.getName();
        String contentType = attachment.getContentType() != null ? attachment.getContentType() : "application/octet-stream";
        if (name != null) {
            int index = contentType.length() + 22;
            contentType = contentType + "; name=\"" + Utils.encodeHeader(name, index) + "\"";
        }
        this.headers.set("Content-Type", contentType);
        this.headers.set("Content-Transfer-Encoding", "base64");
        if (attachment.getDescription() != null) {
            this.headers.set("Content-Description", attachment.getDescription());
        }
        String disposition = attachment.getDisposition() != null ? attachment.getDisposition() : "attachment";
        if (name != null) {
            int index = disposition.length() + 33;
            disposition = disposition + "; filename=\"" + Utils.encodeHeader(name, index) + "\"";
        }
        this.headers.set("Content-Disposition", disposition);
        if (attachment.getContentId() != null) {
            this.headers.set("Content-ID", attachment.getContentId());
        }
        if (attachment.getHeaders() != null) {
            this.headers.addAll(attachment.getHeaders());
        }
        this.part = Utils.base64(attachment.getData().getBytes());
    }
}

